#include "writebmp.h"
#include <stdio.h>
#include <GL/glx.h>

/* Local Functions */
void write_bmp24 (FILE *fp, int width, int height, GLvoid *pixels);
void write_bmpheader (FILE *fp, int width, int height);
void write_bmpimage (FILE *fp, int width, int height, GLvoid *pixels);
unsigned char *int2word(int number);
unsigned char *int2long(unsigned char *longnum, int number);
void checkvalues(int width, int height, GLvoid *pixels);
void write_u_long_int (unsigned long int u_long_int_val, FILE *fp);
void write_u_short_int (unsigned short int u_short_int_val, FILE *fp);

/* Global Variables */
int pad, rasterwidth;
struct template_bmpheader bmpheader;
struct template_bmpfile bmpfile;


void write_bmp24 (FILE *fp, int width, int height, GLvoid *pixels)
{
	/* Write header */
	write_bmpheader(fp, width, height);
	
	/* Write image data */
	write_bmpimage(fp, width, height, pixels);
}

/* Support Functions ------------------------------------------------------ */

void write_bmpheader (FILE *fp, int width, int height)
{
	int filesize, bfsize;
	int bytesperline, bmpnumbytes;
	
	/* Initialize header structure */
	bmpheader.reserved[0] = 0;
	bmpheader.reserved[1] = 0;
	/* WARNING : 	sizeof() function doesn't work well in 64bit computers,
			so in not good for determining the size of a structure.
	*/
	bmpheader.headersize = 54;
		
	/* Determine image width if it is not a multiple of 4. This is, in 
	24-bit bitmap files each raster line should be a multiple of 4 bytes */
	if ((width % 4) == 0) 
		pad = 0;
	else
		pad = 4 - (width % 4);
		
	/* Padded new width */
	rasterwidth = width + pad;
		
	/* Number of bytes in image */
	bmpnumbytes = 3 * rasterwidth * height;
	
	/* File size in bytes */	
	bmpheader.bfsize = sizeof(struct template_bmpheader) + sizeof(struct template_bmpfile) + bmpnumbytes;
	
	/* Start writing the file ----------------------------------------- */
	fputc('B', fp);
	fputc('M', fp);
			
	/* Write size of file in bytes */
	write_u_long_int(bmpheader.bfsize, fp);
	
	/* Write Reserved 1 */
	write_u_short_int(bmpheader.reserved[0], fp);
	
	/* Write Reserved 2 */
	write_u_short_int(bmpheader.reserved[1], fp);
	
	/* Write header size */
	write_u_long_int(bmpheader.headersize, fp);
	
	/* Bitmap Info ---------------------------------------------------- */
	bmpfile.bmpsize = 40;
	/* WARNING :	sizeof() function doesn't work on 64 bit computers.
			whenever this can be solved then use ;
			sizeof(struct template_bmpfile);
	*/
	
	bmpfile.bmpwidth = rasterwidth;
	bmpfile.bmpheight = height;
	bmpfile.biplanes = 1;
	bmpfile.bitcount = 24;
	bmpfile.bicompression = 0;
        bmpfile.bisizeimage = 0;
        bmpfile.bixpelspermeter = 0;
        bmpfile.biypelspermeter = 0;
        bmpfile.biclrused = 0;
	bmpfile.biclrimportant = 0;
	
	/* Write variables in file */
	write_u_long_int(bmpfile.bmpsize, fp);
	write_u_long_int(bmpfile.bmpwidth, fp);
	write_u_long_int(bmpfile.bmpheight, fp);
	write_u_short_int(bmpfile.biplanes, fp);
	write_u_short_int(bmpfile.bitcount, fp);
	write_u_long_int(bmpfile.bicompression, fp);
	write_u_long_int(bmpfile.bisizeimage, fp);
	write_u_long_int(bmpfile.bixpelspermeter, fp);
	write_u_long_int(bmpfile.biypelspermeter, fp);
	write_u_long_int(bmpfile.biclrused, fp);
	write_u_long_int(bmpfile.biclrimportant, fp);
}


void write_bmpimage (FILE *fp, int width, int height, GLvoid *pixels)
{
	int i, j, k, m, n, size, value, rowcount, rowindex;
	int pixnum = 0;
	char *linebuf;
	unsigned char zero = 0;
	unsigned char *curpix;
	int numpixels;

	/* Assign pointer to memory image */
	curpix = (unsigned char *) pixels;
	
	/* Save image */
	for (i = 0; i < height; i++)
	{
		for (j = 0; j < width; j++)
			/* Position pointer to the end of next pixels */
			for (k = 0; k < 3; k++)
				fwrite(curpix++, 1, 1, fp);
				
		/* Fill out remaining zero */
		if (pad > 0)
			for (m = 0; m < pad; m++)
				for (n = 0; n < 3; n++)
					fwrite(&zero, 1, 1, fp);
	}	
}


/* Miscellaneous Functions ------------------------------------------------ */

void checkvalues(int width, int height, GLvoid *pixels)
{
	int i, j, numpixels;
	unsigned char *curpix;
	
	curpix = (unsigned char *) pixels;
	
	numpixels = width * height;
	
	for (i = 0; i < numpixels; i++)
	{
		printf("pixel num : %d \n", i);
		
		for (j = 0; j < 3; j++)
			printf("%d \n", *curpix++);
			
		printf("\n");	
	}
}

/*
unsigned char *int2word(int number)
{
	unsigned char wordnum[2];
	
	wordnum[0] = (number & 0x00FF);
	wordnum[1] = ((number >> 8) & 0x00FF);
	
	return wordnum;
}

unsigned char *int2long(unsigned char *longnum, int number)
{
	longnum[0] = (number & 0x00FF);
	longnum[1] = ((number >> 8) & 0x000000FF);
	longnum[2] = ((number >> 16) & 0x000000FF);
	longnum[3] = ((number >> 24) & 0x000000FF);

	return longnum;	
}
*/
void write_u_long_int (unsigned long int value, FILE *fp)
{
	unsigned short int value_hi;
	unsigned short int value_lo;
	
	value_hi = (unsigned short) (value / 65536);
	value_lo = (unsigned short) (value % 65536);
	
	write_u_short_int(value_lo, fp);
	write_u_short_int(value_hi, fp);
}

void write_u_short_int (unsigned short int value, FILE *fp)
{
	unsigned char chi;
	unsigned char clo;
	
	chi = (unsigned char) (value / 256);
	clo = (unsigned char) (value % 256);
	
	fputc(clo, fp);
	fputc(chi, fp);
}			
