/* Visualization for molecular modeling package */
/* v1.0 */

#include "build.h"
/*#include "color.h" */
/*****************************************************************************/
void redraw(Display *dpy, Window win, GLboolean doubleBuffer,
    GLUquadricObj *qobj, int *graph_switch, int n_mols, int *mol_species,
    int *mol_first_atm, int *n_atoms_per_mol, int *n_bonds_per_mol, 
    double **mol_coords, double **rel_atom_coords,
    double **h, int **temp_bonds_1, int **temp_bonds_2, int n_species,
    int *species_choice,
    int *atom_type, int *comb_col, int resph, double radius_sph, 
    double *radius_cyl, short *keep_going, int x_cut_switch, int pore_switch)
{
    double v0, v1, v2, w0, w1, w2, bond[3], s_bond[3];
    int skip, i_species, i_mol, i_bond, rel_1, rel_2, abs_1, abs_2, k;
    int i_atom, abs, w, i_type, id_col, i_type_1, i_type_2, id_col_1, id_col_2;
    double R, RXY;
    float theta, phi;
    XEvent          event;
    GLboolean       needRedraw = GL_TRUE, recalcModelView = GL_TRUE; 
    KeySym ks;
    char buff[31];
    int grab_switch = 0;

if (!(*keep_going)){ 
/* Just to visualize the initial state we built. */
    do {
    /* Wait for an event before to process. Cannot be used
       when the scene must be updated periodically without
       occurence of an event, like in the MC loop. */
    XNextEvent(dpy, &event);

    switch (event.type) {
        case ButtonPress:
            recalcModelView = GL_TRUE;
            switch (event.xbutton.button) {
                case 1: xAngle += 10.0; break;
                case 2: xTrans += 1.0 / 10.0; break;
                case 3: xTrans -= 1.0 / 10.0; break;
                }
                break;

        case ConfigureNotify:
            glViewport(0, 0, event.xconfigure.width, event.xconfigure.height);

        case Expose:
            needRedraw = GL_TRUE;
            break;

        case MotionNotify:
         if (event.xmotion.state / 256 == 1) { 
            recalcModelView = GL_TRUE;
            xAngle = event.xmotion.x;
            yAngle = event.xmotion.y;
         }
         break;

        case KeyPress:
           (void) XLookupString(&event.xkey, buff, sizeof(buff), &ks, NULL);
           switch (ks) {
                 case XK_Escape:
                    *keep_going = 1; 
                    break;
                case XK_Up:
                    recalcModelView = GL_TRUE;
                    xAngle += 5.0;
                    break;
                 case XK_Down:
                    recalcModelView = GL_TRUE;
                    xAngle -= 5.0;
                    break;
                 case XK_Right:
                    recalcModelView = GL_TRUE;
                    yAngle += 5.0;
                    break;
                 case XK_Left:
                    recalcModelView = GL_TRUE;
                    yAngle -= 5.0;
                    break;
                 case XK_z:
                    recalcModelView = GL_TRUE;
                    zAngle += 5.0;
                    break;
                 case XK_Z:
                    recalcModelView = GL_TRUE;
                    zAngle -= 5.0;
                    break;
                case XK_space:
                    recalcModelView = GL_TRUE;
                    xTrans += 1.0 / 10.0;
                    break;
                 case XK_BackSpace:
                    recalcModelView = GL_TRUE;
                    xTrans -= 1.0 / 10.0;
                    break;
                 case XK_c:
                    recalcModelView = GL_TRUE;
                    xPlane -= 1.0;
                    if (xPlane < -h[0][0]/2.0)
                       xPlane = h[0][0]/2.0;
                    break;
                 case XK_C:
                    recalcModelView = GL_TRUE;
                    xPlane += 1.0;
                    if (xPlane > +h[0][0]/2.0)
                       xPlane = -h[0][0]/2.0;
                    break;

                 /* Here is the switching between the different graphic
                    options. */
                 case XK_1:        /* lines connecting atoms. */
                    recalcModelView = GL_TRUE;
                    *graph_switch = 1;
                    break;
                 case XK_2:        /* atoms as spheres and no bonds. */
                    recalcModelView = GL_TRUE;
                    *graph_switch = 3;
                    break; 
                 case XK_3:        /* bonds as cylinders and no atoms. */
                    recalcModelView = GL_TRUE;
                    *radius_cyl = radius_sph;
                    *graph_switch = 4;
                    break; 
                 case XK_4:        /* bonds as cylinders atoms as spheres. */
                    recalcModelView = GL_TRUE;
                    *radius_cyl = radius_sph / 3.0;
                    *graph_switch = 5;
                    break; 
                 case XK_5:        /* atoms + bonds as spherocylinders. */
                    recalcModelView = GL_TRUE;
                    *radius_cyl = radius_sph;
                    *graph_switch = 5;
                    break; 
                 case XK_s:        /* change the specie displayed */
                    recalcModelView = GL_TRUE;
                    *species_choice += 1;
                    if (*species_choice == n_species)
                       *species_choice = -1;
                    break; 
                 case XK_g:
                    recalcModelView = GL_TRUE;
                    grab_switch = 1;
                    break;
                 default:
                    break;
            }
       
        default:
          break;
    }
} while(XPending(dpy));
} 
else{
    /* This return true if one event of the kind specified by the masks 
       is detected. In opposite to XNextEvent, it doesn't wait for
       a next event...and then may be used inside the MC loop (as well
       as to visualize the building process of the initial state). */
    if (XCheckMaskEvent(dpy, ExposureMask | ButtonPressMask 
           | StructureNotifyMask | ButtonMotionMask | KeyPressMask, &event)) {

    switch (event.type) {
        case ButtonPress:
            recalcModelView = GL_TRUE;
            switch (event.xbutton.button) {
                /* Zoom. */
                case 2: xTrans += 1.0 / 10.0; break;
                case 3: xTrans -= 1.0 / 10.0; break;
                }
                break;

        case ConfigureNotify:
            glViewport(0, 0, event.xconfigure.width, event.xconfigure.height);

        case Expose:
            needRedraw = GL_TRUE;
            break;

        case MotionNotify:
          if (event.xmotion.state / 256 == 1) {
            recalcModelView = GL_TRUE;
            xAngle = event.xmotion.x;
            yAngle = event.xmotion.y;
          }
          break;

        case KeyPress:
           (void) XLookupString(&event.xkey, buff, sizeof(buff), &ks, NULL);
           switch (ks) {
                 case XK_Escape:
                    recalcModelView = GL_TRUE;
                    xAngle = xAngle_init; 
                    yAngle = yAngle_init; 
                    zAngle = zAngle_init; 
                    break;
                 case XK_Up:
                    recalcModelView = GL_TRUE;
                    xAngle += 5.0;
                    break;
                 case XK_Down:
                    recalcModelView = GL_TRUE;
                    xAngle -= 5.0;
                    break;
                 case XK_Right:
                    recalcModelView = GL_TRUE;
                    yAngle += 5.0;
                    break;
                 case XK_Left:
                    recalcModelView = GL_TRUE;
                    yAngle -= 5.0;
                    break;
                 case XK_z:
                    recalcModelView = GL_TRUE;
                    zAngle += 5.0;
                    break;
                 case XK_Z:
                    recalcModelView = GL_TRUE;
                    zAngle -= 5.0;
                    break;
                 case XK_space:
                    recalcModelView = GL_TRUE;
                    xTrans += 1.0 / 10.0;
                    break;
                 case XK_BackSpace:
                    recalcModelView = GL_TRUE;
                    xTrans -= 1.0 / 10.0;
                    break;
                 case XK_c:
                    recalcModelView = GL_TRUE;
                    xPlane -= 1.0;
                    if (xPlane < -h[0][0]/2.0)
                       xPlane = h[0][0]/2.0;
                    break;
                 case XK_C:
                    recalcModelView = GL_TRUE;
                    xPlane += 1.0;
                    if (xPlane > +h[0][0]/2.0)
                       xPlane = -h[0][0]/2.0;
                    break;
                 
                 /* Here is the switching between the different graphic
                    options. */
                 case XK_1:        /* lines connecting atoms. */
                    recalcModelView = GL_TRUE;
                    *graph_switch = 1;
                    break;
                 case XK_2:        /* atoms as spheres and no bonds. */
                    recalcModelView = GL_TRUE;
                    *graph_switch = 3;
                    break; 
                 case XK_3:        /* bonds as cylinders and no atoms. */
                    recalcModelView = GL_TRUE;
                    *radius_cyl = radius_sph;
                    *graph_switch = 4;
                    break; 
                 case XK_4:        /* bonds as cylinders atoms as spheres. */
                    recalcModelView = GL_TRUE;
                    *radius_cyl = radius_sph / 3.0;
                    *graph_switch = 5;
                    break; 
                 case XK_5:        /* atoms + bonds as spherocylinders. */
                    recalcModelView = GL_TRUE;
                    *radius_cyl = radius_sph;
                    *graph_switch = 5;
                    break; 
                 case XK_s:        /* change the specie displayed */
                    recalcModelView = GL_TRUE;
                    *species_choice += 1;
                    if (*species_choice == n_species)
                       *species_choice = -1;
                    break; 
                 case XK_g:
                    recalcModelView = GL_TRUE;
                    grab_switch = 1;
                    break;

                 default:
                    break;
            }
       
        default:
          break;
    } /* end switch. */
  } /* end if */
else{ 
                    recalcModelView = GL_TRUE;
     needRedraw = GL_TRUE;
    }
} 

    if (recalcModelView) {
            glMatrixMode(GL_MODELVIEW);
            glLoadIdentity();
            glTranslatef(0.0, 0.0, zTrans);
            glRotatef(xAngle, 1.0, 0.0, 0.0);
            glRotatef(yAngle, 0.0, 1.0, 0.0);
            glRotatef(zAngle, 0.0, 0.0, 1.0);
            glScalef(xTrans, xTrans, xTrans);

            recalcModelView = GL_FALSE;
            needRedraw = GL_TRUE;
    }


 if (needRedraw) {
   needRedraw = GL_FALSE;

   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

   /************************************************************/
   /* 1 - Display molecules as simple lines joining the atoms. */
   /************************************************************/
   if (*graph_switch == 1) {

   /* Turn off the light. */
   glDisable(GL_LIGHTING); 

   /* Select line width. */
   glLineWidth(2);

   /* Loop over molecules. */
   for (i_mol = 0; i_mol < n_mols; ++i_mol) {

      /* Get label of molecular species. */
      i_species = mol_species[i_mol];

      /* Get atom and bond vector label offsets. */
      skip = mol_first_atm[i_mol];

      /* Display all the species if species_choice == -1 or just
         the specified species_choice otherwise. */
      if ((*species_choice == -1) 
              || (*species_choice > -1 && i_species == *species_choice))
      /* Loop over bonds. */
      for (i_bond = 0; i_bond < n_bonds_per_mol[i_species]; ++i_bond) {

         /* Get relative labels of atoms that share bond. */
         rel_1 = temp_bonds_1[i_species][i_bond];
         rel_2 = temp_bonds_2[i_species][i_bond];

         /* Compute absolute labels of atoms that share bond. */
         abs_1 = skip + rel_1;
         abs_2 = skip + rel_2;

         /* Molecular coordinates. */
         v0 = mol_coords[i_mol][0];
         v1 = mol_coords[i_mol][1];
         v2 = mol_coords[i_mol][2];

         /* Draw bond between 2 coonected atoms. */
         if ((!x_cut_switch) || ((x_cut_switch) && (v0 <= xPlane))){
           glBegin(GL_LINE_LOOP);
           glColor3f(0.0, 1.0, 0.0);
           w0 = v0 + rel_atom_coords[abs_1][0];
           w1 = v1 + rel_atom_coords[abs_1][1];
           w2 = v2 + rel_atom_coords[abs_1][2];
           glVertex3f(w0, w1, w2);
           w0 = v0 + rel_atom_coords[abs_2][0];
           w1 = v1 + rel_atom_coords[abs_2][1];
           w2 = v2 + rel_atom_coords[abs_2][2];
           glVertex3f(w0, w1, w2);
           glEnd();
         }

      }
   }
/* Turn on light. */
glEnable(GL_LIGHTING);
}

/*******************************************************************/
/* 2, 3 - Display atoms as spheres (wireframe (2) or spheres (3)). */
/*******************************************************************/

else if ((*graph_switch == 2) || (*graph_switch == 3)) {
   
   /* Turn off light if wireframe. */
   if (*graph_switch == 2)
      glDisable(GL_LIGHTING);

   /* Loop over molecules. */
   for (i_mol = 0; i_mol < n_mols; ++i_mol) {

      /* Get label of molecular species. */
      i_species = mol_species[i_mol];

      /* Get atom and bond vector label offsets. */
      skip = mol_first_atm[i_mol];

      /* Display all the species if species_choice == -1 or just
         the specified species_choice otherwise. */
      if ((*species_choice == -1) 
              || (*species_choice > -1 && i_species == *species_choice))
      /* Loop over atoms. */
      for (i_atom = 0; i_atom < n_atoms_per_mol[i_species]; ++i_atom) {

         /* Get atom absolute label and integer atom type. */
         abs = skip + i_atom;
         i_type = atom_type[abs];

         /* Get color id for i_atom. */
         id_col = comb_col[i_type];

         /* Get unfolded atomic coordinates. */
         v0 = mol_coords[i_mol][0] + rel_atom_coords[abs][0];
         v1 = mol_coords[i_mol][1] + rel_atom_coords[abs][1];
         v2 = mol_coords[i_mol][2] + rel_atom_coords[abs][2];

         /* Draw atoms as spheres with the chosen color id. */
         if (((!x_cut_switch) || ((x_cut_switch) && (v0 <= xPlane))) &&
            (id_col != 0)){
           glColor3fv(defaultColor[id_col]);
           glPushMatrix();
           glTranslatef (v0, v1, v2);
           gluSphere(qobj, radius_sph, resph, resph);
           glPopMatrix();
         }
      }
   }
   /* Turn on light if wireframe. */
   if (*graph_switch == 2) 
      glEnable(GL_LIGHTING);
}

/**********************************************************************/
/* 4, 5 - Draw bonds as cylinders and (switch == 5) atoms as spheres. */ 
/**********************************************************************/

else if ((*graph_switch == 4) || (*graph_switch == 5)) {

   /* Loop over molecules. */
   for (i_mol = 0; i_mol < n_mols; ++i_mol) { 

      /* Get label of molecular species. */
      i_species = mol_species[i_mol];

      /* Get atom and bond vector label offsets. */
      skip = mol_first_atm[i_mol];

      /* Display all the species if species_choice == -1 or just
         the specified species_choice otherwise. */
      if ((*species_choice == -1) 
              || (*species_choice > -1 && i_species == *species_choice))
      /* Loop over bonds (here spherocylinders). */
      for (i_bond = 0; i_bond < n_bonds_per_mol[i_species]; ++i_bond) {

         /* Get relative labels of atoms that share bond. */
         rel_1 = temp_bonds_1[i_species][i_bond];
         rel_2 = temp_bonds_2[i_species][i_bond];

         /* Compute absolute labels of atoms that share bond. */
         abs_1 = skip + rel_1;
         abs_2 = skip + rel_2;

         /* Calculate bond vector. */
         bond[0] = rel_atom_coords[abs_2][0] - rel_atom_coords[abs_1][0];
         bond[1] = rel_atom_coords[abs_2][1] - rel_atom_coords[abs_1][1];
         bond[2] = rel_atom_coords[abs_2][2] - rel_atom_coords[abs_1][2];

         /* stolen and adapted from VMD. */
         R = bond[0]*bond[0]+bond[1]*bond[1]+bond[2]*bond[2];

         if (R <= 0.0)
           fatalError("R <= 0"); 

         R = sqrt(R); 
 
         /* determine phi rotation angle, amount to rotate about y. */
         phi = acosf(bond[2] / R);

         /* determine theta rotation, amount to rotate about z. */
         RXY = sqrt(bond[0]*bond[0]+bond[1]*bond[1]);
         if(RXY <= 0.0) {
           theta = 0.0;
         }
         else {
           theta = acosf(bond[0] / RXY);
           if (bond[1] < 0.0)
           theta = (float) (2.0 * PI) - theta;
         }

         /* now set up proper transformations to move cylinder from Z-axis 
            to (unfolded) position. */
         v0 = mol_coords[i_mol][0] + rel_atom_coords[abs_1][0];
         v1 = mol_coords[i_mol][1] + rel_atom_coords[abs_1][1];
         v2 = mol_coords[i_mol][2] + rel_atom_coords[abs_1][2];

         /* Get atom id type. */     
         i_type_1 = atom_type[abs_1];
         i_type_2 = atom_type[abs_2];

         /* Get color id for i_atom. */
         id_col_1 = comb_col[i_type_1];
         id_col_2 = comb_col[i_type_2];

       /* Draw the bond between 2 covalent atoms as a gray cylinder if
          the radius of the cylinder is smaller than the radius of the atoms
          connected to it, or as 2 cylinders of half the length of the bond,
          with the respective color of the 2 atoms if the radius of the
          cylinder i sequal to the radius of the atoms. */

if (((!x_cut_switch) || ((x_cut_switch) && (v0 <= xPlane)))
      && ((id_col_1 != 0) && (id_col_2 != 0))) {

       if (*radius_cyl < radius_sph){

         /* Draw all the cylinders with gray color. */
         glColor3fv(defaultColor[3]);

         glPushMatrix();
         glTranslatef((GLfloat)(v0), (GLfloat)(v1), (GLfloat)(v2));

         if(theta != 0.0)
           glRotatef((GLfloat) ((theta / PI) * 180.0), 0.0, 0.0, 1.0);
         if(phi != 0.0)
           glRotatef((GLfloat) ((phi / PI) * 180.0), 0.0, 1.0, 0.0);

          /* call utility routine to draw cylinders. */
          gluCylinder(qobj, (GLdouble)(*radius_cyl), (GLdouble)(*radius_cyl), 
                      (GLdouble)R, (GLint)resph, 1);

          /* restore the matrix */
          glPopMatrix();
       } 
       else if (*radius_cyl == radius_sph){

         /* Position of the second half of the cylinder. */
         w0 = v0 + bond[0] / 2.0;
         w1 = v1 + bond[1] / 2.0;
         w2 = v2 + bond[2] / 2.0;

         /* Draw half of the cylinders with the color of the atom 1,
            and half with the color of atom 2. */
/*         i_type_1 = atom_type[abs_1];
         i_type_2 = atom_type[abs_2];
*/
         /* Get color id for i_atom. */
/*         id_col_1 = comb_col[i_type_1];
         id_col_2 = comb_col[i_type_2];
*/
         /* Draw first half. */
         glColor3fv(defaultColor[id_col_1]);

         glPushMatrix();
         glTranslatef((GLfloat)(v0), (GLfloat)(v1), (GLfloat)(v2));

         if(theta != 0.0)
           glRotatef((GLfloat) ((theta / PI) * 180.0), 0.0, 0.0, 1.0);
         if(phi != 0.0)
           glRotatef((GLfloat) ((phi / PI) * 180.0), 0.0, 1.0, 0.0);

          /* call utility routine to draw cylinders. */
          gluCylinder(qobj, (GLdouble)(*radius_cyl), (GLdouble)(*radius_cyl), 
                      (GLdouble) (R / 2.0), (GLint)resph, 1);

          /* restore the matrix */
          glPopMatrix();
   
         /* Draw second half. */ 
         glColor3fv(defaultColor[id_col_2]);

         glPushMatrix();
         glTranslatef((GLfloat)(w0), (GLfloat)(w1), (GLfloat)(w2));

         if(theta != 0.0)
           glRotatef((GLfloat) ((theta / PI) * 180.0), 0.0, 0.0, 1.0);
         if(phi != 0.0)
           glRotatef((GLfloat) ((phi / PI) * 180.0), 0.0, 1.0, 0.0);

          /* call utility routine to draw cylinders. */
          gluCylinder(qobj, (GLdouble)(*radius_cyl), (GLdouble)(*radius_cyl), 
                      (GLdouble) (R / 2.0), (GLint)resph, 1);

          /* restore the matrix */
          glPopMatrix();
       }
     }

      }
      if (*graph_switch == 5) {
      /* Display all the species if species_choice == -1 or just
         the specified species_choice otherwise. */
      if ((*species_choice == -1) 
              || (*species_choice > -1 && i_species == *species_choice))
      /* Loop over atoms. */
      for (i_atom = 0; i_atom < n_atoms_per_mol[i_species]; ++i_atom) {

         /* Get absolute atomic label. */
         abs = skip + i_atom;
         i_type = atom_type[abs];

         /* Get color id for i_atom. */
         id_col = comb_col[i_type];

         /* Get (unfolded) atomic coordinates. */
         v0 = mol_coords[i_mol][0] + rel_atom_coords[abs][0];
         v1 = mol_coords[i_mol][1] + rel_atom_coords[abs][1];
         v2 = mol_coords[i_mol][2] + rel_atom_coords[abs][2];

         /* Draw atoms as spheres using then chosen color id. */
       if (((!x_cut_switch) || ((x_cut_switch) && (v0 <= xPlane)))
            && (id_col != 0)){
         glColor3fv(defaultColor[id_col]);
         glPushMatrix();
         glTranslatef (v0, v1, v2);
         gluSphere(qobj, radius_sph, resph, resph);
         glPopMatrix();
        }
      }
      } /* end if graph_switch == 5. */ 

   }
}

   /* Now draw the bounding box. */

   /* Turn off the light. */
   glDisable(GL_LIGHTING);

   /* Choose color of the bounding box (red). */
   glColor3f(1.0, 0.0, 0.0);

   /* Line thickness. */
   w = 3;
   glLineWidth((GLfloat)w);

   /* Draw the bounding box. */
   /* front face */
   glBegin(GL_LINE_LOOP);
   v0 = 0.5 * (- h[0][0] - h[0][1] - h[0][2]);
   v1 = 0.5 * (- h[1][1] - h[1][2]);
   v2 = - 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   v0 = 0.5 * (h[0][0] - h[0][1] - h[0][2]);
   v1 = 0.5 * (- h[1][1] - h[1][2]);
   v2 = - 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   v0 = 0.5 * (h[0][0] + h[0][1] - h[0][2]);
   v1 = 0.5 * (h[1][1] - h[1][2]);
   v2 = - 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   v0 = 0.5 * (- h[0][0] + h[0][1] - h[0][2]);
   v1 = 0.5 * (h[1][1] - h[1][2]);
   v2 = - 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   v0 = 0.5 * (- h[0][0] - h[0][1] - h[0][2]);
   v1 = 0.5 * (- h[1][1] - h[1][2]);
   v2 = - 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   v0 = 0.5 * (- h[0][0] - h[0][1] + h[0][2]);
   v1 = 0.5 * (- h[1][1] + h[1][2]);
   v2 = 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   v0 = 0.5 * (h[0][0] - h[0][1] + h[0][2]);
   v1 = 0.5 * (- h[1][1] + h[1][2]);
   v2 = 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   v0 = 0.5 * (h[0][0] - h[0][1] - h[0][2]);
   v1 = 0.5 * (- h[1][1] - h[1][2]);
   v2 = - 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   glEnd();
   glBegin(GL_LINE_LOOP);
   v0 = 0.5 * (- h[0][0] + h[0][1] - h[0][2]);
   v1 = 0.5 * (h[1][1] - h[1][2]);
   v2 = - 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   v0 = 0.5 * (- h[0][0] + h[0][1] + h[0][2]);
   v1 = 0.5 * (h[1][1] + h[1][2]);
   v2 = 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   v0 = 0.5 * (h[0][0] + h[0][1] + h[0][2]);
   v1 = 0.5 * (h[1][1] + h[1][2]);
   v2 = 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   v0 = 0.5 * (h[0][0] + h[0][1] - h[0][2]);
   v1 = 0.5 * (h[1][1] - h[1][2]);
   v2 = - 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   glEnd();
   glBegin(GL_LINE_LOOP);
   v0 = 0.5 * (- h[0][0] - h[0][1] + h[0][2]);
   v1 = 0.5 * (- h[1][1] + h[1][2]);
   v2 = 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   v0 = 0.5 * (- h[0][0] + h[0][1] + h[0][2]);
   v1 = 0.5 * (h[1][1] + h[1][2]);
   v2 = 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   glEnd();
   glBegin(GL_LINE_LOOP);
   v0 = 0.5 * (h[0][0] - h[0][1] + h[0][2]);
   v1 = 0.5 * (- h[1][1] + h[1][2]);
   v2 = 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   v0 = 0.5 * (h[0][0] + h[0][1] + h[0][2]);
   v1 = 0.5 * (h[1][1] + h[1][2]);
   v2 = 0.5 * h[2][2];
   glVertex3f(v0, v1, v2);
   glEnd();

   /* Turn on light. */
   glEnable(GL_LIGHTING);

   if (!pore_switch){ 
      if(doubleBuffer) glXSwapBuffers(dpy, win);  /* buffer swap does 
                                                  implicit glFlush */
      else glFlush();  /* explicit flush for single buffered case */
   }
}
  if (grab_switch){
     grabber(600, 600, 0);
     grab_switch = 0;
  }

}

/*****************************************************************************/
