#define MAIN
#include "build.h"
#undef MAIN
#include "ff.h"
#include "proto.h"
#include "visu.h"

main(int argc, char *argv[])
{
  int ans, i_mol, skip, i_atom, abs;
  int i_rel, j_rel, j_species;
  int i, j, i_atoms, i_species, i_phant, n_species, n_species_chk, 
      n_unit_cells, n_mols, n_atoms;
  int period_switch, vdw_switch, vdw_rad_switch, *excl_switch, start_switch,
      phant_switch, neigh_switch, opt_switch, press_switch, one_four_switch;
  /* Declare parameters used to build the initial state and box matrices*/
  double rho, **h, **h_inv;
  /* Declare and initialize force field parameters. */
  int n_mass = 0, n_type = 0;
  mass_entry *mass = NULL;
  type_entry *atm_type = NULL;
  /* File names */
  char par_file[F_MAX], *mass_file, *color_file, *header_file, *config_file;
  FILE *f_trajec;
  /* Declare and initialize molecular structure parameters. */
  int *n_atoms_per_mol = NULL, *n_mols_per_species = NULL,
      *n_bonds_per_mol = NULL, **temp_atm_lab, **temp_atm_nbr,
      ***temp_atm_br, **temp_atm_type_i;
  double ***temp_atm_pos, **temp_atm_mass, **temp_atm_chg, ***temp_atm_ord;
  char ***temp_atm_type;
  int **temp_bonds_1 = NULL, **temp_bonds_2 = NULL;
  double **temp_bonds_ord = NULL;
  int *mol_species;

  /* Declare some arrays used in set up force field */
  double *mol_mass, *mol_mass_true;
  int *mol_first_atm;

  /* Declare arrays used in build */
  double **scaled_atom_coords, **mol_coords, **scaled_mol_coords,
      **atom_coords, **rel_atom_coords, **atom_vels, *atom_mass;
  int *atom_rel, *atom_mol, *atom_type;

  /* Scan list arrays. */
  int **scan_atm_1, **scan_atm_2;

  /* Monte Carlo parameters. */
  int i_cycle, n_reshape, n_cycles, n_mol_moves, n_mol_accept, n_reshape_moves, 
  n_reshape_accept, reshape_axis, n_opt, n_thermo, n_trajec, n_inst;

  /* Graphics parameters. */
  double radius_sph, radius_cyl;
  int graph_switch, resph, antialias_switch, species_choice, keep_going,
    *comb_col, x_cut_switch;

  /* OpenGL/X variables declaration. */
  Display *dpy;
  Window win;
  GLboolean doubleBuffer = GL_TRUE;
  GLUquadricObj *qobj;

  /* Pore parameters. */
  int graph_pore_switch, pore_switch;
  double x0, y0, z0, r0;

  /* Grabber parameters. */
  int n_frames, count_frames, first_frame, grab_switch, xspin_switch, 
      yspin_switch, zspin_switch, spin_frames;
  double spin_mag;

  /* Get command line input. */
  if (argc != 2) {
    printf("Usage: %s params_file\n", argv[0]);
    exit(1);
  }
  strcpy(par_file, argv[1]);

  /* Read in input parameter file. */
  read_visu_params(par_file, &start_switch, &header_file, &config_file, 
      &mass_file, &color_file, &graph_switch, &graph_pore_switch, 
      &species_choice, &radius_sph, &radius_cyl, &resph, &antialias_switch, 
      &x_cut_switch, &grab_switch, &n_frames, &first_frame, &xspin_switch, 
      &yspin_switch, &zspin_switch, &spin_mag, &spin_frames);
 
  printf("start_switch = %d\n", start_switch);
  printf("header_file = %s, config_file = %s\n",header_file,
      config_file);
  printf("mass_file = %s\n",mass_file);
  printf("color_file = %s\n",color_file);
  printf("graph_switch = %d, graph_pore_switch = %d\n", graph_switch,
          graph_pore_switch);
  printf("species_choice = %d\n", species_choice);
  printf("radius_sph = %g, radius_cyl = %g\n", radius_sph, radius_cyl);
  printf("resph = %d, antialias_switch = %d\n", resph, antialias_switch);
  printf("x_cut_switch = %d\n", x_cut_switch);
  printf("grab_switch = %d, n_frames = %d, first_frame = %d\n", grab_switch, 
    n_frames, first_frame);
  printf("xspin_switch = %d, yspin_switch = %d, zspin_switch = %d, spin_mag = %g, spin_frames = %d\n", xspin_switch, yspin_switch, zspin_switch, spin_mag, spin_frames);


  /* Should be removed later! */
  if (pore_switch){
    pore_switch = 1;
    r0 = 1.4;
    x0 = y0 = r0 / sqrt(2.0);
    z0 = 6.0;
  }

  /* Read information about template molecules and atoms from header file */
  read_header_direct(header_file, &period_switch, &n_species,
      &n_atoms_per_mol,  &temp_atm_lab, &temp_atm_type, &temp_atm_nbr,
      &temp_atm_br, &temp_atm_ord,  &temp_atm_pos, &temp_atm_chg,
      &n_bonds_per_mol, &temp_bonds_1,
      &temp_bonds_2, &temp_bonds_ord,  &n_mols_per_species, &n_mols,
      &n_atoms, &mol_species);

  /* Read FF masses file. */
  read_mass_params(mass_file, &mass, &n_mass);

  /* Set up force field data for masses. */
  set_up_force_field(n_species, n_mols, n_atoms_per_mol, n_mass,
      mass, mol_species, n_bonds_per_mol, &temp_atm_mass, temp_atm_type,
      &mol_mass, &mol_mass_true, &mol_first_atm);

  /* Convert string tags to integer identifiers. */
  /* Create an integer identifier corresponding to template atom type. */ 
  convert_type(n_species, n_atoms_per_mol, temp_atm_type, &temp_atm_type_i, 
     &atm_type, &n_type);

  /* if we consider a pore, add one more integer identifier for the
     walls. This entry cannot be process before because it's not an
     atom type (i.e not read from the structure file). */
  if (pore_switch)
     add_type(&atm_type, &n_type);

  /* Set up scan list. */
  set_up_scan_list(n_species, n_atoms_per_mol, temp_atm_nbr, temp_atm_br,  
     &scan_atm_1, &scan_atm_2);

  /* Allocate memory for arrays used in the builder. */
  allocate_memory_visu(n_atoms, n_mols, n_species, 
      period_switch,  &scaled_atom_coords, &atom_rel, &atom_mol,
      &atom_mass, &atom_type, &mol_coords, &scaled_mol_coords, 
      &rel_atom_coords, &h_inv);  

  /* Set up array of relative atom indices */
  relative_atoms(n_mols, mol_species, mol_first_atm, n_atoms_per_mol,
      temp_atm_mass, temp_atm_type_i, atom_rel, atom_mol, atom_mass, atom_type);

  /* Read and set up color id for each atom type. */
  read_set_up_color(color_file, atm_type, n_type, &comb_col);

  /* Initialize counter for the grabber. */
  count_frames = first_frame;

  /* If start_switch == 0, read and display only a configuration 
     file (ascii). */
  if (start_switch == 0) { 

      /* Read atomic position and velocities from config file */
      read_config_direct(config_file, period_switch, &h, n_atoms, 
                         &atom_coords);

      /* Calculate quantities that depend on box dimensions and exit
         if system is too small. */
      box_dimensions(h, h_inv, period_switch, 0.0, 0.0);

      if (period_switch) {
         scaled_atomic_coords(n_atoms, h_inv, atom_coords, scaled_atom_coords);
         periodic_boundary_conditions(n_atoms, h, scaled_atom_coords,
                                      atom_coords);
      }

      /* Compute center of mass of the molecules and relative atom positions 
         within the molecules. */
      center_of_mass_positions(period_switch, n_mols, n_species,
                   n_atoms_per_mol,  mol_species, atom_mass, mol_first_atm,
                   atom_coords, scaled_atom_coords,  scan_atm_1, scan_atm_2,
                   mol_mass, h, h_inv, mol_coords, scaled_mol_coords,  
                   rel_atom_coords);
      

      /* Plot initial configuration. */
      /* Initialize graphics. */
      initialize(&dpy, &win, doubleBuffer, &qobj, graph_switch, 
                 antialias_switch, h);

      /* Initialize cuting plane. */
      xPlane = h[0][0]/2.0;

      /* Hit Escape to exit the loop.*/
      printf("\nEsc to exit from %s.\n", argv[0]);
      XBell(dpy, 100);
      keep_going = 0;
      do {
     redraw(dpy, win, doubleBuffer, qobj, &graph_switch, n_mols, mol_species,
             mol_first_atm, n_atoms_per_mol, n_bonds_per_mol,
             mol_coords, rel_atom_coords, h, temp_bonds_1, temp_bonds_2,
             n_species, &species_choice, atom_type, comb_col, resph, radius_sph,
             &radius_cyl, &keep_going, x_cut_switch, pore_switch);
      if (pore_switch)
        redraw_pore(dpy, win, doubleBuffer, &graph_pore_switch, resph, z0, r0,
                    h, x_cut_switch, comb_col, n_type);

         } while(!keep_going);

}
else {

  /* Open output file. */
  if ((f_trajec = fopen(config_file, "r")) == NULL)
    error_exit("Cannot open config_file\n");

  /* Read header from the trajectory file. */
  fread(&n_atoms, sizeof(int), 1, f_trajec);
  fread(&n_cycles, sizeof(int), 1, f_trajec);
  fread(&n_trajec, sizeof(int), 1, f_trajec);

  printf("Header from %s\n", config_file);
  printf("n_atoms = %d\n", n_atoms);
  printf("n_cycles = %d\n", n_cycles);
  printf("n_trajec = %d\n", n_trajec);

  /* Compute number of instantaneous configuration in trajectory file. */
  if (n_cycles % n_trajec != 0) {
      printf("n_cycles must be a multiple of n_trajec\n");
      exit(1);
  }
  n_inst = n_cycles / n_trajec;

  /* Allocate memory for box and atom coordinates. */
  h = allocate_2d_array(3, 3, sizeof(double));
  atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Loop  over trajectories. */
  printf("\nEntering main loop\n");
  fflush(NULL);

  for (i_cycle = 1; i_cycle <= n_inst; ++i_cycle) {

      /* Read in instantaneous configuration from trajectory file. */
      read_positions_direct(f_trajec, h, n_atoms, atom_coords);

      /* Calculate quantities that depend on box dimensions and exit
         if system is too small. */
      box_dimensions(h, h_inv, period_switch, 0.0, 0.0);

      if (period_switch) {
         scaled_atomic_coords(n_atoms, h_inv, atom_coords, scaled_atom_coords);
         periodic_boundary_conditions(n_atoms, h, scaled_atom_coords,
                                      atom_coords);
      }

      /* Compute center of mass of the molecules and relative atom positions
         within the molecules. */
      center_of_mass_positions(period_switch, n_mols, n_species,
                   n_atoms_per_mol,  mol_species, atom_mass, mol_first_atm,
                   atom_coords, scaled_atom_coords,  scan_atm_1, scan_atm_2,
                   mol_mass, h, h_inv, mol_coords, scaled_mol_coords,
                   rel_atom_coords);

      /* If this is the first trajectory read stay inside the 'infinite' loop
         of events till Esc entered. */
      if (i_cycle == 1 || i_cycle == n_inst) {

         /* Initialize graphics. */
         if (i_cycle == 1){
            initialize(&dpy, &win, doubleBuffer, &qobj, graph_switch,
                       antialias_switch, h);

            /* Initialize cutting planes. */
            xPlane = h[0][0] / 2.0;

            /* Hit Escape to exit the loop.*/
            printf("\nEsc to display the configurations.\n");
         }
         else
            printf("\nEsc to exit from %s.\n", argv[0]);
         XBell(dpy, 100);
         keep_going = 0;
         do {
            redraw(dpy, win, doubleBuffer, qobj, &graph_switch, n_mols, 
                   mol_species, mol_first_atm, n_atoms_per_mol, 
                   n_bonds_per_mol, mol_coords, rel_atom_coords, h, 
                   temp_bonds_1, temp_bonds_2, n_species, &species_choice, 
                   atom_type, comb_col, resph, radius_sph,
                   &radius_cyl, &keep_going, x_cut_switch, pore_switch);
            if (pore_switch)
               redraw_pore(dpy, win, doubleBuffer, &graph_pore_switch, resph, 
                           z0, r0, h, x_cut_switch, comb_col, n_type);

             } while(!keep_going);
         /* Store initial view angles. Can be reset inside the MC loop
            by pressing Esc. */
         xAngle_init = xAngle;
         yAngle_init = yAngle;
         zAngle_init = zAngle;

         /* Store a bitmap of the screen (Thanks Victor). */
         if (grab_switch){
           if (i_cycle % n_frames == 0){
              grabber(600, 600, count_frames);
              ++count_frames;
           }
  
           /* Let the box rotate. */
           if (i_cycle % spin_frames == 0){
             if (xspin_switch) xAngle += spin_mag;
             if (yspin_switch) yAngle += spin_mag;
             if (zspin_switch) zAngle += spin_mag;
           }
         } 
      }
      else{
            redraw(dpy, win, doubleBuffer, qobj, &graph_switch, n_mols, 
                   mol_species, mol_first_atm, n_atoms_per_mol, 
                   n_bonds_per_mol, mol_coords, rel_atom_coords, h, 
                   temp_bonds_1, temp_bonds_2, n_species, &species_choice, 
                   atom_type, comb_col, resph, radius_sph,
                   &radius_cyl, &keep_going, x_cut_switch, pore_switch);
            if (pore_switch)
               redraw_pore(dpy, win, doubleBuffer, &graph_pore_switch, resph, 
                           z0, r0, h, x_cut_switch, comb_col, n_type);

            /* Store a bitmap of the screen (Thanks again, Victor). */
            if (grab_switch){
              if (i_cycle % n_frames == 0){
                grabber(600, 600, count_frames);
                ++count_frames;
              }
  
              /* Let the box rotate. */
              if (i_cycle % spin_frames == 0){
                if (xspin_switch) xAngle += spin_mag;
                if (yspin_switch) yAngle += spin_mag;
                if (zspin_switch) zAngle += spin_mag;
              }
            } 
      }
  } /* end of the loop. */

  /* Close output file. */
  fclose(f_trajec);
}

  exit(0);

}  /* end of main. */

/****************************************************************************/
/* Allocate memory for static arrays */
void allocate_memory_visu(int n_atoms, int n_mols, int n_species,
   int period_switch, double ***scaled_atom_coords, int **atom_rel,
   int **atom_mol, double **atom_mass, int **atom_type, double ***mol_coords, 
   double ***scaled_mol_coords, double ***rel_atom_coords, 
   double ***h_inv)

{
  int i, i_rel, i_species, n_atoms_max;

  /* Allocate memory for arrays of atomic properties. */
  if (period_switch)
    *scaled_atom_coords = allocate_2d_array(n_atoms,
        3, sizeof(double));
  *rel_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for arrays of atomic properties. */
  *atom_rel = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mol = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mass = allocate_1d_array(n_atoms, sizeof(double));
  *atom_type = allocate_1d_array(n_atoms, sizeof(int));

  /* Allocate memory for arrays of molecular properties. */
  *mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));
  if (period_switch)
    *scaled_mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));

  /* Allocate memory for the box matrices */
  /* For now, orthorombic box */
  *h_inv = allocate_2d_array(3, 3, sizeof(double));

}

/****************************************************************************/
/* Set up array of relative atom indices. */
void relative_atoms(int n_mols, int *mol_species, int *mol_first_atm,
   int *n_atoms_per_mol, double **temp_atm_mass, int **temp_atm_type_i,
   int *atom_rel, int *atom_mol, double *atom_mass, int *atom_type)
{
  int i_species, skip, i, i_mol, i_rel;

  /* Set up array of atomic properties. */
  for (i_mol = 0; i_mol < n_mols; ++i_mol) {
    i_species = mol_species[i_mol];
    skip = mol_first_atm[i_mol];
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
      i = skip + i_rel;
      atom_rel[i] = i_rel;
      atom_mol[i] = i_mol;
      atom_mass[i] = temp_atm_mass[i_species][i_rel];
      atom_type[i] = temp_atm_type_i[i_species][i_rel];
    }
  }

}
