#include "build.h"

/* Set up scan list. */
void set_up_scan_list(int n_species, int *n_atoms_per_mol, int **temp_atm_nbr,
   int ***temp_atm_br, int ***scan_atm_1, int ***scan_atm_2)
{
   int i_species, i, j, i1, i2,
      *done, n_next_1, *next_1, n_next_2, *next_2, *p, i_scan;

   /* Allocate memory for scan lists. */
   *scan_atm_1 = allocate_1d_array(n_species, sizeof(int*));
   *scan_atm_2 = allocate_1d_array(n_species, sizeof(int*));
   for (i_species = 0; i_species < n_species; ++i_species)
      {
        if (n_atoms_per_mol[i_species] > 1) {
          (*scan_atm_1)[i_species] = 
                allocate_1d_array(n_atoms_per_mol[i_species] - 1, sizeof(int));
          (*scan_atm_2)[i_species] = 
                allocate_1d_array(n_atoms_per_mol[i_species] - 1, sizeof(int));
        }
        else /* Atomic specie. */
        {
          (*scan_atm_1)[i_species] = 
                allocate_1d_array(n_atoms_per_mol[i_species], sizeof(int));
          (*scan_atm_2)[i_species] = 
                allocate_1d_array(n_atoms_per_mol[i_species], sizeof(int));
        }
      }

   for (i_species = 0; i_species < n_species; ++i_species){
   
     if (n_atoms_per_mol[i_species] > 1) { 
      /* Allocate memory for temporary arrays. */
      done = allocate_1d_array(n_atoms_per_mol[i_species], sizeof(int));
      next_1 = allocate_1d_array(n_atoms_per_mol[i_species], sizeof(int));
      next_2 = allocate_1d_array(n_atoms_per_mol[i_species], sizeof(int));

      /* Set up scan list. */
      i_scan = 0;
      n_next_1 = 1;
      next_1[0] = 0;
      done[0] = 1;
      while (n_next_1 > 0) {
         n_next_2 = 0;
         for (i = 0; i < n_next_1; ++i) {
            i1 = next_1[i];
            for (j = 0; j < temp_atm_nbr[i_species][i1]; ++j) {
               i2 = temp_atm_br[i_species][i1][j];
               if (!done[i2]) {
                  done[i2] = 1;
                  (*scan_atm_1)[i_species][i_scan] = i1;
                  (*scan_atm_2)[i_species][i_scan] = i2;
                  ++i_scan;
                  next_2[n_next_2] = i2;
                  ++n_next_2;
               }
            }
         }
         n_next_1 = n_next_2;
         p = next_1;
         next_1 = next_2;
         next_2 = p;
      }
      if (i_scan != n_atoms_per_mol[i_species] - 1)
         error_exit("Wrong number of scan list entries in set_up_scan_list");

      /* Free up memory. */
      free_1d_array(done);
      free_1d_array(next_1);
      free_1d_array(next_2);
     }
     else  /* Atomic specie. */
     {  
     i_scan = 0;
     (*scan_atm_1)[i_species][i_scan] = i_scan;
     (*scan_atm_2)[i_species][i_scan] = i_scan;
     }
   }
}

