/* Function declarations */

void read_mass_params(char *mass_file, mass_entry **mass, int *n_mass);
void read_lj_params(char *lj_file, lj_entry **lj, int *n_lj);
void read_e6_params(char *e6_file, e6_entry **e6, int *n_e6);

void start_new_build(char **struct_file, long *i_ran, int trial_switch,
    int n_species, int n_unit_cells,
    int *n_mols_per_unit_cell, int **n_atoms_per_mol, int **n_mols_per_species,
    int **n_bonds_per_mol, int ***temp_atm_lab, char ****temp_atm_type,
    double ****temp_atm_pos, double ***temp_atm_chg, int ***temp_atm_nbr,
    int ****temp_atm_br, double ****temp_atm_ord, int ***temp_bonds_1,
    int ***temp_bonds_2, double ***temp_bonds_ord, int *n_mols, int *n_atoms,
    int **mol_species);
void read_config_direct(char *config_file, int n_atoms, double **atom_coords,
    double **atom_vels);
void set_up_force_field_old(int n_species, int n_mols, int *n_atoms_per_mol,
     int n_mass, mass_entry *mass, int n_lj, lj_entry *lj, 
     int *mol_species, int *n_bonds_per_mol,
     double ***temp_atm_mass, char ***temp_atm_type, double ***temp_atm_sigma,
     double ***temp_atm_eps, double **mol_mass, double **mol_mass_true,
     int **mol_first_atm);
void set_up_force_field(int n_species, int n_mols, int *n_atoms_per_mol,
     int n_mass, mass_entry *mass, int *mol_species, int *n_bonds_per_mol,
     double ***temp_atm_mass, char ***temp_atm_type, double **mol_mass,
     double **mol_mass_true, int **mol_first_atm);
void convert_type(int n_species, int *n_atoms_per_mol,
     char ***temp_atm_type, int ***temp_atm_type_i, type_entry **atm_type,
     int *n_type);

void combination_array(double overlap_criterion, int n_type, int **comb_pot,
   double ***comb_par, double ***combine);

void allocate_memory_build(int n_atoms, int n_mols, int period_switch,
     double ***atom_coords, double ***scaled_atom_coords,
     double ***atom_vels, int **atom_rel, int **atom_type,
     double ***mol_coords, double ***scaled_mol_coords, double ***h,
     double ***h_inv, double ***rel_atom_coords, double **atom_mass,
     int n_sphero, double **length, int **mol_first_sphero);

void relative_atoms(int n_mols, int *mol_species, int *mol_first_atm,
    int *n_atoms_per_mol, int **temp_atm_type_i, int *atom_rel, int *atom_type);

void exclusion_array(int n_species, int *n_atoms_per_mol, int one_four_switch,
       int **temp_atm_nbr, int ***temp_atm_br, int ****exclusions);

void adjust_template_molecules(int n_species, int *n_atoms_per_mol,
      int *principal, double **temp_atm_mass, double ***temp_atm_pos);

void scaled_atomic_coords_single(int i_mol, int *n_atoms_per_mol,
       int *mol_first_atm, int *mol_species, double **h_inv, 
       double **atom_coords, double **scaled_atom_coords);

void box_inverse(double **h, double **h_inv);

void write_header_direct(char *header_file, int period_switch, int n_species,
  int *n_atoms_per_mol, int **temp_atm_lab, char ***temp_atm_type,
  int **temp_atm_nbr, int ***temp_atm_br, double ***temp_atm_ord,
  double ***temp_atm_pos, double **temp_atm_chg, int *n_bonds_per_mol, 
  int **temp_bonds_1, int **temp_bonds_2, double **temp_bonds_ord, 
  int *n_mols_per_species, int n_mols, int *mol_species);

int isotropic_start(Display *dpy, Window win, GLboolean doubleBuffer,
      GLUquadricObj *qobj, int graph_switch,
      int n_mols, double skin, double **h,
      double **h_inv, long *i_ran, int *mol_first_atm, int *n_atoms_per_mol,
      double ***temp_atm_pos,  double **mol_coords, double **scaled_mol_coords,
      double **atom_coords, double **scaled_atom_coords, int *n_bonds_per_mol,
      int **temp_bonds_1, int **temp_bonds_2,
      int n_species, int *n_mols_per_species, int *mol_species, int *atom_rel,
      int *atom_type, int species_choice, int *comb_col,
      int resph, double radius_sph, double radius_cyl, double *length,
      int *mol_first_sphero);

int nematic_start(Display *dpy, Window win, GLboolean doubleBuffer,
      GLUquadricObj *qobj, int graph_switch, int polar_switch,
      int n_mols, double skin, double **h,
      double **h_inv, long *i_ran, int *mol_first_atm, int *n_atoms_per_mol,
      double ***temp_atm_pos,  double **mol_coords, double **scaled_mol_coords,
      double **atom_coords, double **scaled_atom_coords, int *n_bonds_per_mol,
      int **temp_bonds_1, int **temp_bonds_2,
      int n_species, int *n_mols_per_species, int *mol_species, int *atom_rel,
      int *atom_type, int species_choice, int *comb_col,
      int resph, double radius_sph, double radius_cyl, double *length,
      int *mol_first_sphero);

int smectic_start(Display *dpy, Window win, GLboolean doubleBuffer,
      GLUquadricObj *qobj, int graph_switch, int polar_switch, int n_mols,
      int n_layers, double skin,
      double **h, double **h_inv, long *i_ran, int *mol_first_atm,
      int *n_atoms_per_mol, double ***temp_atm_pos,  double **mol_coords,
      double **scaled_mol_coords, double **atom_coords,
      double **scaled_atom_coords, int *n_bonds_per_mol,
      int **temp_bonds_1, int **temp_bonds_2,
      int n_species, int *n_mols_per_species, int *mol_species, int *atom_rel,
      int *atom_type, int species_choice, int *comb_col,
      int resph, double radius_sph, double radius_cyl, double *length,
      int *mol_first_sphero);


/* Routines in overlap.c */
int overlap(double *s1, double *u1, double *s2, double *u2,
            int sphero1, int sphero2, double *length, double skin, double **h);


void redraw(Display *dpy, Window win, GLboolean doubleBuffer,
    GLUquadricObj *qobj, int graph_switch, int n_mols, int *mol_species,
    int *mol_first_atm, int *n_atoms_per_mol, int *n_bonds_per_mol,
    double **mol_coords, double **rel_atom_coords,
    double **h, int **temp_bonds_1, int **temp_bonds_2, int species_choice,
    int *atom_type, int *comb_col, int resph, double radius_sph,
    double radius_cyl, short *keep_going);
