void pme_recip(int n_atoms, int n_grid_x, int n_grid_y, int n_grid_z,
   double **scaled_atom_coords, double **gridded_atom_coords,
   int B_spline_order, double **M_x, double **M_y, double **M_z,
   double **dM_du_x, double **dM_du_y, double **dM_du_z,
   double *atom_charges, fft elec,
   double volume, double alpha,
   double *b_1_un, double *b_2_un, double *b_3_un,
   double *b_mod2_x, double *b_mod2_y, double *b_mod2_z,
   double *pe_coul_recip, double **vir_coul_recip,
   double **atom_forces_coul_recip);

void B_spline_dft_moduli(int B_spline_order,
   int n_grid_x, int n_grid_y, int n_grid_z,
   double *b_mod2_x, double *b_mod2_y, double *b_mod2_z);

void B_spline_dft_modulus(int B_spline_order, int n_grid, double *M_tmp,
                          double *b_mod2);

void B_spline_single(double *u, int B_spline_order,
   double *M_x_ptr, double *M_y_ptr, double *M_z_ptr,
   double *dM_du_x_ptr, double *dM_du_y_ptr, double *dM_du_z_ptr);

void B_spline_recursion(double *u, int j, double *M_x_ptr, double *M_y_ptr,
double *M_z_ptr);

void gridded_atomic_coords(int n_atoms, double *atom_charges,
   int n_grid_x, int n_grid_y, int n_grid_z,
   double **scaled_atom_coords, double **gridded_atom_coords);

void B_spline_coefficients(int n_atoms, double **gridded_atom_coords,
   double *atom_charges,
   int B_spline_order, double **M_x, double **M_y, double **M_z,
   double **dM_du_x, double **dM_du_y, double **dM_du_z);

void B_spline_derivative(int j, double *M_x_ptr, double *M_y_ptr,
    double *M_z_ptr, double *dM_du_x_ptr, double *dM_du_y_ptr,
    double *dM_du_z_ptr);

void grid_atomic_charges(int n_atoms, double **gridded_atom_coords,
   double *atom_charges, int n_grid_x, int n_grid_y, int n_grid_z,
   int B_spline_order, double **M_x, double **M_y, double **M_z,
   fft elec);

void pme_recip_energy_virial(double volume, double alpha,
   int n_grid_x, int n_grid_y, int n_grid_z,
   double *b_1_un, double *b_2_un, double *b_3_un,
   int B_spline_order, fft elec,
   double *b_mod2_x, double *b_mod2_y, double *b_mod2_z,
   double *pe_coul_recip, double **vir_coul_recip);

void pme_recip_energy_virial_half(double volume, double alpha,
   int n_grid_x, int n_grid_y, int n_grid_z,
   double *b_1_un, double *b_2_un, double *b_3_un,
   int B_spline_order, fft elec,
   double *b_mod2_x, double *b_mod2_y, double *b_mod2_z,
   double *pe_coul_recip, double **vir_coul_recip);

void pme_recip_forces(int n_atoms, double *atom_charges,
   double **gridded_atom_coords,
   int n_grid_x, int n_grid_y, int n_grid_z,
   double *b_1_un, double *b_2_un, double *b_3_un,
   int B_spline_order, double **M_x, double **M_y, double **M_z,
   double **dM_du_x, double **dM_du_y, double **dM_du_z,
   fft elec, double **atom_forces_coul_recip);









