/* Header file for force field module. */

/* Structure declarations. */

/* The mass_entry structure contains atom types and their corresponding masses. */
typedef struct {
   char type[TYPE_MAX];   /* Atom type. */
   double true_mass,      /* True atomic mass. */
          eff_mass;       /* Effective atomic mass. */
} mass_entry;

/* The lj_entry structure contains the atom types and van der Waals
   (LJ) parameters for a single pair of nonbonded atoms. */
typedef struct {
   char type_1[TYPE_MAX], /* Tags of atoms involved in vdW interaction. */
        type_2[TYPE_MAX];
   double sigma,          /* Parameters for LJ potential: */
          epsilon;        /* u(r) = 4 * epsilon * (pow(sigma / r, 12) */
                          /*                       - pow(sigma / r, 6)). */
} lj_entry;

/* The e6_entry structure contains the atom types and van der Waals
   (exp-6) parameters for a single pair of nonbonded atoms. */
typedef struct {
   char type_1[TYPE_MAX], /* Tags of atoms involved in vdW interaction. */
        type_2[TYPE_MAX];
  double  A,              /* Parameters for exp-6 vdW potential: */
          B,              /* u(r) = A * exp(- B * r) - C * pow(r, - 6). */
          C;
} e6_entry;

/* The pot_entry structure contains the atom types and form of the pair 
   interactions. */
typedef struct {
   char type_1[TYPE_MAX], /* Tags of atoms involved in vdW interaction. */
        type_2[TYPE_MAX];
   int  form;             /* Pair interaction form. */
} pot_entry;

/* The type_entry structure. */	 
typedef struct {
   char type[TYPE_MAX];   /* Atom type. */
   int id;                /* Identifier. */
} type_entry;

/* The strect_entry structure contains the atom types, spring constant and
   r_equil */
typedef struct {
   char type_1[TYPE_MAX], /* Tags of atoms involved in bending interaction. */
        type_2[TYPE_MAX];
  double  spring,              /* spring constant and r_equil */
          r_equil;
} stretch_entry;

/* The bend_entry structure contains the atom types, spring constant and
   theta_equlibrium */
typedef struct {
   char type_1[TYPE_MAX], /* Tags of atoms involved in bending interaction. */
        type_2[TYPE_MAX],
        type_3[TYPE_MAX];
  double  spring_bend,              /* spring constant and theta_equil */
          theta_equil;
} bend_entry;
