/* Molecular center of mass routine for molecular modeling package */

#include "build.h"

/* Calculate center of mass positions of molecules. */
void center_of_mass_positions(int period_switch, int n_mols, int n_species, 
  int *n_atoms_per_mol, int *mol_species, double *atom_mass, 
  int *mol_first_atm, double ***corr, double **atom_coords, double **scaled_atom_coords, 
  int **scan_atm_1, int **scan_atm_2, double *mol_mass, double **h, 
  double **h_inv, double **mol_coords, double **scaled_mol_coords, 
  double **rel_atom_coords)
{
   int i_mol, i_species, i_scan, i_atom, skip, rel_1, rel_2, abs_1, abs_2, abs,
      v_skip, v_rel, v_abs, k;
   double s_bond[NDIM], bond[NDIM];

   /* Allocate memory for temporary array. */
/*   corr = allocate_1d_array(n_species, sizeof(double**));
   for (i_species = 0; i_species < n_species; ++i_species)
      corr[i_species] = allocate_2d_array(n_atoms_per_mol[i_species], NDIM, 
                              sizeof(double)); 
*/
   /* Calculate bond vectors if necessary. */
/*   if (vars.bond_flag) {
      if (params.period_switch)
         calculate_bond_vectors_period();
      else
         calculate_bond_vectors_free();
   }
*/
   /* Loop over molecules. */
   for (i_mol = 0; i_mol < n_mols; ++i_mol) {

      /* Get label of molecular species. */
      i_species = mol_species[i_mol];

      /* Get atom and bond vector label offsets. */
      skip = mol_first_atm[i_mol];

      /* Calculate corrected position of first atom. */
      rel_1 = scan_atm_1[i_species][0];
      abs_1 = skip + rel_1;
      for (k = 0; k < NDIM; ++k)
        corr[i_species][rel_1][k] = atom_coords[abs_1][k];
/*      printf("%g %g %g\n",corr[i_species][rel_1][0],corr[i_species][rel_1][1],
corr[i_species][rel_1][2]); */

      /* Add contribution of first atom to center of mass position. */
      for (k = 0; k < NDIM; ++k)
        mol_coords[i_mol][k] = atom_mass[abs_1] * corr[i_species][rel_1][k];

/*printf("atom_mass = %g\n",atom_mass[abs_1]); */
      /* Scan through the molecule, adding contributions to center of mass
         position. */
      for (i_scan = 0; i_scan < n_atoms_per_mol[i_species] - 1; ++i_scan) {

         /* Get relative and absolute labels of atoms in scan list. */
         rel_1 = scan_atm_1[i_species][i_scan];
         rel_2 = scan_atm_2[i_species][i_scan];
         abs_1 = skip + rel_1;
         abs_2 = skip + rel_2;

         /* Calculate bond vector and bond length. */
         for (k = 0; k < NDIM; ++k)
         {
            s_bond[k] = scaled_atom_coords[abs_2][k]
                      - scaled_atom_coords[abs_1][k];
            s_bond[k] -= NINT(s_bond[k]);
/*            printf("%g %g\n",scaled_atom_coords[abs_1][k],scaled_atom_coords[abs_2][k]); */
         }
         bond[0] = h[0][0] * s_bond[0] + h[0][1] * s_bond[1]
                  + h[0][2] * s_bond[2];
         bond[1] = h[1][1] * s_bond[1] + h[1][2] * s_bond[2];
         bond[2] = h[2][2] * s_bond[2];
/*printf("bond : %g %g %g\n",bond[0],bond[1],bond[2]);*/

         for (k = 0; k < NDIM; ++k)
           corr[i_species][rel_2][k] = corr[i_species][rel_1][k] + bond[k];

         /* Add contribution of atom to center of mass position. */
         for (k = 0; k < NDIM; ++k)
           mol_coords[i_mol][k] += atom_mass[abs_2] * corr[i_species][rel_2][k];
      }

      /* Normalize center of mass position. */
      for (k = 0; k < NDIM; ++k)
        mol_coords[i_mol][k] /= mol_mass[i_species];
/*      printf("%g %g %g\n",mol_coords[i_mol][0],mol_coords[i_mol][1], mol_coords[i_mol][2]); */

      /* Calculate relative atomic coordinates. */
      for (i_atom = 0; i_atom < n_atoms_per_mol[i_species]; ++i_atom) {
         abs = skip + i_atom;
         for (k = 0; k < NDIM; ++k)
           rel_atom_coords[abs][k] = corr[i_species][i_atom][k] 
                                     - mol_coords[i_mol][k];
  /*    printf("%g %g %g\n",rel_atom_coords[abs][0],rel_atom_coords[abs][1], rel_atom_coords[abs][2]); */
      }
/*printf("---------------------------\n");*/
   }
   /* If we are using periodic boundary conditions, calculate scaled
      center of mass position and apply periodic boundary conditions. */
   if (period_switch)
      for (i_mol = 0; i_mol < n_mols; ++i_mol) {
         scaled_mol_coords[i_mol][0] = h_inv[0][0] * mol_coords[i_mol][0]
            + h_inv[0][1] * mol_coords[i_mol][1]
            + h_inv[0][2] * mol_coords[i_mol][2];
         scaled_mol_coords[i_mol][1] = h_inv[1][1] * mol_coords[i_mol][1]
            + h_inv[1][2] * mol_coords[i_mol][2];
         scaled_mol_coords[i_mol][2] = h_inv[2][2] * mol_coords[i_mol][2];
         for (k = 0; k < NDIM; ++k)
           scaled_mol_coords[i_mol][k] -= NINT(scaled_mol_coords[i_mol][k]);
         mol_coords[i_mol][0] = h[0][0] * scaled_mol_coords[i_mol][0]
            + h[0][1] * scaled_mol_coords[i_mol][1]
            + h[0][2] * scaled_mol_coords[i_mol][2];
         mol_coords[i_mol][1] = h[1][1] * scaled_mol_coords[i_mol][1]
            + h[1][2] * scaled_mol_coords[i_mol][2];
         mol_coords[i_mol][2] = h[2][2] * scaled_mol_coords[i_mol][2];
      }
}
