/* Utility routines for simulation programs. */

#include "build.h"

/* Assign one n-dimensional vector to another. */
void *assign_vector(double *v, double *v1, int n)
{
   int i;

   for (i = 0; i < n; ++i)
      v1[i] = v[i];
   return v1;
}

/* Calculate sum of two n-dimensional vectors. */
void *vector_sum(double *v1, double *v2, double *v3, int n)
{
   int i;

   for (i = 0; i < n; ++i)
      v3[i] = v1[i] + v2[i];
   return v3;
}

/* Calculate difference of two n-dimensional vectors. */
void *vector_difference(double *v1, double *v2, double *v3, int n)
{
   int i;

   for (i = 0; i < n; ++i)
      v3[i] = v1[i] - v2[i];
   return v3;
}

/* Calculate dot product of two n-dimensional vectors. */
double dot_product(double *v1, double *v2, int n)
{
   int i;
   double product = 0.0;

   for (i = 0; i < n; ++i)
      product += v1[i] * v2[i];
 
   return product;
}

/* Calculate cross product of two 3-dimensional vectors. */
/* Maybe one day we'll be able to do the more challenging
   n_dimensional case...just for completness! */
void cross_product(double *v1, double *v2, double *v3, int n)
{
   v3[0] = v1[1] * v2[2] - v1[2] * v2[1];
   v3[1] = v1[2] * v2[0] - v1[0] * v2[2];
   v3[2] = v1[0] * v2[1] - v1[1] * v2[0];
}

/* Calculate magnitude of a n-dimensional vector. */
double magnitude(double *v, int n)
{
  return sqrt(dot_product(v, v, n)); 
}

/* Multiply n-dimensional vector by a scale factor. */
void scale_vector(double *v, double *v1, int n, double scale_factor)
{
   int i;

   for (i = 0; i < n; ++i)
      v1[i] = scale_factor * v[i];
}

