#include "build.h"
#include "ff.h"
#include "proto.h"

void init_ewa(double **h, double **h_inv, double volume, double g_cutoff, 
              int n_atoms,
              int *m1_max, int *m2_max, int *m3_max, double *a1, double *a2, 
              double *a3, double *b1, double *b2, double *b3, 
              double ***cos_G_1_dot_r, double ***sin_G_1_dot_r, 
              double ***cos_G_2_dot_r, double ***sin_G_2_dot_r, 
              double ***cos_G_3_dot_r, double ***sin_G_3_dot_r) 
{
double recip_volume, b_1_mag, b_2_mag, b_3_mag,
       recip_area_1_2, recip_area_2_3, recip_area_3_1,
       b_1_perp, b_2_perp, b_3_perp, b_1_dot_b_2, b_2_dot_b_3, b_3_dot_b_1;
int m1_max_old, m2_max_old, m3_max_old, i;

   a1[0] = h[0][0];
   a1[1] = h[0][1];
   a1[2] = h[0][2];

   a2[0] = h[1][0];
   a2[1] = h[1][1];
   a2[2] = h[1][2];

   a3[0] = h[2][0];
   a3[1] = h[2][1];
   a3[2] = h[2][2];

   /* Calculate conventional primitive reciprocal lattice vectors and
      quantities that depend on them. */
   b1[0] = h_inv[0][0] * TWO_PI;
   b1[1] = h_inv[0][1] * TWO_PI;
   b1[2] = h_inv[0][2] * TWO_PI;
   b2[0] = h_inv[1][0] * TWO_PI;
   b2[1] = h_inv[1][1] * TWO_PI;
   b2[2] = h_inv[1][2] * TWO_PI;
   b3[0] = h_inv[2][0] * TWO_PI;
   b3[1] = h_inv[2][1] * TWO_PI;
   b3[2] = h_inv[2][2] * TWO_PI;

   b_1_mag = magnitude(b1, 3); 
   b_2_mag = magnitude(b2, 3);
   b_3_mag = magnitude(b3, 3);

   b_1_dot_b_2 = dot_product(b1, b2, 3);
   b_2_dot_b_3 = dot_product(b2, b3, 3);
   b_3_dot_b_1 = dot_product(b3, b1, 3);

   recip_area_1_2 = sqrt(SQR(b_1_mag) * SQR(b_2_mag) - SQR(b_1_dot_b_2));
   recip_area_2_3 = sqrt(SQR(b_2_mag) * SQR(b_3_mag) - SQR(b_2_dot_b_3));
   recip_area_3_1 = sqrt(SQR(b_3_mag) * SQR(b_1_mag) - SQR(b_3_dot_b_1));

   recip_volume = CUBE(TWO_PI) / volume;
   b_1_perp = recip_volume / recip_area_2_3;
   b_2_perp = recip_volume / recip_area_3_1;
   b_3_perp = recip_volume / recip_area_1_2;

   /* Compute maximum grid point used for reciprocal Ewald. */
   m1_max_old = *m1_max;
   m2_max_old = *m2_max;
   m3_max_old = *m3_max;
   
   *m1_max = (int) (g_cutoff / b_1_perp);
   *m2_max = (int) (g_cutoff / b_2_perp);
   *m3_max = (int) (g_cutoff / b_3_perp);

   /* Allocate or reallocate memory for arrays used in Ewald routines
      if necessary. */
   if (*m1_max != m1_max_old)
      for (i = 0; i < n_atoms; ++i){
         (*cos_G_1_dot_r)[i] = grealloc((*cos_G_1_dot_r)[i],
                  (*m1_max + 1) * sizeof(double));
         (*sin_G_1_dot_r)[i] = grealloc((*sin_G_1_dot_r)[i],
                  (*m1_max + 1) * sizeof(double));
      }
   if (*m2_max != m2_max_old)
      for (i = 0; i < n_atoms; ++i){
         (*cos_G_2_dot_r)[i] = grealloc((*cos_G_2_dot_r)[i],
                  (*m2_max + 1) * sizeof(double));
         (*sin_G_2_dot_r)[i] = grealloc((*sin_G_2_dot_r)[i],
                  (*m2_max + 1) * sizeof(double));
      }
   if (*m3_max != m3_max_old)
      for (i = 0; i < n_atoms; ++i){
         (*cos_G_3_dot_r)[i] = grealloc((*cos_G_3_dot_r)[i],
                  (*m3_max + 1) * sizeof(double));
         (*sin_G_3_dot_r)[i] = grealloc((*sin_G_3_dot_r)[i],
                  (*m3_max + 1) * sizeof(double));
      }

}
