/* Interaction of the particles with the walls 
   (modelled as a given potential - see pot.ff for the label Wall) */
  
#include "build.h"


void force_pore(int n_atoms, int n_type, int *atom_type, 
   int **comb_pot, double ***comb_par, double r2_on, 
   double r2_off, double gamma, double three_gamma_over_two, 
   double two_over_gamma_cubed, double *pe_pore_s, double **atom_coords,  
   double r0, double x0, double y0, double z0,
   double **at_stress_pore_s, double **mol_stress_pore_s, double **f_pore_s)
{
   int i, k, pot_form, i_type, j_type, i_rel, compute_flag;
   double x, y, z, x_sep, y_sep, z_sep, r, r_sep, r_sep2, rho_sep2, z_sep2, 
          u_pore, fpore, signe_x, signe_y, signe_z, theta;

   /* Initialisation. */
   *pe_pore_s = 0.0;

   /* Zero short-range forces. */
   for (i = 0; i < n_atoms; ++i)
      for (k = 0; k < NDIM; ++k)
         f_pore_s[i][k] = 0.0;

   for (i = 0; i < NDIM; ++i)
      for (k = 0; k < NDIM; ++k)
         at_stress_pore_s[i][k] = 0.0;
  
   /* Get label of the pore wall (by construction it is the last label). */
   j_type = n_type - 1;
 
   /* Loop over atoms. */
   for (i = 0; i < n_atoms ; ++i) {
      
      /* Initialize signe. */
      signe_z = 1.0;

      /* Get attributes of atom i. */
      x = atom_coords[i][0];
      y = atom_coords[i][1];
      z = atom_coords[i][2];
      if (z < 0.0) signe_z = - 1.0;
      
      i_type = atom_type[i];

      /* Compute minimum separation between atom i and the wall. */
      z_sep = fabs(z) - z0;
      if (z_sep < 0.0){ /* Interior of the pore. */
         z_sep = 0.0;
         z_sep2 = 0.0;
      }
      else
         z_sep2 = SQR(z_sep);

      /* Calculate radial pair separation. */
      r = sqrt(SQR(x) + SQR(y));
      r_sep = r0 - r;
      if (r_sep < 0.0){  /* Exterior of the pore. */
         x_sep = 0.0; 
         y_sep = 0.0;
         r_sep2 = 0.0;
      }
      else{              /* Interior of the pore. */
         theta = atan2(y, x);
         x_sep = x - r0 * cos(theta);
         y_sep = y - r0 * sin(theta);
         r_sep2 = SQR(r_sep);
      }
       
      rho_sep2 = r_sep2 + z_sep2;
               
      /* Get the pair interaction form. */
      pot_form = comb_pot[i_type][j_type];
      compute_flag = 0;
/****************************************************************************/
/********************** Begin of pair interaction menu. *********************/
/****************************************************************************/
      /* Compute pair interaction. */
      compute_pot(i_type, j_type, pot_form, r2_off, r2_on, rho_sep2, 
                  comb_par, gamma, three_gamma_over_two, two_over_gamma_cubed,
                  &u_pore, &fpore, &compute_flag);

      if (compute_flag) {

         /* Add contributions to potential energy and atomic and
            molecular pressure tensors. */
         *pe_pore_s += u_pore;

         /* Compute separation distances. */
         z_sep *= signe_z;

         /* Add contributions to force. */
         f_pore_s[i][0] = x_sep * fpore;
         f_pore_s[i][1] = y_sep * fpore;
         f_pore_s[i][2] = z_sep * fpore;
               
         /* Compute stress tensor. */
         at_stress_pore_s[0][0] += x_sep * f_pore_s[i][0];
         at_stress_pore_s[1][1] += y_sep * f_pore_s[i][1];
         at_stress_pore_s[2][2] += z_sep * f_pore_s[i][2];
         at_stress_pore_s[0][1] += x_sep * f_pore_s[i][1];
         at_stress_pore_s[0][2] += x_sep * f_pore_s[i][2];
         at_stress_pore_s[1][2] += y_sep * f_pore_s[i][2];

      }

/****************************************************************************/
/************************ End of pair interaction menu. *********************/
/****************************************************************************/
/*
   printf("%d : x = %g, y = %g, z = %g\n", i, x, y, z);
   printf("flag = %d : fx = %g, fy = %g, fz = %g\n", compute_flag, f_pore_s[i][0], f_pore_s[i][1], f_pore_s[i][2]);
   printf("**************************************\n");
*/
   }
}
