#include "build.h"
#include "ff.h"

/* Compute short-range Coulomb interaction (i.e real part)  between 2 sites. */
void compute_pot_elec(int i_rel, int j_rel, int i_species, int j_species,
     double ****prod_chg, double r2_sep, double alpha, double alpha2, 
     double one_over_erf_tab_incr, double *erfc_sqrt_tab, 
     double two_alpha_over_sqrt_pi, double *u_coul, double *f_coul) 
{
int  i_tab;
double one_over_r_sep, one_over_r2_sep, alpha2_r2, x_tab, delt_tab, y1, y2, 
   erfc_alpha_r, exp_minus_alpha2_r2, erfc_alpha_r_over_r, charge_prod; 

   one_over_r2_sep = 1.0 / r2_sep;
   one_over_r_sep = sqrt(one_over_r2_sep);
   alpha2_r2 = alpha2 * r2_sep;
   x_tab = alpha2_r2 * one_over_erf_tab_incr;
   i_tab = (int) x_tab;
   if (i_tab < N_ERF_TAB) {
       delt_tab = x_tab - i_tab;
       y1 = erfc_sqrt_tab[i_tab];
       y2 = erfc_sqrt_tab[i_tab + 1];
       erfc_alpha_r = y1 + delt_tab * (y2 - y1);
   } 
   else  
       erfc_alpha_r = erfc(alpha / one_over_r_sep);
   exp_minus_alpha2_r2 = exp(- alpha2_r2);
   erfc_alpha_r_over_r = erfc_alpha_r * one_over_r_sep;
   charge_prod = prod_chg[i_species][i_rel][j_species][j_rel];
   *u_coul = charge_prod * erfc_alpha_r_over_r;
   *f_coul = charge_prod * one_over_r2_sep * (erfc_alpha_r_over_r
                     + two_alpha_over_sqrt_pi * exp_minus_alpha2_r2);
}

/*****************************************************************************/

/* Subtract contributions to long-range Coulomb interactions from
   nonbonded exclusions, which are implicitly contained in the
   reciprocal-space Ewald sum. */
void subtract_nonbonded_exclusions(int n_mols, int *mol_species, 
     int *mol_first_atm, int *n_atoms_per_mol, int ***exclusions, double **h, 
     double volume, double **scaled_atom_coords, double ****prod_chg, 
     int ****comb_chg, double alpha, double alpha2, 
     double two_alpha_over_sqrt_pi, double one_over_erf_tab_incr, 
     double *erf_sqrt_tab, double pe_coul_self, double *pe_coul_recip, 
     double **vir_coul_recip, double **f_coul_recip, double *p_normal_coul, 
     double *p_tangent_coul, int ift_switch, int n_slab) 
{
   int i_mol, i_species, i, j, i_rel, j_rel, skip;
   double sx_sep, sy_sep, sz_sep, x_sep, y_sep, z_sep,
      r2_sep, one_over_r2_sep, one_over_r_sep,
      charge_prod,
      alpha2_r2, erf_alpha_r, erf_alpha_r_over_r, exp_minus_alpha2_r2,
      u_coul, f_coul,
      fx_coul, fy_coul, fz_coul;
   int i_tab, slab_index;
   double x_tab, delt_tab, y1, y2, p_norm, z_coords, r_sep;
   double px=0, tx = 0;
   

   /* Loop over molecules. */
   for (i_mol = 0; i_mol < n_mols; ++i_mol) {

      /* Get label of molecular species. */
      i_species = mol_species[i_mol];

      /* Get atom label offset. */
      skip = mol_first_atm[i_mol];

      /* Loop over intramolecular pairs. */
      for (i_rel = 0; i_rel < n_atoms_per_mol[i_species] - 1; ++i_rel) {
         for (j_rel = i_rel + 1; j_rel < n_atoms_per_mol[i_species]; ++j_rel) {

            /* Test for nonbonded exclusions and check if the sites are
               charged. */
            if ((!exclusions[i_species][i_rel][j_rel])&&
                (comb_chg[i_species][i_rel][i_species][j_rel])) {

               /* Calculate absolute labels of atoms. */
               i = skip + i_rel;
               j = skip + j_rel;

               /* Calculate pair separation. */
               sx_sep = scaled_atom_coords[j][0] - scaled_atom_coords[i][0];
               sy_sep = scaled_atom_coords[j][1] - scaled_atom_coords[i][1];
               sz_sep = scaled_atom_coords[j][2] - scaled_atom_coords[i][2];
               sx_sep -= NINT(sx_sep);
               sy_sep -= NINT(sy_sep);
               sz_sep -= NINT(sz_sep);
               x_sep = h[0][0] * sx_sep + h[0][1] * sy_sep + h[0][2] * sz_sep;
               y_sep = h[1][1] * sy_sep + h[1][2] * sz_sep;
               z_sep = h[2][2] * sz_sep;
               r2_sep = SQR(x_sep) + SQR(y_sep) + SQR(z_sep);
                r_sep = sqrt(r2_sep);

               /* Calculate Coulomb interactions due to nonbonded exclusions
                  and subtract them from long-range Coulomb interactions. */
               one_over_r2_sep = 1.0 / r2_sep;
               one_over_r_sep = sqrt(one_over_r2_sep);
               alpha2_r2 = alpha2 * r2_sep;
               x_tab = alpha2_r2 * one_over_erf_tab_incr;
               i_tab = (int) x_tab;
               if (i_tab < N_ERF_TAB) {
                  delt_tab = x_tab - i_tab;
                  y1 = erf_sqrt_tab[i_tab];
                  y2 = erf_sqrt_tab[i_tab + 1];
                  erf_alpha_r = y1 + delt_tab * (y2 - y1);
               }
               else
                  erf_alpha_r = erf(alpha / one_over_r_sep);
               exp_minus_alpha2_r2 = exp(- alpha2_r2);
               erf_alpha_r_over_r = erf_alpha_r * one_over_r_sep;
               charge_prod = prod_chg[i_species][i_rel][i_species][j_rel];
               u_coul = charge_prod * erf_alpha_r_over_r;
               f_coul = charge_prod * one_over_r2_sep * (erf_alpha_r_over_r
                  - two_alpha_over_sqrt_pi * exp_minus_alpha2_r2);
               fx_coul = x_sep * f_coul;
               fy_coul = y_sep * f_coul;
               fz_coul = z_sep * f_coul;
               f_coul_recip[i][0] += fx_coul;
               f_coul_recip[i][1] += fy_coul;
               f_coul_recip[i][2] += fz_coul;
               f_coul_recip[j][0] -= fx_coul;
               f_coul_recip[j][1] -= fy_coul;
               f_coul_recip[j][2] -= fz_coul;

               /* Subtract contributions from potential energy and atomic
                  stress tensor. */
                  *pe_coul_recip -= u_coul;
                  vir_coul_recip[0][0] -= x_sep * fx_coul;
                  vir_coul_recip[1][1] -= y_sep * fy_coul;
                  vir_coul_recip[2][2] -= z_sep * fz_coul;
                  vir_coul_recip[0][1] -= x_sep * fy_coul;
                  vir_coul_recip[0][2] -= x_sep * fz_coul;
                  vir_coul_recip[1][2] -= y_sep * fz_coul;

            /* Addition to compute normal and tangential stress profile */
              if ( ift_switch > 0){
              px = (z_sep * fz_coul);
              tx = (x_sep * fx_coul + y_sep * fy_coul)*0.5;

              slab_index = (int) ((scaled_atom_coords[j][2] + 0.5) * n_slab);
              p_normal_coul[slab_index] -= px;
              p_tangent_coul[slab_index] -= tx;

              slab_index = (int) ((scaled_atom_coords[i][2] + 0.5) * n_slab);
              p_normal_coul[slab_index] -= px;
              p_tangent_coul[slab_index] -= tx;
             }

            }
         }
      }
   }

   /* Subtract contribution to long-range Coulomb
      potential energy from self-interaction, which is implicitly contained
      in the reciprocal-space Ewald sum. Also, normalize contributions to
      potential energy and atomic stress tensor. */

      *pe_coul_recip -= pe_coul_self;
      p_norm = 1.0 / volume;
      for (i = 0; i < 3; ++i)
         for (j = i; j < 3; ++j)
            vir_coul_recip[i][j] *= p_norm;

      if (ift_switch >0) {
       p_norm = n_slab/volume;
       for ( i = 0; i < n_slab; ++i){
           p_normal_coul[i] *= p_norm;
           p_tangent_coul[i] *= p_norm;
       }   
     }
}
