/* Input/output routines for template module. */

#include "build.h"
#include "ff.h"

/****************************************************************************/
/* Read and Set up colors for beads and bonds. */
/*
*/

void read_set_up_color(char *color_file, type_entry *atm_type, int n_type, 
   int **comb_col)
{
   FILE *f_input;
   char line[MAX_LINE], **token = NULL;
   char *type_1, *color_1, *type_i, *color_i;
   int i_type, i_col, id_0, test_1, found, found_col, n_tokens, *found_entry;

   /* Allocate memory for color id array. */
   *comb_col = allocate_1d_array(n_type, sizeof(int));

   /* Allocate memory for temporary array. */
   found_entry = allocate_1d_array(n_type, sizeof(int)); 

   /* Initialisation. */
   for (i_type = 0; i_type < n_type; ++i_type)
       found_entry[i_type] = 0;

   /* Open potential file. */
   if ((f_input = fopen(color_file, "r")) == NULL)
      error_exit("Unable to open color.map");

   /* Read and parse col_file line. */ 
   while (fgets(line, MAX_LINE, f_input) != NULL) {
     if (strncmp(line, "#", 1) != 0) {
       n_tokens = parse_tokens(line, &token);
       if (n_tokens != 2)
           error_exit("Invalid number of entries in color_file.");
       type_i = token[0];
       color_i = token[1];

       /* Search for the integer identifiers corresponding 
          to the atom type. */
         found = 0;
         for (i_type = 0; i_type < n_type; ++i_type) {
            type_1 = atm_type[i_type].type;
            test_1 = strcmp(type_i, type_1) == 0;
            if (test_1) {
              found = 1;
              break;
            }
         }
                  
         if (found) {
            /* Search for the color entry. */ 
            found_col = 0;
            for (i_col = 0; i_col < REGCLRS; ++i_col) {
               color_1 = defColorNames[i_col];
               test_1 = strcmp(color_i, color_1) == 0;
               if (test_1) {
                  found_col = 1;
                  break;
               }
            }

            /* If found_col == 0, then the color specified by the user
               in color_file is undefined. */
            if (found_col == 0){
                printf("%s entry undefined in color_file\n", color_i);
                exit(1);
            }

            /* Get integer identifier. */
            id_0 = atm_type[i_type].id;

            /* Assign color id to atom type. */
            (*comb_col)[id_0] = i_col;

            /* Update found entry counter. */
            found_entry[id_0] = 1;          
         }
     } /* end if. */
   } /* end while */

   /* Check that all atom types got a color id. */
   for (i_type = 0; i_type < n_type; ++i_type)
       if (found_entry[i_type] == 0) {
           printf("%s entry not found in color_file.\n", atm_type[i_type].type);           exit(1);
       }

   /* Close potential file. */
   fclose(f_input); 
}
/*****************************************************************************/
