#include "build.h"
#include "stress_prof.h"
#include "allocate.h"

void init_stress_prof(int n_slabs, int n_blocks, double **p_normal_vdw, double **p_tangent_vdw,
                 double ***p_normal_vdw_block, double ***p_tangent_vdw_block, double **p_normal_coul,
                 double **p_tangent_coul, double ***p_normal_coul_block, double ***p_tangent_coul_block,
                 double **p_normal, double **p_tangent, double ***p_normal_block, double ***p_tangent_block,
                 double **dens_prof, double ***dens_prof_block, double **ift_block,
                 double **p_tangent_stretch, double **p_normal_stretch, double **p_tangent_bend,
                 double **p_normal_bend, double ***dens_prof_species, double ****dens_prof_species_block,
                 int n_species)
{
 
    *p_normal_vdw = (double *) allocate_1d_array(n_slabs, sizeof(double));
    *p_tangent_vdw = (double *) allocate_1d_array(n_slabs, sizeof(double));
    *p_normal_vdw_block = (double **) allocate_2d_array(n_slabs, n_blocks, sizeof(double));
    *p_tangent_vdw_block = (double **) allocate_2d_array(n_slabs, n_blocks, sizeof(double));
    *p_normal_coul = (double *) allocate_1d_array(n_slabs, sizeof(double));
    *p_tangent_coul = (double *) allocate_1d_array(n_slabs, sizeof(double));
    *p_normal_coul_block = (double **) allocate_2d_array(n_slabs, n_blocks, sizeof(double));
    *p_tangent_coul_block = (double **) allocate_2d_array(n_slabs, n_blocks, sizeof(double));
    *p_normal = (double *) allocate_1d_array(n_slabs, sizeof(double));
    *p_tangent = (double *) allocate_1d_array(n_slabs, sizeof(double));
    *p_normal_block = (double **) allocate_2d_array(n_slabs, n_blocks, sizeof(double));
    *p_tangent_block = (double **) allocate_2d_array(n_slabs, n_blocks, sizeof(double));
    *dens_prof = (double *) allocate_1d_array(n_slabs, sizeof(double));
    *dens_prof_block = (double **) allocate_2d_array(n_slabs, n_blocks, sizeof(double));
    *ift_block = (double *) allocate_1d_array(n_blocks, sizeof(double));
    *p_tangent_stretch = (double *) allocate_1d_array(n_slabs, sizeof(double));
    *p_normal_stretch = (double *) allocate_1d_array(n_slabs, sizeof(double));
    *p_tangent_bend = (double *) allocate_1d_array(n_slabs, sizeof(double));
    *p_normal_bend = (double *) allocate_1d_array(n_slabs, sizeof(double));
    *dens_prof_species = (double **) allocate_2d_array(n_species, n_slabs, sizeof(double));
    *dens_prof_species_block = (double ***) allocate_3d_array(n_species, n_slabs, n_blocks, sizeof(double));
    
}

/* Calculate density profiles. */
void profiles(int n_bins, int n_atoms, double **scaled_atom_coords, int n_species,
              double **h, double *dens_prof, int *atom_mol, int *mol_species, double **dens_prof_species)
{
   int i_atom, i_bin, i, i_mol, i_species;
   double sbin, sproj;

   /* Zero dens_prof for every time steps */
     for (i = 0; i < n_bins; ++i)
         dens_prof[i] = 0.0;
     for (i_species = 0; i_species<n_species; ++i_species)
	 for ( i= 0; i <n_bins; ++i)
         dens_prof_species[i_species][i] = 0;

   /* Loop over molecules */
   for (i_atom = 0; i_atom < n_atoms; ++i_atom) {

      /* Compute projection of the apex point onto the
         layer normal. */
      sproj = scaled_atom_coords[i_atom][2];
      i_mol = atom_mol[i_atom];
      i_species = mol_species[i_mol];

      /* Add contributions to density profiles. */
      i_bin = (int) ((sproj + 0.5) * n_bins);
      if (i_bin == n_bins) i_bin = 0;
      dens_prof[i_bin] += 1.0;
      dens_prof_species[i_species][i_bin] += 1.0;
   }
}

void surface_tension_block(int i_block, int n_slab, double *p_normal, double *p_tangent,
                           double *dens_prof, double **p_nromal_block, double **p_tangent_block,
                           double **dens_prof_block, double **dens_prof_species, 
                           double ***dens_prof_species_block, int n_species) 
{
  int i, i_species;

  for ( i = 0; i < n_slab; ++i){
      p_nromal_block[i][i_block] += p_normal[i];
      p_tangent_block[i][i_block] += p_tangent[i];
      dens_prof_block[i][i_block] += dens_prof[i];
   }
      for ( i_species = 0; i_species < n_species; ++i_species)
           for ( i = 0; i < n_slab; ++i){
           dens_prof_species_block[i_species][i][i_block] += dens_prof_species[i_species][i];
  }
}

void write_tension_block(int i_block, int n_block, int n_slab, double **p_normal_block, 
                         double **p_tangent_block, double **dens_prof_block, 
                         double **h_block, double *vol_block, double *ift_block, int i_cycle, double temp,
                         double ***dens_prof_species_block, int n_species)
{
 double norm, norm_dens, d_bin, z_bin, slab_vol;
 int i, i_bin, i_species;
 char bmpfname[20];
 char fname[] = "profile";
 FILE *fp_bmp;

     /* Compute normalization. */
    norm = 1.0 / n_block;
   /* Normalize density profile. */
   norm_dens = n_slab / (vol_block[i_block] * n_block);
   d_bin = h_block[2][i_block]/ n_slab;
   slab_vol = vol_block[i_block]/n_slab;

        /* Create filename. */
        sprintf (bmpfname, "%s%d.dat", fname, i_cycle);
        /* Open file */
        fp_bmp = fopen(bmpfname, "wb");
        if (fp_bmp == NULL)
        {
                printf("Unable to open file. \n");
                exit(0);
        }

   fprintf(fp_bmp, "#z\t\tdensity\t\tp_tangent\tp_normal\n");
   for (i_bin = 0; i_bin < n_slab; ++i_bin){
       z_bin = i_bin * d_bin;
       dens_prof_block[i_bin][i_block] *= norm_dens;
       p_tangent_block[i_bin][i_block] *= norm;
       p_normal_block[i_bin][i_block] *= norm;

       p_tangent_block[i_bin][i_block] = dens_prof_block[i_bin][i_block]*temp 
                                        + p_tangent_block[i_bin][i_block];

       p_normal_block[i_bin][i_block] = dens_prof_block[i_bin][i_block]*temp 
                                         + p_normal_block[i_bin][i_block];
       ift_block[i_block] += (p_normal_block[i_bin][i_block] - p_tangent_block[i_bin][i_block])*d_bin;

       fprintf(fp_bmp, "%lf\t%lf\t%lf\t%lf\n", z_bin, dens_prof_block[i_bin][i_block], 
                                               p_tangent_block[i_bin][i_block], p_normal_block[i_bin][i_block]);
   } 
     for (i_species = 0; i_species <n_species; ++i_species)
          for (i_bin = 0; i_bin < n_slab; ++i_bin)
              dens_prof_species_block[i_species][i_bin][i_block] *=norm_dens;

   /* Normalize ift */
   ift_block[i_block] /= 2.0;
   fprintf(fp_bmp, "#Surface tension: %lf \n", ift_block[i_block]);
/* Close file */
 fclose(fp_bmp);
}
