#include "build.h"

/* Molecular dynamics loop. */
void md_loop(int *mol_species, int n_mols, int *atom_rel, int *atom_mol,
   int n_type, int *atom_type, int n_atoms, int *n_atoms_per_mol, 
   int ***exclusions,
   int **comb_pot, double ***comb_par, double r2_on, double r2_off, 
   double r_off, double **h, double **scaled_atom_coords, double gamma,
   double three_gamma_over_two, double two_over_gamma_cubed,
   double *pe_vdw_s, int period_switch, int **first, int **last,
   phantom_cell **phantoms, int noffsets, int *nc, int *nc_p, 
   int *nc_p_total, int kc, int *phantom_skip,
   atom_cell *atom_cells, int *offsets, double ***corr, double **atom_coords,
   double **rel_atom_coords, double **at_stress_vdw_s,
   double **mol_stress_vdw_s, double **f_vdw_s, double **comp_forces,
   double **atom_vels, double delta, long *idum,
   double *sqrt_kT_over_m, double *atom_mass, double **atom_move, 
   double **h_inv, int neigh_switch, int temp_switch, double **mol_vels, 
   double *mol_mass, int *mol_first_atm, int n_free_atom, double boltzmann,
   double temperature, double *at_temp, double temp_scale, int n_free_mol,
   int ke_flag, double *pe_stretch, double **f_stretch, 
   bond_prop **bond_props, int vdw_switch, int bend_switch, 
   nl_entry **nl_head, nl_entry **nl_tail,
   double r2_nl, double r_nl, int *n_bonds_per_mol,
   double **at_stress_stretch, int eval_flag, int **temp_bonds_1, 
   int **temp_bonds_2, double *ke, double *pe, double *te,
   double **mol_stress_kin, double **at_stress_kin, 
   double **mol_stress, double **at_stress,
   double **mol_stress_vdw, 
   angle_prop **angle_props, double *pe_bend, double **f_bend,
   double **at_stress_bend, int *n_angles_per_mol,
   int pore_switch, double r0, double x0, double y0, double z0,
   double *pe_pore_s, double **f_pore_s, double **at_stress_pore, 
   double **mol_stress_pore, int press_switch,
   int scale_con, double press, double press_scale, int  **scale,
   int phant_switch, double **mol_coords, double **scaled_mol_coords,
   int **scan_atm_1, int **scan_atm_2, int n_species, 

   double *pe_coul_s, int coul_switch, double alpha,
   double alpha2, double one_over_erf_tab_incr, double *erfc_sqrt_tab,
   double two_alpha_over_sqrt_pi, double ****prod_chg, int ****comb_chg,
   double **f_coul_s, double **at_stress_coul_s, double *atom_chg,
   double *b1, double *b2, double *b3,
   int m1_max, int m2_max, int m3_max, double g2_cutoff,
   double **cos_G_1_dot_r, double **sin_G_1_dot_r,
   double **cos_G_2_dot_r, double **sin_G_2_dot_r,
   double **cos_G_3_dot_r, double **sin_G_3_dot_r,
   double *q_cos_G_12_dot_r, double *q_sin_G_12_dot_r,
   double *q_cos_G_123_dot_r, double *q_sin_G_123_dot_r,
   double *pe_coul_recip, 
   double **f_coul_recip, int n_grid_x, int n_grid_y, int n_grid_z,
   double **gridded_atom_coords,
   int B_spline_order, double **M_x, double **M_y, double **M_z,
   double **dM_du_x, double **dM_du_y, double **dM_du_z,
   fft elec, double volume, double *b_1_un, double *b_2_un, double *b_3_un,
   double *b_mod2_x, double *b_mod2_y, double *b_mod2_z,
   double *erf_sqrt_tab, double pe_coul_self, double **at_stress_coul_recip,
   double **mol_stress_coul_s, double **mol_stress_coul_recip, double *p_normal_vdw, 
   double *p_tangent_vdw, double *p_normal_coul,
   double *p_tangent_coul, double slab_width, int ift_switch, int n_slab,
   double *p_tangent_stretch, double *p_normal_stretch, double *p_tangent_bend,
   double *p_normal_bend)
{

      /* If n_levels == 1, integrate the equations of motion
         using the velocity Verlet algorithm. */


   one_step(mol_species, atom_rel, atom_mol,
   n_type, atom_type, n_atoms, n_atoms_per_mol, exclusions,
   comb_pot, comb_par, r2_on, r2_off, h, scaled_atom_coords, gamma,
   three_gamma_over_two, two_over_gamma_cubed,
   pe_vdw_s, period_switch, *first, *last,
   *phantoms, noffsets, nc, nc_p, nc_p_total, kc, phantom_skip,
   atom_cells, offsets, corr, atom_coords,
   rel_atom_coords, at_stress_vdw_s,
   mol_stress_vdw_s, f_vdw_s, comp_forces,
   atom_vels, delta, atom_mass, atom_move,
   h_inv, neigh_switch, pe_stretch, f_stretch, bond_props,
   vdw_switch, bend_switch, nl_head, nl_tail,
   r2_nl, mol_first_atm, n_bonds_per_mol,
   at_stress_stretch, eval_flag, temp_bonds_1, temp_bonds_2, n_mols,
   r_nl, r_off, 
   angle_props, pe_bend, f_bend, at_stress_bend, n_angles_per_mol,
   pore_switch, r0, x0, y0, z0, pe_pore_s, f_pore_s, at_stress_pore, 
   mol_stress_pore, mol_mass,
   scan_atm_1, scan_atm_2, mol_coords, scaled_mol_coords,
   n_species, 

   pe_coul_s, coul_switch, alpha,
   alpha2, one_over_erf_tab_incr, erfc_sqrt_tab,
   two_alpha_over_sqrt_pi, prod_chg, comb_chg,
   f_coul_s, at_stress_coul_s, atom_chg,
   b1, b2, b3, m1_max, m2_max, m3_max, g2_cutoff,
   cos_G_1_dot_r, sin_G_1_dot_r, cos_G_2_dot_r, sin_G_2_dot_r,
   cos_G_3_dot_r, sin_G_3_dot_r, q_cos_G_12_dot_r, q_sin_G_12_dot_r,
   q_cos_G_123_dot_r, q_sin_G_123_dot_r,
   pe_coul_recip, f_coul_recip, n_grid_x, n_grid_y, n_grid_z,
   gridded_atom_coords,
   B_spline_order, M_x, M_y, M_z,
   dM_du_x, dM_du_y, dM_du_z,
   elec, volume, b_1_un, b_2_un, b_3_un,
   b_mod2_x, b_mod2_y, b_mod2_z,
   erf_sqrt_tab, pe_coul_self, at_stress_coul_recip ,
   mol_stress_coul_s, mol_stress_coul_recip, p_normal_vdw, 
   p_tangent_vdw, p_normal_coul, p_tangent_coul, slab_width, ift_switch, n_slab,
   p_tangent_stretch, p_normal_stretch, p_tangent_bend, p_normal_bend);

      /* Calculate thermodynamic quantities. */
      thermodynamics(ke_flag, n_mols, mol_vels,
                    atom_vels, atom_mass, mol_mass,
                    mol_first_atm, n_atoms_per_mol,
                    n_free_atom, n_free_mol, boltzmann,
                    temperature, h, pe_vdw_s, pe_stretch, n_atoms,
                    mol_species, at_temp, ke, pe, te,
                    at_stress_vdw_s,
                    at_stress_stretch, mol_stress_kin,
                    at_stress_kin, 
                    mol_stress, at_stress,
                    mol_stress_vdw, mol_stress_vdw_s, pe_bend,
                    at_stress_bend, bend_switch, pe_coul_s, 
                    pe_coul_recip, at_stress_coul_s, 
                    at_stress_coul_recip, mol_stress_coul_s, 
                    mol_stress_coul_recip);   

}
