#include "build.h"
#include "ff.h"
#include "proto.h"

main(int argc, char *argv[])
{
  int ans, i_mol, skip, i_atom, abs;
  double diff_x, diff_y, diff_z, xx, yy, zz, pe_vdw_s_single,
      pe_vdw_s_p;
  nl_entry *p, *p_term;

  double pe_vdw_s_tot;
  int i_rel, j_rel, j_species;
  int i, j, i_atoms, i_species, i_phant, n_species, n_species_chk, 
      n_unit_cells, n_mols, n_atoms;
  int period_switch, vdw_switch, vdw_rad_switch, *excl_switch, init_switch,
      phant_switch, neigh_switch, opt_switch, press_switch, one_four_switch,
      nb_switch, con_switch;
  /* Random generator */
  long i_ran, seed;
  /* Array of geometrical molecular lengths. */
  double **mol_range, mol_max_length, xmax;
  /* Declare parameters used to build the initial state and box matrices*/
  int n_layers;
  double rho, aspect_xy, aspect_xz, layer_spacing;
  double **h, **h_inv, r_off, r_on, r2_on, r2_off, r_nl, r2_nl;
  int kc;
  /* Declare and initialize force field parameters. */
  int n_mass = 0, n_lj = 0, n_e6 = 0, n_pot = 0, n_type = 0;
  mass_entry *mass = NULL;
  lj_entry *lj = NULL;
  e6_entry *e6 = NULL;
  pot_entry *pot = NULL;
  type_entry *atm_type = NULL;
  /* File names */
  char par_file[F_MAX], *mass_file, *lj_file, *e6_file, *pot_file, 
      **struct_file, *header_file, *config_file, *header_file_save, 
      *config_file_save;
  FILE *f_thermo, *f_trajec;
  /* Declare and initialize molecular structure parameters. */
  int *n_atoms_per_mol = NULL, *n_mols_per_species = NULL,
      *n_bonds_per_mol = NULL, **temp_atm_lab, **temp_atm_nbr,
      ***temp_atm_br, **temp_atm_type_i;
  double ***temp_atm_pos, **temp_atm_mass, **temp_atm_chg,
      **temp_atm_sigma, **temp_atm_eps, ***temp_atm_ord;
  char ***temp_atm_type;
  int **temp_bonds_1 = NULL, **temp_bonds_2 = NULL;
  double **temp_bonds_ord = NULL;
  int *n_mols_per_unit_cell, *mol_species;

  /* Declare some arrays used in set up force field */
  double *mol_mass, *mol_mass_true;
  int *mol_first_atm;

  /* Declare combination and exclusion arrays */
  int ***exclusions, **comb_pot;
  double ***comb_par;
  /* Declare arrays used in build */
  double **scaled_atom_coords, **mol_coords, **scaled_mol_coords,
      **atom_coords, **rel_atom_coords, **atom_vels, *atom_mass;
  int *atom_rel, *atom_mol, *atom_type;

  /* Scan list arrays. */
  int **scan_atm_1, **scan_atm_2;

  /* Array of the chosen principal molecular axe. */
  int *principal;

  /* Variable used in the computation of the potential. */
  double gamma, three_gamma_over_two, two_over_gamma_cubed,
      pe_vdw_s, pe_vdw_s_check, pe_stretch;

  /* Variable for force and stress tensor calculation */
  double **vdw_s , **vdw_s_single ,  **at_stress_vdw_s ,
  **at_stress_vdw_single ,  **mol_stress_vdw_s ,
  **mol_stress_vdw_single;

  /* Thermodynamics parameters. */
  double temp, press, mol_press, reduce_boltz, volume;
  /* Monte Carlo parameters. */
  int i_cycle, n_reshape, n_cycles, n_mol_moves, n_mol_accept, n_reshape_moves, 
  n_reshape_accept, reshape_axis, n_opt, n_thermo, n_trajec;
  double dr_max, dr_max_old, ratio_dang_dr, ratio_dang_dr_old, 
      ds_mol_max[NDIM], dang_mol_max, 
  dh_max, **old, **s_old, **rel_old, **mol_old, skin;
  /* Optimization parameters. */
  double opt_time, efficiency, **ds_opt;
  /* Graphic parameters */
  int n_graph;
  /* Analysis variables. */
  double **mol_inert_mt, ***mol_inert_axis, ***mol_order_inst,
      **lambda, ***v, *phi, *cos_theta, **order_temp, *lambda_temp, **v_temp,
      norm;
  int nrot;
  double reshape_accept, mol_accept;
  /* Block accumulators. */
  int n_block, n_blocks, i_block, n_mol_moves_tot, n_mol_accept_tot, 
      n_reshape_moves_tot, n_reshape_accept_tot, n_reshape_moves_opt, 
      n_reshape_accept_opt;
  double mol_accept_rate, reshape_accept_opt, **h_block, *vol_block,
   *rho_block, *layer_spacing_block, ****mol_order_block, ***lambda_block,
      **cos_theta_block,
  **phi_block, ***mol_stress_block, *press_block, *pe_vdw_s_block, 
  *n_mol_moves_block, *n_mol_accept_block,
      *n_reshape_moves_block, *n_reshape_accept_block, *h_ave,
      *h_unc, vol_ave, vol_unc, rho_ave, rho_unc, 
  layer_spacing_ave, layer_spacing_unc, ***mol_order_ave,
      ***mol_order_unc,
  *cos_theta_ave, *cos_theta_unc, *phi_ave, *phi_unc, **lambda_ave,
      **lambda_unc, dummy, **mol_stress_ave, **mol_stress_unc, 
  press_ave, press_unc, pe_vdw_s_ave, pe_vdw_s_unc;
  /* Constants. */
  double radians_to_degrees;
  /* Declare cell arrays. */
  atom_cell *atom_cells = NULL;
  phantom_cell *phantoms = NULL;
  int phantom_skip[7], nc[NDIM], nc_p[NDIM], nc_p_total, *first = NULL, 
  *last = NULL, *offsets, *offsets_total, noffsets;
  int *offsets_x, *offsets_y, *offsets_z;

  /* Neighbor list. */ 
  nl_entry **nl_head, **nl_tail; 
  double **atom_move;

  /* Get command line input. */
  if (argc != 2) {
    printf("Usage: %s params_file\n", argv[0]);
    exit(1);
  }
  strcpy(par_file, argv[1]);

  /* Read in input parameter file. */
  read_simu_params(par_file, &header_file, &config_file, &header_file_save,
      &config_file_save, &mass_file, &pot_file, &vdw_rad_switch, 
      &n_species_chk, &excl_switch, &r_on, &r_off, 
      &neigh_switch, &phant_switch, &kc, &r_nl, &n_cycles, &n_reshape, 
      &reshape_axis, &opt_switch, &dr_max, &ratio_dang_dr, &dh_max, 
      &press_switch, &temp, &press, &n_graph, &n_opt, &n_thermo, &n_block, 
      &n_trajec, &seed);

  printf("header_file = %s, config_file = %s\n",header_file,
      config_file);
  printf("header_file_save = %s, config_file_save = %s\n",
      header_file_save,config_file_save);
  printf("mass_file = %s\n",mass_file);
  printf("pot_file = %s\n",pot_file);
  printf("vdw_rad_switch = %d\n", vdw_rad_switch);
  printf("n_species (from params file) = %d\n", n_species_chk);
  for (i_species = 0; i_species < n_species_chk; ++i_species)
     printf("i_specie = %d, excl_switch = %d\n", i_species,
          excl_switch[i_species]);

  printf("r_on = %g, r_off = %g\n",r_on, r_off);
  printf("neigh_switch = %d, phant_switch = %d\n", neigh_switch,
      phant_switch);
  printf("kc = %d, r_nl = %g\n",kc, r_nl);
  printf("n_cycles = %d, n_reshape = %d, reshape_axis = %d\n",
      n_cycles, n_reshape, reshape_axis);
  printf("opt_switch = %d\n", opt_switch);
  printf("dr_max = %g, ratio_dang_dr = %g, dh_max = %g\n",
      dr_max, ratio_dang_dr, dh_max);
  printf("press_switch = %d\n", press_switch);
  printf("temp = %g, press = %g\n",temp, press);
  printf("n_graph = %d, n_opt = %d, n_thermo = %d, n_block = %d, n_trajec = %d\n", n_graph, n_opt, n_thermo, n_block, n_trajec);
  printf("seed = %ld\n",seed);

  /* Define additional variables. */
  if (n_cycles % n_block != 0) 
    error_exit("n_cycles must be a multiple of n_block!\n");
  n_blocks = n_cycles / n_block;
  noffsets = CUBE(2 * kc + 1);

  /* Initialize random number generator. */
  i_ran = -seed;
  ran3(&i_ran);

  /* Read information about template molecules and atoms from header file */
  read_header_direct(header_file, &period_switch, &n_species,
      &n_atoms_per_mol,  &temp_atm_lab, &temp_atm_type, &temp_atm_nbr,
      &temp_atm_br, &temp_atm_ord,  &temp_atm_pos, &temp_atm_chg,
      &temp_atm_sigma, &temp_atm_eps,  &n_bonds_per_mol, &temp_bonds_1,
      &temp_bonds_2, &temp_bonds_ord,  &n_mols_per_species, &n_mols,
      &n_atoms, &mol_species);

  /* Read atomic position and velocities from config file */
  read_config_direct(config_file, period_switch, &h, n_atoms, &atom_coords,  
     &atom_vels);

  /* Check exclusion switch array. */
  if (n_species_chk != n_species) {
     printf("n_species_chk = %d, n_species = %d\n", n_species_chk, n_species);
     error_exit("Problem in the number of species.\n");
  }
 
  /* If the number of exclusion sites is greater than the number of atoms
     present in the template molecule, set the exclusion switch to -1, i.e.
     remove all intramolecular interactions. */ 
  for (i_species = 0; i_species < n_species; ++i_species)
    if (excl_switch[i_species] >= n_atoms_per_mol[i_species])
      excl_switch[i_species] = -1;
 
  /* Read FF masses file. */
  read_mass_params(mass_file, &mass, &n_mass);

  /* Set up force field data for masses. */
  set_up_force_field(n_species, n_mols, n_atoms_per_mol, n_mass,
      mass, mol_species, n_bonds_per_mol, &temp_atm_mass, temp_atm_type,
      &mol_mass, &mol_mass_true, &mol_first_atm);

  /* Convert string tags to integer identifiers. */
  /* Create an integer identifier corresponding to template atom type. */ 
  convert_type(n_species, n_atoms_per_mol, temp_atm_type, &temp_atm_type_i, 
     &atm_type, &n_type);

  /* Read and Set up force field data for potential interactions. */
  read_set_up_pot(pot_file, vdw_switch, vdw_rad_switch, atm_type, n_type, 
     &comb_pot, &comb_par);

  /* Adjust cutoffs (r_off and r_on) according to the potential interaction 
  form present. */
  adjust_cutoff(n_type, comb_pot, comb_par, &r_on, &r_off); 

  /* Set up scan list. */
  set_up_scan_list(n_species, n_atoms_per_mol, temp_atm_nbr, temp_atm_br,  
     &scan_atm_1, &scan_atm_2);

  /* Allocate memory for arrays used in the builder. */
  allocate_memory_simu(n_atoms, n_mols, n_species, n_blocks,
      period_switch,  &scaled_atom_coords, &atom_rel, &atom_mol,
      &atom_mass, &atom_type, &mol_coords, &scaled_mol_coords, 
      &rel_atom_coords, &h_inv, &atom_cells, &offsets, &offsets_total, 
      noffsets, &nl_head, &nl_tail, &atom_move,
      n_atoms_per_mol, &exclusions, &old, &s_old, &rel_old, &mol_old,
      &ds_opt, &mol_inert_mt, &mol_inert_axis, &mol_order_inst,
      &lambda, &v, &phi, &cos_theta, &h_block, &h_ave, &h_unc,
      &layer_spacing_block, &mol_order_block, &mol_order_ave,
      &mol_order_unc, &lambda_block, &lambda_ave, &lambda_unc,
      &cos_theta_block, &cos_theta_ave, &cos_theta_unc, &phi_block,
      &phi_ave, &phi_unc, &mol_stress_block, &mol_stress_ave, &mol_stress_unc,
      &press_block, &vol_block, &rho_block, &pe_vdw_s_block, &n_mol_moves_block,
      &n_mol_accept_block, &n_reshape_moves_block, &n_reshape_accept_block,
      &offsets_x, &offsets_y, &offsets_z, &vdw_s, &vdw_s_single,
      &at_stress_vdw_s, &at_stress_vdw_single, &mol_stress_vdw_s,
      &mol_stress_vdw_single, &mol_range);

  /* Set up array of relative atom indices */
  relative_atoms(n_mols, mol_species, mol_first_atm, n_atoms_per_mol,
      temp_atm_mass, temp_atm_type_i, atom_rel, atom_mol, atom_mass, atom_type);
  /* Set up the nonbonded exclusion array */
  exclusion_array(n_species, n_atoms_per_mol, excl_switch, temp_atm_nbr,  
    temp_atm_br, &exclusions);
 
  /* Compute geometrical molecular lengths. */
  geom_molecules(n_species, n_atoms_per_mol, temp_atm_pos, mol_range, 
    &mol_max_length);

  /* Calculate box aspect ratio. */
  aspect_xy = h[1][1] / h[0][0];
  aspect_xz = h[2][2] / h[0][0];

  /* Calculate quantities that depend on box dimensions and exit
     if system is too small. */
  box_dimensions(h, h_inv, period_switch, r_off, mol_max_length);

  if (period_switch) {
    scaled_atomic_coords(n_atoms, h_inv, atom_coords,
        scaled_atom_coords);
    periodic_boundary_conditions(n_atoms, h, scaled_atom_coords,
        atom_coords);
  }

  /* Compute center of mass of the molecules and relative atom positions 
  within the molecules. */
  center_of_mass_positions(period_switch, n_mols, n_species,
      n_atoms_per_mol,  mol_species, atom_mass, mol_first_atm,
      atom_coords, scaled_atom_coords,  scan_atm_1, scan_atm_2,
      mol_mass, h, h_inv, mol_coords, scaled_mol_coords,  rel_atom_coords);

  /* If we are using periodic boundary conditions, and that we are using
   cell (or neighbor) list, set up atom index offsets for updating phantom 
   atoms. */

  r2_nl = r_nl * r_nl;
  r2_on = r_on * r_on;
  r2_off = r_off * r_off;

  if ((period_switch) && (neigh_switch != 0))
  {
    for (i_phant = 0; i_phant < 7; ++i_phant)
      phantom_skip[i_phant] = (i_phant + 1) *
          n_atoms;

    /* Initialize number of phantom cells. */
    nc_p[0] = nc_p[1] = nc_p[2] = 0;
    nc_p_total = 0;

    if ( phant_switch == 1) {
      /* Set up cell list with phantom cells. */
      set_up_cells_phantom(h, nc, nc_p, &nc_p_total,
          atom_cells,  kc,  period_switch, r_nl, r_off,
          neigh_switch, &first, &last, offsets,  n_atoms,
          scaled_atom_coords, atom_coords, &phantoms,
          phantom_skip);

      /* Compute coordinates of phantom atoms. */
      update_phantoms(n_atoms, atom_cells, phantom_skip,
          phantoms, atom_coords);
    } else
      if ( phant_switch == 0){
	/* Set up cell list without phantom cells. */
	set_up_cells_nophantom(h, nc, nc_p, &nc_p_total, atom_cells, kc, 
            period_switch, r_nl, r_off, neigh_switch, &first,
	    &last, offsets_x, offsets_y, offsets_z,
	    n_atoms, scaled_atom_coords, atom_coords);
      }
    if (neigh_switch == 2) {
       if (phant_switch == 0)
          error_exit("Neighbor lists work only with phantom cells\n"); 

       neighbor_lists_period(mol_species, atom_rel, atom_mol,  n_atoms,
          n_atoms_per_mol, exclusions, h, r2_on,  r2_off, scaled_atom_coords, 
          period_switch, first, last, phantoms, noffsets, nc_p, kc,
          phantom_skip, nc, atom_cells, offsets, atom_coords, atom_move,
          nl_head, nl_tail, r2_nl);
        }
  }

    printf("I am here\n");
  /* Compute the potential energy of the initial state. */
  gamma = 0.0;
  three_gamma_over_two = 0.0;
  two_over_gamma_cubed = 0.0;
  if (r2_on < r2_off) {
    gamma = r2_off - r2_on;
    three_gamma_over_two = 1.5 * gamma;
    two_over_gamma_cubed = 2.0 / CUBE(gamma);
    }

  if (neigh_switch == 0) {
    printf("I am here\n");
   lj_s_period(mol_species, atom_rel, atom_mol, atom_type, n_atoms,
        n_atoms_per_mol, exclusions, comb_pot, comb_par,
        h, r2_on, r2_off, scaled_atom_coords, scaled_mol_coords, 
        rel_atom_coords, gamma, 
        three_gamma_over_two, two_over_gamma_cubed, &pe_vdw_s, vdw_s, 
        mol_stress_vdw_s);
  }
  else if (neigh_switch == 1) {   
    if (phant_switch == 1) {
/*      if (vdw_switch == 2)   */
        wca_period_phantom(mol_species, atom_rel, atom_mol, atom_type, n_atoms, 
          n_atoms_per_mol, exclusions, comb_pot, comb_par,
          r2_on, r2_off, h, scaled_atom_coords, gamma, three_gamma_over_two,
          two_over_gamma_cubed, &pe_vdw_s, period_switch,
          first, last, phantoms, noffsets, nc_p, kc,
          phantom_skip, nc, atom_cells, offsets, atom_coords,
          rel_atom_coords, at_stress_vdw_s, mol_stress_vdw_s,
          vdw_s);
/*     else

        lj_s_period_phantom(mol_species, atom_rel,
          atom_mol, n_atoms, n_atoms_per_mol, exclusions,
          comb_sigma2, comb_four_eps, h, r2_on, r2_off,
          scaled_atom_coords, gamma, three_gamma_over_two,
          two_over_gamma_cubed, &pe_vdw_s, period_switch,
          first, last, phantoms, noffsets, nc_p, kc,
          phantom_skip, nc, atom_cells, offsets, atom_coords,
          rel_atom_coords, at_stress_vdw_s, mol_stress_vdw_s,
          vdw_s);
*/
    }
    else{
      if (phant_switch == 0) {
	lj_s_period_nophantom(mol_species, atom_rel, atom_mol, atom_type,
            n_atoms, n_atoms_per_mol, exclusions, 
            comb_pot, comb_par, h, r2_on, r2_off, scaled_atom_coords,
	    gamma, three_gamma_over_two, two_over_gamma_cubed, &pe_vdw_s, 
            period_switch, first, last, noffsets, nc_p, kc,  nc, atom_cells,
	    offsets_x, offsets_y, offsets_z, atom_coords, rel_atom_coords, 
            at_stress_vdw_s, mol_stress_vdw_s, vdw_s);

      }
    }
  } 
  else {
 /*   lj_s_nl_period_phantom( mol_species, atom_rel, atom_mol, n_atoms,
       n_atoms_per_mol, exclusions, comb_sigma2, comb_four_eps, h, r2_on, 
       r2_off, scaled_atom_coords, gamma, three_gamma_over_two, 
       two_over_gamma_cubed, &pe_vdw_s, period_switch, first, last, phantoms, 
       noffsets, nc_p, kc, phantom_skip, nc, atom_cells, offsets, atom_coords, 
       nl_head, nl_tail, r2_nl, rel_atom_coords, at_stress_vdw_s, 
       mol_stress_vdw_s, vdw_s, atom_move);
*/ 
    /* Zero atom moves counter. */ 
    zero_move(n_atoms, atom_move);
    }

  printf("pe_vdw_s = %g\n",pe_vdw_s);

/*
pe_vdw_s_tot = 0.0;
for (i_mol = 0; i_mol < n_mols; ++i_mol)
{
skip = mol_first_atm[i_mol];

if (neigh_switch == 0)
lj_s_period_single(skip, i_mol, mol_species, atom_rel, atom_mol, atom_type, 
   n_atoms, n_atoms_per_mol, exclusions, comb_pot, comb_par, h,
   r2_on, r2_off, scaled_atom_coords, gamma, three_gamma_over_two, 
   two_over_gamma_cubed, &pe_vdw_s_single);
else if (neigh_switch == 1) {
if (phant_switch == 1)
wca_period_single_phantom(skip, i_mol, mol_species, atom_rel,
   atom_mol, atom_type, n_atoms, n_atoms_per_mol, exclusions, comb_pot, 
   comb_par, r2_on, r2_off, h, scaled_atom_coords, gamma, three_gamma_over_two, 
   two_over_gamma_cubed, &pe_vdw_s_single, period_switch, first, last, 
   phantoms, noffsets, nc_p, kc, phantom_skip, 
   nc, atom_cells, offsets, atom_coords, mol_first_atm);
else
lj_s_period_single_nophantom(skip, i_mol, mol_species, atom_rel, atom_mol, 
   atom_type, n_atoms, n_atoms_per_mol, exclusions, comb_pot, comb_par, h, 
   r2_on, r2_off, scaled_atom_coords, gamma, three_gamma_over_two, 
   two_over_gamma_cubed, &pe_vdw_s_single, period_switch, first, last,
   noffsets, nc_p, kc, nc, atom_cells, offsets_x, offsets_y, offsets_z, 
   atom_coords, mol_first_atm);

}

pe_vdw_s_tot += pe_vdw_s_single;
}

printf("pe_vdw_s = %g\n",pe_vdw_s_tot/2.0);
exit(1);
*/

  /* Initialize graphics. */
#ifdef GRAPHICS
  initialize_graphics(h);
#endif

  /* Open output files. */
  if ((f_thermo = fopen("sim.thermo", "w")) == NULL)
    error_exit("Cannot open sim.thermo\n");
  if ((f_trajec = fopen("sim.trajec", "w")) == NULL)
    error_exit("Cannot open sim.thermo\n");

  /* Compute beta = 1 / kT (k = 1). */
  reduce_boltz = 1.0 / temp;

  /* Compute maximum scale translational and angular displacement of the 
   molecules. */
  for (i = 0; i < NDIM; ++i)
    ds_mol_max[i] = dr_max / h[i][i];
  dang_mol_max = ratio_dang_dr * dr_max;

  /* Zero acceptance rate accumulators. */
  n_mol_moves_tot = 0;
  n_mol_accept_tot = 0;
  n_reshape_moves_tot = 0;
  n_reshape_accept_tot = 0;

  /* Initialize variables used for optimization. */
  dr_max_old = dr_max;
  ratio_dang_dr_old = ratio_dang_dr;
  opt_time = cpu();
  efficiency = 0.0;
  for (i_mol = 0; i_mol < n_mols; ++i_mol)
    for (i = 0; i < NDIM; ++i)
      ds_opt[i_mol][i] = 0.0;
 
  /* Zero optimization accumulators. */
  n_reshape_moves_opt = 0;
  n_reshape_accept_opt = 0;

  /* Write header of the trajectory file. */
  fwrite(&n_atoms, sizeof(int), 1, f_trajec);
  fwrite(&n_cycles, sizeof(int), 1, f_trajec);
  fwrite(&n_trajec, sizeof(int), 1, f_trajec);

  /* Compute various instantaneous quantities. */
  /* Compute inertia tensors for each molecule. */
  inertia_tensors(n_mols, mol_species, mol_first_atm, n_atoms_per_mol,
      atom_mass, mol_mass, rel_atom_coords, mol_inert_mt, mol_inert_axis);

  /* Compute instantaneous orientational order parameters. */
  nematic_order(n_mols, n_species, mol_species, n_mols_per_species,
      mol_inert_axis, mol_order_inst, lambda, v);

  /* Use the largest eigenvalue to compute the average molecular orientation. */
  for (i_species = 0; i_species < n_species; ++i_species) {
    if (v[i_species][2][0] < 0.0)
      for (i = 0; i < 3; ++i)
	v[i_species][i][0] *= -1.0;
    cos_theta[i_species] = v[i_species][2][0];
    phi[i_species] = atan2(v[i_species][1][0], v[i_species][0][0]);
  }

  /* Write instantaneous quantities to thermodynamics file. */
  i_cycle = 0;
  fprintf(f_thermo,"%d ", i_cycle);
  for (i = 0; i < 3; ++i)
    fprintf(f_thermo, "%g ", h[i][i]);

  /* Write stress tensor. */
  mol_press = 0.0;
  for (i = 0; i < 3; ++i) {
    for (j = i; j < 3; ++j)
      fprintf(f_thermo, "%g ", mol_stress_vdw_s[i][j]);
    mol_press += mol_stress_vdw_s[i][i];
  }

  volume = h[0][0] * h[1][1] * h[2][2];
  rho = n_mols / volume;
  /* Compute and write hydrostatic pressure. */
  mol_press = n_mols * temp + mol_press / 3.0;
  mol_press /= volume;
  fprintf(f_thermo, "%g ", mol_press);

  fprintf(f_thermo, "%g ", volume);
  fprintf(f_thermo, "%g ", rho); 

  fprintf(f_thermo, "%g ", layer_spacing);
  for (i_species = 0; i_species < n_species; ++i_species) {
    for (i = 0; i < 3; ++i)
      for (j = 0; j < 3; ++j)
	fprintf(f_thermo, "%g ", mol_order_inst[i_species][i][j]);
    fprintf(f_thermo, "%g ", cos_theta[i_species]);
    fprintf(f_thermo, "%g ", phi[i_species]);
    for (i = 0; i < 3; ++i)
      fprintf(f_thermo, "%g ", lambda[i_species][i]);
  }
  /* Write potential energy. */
  fprintf(f_thermo, "%g\n", pe_vdw_s);

  /* Define constant */
  radians_to_degrees = 180.0 / PI;

  /* Allocate memory for scratch arrays. */
  order_temp = dmatrix(1, 3, 1, 3);
  lambda_temp = dvector(1, 3);
  v_temp = dmatrix(1, 3, 1, 3);

  /* Monte Carlo loop */
  for (i_cycle = 1; i_cycle <= n_cycles; ++i_cycle) {

  mc_cycle(n_mols, n_atoms, vdw_switch, period_switch, &i_ran,
        mol_first_atm,  n_atoms_per_mol, mol_species, atom_rel,
        atom_mol, atom_type, temp_atm_pos, h,  h_inv, aspect_xy, aspect_xz, 
        mol_coords, scaled_mol_coords, atom_coords, scaled_atom_coords,  
        rel_atom_coords, exclusions, comb_pot, comb_par, gamma, 
        three_gamma_over_two, two_over_gamma_cubed, dr_max,
        ds_mol_max,  dang_mol_max, dh_max, reshape_axis, mol_max_length,
        r2_on, r2_off, r_off, r_nl, r2_nl, s_old,  old, rel_old,
        mol_old, press_switch, reduce_boltz, press, neigh_switch, phant_switch,
        &first, &last, &phantoms, noffsets, nc, nc_p, &nc_p_total,
        kc,  phantom_skip, atom_cells, offsets, nl_head, nl_tail, atom_move,
        n_reshape, &pe_vdw_s, &n_mol_moves, &n_mol_accept, &n_reshape_moves,
        &n_reshape_accept, ds_opt, at_stress_vdw_s, mol_stress_vdw_s,
        vdw_s, offsets_x, offsets_y, offsets_z);

#ifdef GRAPHICS
    if (i_cycle % n_graph == 0)
      plot_molecules(n_mols, mol_species, mol_first_atm,
          n_atoms_per_mol, n_bonds_per_mol, atom_coords,
          scaled_atom_coords, h, temp_bonds_1, temp_bonds_2, temp_atm_type);
#endif

    /* Add to optimization accumulators. */
    n_reshape_moves_opt += n_reshape_moves;
    n_reshape_accept_opt += n_reshape_accept;

    /* Calculate instantaneous thermodynamic and structural quantities. */
    /* Calculate forces and stress tensor. */
    if (neigh_switch == 0) {
        lj_s_period(mol_species, atom_rel, atom_mol, atom_type, n_atoms,
          n_atoms_per_mol, exclusions, comb_pot, comb_par,
          h, r2_on, r2_off, scaled_atom_coords, scaled_mol_coords, 
          rel_atom_coords, gamma, three_gamma_over_two, 
          two_over_gamma_cubed, &pe_vdw_s_check, vdw_s, mol_stress_vdw_s);
    }
    else if (neigh_switch == 1) {   
    if (phant_switch == 1) {
/*      if (vdw_switch == 2)   */
        wca_period_phantom(mol_species, atom_rel, atom_mol, atom_type, 
          n_atoms, n_atoms_per_mol, exclusions, comb_pot, comb_par, 
          r2_on, r2_off, h, scaled_atom_coords, gamma, three_gamma_over_two,
          two_over_gamma_cubed, &pe_vdw_s_check, period_switch,
          first, last, phantoms, noffsets, nc_p, kc,
          phantom_skip, nc, atom_cells, offsets, atom_coords,
          rel_atom_coords, at_stress_vdw_s, mol_stress_vdw_s,
          vdw_s);
/*      else
        lj_s_period_phantom(mol_species, atom_rel,
          atom_mol, n_atoms, n_atoms_per_mol, exclusions,
          comb_sigma2, comb_four_eps, h, r2_on, r2_off,
          scaled_atom_coords, gamma, three_gamma_over_two,
          two_over_gamma_cubed, &pe_vdw_s_check, period_switch,
          first, last, phantoms, noffsets, nc_p, kc,
          phantom_skip, nc, atom_cells, offsets, atom_coords,
          rel_atom_coords, at_stress_vdw_s, mol_stress_vdw_s,
          vdw_s);
*/
    }
      else{
      if (phant_switch == 0) {
	lj_s_period_nophantom(mol_species, atom_rel, atom_mol, atom_type, 
            n_atoms, n_atoms_per_mol, exclusions, comb_pot, comb_par,
	    h, r2_on, r2_off, scaled_atom_coords, gamma, three_gamma_over_two, 
            two_over_gamma_cubed, &pe_vdw_s_check, period_switch, first,
	    last, noffsets, nc_p, kc,  nc, atom_cells, offsets_x, offsets_y, 
            offsets_z, atom_coords, rel_atom_coords, at_stress_vdw_s,
	    mol_stress_vdw_s, vdw_s);

       }
     }
    } 
   else {
/*    lj_s_nl_period_phantom( mol_species, atom_rel, atom_mol, n_atoms,
       n_atoms_per_mol, exclusions, comb_sigma2, comb_four_eps, h, r2_on, 
       r2_off, scaled_atom_coords, gamma, three_gamma_over_two, 
       two_over_gamma_cubed, &pe_vdw_s_check, period_switch, first, last, 
       phantoms, 
       noffsets, nc_p, kc, phantom_skip, nc, atom_cells, offsets, atom_coords, 
       nl_head, nl_tail, r2_nl, rel_atom_coords, at_stress_vdw_s, 
       mol_stress_vdw_s, vdw_s, atom_move);
*/
    }

    /* Check potential energy. */
    if (fabs(pe_vdw_s - pe_vdw_s_check) > 1e-05){
       printf("%lf, chk = %lf\n", pe_vdw_s, pe_vdw_s_check);

    /* Save current configuration. */
    write_header_direct(header_file_save, period_switch, n_species,
      n_atoms_per_mol, temp_atm_lab, temp_atm_type, temp_atm_nbr,
      temp_atm_br,  temp_atm_ord, temp_atm_pos, temp_atm_chg,
      temp_atm_sigma, temp_atm_eps,  n_bonds_per_mol, temp_bonds_1,
      temp_bonds_2, temp_bonds_ord,  n_mols_per_species, n_mols,
      mol_species);

    write_config_direct(config_file_save, period_switch, h,
      n_atoms,  dr_max, ratio_dang_dr, dh_max, skin, atom_coords,
      atom_vels, i_cycle);

    /* Exit. */
    error_exit("Problem in potential energy calculation.\n"); 
    }

    /* Compute hydrostatic pressure. */
    mol_press = 0.0;
    for (i = 0; i < 3; ++i)
      mol_press += mol_stress_vdw_s[i][i];
    volume = h[0][0] * h[1][1] * h[2][2];
    rho = n_mols / volume;
    mol_press = n_mols * temp + mol_press / 3.0;
    mol_press /= volume;

    /* Compute layer spacing. */
    layer_spacing = h[2][2] / n_layers;

    /* Compute inertia tensors for each molecule. */
    inertia_tensors(n_mols, mol_species, mol_first_atm,
        n_atoms_per_mol,  atom_mass, mol_mass, rel_atom_coords,
        mol_inert_mt, mol_inert_axis);

    /* Compute instantaneous orientational order parameters. */
    nematic_order(n_mols, n_species, mol_species, n_mols_per_species,
        mol_inert_axis, mol_order_inst, lambda, v);

    /* Use the largest eigenvalue to compute the average molecular
       orientation. */
    for (i_species = 0; i_species < n_species; ++i_species) {
      if (v[i_species][2][0] < 0.0)
	for (i = 0; i < 3; ++i)
	  v[i_species][i][0] *= -1.0;
      cos_theta[i_species] = v[i_species][2][0];
      phi[i_species] = atan2(v[i_species][1][0],
          v[i_species][0][0]);
    }

    /* Write instantaneous quantities to thermodynamics file every 
       n_thermo MC cycles. */
    if (i_cycle % n_thermo == 0) {
      fprintf(f_thermo, "%d ", i_cycle);
      for (i = 0; i < 3; ++i)
	fprintf(f_thermo, "%g ", h[i][i]);
      for (i = 0; i < 3; ++i)
         for (j = i; j < 3; ++j)
           fprintf(f_thermo, "%g ", mol_stress_vdw_s[i][j]); 
      fprintf(f_thermo, "%g ", mol_press); 
      fprintf(f_thermo, "%g ", volume); 
      fprintf(f_thermo, "%g ", rho); 
      fprintf(f_thermo, "%g ", layer_spacing);
      for (i_species = 0; i_species < n_species; ++i_species) {
	for (i = 0; i < 3; ++i)
	  for (j = 0; j < 3; ++j)
	    fprintf(f_thermo,
	        "%g ", mol_order_inst[i_species][i][j]);
	fprintf(f_thermo, "%g ", cos_theta[i_species]);
	fprintf(f_thermo, "%g ", phi[i_species]);
	for (i = 0; i < 3; ++i)
	  fprintf(f_thermo, "%g ",
	      lambda[i_species][i]);
      }
      /* Write potential energy. */
      fprintf(f_thermo, "%g\n", pe_vdw_s);
    }

    /* Write instantaneous configuration to trajectory file every 
         n_trajec MC cycles. */
    if (i_cycle % n_trajec == 0){
    /*  write_positions_direct(f_trajec, h, n_atoms,
          atom_coords); */
    /* Save current configuration. */
    write_header_direct(header_file_save, period_switch, n_species,
      n_atoms_per_mol, temp_atm_lab, temp_atm_type, temp_atm_nbr,
      temp_atm_br,  temp_atm_ord, temp_atm_pos, temp_atm_chg,
      temp_atm_sigma, temp_atm_eps,  n_bonds_per_mol, temp_bonds_1,
      temp_bonds_2, temp_bonds_ord,  n_mols_per_species, n_mols,
      mol_species);

    write_config_direct(config_file_save, period_switch, h,
      n_atoms,  dr_max, ratio_dang_dr, dh_max, skin, atom_coords,
      atom_vels, i_cycle);
    }
    /* Calculate block index. */
    i_block = (i_cycle - 1) / n_block;

    /* Add contributions to block accumulators. */
    for (i = 0; i < 3; ++i)
      h_block[i][i_block] += h[i][i];
    for (i = 0; i < 3; ++i)
       for (j = i; j < 3; ++j)
          mol_stress_block[i][j][i_block] += mol_stress_vdw_s[i][j];
    press_block[i_block] += mol_press;
    vol_block[i_block] += volume;
    rho_block[i_block] += rho;
    layer_spacing_block[i_block] += layer_spacing;
    for (i_species = 0; i_species < n_species; ++i_species) {
      for (i = 0; i < 3; ++i)
	for (j = 0; j < 3; ++j)
	  mol_order_block[i_species][i][j][i_block]
	      +=  mol_order_inst[i_species][i][j];
    }
    pe_vdw_s_block[i_block] += pe_vdw_s;
    n_mol_moves_block[i_block] += n_mol_moves;
    n_mol_accept_block[i_block] += n_mol_accept;
    n_reshape_moves_block[i_block] += n_reshape_moves;
    n_reshape_accept_block[i_block] += n_reshape_accept;

    /* Compute and print block averages every n_block MC cycles. */
    if (i_cycle % n_block == 0) {

      /* Calculate block averages. */
      norm = 1.0 / n_block;
      for (i = 0; i < 3; ++i)
	h_block[i][i_block] *= norm;
      for (i = 0; i < 3; ++i)
	for (j = i; j < 3; ++j)
	  mol_stress_block[i][j][i_block] *= norm;
      press_block[i_block] *= norm;
      vol_block[i_block] *= norm;
      rho_block[i_block] *= norm;
      layer_spacing_block[i_block] *= norm;
      for (i_species = 0; i_species < n_species; ++i_species) {
	for (i = 0; i < 3; ++i)
	  for (j = 0; j < 3; ++j) {
	    mol_order_block[i_species][i][j][i_block] *= norm;
	    order_temp[i+1][j+1] =  mol_order_block[i_species][i][j][i_block];
	  }
	jacobi(order_temp, 3, lambda_temp, v_temp, &nrot);
	eigsrt(lambda_temp, v_temp, 3);
	/* Copy scratch arrays into real arrays. */
	for (i = 0; i < 3; ++i) {
	  lambda[i_species][i] = lambda_temp[i+1];
	  for (j = 0; j < 3; ++j)
	    v[i_species][i][j] = v_temp[i+1][j+1];
	}
	if (v[i_species][2][0] < 0.0)
	  for (i = 0; i < 3; ++i)
	    v[i_species][i][0]
	        *= -1.0;
	cos_theta_block[i_species][i_block]
	    = v[i_species][2][0];
	phi_block[i_species][i_block] =
	    atan2(v[i_species][1][0], v[i_species][0][0]);
	for (i = 0; i < 3; ++i)
	  lambda_block[i_species][i][i_block]
	      = lambda[i_species][i];
      }

      pe_vdw_s_block[i_block] *= norm;
      mol_accept = (double) n_mol_accept_block[i_block]
          / n_mol_moves_block[i_block];
      if (n_reshape > 0)
        reshape_accept = (double) n_reshape_accept_block[i_block]
          / n_reshape_moves_block[i_block];

      /* Print block averages to standard output. */
      printf("\nBlock averages for block %d, MC cycles %d - %d\n",
          i_block, i_block * n_block + 1, (i_block + 1) * n_block);
      for (i = 0; i < 3; ++i)
	printf("   h[%d][%d] = %g\n", i, i, h_block[i][i_block]);
      for (i = 0; i < 3; ++i)
         for (j = i; j < 3; ++j)
            printf("   stress[%d][%d] = %g\n", i, j, 
                                       mol_stress_block[i][j][i_block]);

      printf("   press = %g\n", press_block[i_block]);
      printf("   volume = %g\n", vol_block[i_block]);
      printf("   rho = %g\n", rho_block[i_block]);
      printf("   layer_spacing = %g\n", layer_spacing_block[i_block]);
      for (i_species = 0; i_species < n_species;
          ++i_species) {
	printf("         i_species = %d\n", i_species);
	printf("   q = %g %g %g\n",  mol_order_block[i_species][0][0][i_block],
	    mol_order_block[i_species][0][1][i_block],
	    mol_order_block[i_species][0][2][i_block]);
	printf("       %g %g %g\n", mol_order_block[i_species][1][0][i_block],
	    mol_order_block[i_species][1][1][i_block],
	    mol_order_block[i_species][1][2][i_block]);
	printf("       %g %g %g\n", mol_order_block[i_species][2][0][i_block],
	    mol_order_block[i_species][2][1][i_block],
	    mol_order_block[i_species][2][2][i_block]);
	printf("   cos_theta = %g\n", cos_theta_block[i_species][i_block]);
	printf("   theta = %g degrees\n",
	    acos(cos_theta_block[i_species][i_block]) *
	    radians_to_degrees);
	printf("   phi = %g degrees\n",
	    phi_block[i_species][i_block] * radians_to_degrees);
	for (i = 0; i < 3; ++i)
	  printf("   lambda[%d] = %g\n", i, 
                     lambda_block[i_species][i][i_block]);
      }
      printf("   pe_vdw_s = %g\n", pe_vdw_s_block[i_block]);
      printf("   mol_accept = %g\n", mol_accept);
      if (n_reshape > 0)
        printf("   reshape_accept = %g\n", reshape_accept);
      fflush(NULL);
    }

    /* Adjust maximum size of molecule and size of cell reshaping moves 
        to maximize efficiency every n_opt timesteps. */
    if (i_cycle % n_opt == 0) {

      /* Adjust maximum size of molecule moves (opt_switch =1), ratio
         of angular versus tranlational move (opt_switch = 2), skin of the
         neighbor list (opt_switch = 3). */
         if (opt_switch == 1)
            optimize_molecule_moves(n_mols, h, &dr_max,
              &dr_max_old, ds_mol_max, &dang_mol_max,
              ratio_dang_dr, &opt_time, &efficiency, ds_opt);
         else if (opt_switch == 2)
            optimize_ratio(n_mols, h, dr_max, &ratio_dang_dr_old, 
              &ratio_dang_dr, &dang_mol_max, &opt_time, &efficiency, ds_opt);
         else if ((opt_switch == 3) && (neigh_switch)) {
         /*   optimize_skin(n_mol, length, side, &skin, &skin_old,
                          &opt_time, &efficiency, ds_opt,
                          s, u, nl_head, nl_tail, ds_tot, u_old); */
               }
      /* Calculate average acceptance rate for reshaping moves over 
            previous n_opt cycles. */
      if(n_reshape > 0){
        reshape_accept_opt = (double) n_reshape_accept_opt 
                                                      / n_reshape_moves_opt;
        printf("reshape_accept_opt = %g\n", reshape_accept_opt);
        n_reshape_moves_opt = n_reshape_accept_opt = 0;

        /* Adjust maximum size of reshaping moves. */
        optimize_reshape_moves(h, reshape_accept_opt, &dh_max);
       }
    }
  } /* end of MC loop. */

  /* Close output files. */
  fclose(f_thermo);
  fclose(f_trajec);

  /* Save final configuration. */
  write_header_direct(header_file_save, period_switch, n_species,
      n_atoms_per_mol, temp_atm_lab, temp_atm_type, temp_atm_nbr,
      temp_atm_br,  temp_atm_ord, temp_atm_pos, temp_atm_chg,
      temp_atm_sigma, temp_atm_eps,  n_bonds_per_mol, temp_bonds_1,
      temp_bonds_2, temp_bonds_ord,  n_mols_per_species, n_mols,
      mol_species);

  write_config_direct(config_file_save, period_switch, h,
      n_atoms,  dr_max, ratio_dang_dr, dh_max, skin, atom_coords,
      atom_vels, i_cycle);

  /* Calculate run averages and uncertainties. */
  for (i = 0; i < 3; ++i)
    statistics(n_blocks, h_block[i], &h_ave[i], &h_unc[i]);
  for (i = 0; i < 3; ++i)
    for (j = 0; j < 3; ++j)
      statistics(n_blocks, mol_stress_block[i][j],
          &mol_stress_ave[i][j], &mol_stress_unc[i][j]);

  statistics(n_blocks, press_block, &press_ave, &press_unc);
  statistics(n_blocks, vol_block, &vol_ave, &vol_unc);
  statistics(n_blocks, rho_block, &rho_ave, &rho_unc);
  statistics(n_blocks, layer_spacing_block, &layer_spacing_ave,
      &layer_spacing_unc);
  for (i_species = 0; i_species < n_species; ++i_species) {
    for (i = 0; i < 3; ++i)
      for (j = 0; j < 3; ++j)
	statistics(n_blocks, mol_order_block[i_species][i][j],
	    &mol_order_ave[i_species][i][j], &mol_order_unc[i_species][i][j]);
    for (i = 0; i < 3; ++i)
      for (j = 0; j < 3; ++j)
	order_temp[i+1][j+1] = mol_order_ave[i_species][i][j];
    jacobi(order_temp, 3, lambda_temp, v_temp, &nrot);
    eigsrt(lambda_temp, v_temp, 3);
    /* Copy scratch arrays into real arrays. */
    for (i = 0; i < 3; ++i) {
      lambda_ave[i_species][i] = lambda_temp[i+1];
      for (j = 0; j < 3; ++j)
	v[i_species][i][j] = v_temp[i+1][j+1];
    }
    if (v[i_species][2][0] < 0.0)
      for (i = 0; i < 3; ++i)
	v[i_species][i][0] *= -1.0;
    cos_theta_ave[i_species] = v[i_species][2][0];
    statistics(n_blocks, cos_theta_block[i_species],
        &dummy,  &cos_theta_unc[i_species]);
    phi_ave[i_species] = atan2(v[i_species][1][0], v[i_species][0][0]);
    statistics(n_blocks, phi_block[i_species], &dummy,
        &phi_unc[i_species]);
    for (i = 0; i < 3; ++i)
      statistics(n_blocks, lambda_block[i_species][i],
          &dummy,  &lambda_unc[i_species][i]);
  }
  statistics(n_blocks, pe_vdw_s_block, &pe_vdw_s_ave, &pe_vdw_s_unc);
  n_mol_moves_tot = n_mol_accept_tot = n_reshape_moves_tot
      =  n_reshape_accept_tot = 0;
  for (i_block = 0; i_block < n_blocks; ++i_block) {
    n_mol_moves_tot += n_mol_moves_block[i_block];
    n_mol_accept_tot += n_mol_accept_block[i_block];
    n_reshape_moves_tot += n_reshape_moves_block[i_block];
    n_reshape_accept_tot += n_reshape_accept_block[i_block];
  }
  mol_accept = (double) n_mol_accept_tot / n_mol_moves_tot;
  if (n_reshape > 0)
    reshape_accept = (double) n_reshape_accept_tot / n_reshape_moves_tot;

  /* Print run averages and uncertainties to standard output. */
  printf("\nRun averages\n");
  for (i = 0; i < 3; ++i)
    printf("   h[%d][%d] = %g +/- %g\n", i, i, h_ave[i], h_unc[i]);
  for (i = 0; i < 3; ++i)
     for (j = i; j < 3; ++j)
        printf("  stress[%d][%d] = %g +/- %g\n", i, j, mol_stress_ave[i][j],
           mol_stress_unc[i][j]);
  printf("   press = %g +/- %g\n", press_ave, press_unc); 
  printf("   volume = %g +/- %g\n", vol_ave, vol_unc); 
  printf("   rho = %g +/- %g\n", rho_ave, rho_unc); 
  printf("   layer_spacing = %g +/- %g\n", layer_spacing_ave,
      layer_spacing_unc);
  for (i_species = 0; i_species < n_species; ++i_species) {
    printf("   q = %g %g %g\n", mol_order_ave[i_species][0][0],

        mol_order_ave[i_species][0][1], mol_order_ave[i_species][0][2]);
    printf("       %g %g %g\n", mol_order_ave[i_species][1][0],
        mol_order_ave[i_species][1][1], mol_order_ave[i_species][1][2]);
    printf("       %g %g %g\n", mol_order_ave[i_species][2][0],

        mol_order_ave[i_species][2][1], mol_order_ave[i_species][2][2]);
    printf("   cos_theta = %g +/- %g\n", cos_theta_ave[i_species],

        cos_theta_unc[i_species]);
    printf("   theta = %g degrees\n", acos(cos_theta_ave[i_species])
        * radians_to_degrees);
    printf("   phi = %g +/- %g degrees\n", phi_ave[i_species]
        * radians_to_degrees, phi_unc[i_species] * radians_to_degrees);
    for (i = 0; i < 3; ++i)
      printf("   lambda[%d] = %g +/- %g\n", i,
          lambda_ave[i_species][i],  lambda_unc[i_species][i]);
  }
  printf("   pe_vdw_s = %g +/- %g\n", pe_vdw_s_ave, pe_vdw_s_unc);
  printf("   mol_accept = %g\n", mol_accept);
  if (n_reshape > 0)
    printf("   reshape_accept = %g\n", reshape_accept);
  fflush(NULL);

  exit(0);

}  /* end of main. */

/****************************************************************************/
/* Allocate memory for static arrays */
void allocate_memory_simu(int n_atoms, int n_mols, int n_species,
int n_blocks, 
int period_switch, double ***scaled_atom_coords, int **atom_rel,
int **atom_mol, double **atom_mass, int **atom_type, double ***mol_coords, 
double ***scaled_mol_coords, double ***rel_atom_coords, 
double ***h_inv, atom_cell **atom_cells, int **offsets, 
int **offsets_total, int noffsets, nl_entry ***nl_head,
nl_entry ***nl_tail, double ***atom_move, int *n_atoms_per_mol, 
int ****exclusions, 
double ***old, double ***s_old, double ***rel_old, double ***mol_old,
double ***ds_opt, double ***mol_inert_mt, double ****mol_inert_axis,
double ****mol_order_inst, double ***lambda, double ****v, double **phi,
double **cos_theta, double ***h_block, double **h_ave, double **h_unc,
double **layer_spacing_block, double *****mol_order_block, 
double ****mol_order_ave, double ****mol_order_unc, 
double ****lambda_block, double ***lambda_ave, double ***lambda_unc,
double ***cos_theta_block, double **cos_theta_ave, double **cos_theta_unc,
double ***phi_block, double **phi_ave, double **phi_unc, 
  double ****mol_stress_block, double ***mol_stress_ave, 
  double ***mol_stress_unc, double **press_block, double **vol_block,
  double **rho_block, double **pe_vdw_s_block, double **n_mol_moves_block, 
double **n_mol_accept_block, double **n_reshape_moves_block, 
double **n_reshape_accept_block,
int **offsets_x, int **offsets_y, int **offsets_z,
double ***vdw_s, double ***vdw_s_single, double ***at_stress_vdw_s,
double ***at_stress_vdw_single, double ***mol_stress_vdw_s,
double ***mol_stress_vdw_single, double ***mol_range)
{
  int i, i_rel, i_species, n_atoms_max;

  /* Allocate memory for arrays of atomic properties. */
  if (period_switch)
    *scaled_atom_coords = allocate_2d_array(n_atoms,
        3, sizeof(double));
  *rel_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for arrays of atomic properties. */
  *atom_rel = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mol = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mass = allocate_1d_array(n_atoms, sizeof(double));
  *atom_type = allocate_1d_array(n_atoms, sizeof(int));

  /* Allocate memory for arrays of molecular properties. */
  *mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));
  *mol_old = allocate_2d_array(n_mols, 3, sizeof(double));
  if (period_switch)
    *scaled_mol_coords = allocate_2d_array(n_mols, 3,
        sizeof(double));

  /* Allocate memory for the box matrices */
  /* For now, orthorombic box */
  *h_inv = allocate_2d_array(3, 3, sizeof(double));

  /* Allocate memory for atomic cell lists. */
  if (period_switch) {
    *atom_cells = allocate_1d_array(8 * n_atoms, sizeof(atom_cell));
    *offsets = allocate_1d_array(noffsets, sizeof(int));
    *offsets_total = allocate_1d_array(noffsets, sizeof(int));
  }
  
  /* Allocate memory for neighbor lists. */
  *nl_head = gcalloc(n_atoms, sizeof(nl_entry*));
  for (i = 0; i < n_atoms; ++i) {
    (*nl_head)[i] = gmalloc(sizeof(nl_entry));
    (*nl_head)[i] -> next = NULL;
    }
  *nl_tail = gcalloc(n_atoms, sizeof(nl_entry*));
  *atom_move = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for exclusion array. */
  *exclusions = allocate_1d_array(n_species, sizeof(int**));
  for (i_species = 0; i_species < n_species; ++i_species) {
    (*exclusions)[i_species] = allocate_1d_array(n_atoms_per_mol[i_species],
        sizeof(int*));
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species];
        ++i_rel) {
      (*exclusions)[i_species][i_rel] = allocate_1d_array(n_atoms_per_mol[i_species],
          sizeof(int));
    }
  }
  n_atoms_max = 0;
  for (i_species = 0; i_species < n_species; ++i_species)
    n_atoms_max = MAX(n_atoms_max, n_atoms_per_mol[i_species]);
  *old = allocate_2d_array(n_atoms_max, 3, sizeof(double));
  *s_old = allocate_2d_array(n_atoms_max, 3, sizeof(double));
  *rel_old = allocate_2d_array(n_atoms_max, 3, sizeof(double));

  /* Allocate memory for optimization array. */
  *ds_opt = allocate_2d_array(n_mols, 3, sizeof(double));

  /* Allocate memory for analysis arrays. */
  *mol_inert_mt = allocate_2d_array(n_mols, 3, sizeof(double));
  *mol_inert_axis = allocate_3d_array(n_mols, 3, 3, sizeof(double));
  *mol_order_inst = allocate_3d_array(n_species, 3, 3, sizeof(double));
  *lambda = allocate_2d_array(n_species, 3, sizeof(double));
  *v = allocate_3d_array(n_species, 3, 3, sizeof(double));
  *phi = allocate_1d_array(n_species, sizeof(double));
  *cos_theta = allocate_1d_array(n_species, sizeof(double));

  /* Block accumulators */
  *h_block = allocate_2d_array(3, n_blocks, sizeof(double));
  *layer_spacing_block = allocate_1d_array(n_blocks, sizeof(double));
  *mol_order_block =  allocate_4d_array(n_species, 3, 3, n_blocks,
      sizeof(double));
  *lambda_block = allocate_3d_array(n_species, 3, n_blocks,
      sizeof(double));
  *cos_theta_block = allocate_2d_array(n_species, n_blocks,
      sizeof(double));
  *phi_block = allocate_2d_array(n_species, n_blocks, sizeof(double));
  *mol_stress_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *press_block = allocate_1d_array(n_blocks, sizeof(double));
  *vol_block = allocate_1d_array(n_blocks, sizeof(double));
  *rho_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_vdw_s_block = allocate_1d_array(n_blocks, sizeof(double));
  *n_mol_moves_block = allocate_1d_array(n_blocks, sizeof(double));
  *n_mol_accept_block = allocate_1d_array(n_blocks, sizeof(double));
  *n_reshape_moves_block = allocate_1d_array(n_blocks, sizeof(double));
  *n_reshape_accept_block = allocate_1d_array(n_blocks, sizeof(double));

  /* Average accumulators. */
  *h_ave = allocate_1d_array(3, sizeof(double));
  *h_unc = allocate_1d_array(3, sizeof(double));
  *mol_order_ave =  allocate_3d_array(n_species, 3, 3, sizeof(double));
  *mol_order_unc =  allocate_3d_array(n_species, 3, 3, sizeof(double));
  *lambda_ave = allocate_2d_array(n_species, 3, sizeof(double));
  *lambda_unc = allocate_2d_array(n_species, 3, sizeof(double));
  *cos_theta_ave = allocate_1d_array(n_species, sizeof(double));
  *cos_theta_unc = allocate_1d_array(n_species, sizeof(double));
  *phi_ave = allocate_1d_array(n_species, sizeof(double));
  *phi_unc = allocate_1d_array(n_species, sizeof(double));
  *mol_stress_ave = allocate_2d_array(3, 3, sizeof(double));
  *mol_stress_unc = allocate_2d_array(3, 3, sizeof(double));

  /* Array of offsets for nophantom case */

  *offsets_x =allocate_1d_array(noffsets, sizeof(int));
  *offsets_y =allocate_1d_array(noffsets, sizeof(int));
  *offsets_z =allocate_1d_array(noffsets, sizeof(int));

  /* Memory for force and stress tensor */

  *vdw_s = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *vdw_s_single = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *at_stress_vdw_s = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_vdw_s = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress_vdw_single = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_vdw_single = allocate_2d_array(NDIM, NDIM, sizeof(double));

  /* Memory for geometrical molecular lengths. */
  
  *mol_range = allocate_2d_array(n_species, NDIM, sizeof(double));

}

/****************************************************************************/
/* Set up array of relative atom indices. */
void relative_atoms(int n_mols, int *mol_species, int *mol_first_atm,
   int *n_atoms_per_mol, double **temp_atm_mass, int **temp_atm_type_i,
   int *atom_rel, int *atom_mol, double *atom_mass, int *atom_type)
{
  int i_species, skip, i, i_mol, i_rel;

  /* Set up array of atomic properties. */
  for (i_mol = 0; i_mol < n_mols; ++i_mol) {
    i_species = mol_species[i_mol];
    skip = mol_first_atm[i_mol];
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
      i = skip + i_rel;
      atom_rel[i] = i_rel;
      atom_mol[i] = i_mol;
      atom_mass[i] = temp_atm_mass[i_species][i_rel];
      atom_type[i] = temp_atm_type_i[i_species][i_rel];
    }
  }

}
