#include "build.h"

int parse_tokens(char *line, char ***token)
{
   int n_tokens = 0;
   char *token_tmp;

   token_tmp = strtok(line, " \n");
   while (token_tmp != NULL) {
      (*token) = grealloc((*token), (n_tokens+1) * sizeof(char*));
      (*token)[n_tokens] = token_tmp;
      ++n_tokens;
      token_tmp = strtok(NULL, " \n");
   }

   return n_tokens;
}

main(int argc, char *argv[])
{
   FILE *f_input;
   char pot_file[F_MAX];
   char line[MAX_LINE], **token = NULL;
   int form_pot, n_tokens, mass;

   strcpy(pot_file, argv[1]);
   /* Open parameter file. */
   if ((f_input = fopen(pot_file, "r")) == NULL)
      error_exit("Unable to open parameter file in read_pot_params");

   /* Read in pot entries. */
   while (fgets(line, MAX_LINE, f_input) != NULL) {
     if (strncmp(line, "#", 1) != 0) {
     n_tokens = parse_tokens(line, &token); 
     form_pot = atoi(token[0]);
     mass = atoi(token[3]);
     printf("form_pot = %d, %s, %s, mass = %d\n", form_pot, token[1], token[2], mass);
     }
   }

   /* Close input file. */
   fclose(f_input);
}
