#include "build.h"
#include "ff.h"
#include "proto.h"

void EvalRdf(int n_atoms, int *atom_mol, int *atom_rel, int *mol_species, 
             double **scaled_atom_coords, double rangeRdf, int sizeHistRdf,
             double **histRdf, double *tRdf, char ***temp_atm_type ,
             double **h, int limitRdf, double rrRange, double deltaR)
    {
    double s_sep[NDIM], sep[NDIM], r2_sep;
    int j1, j2, k, n,i, rdfType, i_mol, j_mol, 
        i_species, j_species, i_rel, j_rel;
    double volume;
    char *type_i, *type_j;
    


    volume = h[0][0]*h[1][1]*h[2][2];
    for (j1 = 0; j1 < n_atoms - 1; ++j1) {
      for (j2 = j1 + 1; j2 < n_atoms; ++j2) {
      
           i_mol = atom_mol[j1];
           i_rel = atom_rel[j1];
           i_species = mol_species[i_mol];
           j_mol = atom_mol[j2];
           j_rel = atom_rel[j2];
           j_species = mol_species[j_mol];

           type_i = temp_atm_type[i_species][i_rel];
           type_j = temp_atm_type[j_species][j_rel];

        /* Calculate pair separation. */

               for (k = 0; k < NDIM; ++k){
                 s_sep[k] = scaled_atom_coords[j1][k] - scaled_atom_coords[j2][k];
                 s_sep[k] -= NINT(s_sep[k]);
               }
               sep[0] = h[0][0] * s_sep[0] + h[0][1] * s_sep[1]
                        + h[0][2] * s_sep[2];
               sep[1] = h[1][1] * s_sep[1] + h[1][2] * s_sep[2];
               sep[2] = h[2][2] * s_sep[2];

               r2_sep = SQR(sep[0]) + SQR(sep[1]) + SQR(sep[2]);


        if (r2_sep < rrRange) {
/* printf(" i_species %d j_species %d type_i %c type_j %c\n", i_species, 
           j_species, type_i, type_j); */

          if (i_species ==0 &&strcmp(type_i,"C_3")==0 
               && j_species == 0 && strcmp(type_j,"C_3")==0) 
                                       rdfType = 1;  /* HH correlation*/

          if (i_species ==0 &&strcmp(type_i,"C_3")==0 
               && j_species == 0 && strcmp(type_j,"C_2")==0) 
                                       rdfType = 2;  /* HT correlation*/

          if (i_species ==0 &&strcmp(type_i,"C_2")==0 
               && j_species == 0 && strcmp(type_j,"C_2")==0) 
                                       rdfType = 3;  /* TT correlation*/

          if (i_species ==1 &&strcmp(type_i,"C_3")==0 
               && j_species == 1 && strcmp(type_j,"C_3")==0) 
                                       rdfType = 4;  /* WW correlation*/

          if (i_species ==0 &&strcmp(type_i,"C_3")==0 
               && j_species == 1 && strcmp(type_j,"C_3")==0) 
                                       rdfType = 5;  /* WH correlation*/
          
          n = (int) (sqrt (r2_sep) / deltaR) + 1;
     if (n < sizeHistRdf){
          histRdf[n][rdfType]= histRdf[n][rdfType] + 1.;
          tRdf[n] = tRdf[n] + 1. ;
     }
    } } }
  }
  
  
void PrintRdf( int sizeHistRdf, double rangeRdf, double **histRdf,
            double *tRdf, double dum1_total, double dum1_water,
            double dum1_lyo) 
{
    
    FILE *hhfp1,*ttfp1, *wwfp1, *whfp1, *htfp1, *wtfp1;
    FILE *ssfp1,*stfp1, *shfp1, *swfp1,*towfp1;
 
    double rBin;
    int n;

    hhfp1=fopen("hhcor.dat","w");
    htfp1=fopen("htcor.dat","w");
    ttfp1=fopen("ttcor.dat","w");
    wwfp1=fopen("wwcor.dat","w");
    whfp1=fopen("whcor.dat","w");
    towfp1=fopen("totalcor.dat","w");
/*
    wtfp1=fopen("wtcor_l12.dat","w");
    ssfp1=fopen("sscor_l12.dat","w");
    stfp1=fopen("stcor_l12.dat","w");
    shfp1=fopen("shcor_l12.dat","w");
    swfp1=fopen("swcor_l12.dat","w");

*/
printf(" I am in printing pair corelation\n");

        for (n = 0; n < sizeHistRdf; ++n) {
             rBin = (n + 0.5) * rangeRdf / sizeHistRdf;
             fprintf (hhfp1, "%8.4f %8.4f\n", rBin, histRdf[n][1]*dum1_lyo);
             fprintf (htfp1, "%8.4f %8.4f\n", rBin, histRdf[n][2]*dum1_lyo);
             fprintf (ttfp1, "%8.4f %8.4f\n", rBin, histRdf[n][3]*dum1_lyo);
             fprintf (wwfp1, "%8.4f %8.4f\n", rBin, histRdf[n][4]*dum1_water);
             fprintf (whfp1, "%8.4f %8.4f\n", rBin, histRdf[n][5]*dum1_total);
/*
             fprintf (wtfp1, "%8.4f %8.4f\n", rBin, histRdf[6][n]);
             fprintf (ssfp1, "%8.4f %8.4f\n", rBin, histRdf[7][n]);
             fprintf (stfp1, "%8.4f %8.4f\n", rBin, histRdf[8][n]);
             fprintf (shfp1, "%8.4f %8.4f\n", rBin, histRdf[9][n]);
             fprintf (swfp1, "%8.4f %8.4f\n", rBin, histRdf[10][n]);
*/
             fprintf (towfp1, "%8.4f %8.4f\n", rBin,tRdf[n]*dum1_total);
        }
fclose(hhfp1);
fclose(htfp1);
fclose(ttfp1);
fclose(wwfp1);
fclose(whfp1);
fclose(towfp1);
/*
fclose(wtfp1);
fclose(ssfp1);
fclose(stfp1);
fclose(shfp1);
fclose(swfp1);
*/
  }

