#include "build.h"
#include "ff.h"
#include "proto.h"

void geom_molecules(int n_species, int *n_atoms_per_mol, 
   double ***temp_atm_pos, double **mol_range, double *mol_max_length)
{
double x_min, x_max, y_min, y_max, z_min, z_max;
int i_species, i;
     
  for (i_species = 0; i_species < n_species; ++i_species)
    {     
     /* Measure geometrical dimensions of molecule. */
      x_min = x_max = temp_atm_pos[i_species][0][0];
      y_min = y_max = temp_atm_pos[i_species][0][1];
      z_min = z_max = temp_atm_pos[i_species][0][2];
      for (i = 1; i < n_atoms_per_mol[i_species]; ++i) {
         x_min = MIN(x_min, temp_atm_pos[i_species][i][0]);
         y_min = MIN(y_min, temp_atm_pos[i_species][i][1]);
         z_min = MIN(z_min, temp_atm_pos[i_species][i][2]);
         x_max = MAX(x_max, temp_atm_pos[i_species][i][0]);
         y_max = MAX(y_max, temp_atm_pos[i_species][i][1]);
         z_max = MAX(z_max, temp_atm_pos[i_species][i][2]);
      }
      mol_range[i_species][0] = x_max - x_min;
      mol_range[i_species][1] = y_max - y_min;
      mol_range[i_species][2] = z_max - z_min;
    }

 /* Compute maximum geometrical length. */
  *mol_max_length = -1.0;
  for (i_species = 0; i_species < n_species; ++i_species){
   x_max = mol_range[i_species][0];
   x_max = MAX(mol_range[i_species][1], x_max);
   x_max = MAX(mol_range[i_species][2], x_max);
   *mol_max_length = MAX(*mol_max_length, x_max);

   /* Print geometrical molecular informations to standard output. */
   printf("Geometrical dimensions of specie %d : x_mol = %g, y_mol = %g, z_mol = %g\n", i_species, mol_range[i_species][0], mol_range[i_species][1], mol_range[i_species][2]);
   }
   printf("\nMaximum geometrical length = %g\n", *mol_max_length);
}
