#include "build.h"
#include "ff.h"
#include "proto.h"
#include "clust.h"

main(int argc, char *argv[])
{
  int ans, i_mol, skip, i_atom, abs;
  double diff_x, diff_y, diff_z, xx, yy, zz, pe_vdw_s_single,
      pe_vdw_s_p;
  nl_entry *p, *p_term;

  double pe_vdw_s_tot;
  int i_rel, j_rel, j_species;
  int i, j, k, i_atoms, i_species, i_phant, n_species, n_species_chk, 
      n_unit_cells, n_mols, n_atoms;
  int period_switch, vdw_switch, vdw_rad_switch, *excl_switch, init_switch,
      phant_switch, neigh_switch, opt_switch, press_switch, one_four_switch,
      nb_switch, con_switch, sim_switch, temp_switch, start_switch;
  /* Random generator */
  long i_ran, seed, idum;
  /* Array of geometrical molecular lengths. */
  double **mol_range, mol_max_length, xmax;
  /* Declare parameters used to build the initial state and box matrices*/
  int n_layers;
  double rho, aspect_xy, aspect_xz, layer_spacing;
  double **h, **h_inv, r_off, r_on, r2_on, r2_off, r_nl, r2_nl;
  int kc;
  /* Declare and initialize force field parameters. */
  int n_mass = 0, n_lj = 0, n_e6 = 0, n_pot = 0, n_type = 0;
  mass_entry *mass = NULL;
  lj_entry *lj = NULL;
  e6_entry *e6 = NULL;
  pot_entry *pot = NULL;
  type_entry *atm_type = NULL;
  /* File names */
  char par_file[F_MAX], *mass_file, *lj_file, *e6_file, *pot_file, 
      **struct_file, *header_file, *config_file, *header_file_save, 
      *config_file_save;
  FILE *f_thermo, *f_trajec;
  /* Declare and initialize molecular structure parameters. */
  int *n_atoms_per_mol = NULL, *n_mols_per_species = NULL,
      *n_bonds_per_mol = NULL, **temp_atm_lab, **temp_atm_nbr,
      ***temp_atm_br, **temp_atm_type_i;
  double ***temp_atm_pos, **temp_atm_mass, **temp_atm_chg,
      **temp_atm_sigma, **temp_atm_eps, ***temp_atm_ord;
  char ***temp_atm_type;
  int **temp_bonds_1 = NULL, **temp_bonds_2 = NULL;
  double **temp_bonds_ord = NULL;
  int *n_mols_per_unit_cell, *mol_species;

  /* Declare some arrays used in set up force field */
  double *mol_mass, *mol_mass_true;
  int *mol_first_atm;

  /* Declare combination and exclusion arrays */
  int ***exclusions, **comb_pot;
  double ***comb_par;
  /* Declare arrays used in build */
  double **scaled_atom_coords, **mol_coords, **scaled_mol_coords,
      **atom_coords, **rel_atom_coords, **atom_vels, *atom_mass, 
      *sqrt_kT_over_m, *one_over_2m, **mol_vels;
  int *atom_rel, *atom_mol, *atom_type, *hot_atom;
  int hot_flag;

  /* Scan list arrays. */
  int **scan_atm_1, **scan_atm_2;

  /* Array of the chosen principal molecular axe. */
  int *principal;
  /* Monte Carlo parameters. */
  int i_cycle, n_cycles, n_trajec, n_block, n_blocks, n_inst;

  /* Declare cell arrays. */
  atom_cell *atom_cells = NULL;
  phantom_cell *phantoms = NULL;
  int phantom_skip[7], nc[NDIM], nc_p[NDIM], nc_p_total, *first = NULL, 
  *last = NULL, *offsets, *offsets_total, noffsets;
  int *offsets_x, *offsets_y, *offsets_z;

  /* Neighbor list. */ 
  nl_entry **nl_head, **nl_tail; 
  double **atom_move;

/* Array for cluster analysis */
  int *inClust, *clustSize, *clustHead, *clustNext, *hist, 
      *hist_ave, nClust, nClustt, 
      bigSize, nSingle, ncUse, cBig, m, ncl, *total_clust, isum_w, s2_w, 
      isum_n, s2_n, s2_big,
      l_amp, N_amp, clust_size;
  double rClust, sSum, ssSum,rrClust, clsize_w, clsize_n, clsize_wave, 
         clsize_nave, dev, dev_ave,
         dist_ave, mol_fraction, vol_fraction;

  /* Get command line input. */
  if (argc != 2) {
    printf("Usage: %s params_file\n", argv[0]);
    exit(1);
  }
  strcpy(par_file, argv[1]);

  /* Read in input parameter file. */
  read_clust_params(par_file, &start_switch, &header_file, &config_file, 
      &mass_file, &pot_file, 
      &n_species_chk, &excl_switch, &r_on, &r_off, &rClust, 
      &neigh_switch, &phant_switch, &kc, &r_nl, &n_cycles, 
      &n_block, &n_trajec, &seed);

  printf("header_file = %s, config_file = %s\n",header_file,
      config_file);
  printf("mass_file = %s\n",mass_file);
  printf("pot_file = %s\n",pot_file);
  printf("n_species (from params file) = %d\n", n_species_chk);
  for (i_species = 0; i_species < n_species_chk; ++i_species)
     printf("i_specie = %d, excl_switch = %d\n", i_species,
          excl_switch[i_species]);

  printf("r_on = %g, r_off = %g\n",r_on, r_off);
  printf("neigh_switch = %d, phant_switch = %d\n", neigh_switch,
      phant_switch);
  printf("kc = %d, r_nl = %g\n",kc, r_nl);
  printf("n_cycles = %d, \n", n_cycles);
  printf("n_trajec = %d\n", n_trajec);
  printf("seed = %ld\n",seed);

  /* Define additional variables. */
  if (n_cycles % n_block != 0) 
    error_exit("n_cycles must be a multiple of n_block!\n");
  n_blocks = n_cycles / n_block;
  noffsets = 1 + kc + kc * (2 * kc + 1) + kc * SQR(2 * kc + 1);

  /* Initialize random number generator. */
  i_ran = -seed;
  ran3(&i_ran);

  /* Read information about template molecules and atoms from header file */
  read_header_direct(header_file, &period_switch, &n_species,
      &n_atoms_per_mol,  &temp_atm_lab, &temp_atm_type, &temp_atm_nbr,
      &temp_atm_br, &temp_atm_ord,  &temp_atm_pos, &temp_atm_chg,
      &temp_atm_sigma, &temp_atm_eps,  &n_bonds_per_mol, &temp_bonds_1,
      &temp_bonds_2, &temp_bonds_ord,  &n_mols_per_species, &n_mols,
      &n_atoms, &mol_species);

  /* Check exclusion switch array. */
  if (n_species_chk != n_species) {
     printf("n_species_chk = %d, n_species = %d\n", n_species_chk, n_species);
     error_exit("Problem in the number of species.\n");
  }
 
  /* If the number of exclusion sites is greater than the number of atoms
     present in the template molecule, set the exclusion switch to -1, i.e.
     remove all intramolecular interactions. */ 
  for (i_species = 0; i_species < n_species; ++i_species)
    if (excl_switch[i_species] >= n_atoms_per_mol[i_species])
      excl_switch[i_species] = -1;
 
  /* Read FF masses file. */
  read_mass_params(mass_file, &mass, &n_mass);

  /* Set up force field data for masses. */
  set_up_force_field_pair(n_species, n_mols, n_atoms_per_mol, n_mass,
      mass, mol_species, n_bonds_per_mol, &temp_atm_mass, temp_atm_type,
      &mol_mass, &mol_mass_true, &mol_first_atm);

  /* Convert string tags to integer identifiers. */
  /* Create an integer identifier corresponding to template atom type. */ 
  convert_type(n_species, n_atoms_per_mol, temp_atm_type, &temp_atm_type_i, 
     &atm_type, &n_type);

  /* Set up scan list. */
  set_up_scan_list(n_species, n_atoms_per_mol, temp_atm_nbr, temp_atm_br,  
     &scan_atm_1, &scan_atm_2);

  /* Allocate memory for arrays used in the builder. */
  allocate_memory_clust(n_atoms, n_mols, n_species, 
      period_switch,  &scaled_atom_coords, &atom_rel, &atom_mol,
      &atom_mass, &atom_type, 
      &mol_coords, &scaled_mol_coords, 
      &rel_atom_coords, &h_inv, &atom_cells, &offsets, &offsets_total, 
      noffsets, &nl_head, &nl_tail, &atom_move,
      n_atoms_per_mol, &exclusions, &inClust, &clustSize, &clustHead,
      &clustNext, &hist, &hist_ave, &total_clust);


  /* Set up array of relative atom indices */
  relative_atoms_clust(n_mols, mol_species, mol_first_atm, n_atoms_per_mol,
      temp_atm_mass, temp_atm_type_i, atom_rel, atom_mol, atom_mass, atom_type);
      

  /* Set up the nonbonded exclusion array */
  exclusion_array(n_species, n_atoms_per_mol, excl_switch, temp_atm_nbr,  
    temp_atm_br, &exclusions);
 
  /* If we are using periodic boundary conditions, and that we are using
   cell (or neighbor) list, set up atom index offsets for updating phantom 
   atoms. */

  r2_nl = r_nl * r_nl;
  r2_on = r_on * r_on;
  r2_off = r_off * r_off;

  l_amp = n_atoms_per_mol[0];
  N_amp = n_mols_per_species[0];
  printf(" Length of the surfactant: %d and No. of surfactants %d\n", l_amp, N_amp);


 /* If start_switch == 0, read and display only a configuration
     file (ascii). */
  if (start_switch == 0) {
    nClust = 0;
      /* Read atomic position and velocities from config file */
      read_config_direct(config_file, period_switch, &h, n_atoms,
                         &atom_coords, &atom_vels);

      /* Calculate quantities that depend on box dimensions and exit
         if system is too small. */
      box_dimensions(h, h_inv, period_switch, 0.0, 0.0);

      if (period_switch) {
         scaled_atomic_coords(n_atoms, h_inv, atom_coords, scaled_atom_coords);
         periodic_boundary_conditions(n_atoms, h, scaled_atom_coords,
                                      atom_coords);
      }
    /* Initialize number of phantom cells. */
    nc_p[0] = nc_p[1] = nc_p[2] = 0;
    nc_p_total = 0;
  if ((period_switch) && (neigh_switch != 0))
  {
    for (i_phant = 0; i_phant < 7; ++i_phant)
      phantom_skip[i_phant] = (i_phant + 1) *
          n_atoms;

  }

      set_up_cells_phantom(h, nc, nc_p, &nc_p_total,
          atom_cells,  kc,  period_switch, r_nl, r_off,
          neigh_switch, &first, &last, offsets,  n_atoms,
          scaled_atom_coords, atom_coords, &phantoms,
          phantom_skip);

       update_phantoms(n_atoms, atom_cells, phantom_skip,
          phantoms, atom_coords);

      InitClusters (inClust, hist,  n_atoms, mol_species,
                atom_mol);


   cluster_lists_period(mol_species, atom_rel, atom_mol,
    n_atoms, n_atoms_per_mol, exclusions, h,
    r2_on, r2_off, scaled_atom_coords, period_switch,
    first, last, phantoms, noffsets, nc_p,
    kc, phantom_skip, nc, atom_cells, offsets,
   atom_coords, atom_move, nl_head,
   nl_tail, rClust, inClust, clustSize, clustHead,
   clustNext, &nClust);

/* Compress the cluster */

   ncl = 0;
    for (j = 0; j <= nClust; ++j) {
      if (clustSize[j] > 0) {
        ncl = ncl + 1;
        clustSize[ncl] = clustSize[j];
        clustHead[ncl] = clustHead[j];
        m = clustHead[ncl];
        while (m != -1) {
          inClust[m] = ncl;    m = clustNext[m];
    } } }
  nClust = ncl; 

/* Calculates the histogram */
ncUse = 0;    cBig = 1;
    sSum = ssSum = 0.;

    for (ncl = 0; ncl <= nClust; ++ncl) {
      if (clustSize[ncl] > clustSize[cBig]) cBig = ncl;
      if (clustSize[ncl] > 1) {
        ncUse = ncUse + 1;
        sSum = sSum + clustSize[ncl];
        ssSum = ssSum + SQR (clustSize[ncl]);
        hist[clustSize[ncl]] = hist[clustSize[ncl]]+1;
    } }
    bigSize = clustSize[cBig];
    nSingle = n_atoms - sSum;
    printf("sSum %lf ncUse %d nClust %d\n", sSum, ncUse, nClust);
    if (ncUse > 0) {
      sSum = sSum / ncUse;
      ssSum = sqrt (ssSum / ncUse - SQR (sSum));
    }
   for (ncl = 0; ncl < n_atoms; ++ncl)
   if(hist[ncl] > 0) printf("%d %d %d\n",ncl,hist[ncl], ncl*hist[ncl]);

  printf ("%d %d %d %d %.1f %.1f \n", n_atoms, nSingle, nClust,
                              bigSize, sSum, ssSum);

}
 else {

/* Open output file. */
  if ((f_trajec = fopen(config_file, "r")) == NULL)
    error_exit("Cannot open config_file\n");

  /* Read header from the trajectory file. */
  fread(&n_atoms, sizeof(int), 1, f_trajec);
  fread(&n_cycles, sizeof(int), 1, f_trajec);
  fread(&n_trajec, sizeof(int), 1, f_trajec);

  printf("Header from %s\n", config_file);
  printf("n_atoms = %d\n", n_atoms);
  printf("n_cycles = %d\n", n_cycles);
  printf("n_trajec = %d\n", n_trajec);

  /* Compute number of instantaneous configuration in trajectory file. */
  if (n_cycles % n_trajec != 0) {
      printf("n_cycles must be a multiple of n_trajec\n");
      exit(1);
  }
  n_inst = n_cycles / n_trajec;
  dev_ave = clsize_wave = 0.0;
  clsize_nave = 0.0;

  /* Allocate memory for box and atom coordinates. */
  h = allocate_2d_array(3, 3, sizeof(double));
  atom_coords = allocate_2d_array(8*n_atoms, 3, sizeof(double));

  /* Loop  over trajectories. */
  printf("\nEntering main loop\n");
  fflush(NULL);

    for (i_cycle = 1; i_cycle <= n_inst; ++i_cycle) {

    nClust = 0;
    isum_n = s2_n = 0;
    isum_w = s2_w = 0;

      /* Read in instantaneous configuration from trajectory file. */
      read_positions_direct(f_trajec, h, n_atoms, atom_coords);

      /* Calculate quantities that depend on box dimensions and exit
         if system is too small. */
      box_dimensions(h, h_inv, period_switch, 0.0, 0.0);

      if (period_switch) {
         scaled_atomic_coords(n_atoms, h_inv, atom_coords, scaled_atom_coords);
         periodic_boundary_conditions(n_atoms, h, scaled_atom_coords,
                                      atom_coords);
      }

  /* Initialize number of phantom cells. */
    nc_p[0] = nc_p[1] = nc_p[2] = 0;
    nc_p_total = 0;


  if ((period_switch) && (neigh_switch != 0))
  {
    for (i_phant = 0; i_phant < 7; ++i_phant)
      phantom_skip[i_phant] = (i_phant + 1) *
          n_atoms;
  }

      set_up_cells_phantom(h, nc, nc_p, &nc_p_total,
          atom_cells,  kc,  period_switch, r_nl, r_off,
          neigh_switch, &first, &last, offsets,  n_atoms,
          scaled_atom_coords, atom_coords, &phantoms,
          phantom_skip);

       update_phantoms(n_atoms, atom_cells, phantom_skip,
          phantoms, atom_coords); 

      InitClusters (inClust, hist,  n_atoms, mol_species,
                atom_mol);


   cluster_lists_period(mol_species, atom_rel, atom_mol,
    n_atoms, n_atoms_per_mol, exclusions, h,
    r2_on, r2_off, scaled_atom_coords, period_switch,
    first, last, phantoms, noffsets, nc_p,
    kc, phantom_skip, nc, atom_cells, offsets,
   atom_coords, atom_move, nl_head,
   nl_tail, rClust, inClust, clustSize, clustHead,
   clustNext, &nClust);
   
  /* Compress the cluster */
  ncl = 0;
    for (j = 0; j <= nClust; ++j) {
      if (clustSize[j] > 0) {
        ncl = ncl + 1;
        clustSize[ncl] = clustSize[j];
        clustHead[ncl] = clustHead[j];
        m = clustHead[ncl];
        while (m != -1) {
          inClust[m] = ncl;    m = clustNext[m];
        } 
     } 

}
    nClust = ncl;

/* Calculates the histogram */
 ncUse = 0;    cBig = 1;
    sSum = ssSum = 0.;

    for (ncl = 0; ncl <= nClust; ++ncl) {
      if (clustSize[ncl] > clustSize[cBig]) cBig = ncl; 
      if (clustSize[ncl] > 1) {
        ncUse = ncUse + 1;
        sSum = sSum + clustSize[ncl];
        ssSum = ssSum + SQR (clustSize[ncl]);
        hist[clustSize[ncl]] = hist[clustSize[ncl]]+1;
        hist_ave[clustSize[ncl]] = hist_ave[clustSize[ncl]]+1;
    } }

    bigSize = clustSize[cBig]; 
    nSingle = n_atoms - sSum;

   for (ncl = 0; ncl <= bigSize; ++ncl){
     if (hist[ncl] > 0) total_clust[ncl]++;
   }

    if (ncUse > 0) {
      sSum = sSum / ncUse;
      ssSum = sqrt (ssSum / ncUse - SQR (sSum));
    }
   for (ncl = 0; ncl < n_atoms; ++ncl)
       if(hist[ncl] > 0) {
       isum_w = isum_w + ncl * hist[ncl];
       isum_n = isum_n + hist[ncl];
       s2_w = s2_w + 1.0 * ncl *ncl * hist[ncl];
       s2_n = s2_n + 1.0 * ncl * hist[ncl];
       printf("%d %d %d\n",ncl,hist[ncl], ncl*hist[ncl]);
    }

 /* There is a probability s*n(s) that an arbitrary atom belongs to an 
    s-cluster and a probability sum(s*n(s)) that it belongs to any finite
   cluster. Thus w_s = s*n(s)/sum(s*n(s)) is the probability that that the
   cluster to which an arbitrary atom belongs contains exactly s atoms. The
   average cluster size  S = sum ( w_s *s) = sum (n(s)*s^2)/sum(n(s)*s) ---(1).
   Note: S = sum(s*n(s))/sum(n(s)) ---(2) is the average cluster size if every 
   cluster, and not every atom as in equ. (1), is selected with equal 
   probability , Stauffer, Intro. to percolation .., page 21 */

 /* Average clustersize (weight average) for a given cluster distribution */
  clsize_w = s2_w/(1.0 * isum_w); 
 /* Average clustersize (number average) for a given cluster distribution */
  clsize_n = s2_n/(1.0 * isum_n); 

  s2_big = s2_w - bigSize*bigSize*hist[bigSize];

  dev = s2_big/(1.0* isum_w);
  clsize_wave += clsize_w;
  clsize_nave += clsize_n;
  dev_ave += dev;



  printf ("%d %d %d %d %g %g %d\n", n_atoms, nSingle, nClust,
                              bigSize, clsize_n, clsize_w, i_cycle*n_trajec);
  } /* end of the loop. */

  /* Close output file. */
  fclose(f_trajec);
  }
  printf(" Printing the average Cluster size distribution etc.\n"); 

   for (ncl = 0; ncl < n_atoms; ++ncl)
   if(hist_ave[ncl] > 0) 
          printf("%d %d %g %g %d %d\n", ncl, hist_ave[ncl], 
                        hist_ave[ncl]/(1.*total_clust[ncl]),
                        hist_ave[ncl]/(1.0* n_inst), total_clust[ncl], n_inst); 

   /* Calculate the volume/mol fraction of the surfactants in different cluster 
     mol. fraction: X_s = s*n(s)/N_amp, 
     vol. fraction: X_s = s*n(s)/n_mols */

 printf(" Printing the mol/volume fraction of the the sufactants\n"); 
   for (ncl = 0; ncl < n_atoms; ++ncl)
       if(hist_ave[ncl] > 0){
         dist_ave = hist_ave[ncl]/(1.0* n_inst);
         clust_size = ncl/l_amp; 

         mol_fraction = clust_size*dist_ave/(1.0 * N_amp);
         vol_fraction = clust_size*dist_ave/(1.0 * n_mols);

          printf("%d %g %g\n", clust_size, mol_fraction, vol_fraction);
      }

   printf(" Weight average cluster size : %g\n", clsize_wave/n_inst);
   printf(" Number Average cluster size : %g\n", clsize_nave/n_inst);
   printf(" Average cluster size excluding the largest : %g\n", dev_ave/n_inst);
  exit(0);

}  /* end of main. */

/****************************************************************************/
/* Allocate memory for static arrays */
void allocate_memory_clust(int n_atoms, int n_mols, int n_species,
int period_switch, double ***scaled_atom_coords, int **atom_rel,
int **atom_mol, double **atom_mass, int **atom_type, 
double ***mol_coords, 
double ***scaled_mol_coords, double ***rel_atom_coords, 
double ***h_inv, atom_cell **atom_cells, int **offsets, 
int **offsets_total, int noffsets, nl_entry ***nl_head,
nl_entry ***nl_tail, double ***atom_move, int *n_atoms_per_mol, 
int ****exclusions, int **inClust, int **clustSize, int **clustHead,
int **clustNext, int **hist, int **hist_ave, int **total_clust)

{
  int i, i_rel, i_species, n_atoms_max;

  /* Allocate memory for arrays of atomic properties. */
  if (period_switch)
    *scaled_atom_coords = allocate_2d_array(n_atoms,
        3, sizeof(double));
  *rel_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for arrays of atomic properties. */
  *atom_rel = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mol = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mass = allocate_1d_array(n_atoms, sizeof(double));
  *atom_type = allocate_1d_array(n_atoms, sizeof(int));

  /* Allocate memory for arrays of molecular properties. */
  *mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));
  if (period_switch)
    *scaled_mol_coords = allocate_2d_array(n_mols, 3,
        sizeof(double));

  /* Allocate memory for the box matrices */
  /* For now, orthorombic box */
  *h_inv = allocate_2d_array(3, 3, sizeof(double));

  /* Allocate memory for atomic cell lists. */
  if (period_switch) {
    *atom_cells = allocate_1d_array(8 * n_atoms, sizeof(atom_cell));
    *offsets = allocate_1d_array(noffsets, sizeof(int));
    *offsets_total = allocate_1d_array(noffsets, sizeof(int));
  }
  
  /* Allocate memory for neighbor lists. */
  *nl_head = gcalloc(n_atoms, sizeof(nl_entry*));
  for (i = 0; i < n_atoms; ++i) {
    (*nl_head)[i] = gmalloc(sizeof(nl_entry));
    (*nl_head)[i] -> next = NULL;
    }
  *nl_tail = gcalloc(n_atoms, sizeof(nl_entry*));
  *atom_move = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for exclusion array. */
  *exclusions = allocate_1d_array(n_species, sizeof(int**));
  for (i_species = 0; i_species < n_species; ++i_species) {
    (*exclusions)[i_species] = allocate_1d_array(n_atoms_per_mol[i_species],
        sizeof(int*));
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species];
        ++i_rel) {
      (*exclusions)[i_species][i_rel] = allocate_1d_array(n_atoms_per_mol[i_species],
          sizeof(int));
    }
  }
/* Allocate memory for cluster count */
  *inClust = allocate_1d_array(n_atoms, sizeof(int));
  *clustSize = allocate_1d_array(n_atoms, sizeof(int));
  *clustHead = allocate_1d_array(n_atoms, sizeof(int));
  *clustNext = allocate_1d_array(n_atoms, sizeof(int));
  *hist = allocate_1d_array(n_atoms, sizeof(int));
  *hist_ave = allocate_1d_array(n_atoms, sizeof(int));
  *total_clust = allocate_1d_array(n_atoms, sizeof(int));


}

/****************************************************************************/
/* Set up array of relative atom indices. */
void relative_atoms_clust(int n_mols, int *mol_species, int *mol_first_atm,
   int *n_atoms_per_mol, double **temp_atm_mass, int **temp_atm_type_i,
   int *atom_rel, int *atom_mol, double *atom_mass, int *atom_type)
{
  int i_species, skip, i, i_mol, i_rel;

  /* Set up array of atomic properties. */
  for (i_mol = 0; i_mol < n_mols; ++i_mol) {
    i_species = mol_species[i_mol];
    skip = mol_first_atm[i_mol];
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
      i = skip + i_rel;
      atom_rel[i] = i_rel;
      atom_mol[i] = i_mol;
      atom_mass[i] = temp_atm_mass[i_species][i_rel];
      atom_type[i] = temp_atm_type_i[i_species][i_rel];
    }
  }

}
