/* Neighbor list routines for molecular modeling package. */

#include "build.h"
#include "ff.h"
#include "proto.h"

/*****************************************************************************/
/* Construct neighbor lists,  for cluster counting 
               with periodic_boundary conditions. */
void cluster_lists_period(int *mol_species, int *atom_rel, int *atom_mol, 
   int n_atoms, int *n_atoms_per_mol, int ***exclusions, double **h, 
   double r2_on, double r2_off, double **scaled_atom_coords, int period_switch,
   int *first, int *last, phantom_cell *phantoms, int noffsets, int *nc_p, 
   int kc, int *phantom_skip, int *nc, atom_cell *atom_cells, int *offsets, 
   double **atom_coords, double **atom_move, nl_entry **nl_head, 
   nl_entry **nl_tail, double rClust, int *inClust, int *clustSize, int *clustHead,
   int *clustNext, int *nClust)
                            
{
   int i, j, k, j_real, ic, jc, i_off, i_species, i_mol, j_mol, i_rel, j_rel, 
      inter_flag, j_species, tClust;
   double sep[NDIM], r2_sep, s_i[NDIM], rrClust;
   nl_entry *p;
   
   rrClust = SQR(rClust);

   /* Purge neighbor lists. */
   for (i = 0; i < n_atoms; ++i)
      nl_tail[i] = NULL;

   /* Loop over central atoms. */
   for (i = 0; i < n_atoms; ++i) {

      /* Get attributes of atom i. */
      for (k = 0; k < NDIM; ++k)
         s_i[k] = atom_coords[i][k];

      i_mol = atom_mol[i];
      i_rel = atom_rel[i];
      i_species = mol_species[i_mol];

      /* Get cell index. */
      ic = atom_cells[i].cell;


      for (i_off = 0; i_off < noffsets; ++i_off) {

         /* If i_off == 0, start with the atom that follows atom i in the
            home cell list. Otherwise, start with the first atom in the
            neighboring cell. */
         if (i_off == 0)
            j = atom_cells[i].next;
         else {

         /* Compute index of neighboring cell and get index of the
            first atom in that cell. */
         jc = ic + offsets[i_off];
         j = first[jc];
       }
         /* Loop over atoms in neighboring cell. */
         while (j != -1) {

            /* Determine whether entry should be added to neighbor list. */
            j_real = atom_cells[j].real;
            j_mol = atom_mol[j_real];
            j_rel = atom_rel[j_real];
            j_species = mol_species[j_mol];
            inter_flag = i_mol != j_mol;
            if (i_species == 0 && j_species == 0 && i != j_real) {

               /* Calculate pair separation. */

               for (k = 0; k < NDIM; ++k)
                 sep[k] = atom_coords[j][k] - s_i[k];

                r2_sep = SQR(sep[0]) + SQR(sep[1]) + SQR(sep[2]);

               /* If the pair separation is less than r_nl, add entries
                  to neighbor lists. */

               if (r2_sep < rrClust) {
                   if (nl_tail[i] == NULL){
                     p = nl_head[i];
                  } else {
                     p = nl_tail[i] -> next;
                     if (p == NULL) {
                           p = gmalloc(sizeof(nl_entry));
                        p -> next = NULL;
                       nl_tail[i] -> next = p ;
                     }
                  }
                  p -> atom = j_real;
                  nl_tail[i] = p;

/*                  printf(" bonded atoms i %d i_off %d ic %d j_real %d\n", i, i_off,
                         ic, j_real); */ 
                  AddBondedPair (i, j_real, inClust, clustSize, clustHead, 
                           clustNext, nClust);
               }
            }
            j = atom_cells[j].next;
         }
      }
   }
printf(" Total in cluster %d\n", *nClust);
}

/* Put the atom in cluster and claculates the cluster size distribution */
int AddBondedPair(int j1, int j2, int *inClust, int *clustSize, int *clustHead,
               int *clustNext, int *nClust) 
{
    int cBig, cSmall, m, mp, nc, nc1, nc2;
/* printf(" I am in bonded pair nClust %d i %d j \n", *nClust, j1, j2); */

    if (inClust[j1] == 0) {
      if (inClust[j2] == 0) {
        *nClust = *nClust + 1;
        inClust[j1] = *nClust;    inClust[j2] = *nClust;
        clustSize[*nClust] = 2;    clustHead[*nClust] = j1;
        clustNext[j1] = j2;    clustNext[j2] = 0;
      } else {
        nc = inClust[j2];
        clustSize[nc] = clustSize[nc] + 1;
        inClust[j1] = nc;
        clustNext[j1] = clustHead[nc];    clustHead[nc] = j1;
      }
    } else {
      if (inClust[j2] == 0) {
        nc = inClust[j1];
        clustSize[nc] = clustSize[nc] + 1;
        inClust[j2] = nc;
        clustNext[j2] = clustHead[nc];    clustHead[nc] = j2;
      } else {
        nc1 = inClust[j1];    nc2 = inClust[j2];
        if (nc1 != nc2) {
          if (clustSize[nc1] <= clustSize[nc2]) cBig = nc2;
          else cBig = nc1;
          cSmall = nc1 + nc2 - cBig;
          m = clustHead[cSmall];
          while (m > 0) {
            inClust[m] = cBig;    mp = m;
            m = clustNext[m];
          }
          clustNext[mp] = clustHead[cBig];
          clustHead[cBig] = clustHead[cSmall];
          clustSize[cBig] = clustSize[cBig] +
             clustSize[cSmall];
          clustSize[cSmall] = 0;
       } } }
/*  printf(" total cluster nClust %d\n", *nClust); */
  }

/* Initialize the cluster before the cluster counting */

void InitClusters (int *inClust, int *hist, int n_atoms, int *mol_species, 
                int *atom_mol) 
  {
    int k, n, i_mol, i_species;
    int chainP=0;

    for (n = 0; n < n_atoms; n ++) {
    inClust[n]=-100000;
      i_mol = atom_mol[n];
      i_species = mol_species[i_mol];
    if(i_species == 0) {
    inClust[n] = 0;
    chainP=chainP+1;
     } 
     hist[n] = 0;
    }
    printf("chainP %d \n",chainP);
  }

void CompressClusters (int *inClust, int *clustSize, int *clustHead, 
                    int *clustNext, int *nClustt) 
{
    int j, m, nc;
    nc = 0;
    printf(" I am in Compress nClust %d\n", *nClustt);
    printf(" I am in Compress nClust %d\n", *nClustt);

    for (j = 1; j <= *nClustt; j ++) {
    printf(" I am in Compress nClust %d\n", *nClustt);
      if (clustSize[j] > 0) {
        nc = nc + 1;
        clustSize[nc] = clustSize[j];
        clustHead[nc] = clustHead[j];
        m = clustHead[nc];
        while (m > 0) {
          inClust[m] = nc;    m = clustNext[m];
    } } }
    *nClustt = nc;
  }


/* Calculates the histogram of the cluster size distribution */

void AnalClusterSize (int *clustSize, int *hist, int n_atoms, int *nClust) {

    int cBig, nc, ncUse, bigSize, nSingle;
    double sSum, ssSum; 

    ncUse = 0;    cBig = 1;
    sSum = ssSum = 0.;

    for (nc = 1; nc <= *nClust; nc ++) {
      if (clustSize[nc] > clustSize[cBig]) cBig = nc;
      if (clustSize[nc] > 1) {
        ncUse = ncUse + 1;
        sSum = sSum + clustSize[nc];
        ssSum = ssSum + SQR (clustSize[nc]);
        hist[clustSize[nc]] = hist[clustSize[nc]]+1;
    } }
    bigSize = clustSize[cBig];
    nSingle = n_atoms - sSum;
    printf("sSum %lf ncUse %d nClust %d\n", sSum, ncUse, *nClust);
    if (ncUse > 0) {
      sSum = sSum / ncUse;
      ssSum = sqrt (ssSum / ncUse - SQR (sSum));
    }
   for (nc = 1; nc <= n_atoms; nc ++)
/*   if(hist[nc] > 0) printf("%d %d\n",clustSize[nc],hist[clustSize[nc]]); */
   if(hist[nc] > 0) printf("%d %d\n",nc,hist[nc]);
  }
