#define MAIN
#include "build.h"
#undef MAIN
#include "ff.h"
#include "proto.h"

main(int argc, char *argv[])
{
  int ans, i_mol, skip, i_atom, abs;
  double diff_x, diff_y, diff_z, xx, yy, zz, pe_vdw_s_single,
      pe_vdw_s_p;
  nl_entry *p, *p_term;

  double pe_vdw_s_tot;
  int i_rel, j_rel, j_species;
  int i, j, k, i_atoms, i_species, i_phant, n_species, n_species_chk, 
      n_unit_cells, n_mols, n_atoms;
  int period_switch, vdw_switch, vdw_rad_switch, *excl_switch, init_switch,
      phant_switch, neigh_switch, opt_switch, press_switch, one_four_switch,
      nb_switch, con_switch, sim_switch, temp_switch;
  /* Random generator */
  long i_ran, seed, idum;
  /* Array of geometrical molecular lengths. */
  double **mol_range, mol_max_length, xmax;
  /* Declare parameters used to build the initial state and box matrices*/
  int n_layers=1;
  double rho, aspect_xy, aspect_xz, layer_spacing;
  double **h, **h_inv, r_off, r_on, r2_on, r2_off, r_nl, r2_nl;
  int kc;
  /* Declare and initialize force field parameters. */
  int n_mass = 0, n_lj = 0, n_e6 = 0, n_pot = 0, n_type = 0,
      n_bend = 0;
  mass_entry *mass = NULL;
  bend_entry *bend = NULL;
  lj_entry *lj = NULL;
  e6_entry *e6 = NULL;
  pot_entry *pot = NULL;
  type_entry *atm_type = NULL;

  /* File names */
  char par_file[F_MAX], *mass_file, *lj_file, *e6_file, *pot_file,
       *bend_file, 
      **struct_file, *header_file, *config_file, *header_file_save, 
      *config_file_save, *thermo_file, *trajec_file;

  FILE *f_thermo, *f_trajec;

  /* Declare and initialize molecular structure parameters. */
  int *n_atoms_per_mol = NULL, *n_mols_per_species = NULL,
      *n_bonds_per_mol = NULL, *n_angles_per_mol, **temp_atm_lab, **temp_atm_nbr,
      ***temp_atm_br, **temp_atm_type_i;
  double ***temp_atm_pos, **temp_atm_mass, **temp_atm_chg,
      **temp_atm_sigma, **temp_atm_eps, ***temp_atm_ord;
  char ***temp_atm_type;
  int **temp_bonds_1 = NULL, **temp_bonds_2 = NULL;
  double **temp_bonds_ord = NULL;
  int *n_mols_per_unit_cell, *mol_species;

  /* Declare some arrays used in set up force field */
  double *mol_mass, *mol_mass_true;
  int *mol_first_atm;
  int n_free_atom, n_free_mol, level, n_levels, ke_flag=1, eval_flag=1;
  double beta, hot_beta, delta_beta, sqrt_hot_T_over_T, temp_scale,
         temp_time, system_mass_true, system_mass, ps_to_intern,
         intern_to_ps, **comp_forces, delta, at_temp, ke, 
         pe, te, pressure_scale, compress;

  /* Declare combination and exclusion arrays */
  int ***exclusions, **comb_pot;
  double ***comb_par;
  /* Declare arrays used in build */
  double **scaled_atom_coords, **mol_coords, **scaled_mol_coords,
      **atom_coords, **rel_atom_coords, **atom_vels, *atom_mass, 
      *sqrt_kT_over_m, *one_over_2m, **mol_vels;
  int *atom_rel, *atom_mol, *atom_type, *hot_atom;
  int hot_flag;

  /* Scan list arrays. */
  int **scan_atm_1, **scan_atm_2;

  /* Array of the chosen principal molecular axe. */
  int *principal;

  /* Variable used in the computation of the potential. */
  double gamma, three_gamma_over_two, two_over_gamma_cubed,
      pe_vdw_s, pe_vdw_s_check, pe_stretch, pe_bend;

  /* Variable for force and stress tensor calculation */
  double **f_vdw_s , **vdw_s_single ,  **at_stress_vdw_s ,
  **at_stress_vdw_single ,  **mol_stress_vdw_s ,
  **mol_stress_vdw_single, **f_stretch, **at_stress_stretch,
  **mol_stress_stretch, **at_stress, **mol_stress, **at_stress_kin,
  **mol_stress_kin, **mol_stress_vdw, **f_bend, **at_stress_bend;

  /* Thermodynamics parameters. */
  double temp, press, at_press, mol_press, reduce_boltz, volume, temperature, boltzmann,
         hot_temp, press_time, r_equil , spring, at_press_vdw_s,
         at_press_kin, mol_press_vdw_s, mol_press_kin, spring_bend, cos_theta_equil;

  /* Molecular Dynamics parameters. */
  int i_cycle, n_cycles,
  reshape_axis, n_opt, n_thermo, n_trajec;
  double dr_max, dr_max_old, ratio_dang_dr, ratio_dang_dr_old, 
      ds_mol_max[NDIM], dang_mol_max, 
  dh_max, **old, **s_old, **rel_old, **mol_old, skin;

 /* varibales for constant pressure MD */
  int scale_con; 
  double press_scale; 
  int  **scale;
  

  /* Optimization parameters. */
  double opt_time, efficiency, **ds_opt;
  /* Graphic parameters */
  int n_graph;
    double radius_sph, radius_cyl;
  int graph_switch, resph, antialias_switch, species_choice, keep_going,
    *comb_col;
  char *color_file;

  /* OpenGL/X variables declaration. */
  Display *dpy;
  Window win;
  GLboolean doubleBuffer = GL_TRUE;
  GLUquadricObj *qobj;

  /* Analysis variables. */
  double norm;
  int nrot, n_reshape;
  double reshape_accept, mol_accept;

  /* Block accumulators. */
  int n_block, n_blocks, i_block, n_mol_moves_tot, n_mol_accept_tot, 
      n_reshape_moves_tot, n_reshape_accept_tot, n_reshape_moves_opt, 
      n_reshape_accept_opt;

  double mol_accept_rate, reshape_accept_opt, **h_block, *vol_block,
   *rho_block, ***mol_stress_block, ***at_stress_block, *at_press_block, 
  *mol_press_block,  *pe_vdw_s_block,
  *pe_stretch_block, *pe_bend_block,
  *n_mol_moves_block, *n_mol_accept_block,
      *n_reshape_moves_block, *n_reshape_accept_block, *h_ave,
      *h_unc, vol_ave, vol_unc, rho_ave, rho_unc, 
      dummy, **mol_stress_ave, **mol_stress_unc, **at_stress_ave, 
      **at_stress_unc, 
  at_press_ave, at_press_unc, mol_press_ave, mol_press_unc, 
  pe_vdw_s_ave, pe_vdw_s_unc, pe_stretch_ave, pe_stretch_unc, pe_bend_ave, pe_bend_unc;

  /* Constants. */

  double radians_to_degrees;

  /* Declare cell arrays. */

  atom_cell *atom_cells = NULL;
  phantom_cell *phantoms = NULL;
  int phantom_skip[7], nc[NDIM], nc_p[NDIM], nc_p_total, *first = NULL, 
  *last = NULL, *offsets, *offsets_total, noffsets;
  int *offsets_x, *offsets_y, *offsets_z;

  /* Neighbor list. */ 
  nl_entry **nl_head, **nl_tail; 
  double **atom_move;
  angle_prop **angle_props;

  /* Get command line input. */
  if (argc != 2) {
    printf("Usage: %s params_file\n", argv[0]);
    exit(1);
  }
  strcpy(par_file, argv[1]);

  /* Read in input parameter file. */
  read_simu_params(par_file, &header_file, &config_file, &header_file_save,
      &config_file_save, &thermo_file, &trajec_file, 
      &mass_file, &pot_file, &bend_file, &vdw_rad_switch, 
      &n_species_chk, &excl_switch, &r_on, &r_off, 
      &neigh_switch, &phant_switch, &kc, &r_nl, &n_cycles, &n_reshape, 
      &reshape_axis, &opt_switch, &dr_max, &ratio_dang_dr, &dh_max, 
      &press_switch, &scale_con, &press_time, &scale, &temp, &press, 
      &n_opt, &n_thermo, &n_block, 
      &n_trajec, &seed, &delta, &temp_time, &spring, &r_equil, 
      &graph_switch, &n_graph, &color_file, &species_choice,
      &radius_sph, &radius_cyl, &resph, &antialias_switch);

  printf("header_file = %s, config_file = %s\n",header_file,
      config_file);
  printf("header_file_save = %s, config_file_save = %s\n",
      header_file_save,config_file_save);
  printf("thermo_file = %s, trajec_file = %s\n",
      thermo_file,trajec_file);
  printf("mass_file = %s\n",mass_file);
  printf("pot_file = %s\n",pot_file);
  printf("bend_file = %s\n",bend_file);
  printf("vdw_rad_switch = %d\n", vdw_rad_switch);
  printf("n_species (from params file) = %d\n", n_species_chk);
  for (i_species = 0; i_species < n_species_chk; ++i_species)
     printf("i_specie = %d, excl_switch = %d\n", i_species,
          excl_switch[i_species]);

  printf("r_on = %g, r_off = %g\n",r_on, r_off);
  printf("neigh_switch = %d, phant_switch = %d\n", neigh_switch,
      phant_switch);
  printf("kc = %d, r_nl = %g\n",kc, r_nl);

  printf("n_cycles = %d, n_reshape = %d, reshape_axis = %d\n",
      n_cycles, n_reshape, reshape_axis);

  printf("opt_switch = %d\n", opt_switch);

  printf("dr_max = %g, ratio_dang_dr = %g, dh_max = %g\n",
      dr_max, ratio_dang_dr, dh_max);

  printf("press_switch = %d, scale_con =%d, press_time =%g\n", press_switch,
          scale_con, press_time);
  for ( i = 0; i < 3; ++i)
     for (j = i; j < 3; ++j)
     printf("scale[%d][%d] = %d\n", i, j, scale[i][j]);

  printf("temp = %g, press = %g\n",temp, press);
  printf("n_opt = %d, n_thermo = %d, n_block = %d, n_trajec = %d\n", 
           n_opt, n_thermo, n_block, n_trajec);
  printf("seed = %ld\n",seed);
  printf("delta = %lf, temp_time %lf , spring = %lf, r_equil= %lf\n",delta, temp_time, spring,
   r_equil);
  printf("graph_switch = %d, n_graph = %d\n", graph_switch, n_graph);
  printf("color_file = %s\n", color_file);
  printf("species_choice = %d\n", species_choice);
  printf("radius_sph = %g, radius_cyl = %g\n", radius_sph, radius_cyl);
  printf("resph = %d, antialias_switch = %d\n", resph, antialias_switch);


  /* Define additional variables. */
  if (n_cycles % n_block != 0) 
    error_exit("n_cycles must be a multiple of n_block!\n");
  n_blocks = n_cycles / n_block;
  noffsets = CUBE(2 * kc + 1);
  boltzmann = 1.0;

  /* Initialize random number generator. */
  i_ran = -seed;
  ran3(&i_ran);

  /* Read information about template molecules and atoms from header file */
  read_header_direct(header_file, &period_switch, &n_species,
      &n_atoms_per_mol,  &temp_atm_lab, &temp_atm_type, &temp_atm_nbr,
      &temp_atm_br, &temp_atm_ord,  &temp_atm_pos, &temp_atm_chg,
      &temp_atm_sigma, &temp_atm_eps,  &n_bonds_per_mol, &temp_bonds_1,
      &temp_bonds_2, &temp_bonds_ord,  &n_mols_per_species, &n_mols,
      &n_atoms, &mol_species);

  /* Read atomic position and velocities from config file */
  read_config_direct(config_file, period_switch, &h, n_atoms, &atom_coords,  
     &atom_vels);

  /* Check exclusion switch array. */
  if (n_species_chk != n_species) {
     printf("n_species_chk = %d, n_species = %d\n", n_species_chk, n_species);
     error_exit("Problem in the number of species.\n");
  }
 
  /* If the number of exclusion sites is greater than the number of atoms
     present in the template molecule, set the exclusion switch to -1, i.e.
     remove all intramolecular interactions. */ 
  for (i_species = 0; i_species < n_species; ++i_species)
    if (excl_switch[i_species] >= n_atoms_per_mol[i_species])
      excl_switch[i_species] = -1;
 
  /* Read FF masses file. */
  read_mass_params(mass_file, &mass, &n_mass);
  read_bend_params(bend_file, &bend, &n_bend);

  /* Set up force field data for masses. */
  set_up_force_field(n_species, n_mols, n_atoms_per_mol, n_mass,
      mass, mol_species, n_bonds_per_mol, &temp_atm_mass, temp_atm_type,
      &mol_mass, &mol_mass_true, &mol_first_atm, &n_angles_per_mol, 
      temp_atm_nbr, temp_atm_br, &angle_props, n_bend, bend);

  /* Convert string tags to integer identifiers. */
  /* Create an integer identifier corresponding to template atom type. */ 
  convert_type(n_species, n_atoms_per_mol, temp_atm_type, &temp_atm_type_i, 
     &atm_type, &n_type);

  /* Read and Set up force field data for potential interactions. */
  read_set_up_pot(pot_file, vdw_switch, vdw_rad_switch, atm_type, n_type, 
     &comb_pot, &comb_par);

  /* Adjust cutoffs (r_off and r_on) according to the potential interaction 
  form present. */
  adjust_cutoff(n_type, comb_pot, comb_par, &r_on, &r_off); 

  /* Set up scan list. */
  set_up_scan_list(n_species, n_atoms_per_mol, temp_atm_nbr, temp_atm_br,  
     &scan_atm_1, &scan_atm_2);

  /* Allocate memory for arrays used in the builder. */
  allocate_memory_simu(n_atoms, n_mols, n_species, n_blocks,
      period_switch,  &scaled_atom_coords, &atom_rel, &atom_mol,
      &atom_mass, &atom_type, &sqrt_kT_over_m, &one_over_2m, 
      &mol_coords, &scaled_mol_coords, 
      &rel_atom_coords, &h_inv, &atom_cells, &offsets, &offsets_total, 
      noffsets, &nl_head, &nl_tail, &atom_move,
      n_atoms_per_mol, &exclusions, &old, &s_old, &rel_old, &mol_old,
      &ds_opt, &h_block, &h_ave, &h_unc,
      &mol_stress_block, &mol_stress_ave, &mol_stress_unc,
      &at_stress_block, &at_stress_ave, &at_stress_unc,
      &at_press_block, &mol_press_block, &vol_block, &rho_block, &pe_vdw_s_block, 
      &pe_stretch_block, &pe_bend_block, &n_mol_moves_block,
      &n_mol_accept_block, &n_reshape_moves_block, &n_reshape_accept_block,
      &offsets_x, &offsets_y, &offsets_z, &f_vdw_s, &vdw_s_single,
      &at_stress_vdw_s, &at_stress_vdw_single, &mol_stress_vdw_s,
      &mol_stress_vdw_single, &mol_range, &atom_vels,
      &mol_vels, &f_stretch, &at_stress_stretch,&mol_stress_stretch,
      &comp_forces, &at_stress, &mol_stress, &at_stress_kin,
      &mol_stress_kin, &mol_stress_vdw, &f_bend, &at_stress_bend);


  /* Set up array of relative atom indices */
  relative_atoms(n_mols, mol_species, mol_first_atm, n_atoms_per_mol,
      temp_atm_mass, temp_atm_type_i, atom_rel, atom_mol, atom_mass, atom_type,
      sqrt_kT_over_m, one_over_2m, boltzmann, temp);

  /* Set up the nonbonded exclusion array */
  exclusion_array(n_species, n_atoms_per_mol, excl_switch, temp_atm_nbr,  
    temp_atm_br, &exclusions);
 
  /* Compute geometrical molecular lengths. */
  geom_molecules(n_species, n_atoms_per_mol, temp_atm_pos, mol_range, 
    &mol_max_length);

  /* Calculate box aspect ratio. */
  aspect_xy = h[1][1] / h[0][0];
  aspect_xz = h[2][2] / h[0][0];

  /* Calculate quantities that depend on box dimensions and exit
     if system is too small. */
  box_dimensions(h, h_inv, period_switch, r_off, mol_max_length);

  if (period_switch) {
    scaled_atomic_coords(n_atoms, h_inv, atom_coords,
        scaled_atom_coords);
    periodic_boundary_conditions(n_atoms, h, scaled_atom_coords,
        atom_coords);
  }

  /* Compute center of mass of the molecules and relative atom positions 
  within the molecules. */
  center_of_mass_positions(period_switch, n_mols, n_species,
      n_atoms_per_mol,  mol_species, atom_mass, mol_first_atm,
      atom_coords, scaled_atom_coords,  scan_atm_1, scan_atm_2,
      mol_mass, h, h_inv, mol_coords, scaled_mol_coords,  rel_atom_coords);

/* Define all the constants used in the simulation */

  /* If we are using periodic boundary conditions, and that we are using
   cell (or neighbor) list, set up atom index offsets for updating phantom 
   atoms. */

  r2_nl = r_nl * r_nl;
  r2_on = r_on * r_on;
  r2_off = r_off * r_off;

  if ((period_switch) && (neigh_switch != 0))
  {
    for (i_phant = 0; i_phant < 7; ++i_phant)
      phantom_skip[i_phant] = (i_phant + 1) *
          n_atoms;

    /* Initialize number of phantom cells. */
    nc_p[0] = nc_p[1] = nc_p[2] = 0;
    nc_p_total = 0;

   /* Calculate the number of atomic and molecular degrees of freedom. */
      n_free_atom = 3 *n_atoms;
      n_free_mol = 3 * n_mols;

   /* Define Boltzmann's constant (in (kcal/mole)/K) and other constants. */
   beta = 1.0 / (boltzmann * temp);
   delta_beta = hot_beta - beta;

    /* Calculate constants used in Berendsen thermostat and manostat routines. */
   compress = 1.0; 
   temp_scale = delta/ (2.0 * temp_time);
   press_scale = compress*delta/(3.0 * press_time);

    /* Calculate total mass of system. */
   system_mass_true = 0.0;
   system_mass = 0.0;
   for (i_species = 0; i_species < n_species; ++i_species) {
      system_mass_true += n_mols_per_species[i_species]
         * mol_mass_true[i_species];
      system_mass += n_mols_per_species[i_species]
         * mol_mass[i_species];
   }


/* End of constants definition */
   
    if ( phant_switch == 1) {
      /* Set up cell list with phantom cells. */
      set_up_cells_phantom(h, nc, nc_p, &nc_p_total,
          atom_cells,  kc,  period_switch, r_nl, r_off,
          neigh_switch, &first, &last, offsets,  n_atoms,
          scaled_atom_coords, atom_coords, &phantoms,
          phantom_skip);

      /* Compute coordinates of phantom atoms. */
      update_phantoms(n_atoms, atom_cells, phantom_skip,
          phantoms, atom_coords);
    } else
      if ( phant_switch == 0){
	/* Set up cell list without phantom cells. */
	set_up_cells_nophantom(h, nc, nc_p, &nc_p_total, atom_cells, kc, 
            period_switch, r_nl, r_off, neigh_switch, &first,
	    &last, offsets_x, offsets_y, offsets_z,
	    n_atoms, scaled_atom_coords, atom_coords);
      }
    if (neigh_switch == 2) {
       if (phant_switch == 0)
          error_exit("Neighbor lists work only with phantom cells\n"); 

       neighbor_lists_period(mol_species, atom_rel, atom_mol,  n_atoms,
          n_atoms_per_mol, exclusions, h, r2_on,  r2_off, scaled_atom_coords, 
          period_switch, first, last, phantoms, noffsets, nc_p, kc,
          phantom_skip, nc, atom_cells, offsets, atom_coords, atom_move,
          nl_head, nl_tail, r2_nl);
        }
  }

   sample_velocities(&i_ran, atom_vels, n_atoms, sqrt_kT_over_m);

  /* Compute the potential energy of the initial state. */
  gamma = 0.0;
  three_gamma_over_two = 0.0;
  two_over_gamma_cubed = 0.0;
  if (r2_on < r2_off) {
    gamma = r2_off - r2_on;
    three_gamma_over_two = 1.5 * gamma;
    two_over_gamma_cubed = 2.0 / CUBE(gamma);
    }

/* Calulcate volume of the simulation box */

  volume = h[0][0] * h[1][1] * h[2][2];
     /* Zero force accumulators. */
   for (i = 0; i < n_atoms; ++i) {
       for (k = 0; k < NDIM; ++k)
      comp_forces[i][k] = 0.0;
   }

         wca_period_phantom(mol_species, atom_rel, atom_mol, atom_type, n_atoms,
          n_atoms_per_mol, exclusions, comb_pot, comb_par,
          r2_on, r2_off, h, scaled_atom_coords, gamma, three_gamma_over_two,
          two_over_gamma_cubed, &pe_vdw_s, period_switch,
          first, last, phantoms, noffsets, nc_p, kc,
          phantom_skip, nc, atom_cells, offsets, atom_coords,
          rel_atom_coords, at_stress_vdw_s, mol_stress_vdw_s,
          f_vdw_s);

      /* Add short-range  nonbonded forces to force accumulators. */
      for (i = 0; i < n_atoms; ++i) {
         for ( k = 0; k < NDIM; ++k)
         comp_forces[i][k] += f_vdw_s[i][k];
      }

   /* calculate bond stretching interactions and add contributions to force
      accumulators. */

      /* Calculate bond stretching interactions. */
       stretch(period_switch, eval_flag, 
             f_stretch, mol_first_atm, n_bonds_per_mol,at_stress_stretch,
             &pe_stretch, spring, r_equil, n_atoms, n_mols, mol_species,
             temp_bonds_1, temp_bonds_2, h,
             scaled_atom_coords);

      /* Add bond stretching forces to force accumulators. */
      for (i = 0; i < n_atoms; ++i) {
         for ( k = 0; k < NDIM; ++k)
         comp_forces[i][k] += f_stretch[i][k];
       }
    
   /* calculate bond angle bending interactions and add contributions to force
      accumulators. */

    bend_cos_harmonic(period_switch, eval_flag,
             f_bend, mol_first_atm, n_angles_per_mol,
             at_stress_bend, &pe_bend,
             n_atoms, n_mols, mol_species,
             angle_props, h, scaled_atom_coords);
    
    /* Add bond angle bending  forces to force accumulators. */
      for (i = 0; i < n_atoms; ++i) {
         for ( k = 0; k < NDIM; ++k)
         comp_forces[i][k] += f_bend[i][k];
      }

/*  evaluate_forces(mol_species,
   atom_rel, atom_mol, atom_type, n_atoms, n_atoms_per_mol, exclusions,
   comb_pot, comb_par, r2_on, r2_off, h, scaled_atom_coords, gamma,
   three_gamma_over_two, two_over_gamma_cubed,
   &pe_vdw_s, period_switch, first, last,
   phantoms, noffsets, nc, nc_p, kc, phantom_skip,
   atom_cells, offsets, atom_coords,
   rel_atom_coords, at_stress_vdw_s,
   mol_stress_vdw_s, f_vdw_s, comp_forces,
   &pe_stretch, f_stretch, spring, r_equil, neigh_switch, vdw_switch,nl_head, nl_tail,
   r2_nl, atom_move, mol_first_atm, n_bonds_per_mol,
   mol_stress_stretch, eval_flag, n_mols, temp_bonds_1, temp_bonds_2);

*/
printf(" pe_vdw_s %g and pe_stretch %g pe_bend %lf\n", pe_vdw_s,pe_stretch, pe_bend);
printf(" f_vdw_s %g f_stretch %g f_bend %g\n", f_vdw_s[0][0], f_stretch[0][0],
         f_bend[0][0]);

/*  for (i = 0; i < n_atoms; ++i) {
  printf("bend_forces x  %lf y %lf z %lf \n",f_bend[i][0], 
                   f_bend[i][1], f_bend[i][2]);
  }
*/

  /* Initialize graphics. */
#ifdef GRAPHICS
 if (graph_switch > 0) {
  /* Read and set up color id for each atom type. */
  read_set_up_color(color_file, atm_type, n_type, &comb_col);

  /* Initialize graphics. */
  initialize(&dpy, &win, doubleBuffer, &qobj, graph_switch, antialias_switch,
             h);

  /* Plot initial configuration. Hit Escape to exit the loop.*/
  printf("\nEsc to start the MC simulation.\n");
  XBell(dpy, 100);
  keep_going = 0;
  do {
      redraw(dpy, win, doubleBuffer, qobj, graph_switch, n_mols, mol_species,
             mol_first_atm, n_atoms_per_mol, n_bonds_per_mol,
             mol_coords, rel_atom_coords, h, temp_bonds_1, temp_bonds_2,
             species_choice, atom_type, comb_col, resph, radius_sph,
             radius_cyl, &keep_going);

     } while(!keep_going);
 }
#endif


/* Evaluate the initail stress tensors */

   stress_tensors(ke_flag, at_stress_kin, mol_stress_kin,
                  atom_mass, atom_vels, mol_vels,
                  n_atoms, n_mols, mol_species, h,
                  mol_stress, at_stress, at_stress_vdw_s,
                  mol_stress_vdw, n_free_atom, n_free_mol,
                  boltzmann, temperature, at_stress_stretch,
                  mol_stress_vdw_s, mol_mass, at_stress_bend);


  /* Open output files. */
  if ((f_thermo = fopen(thermo_file, "w")) == NULL)
    error_exit("Cannot open sim.thermo\n");
  if ((f_trajec = fopen(trajec_file, "w")) == NULL)
    error_exit("Cannot open sim.thermo\n");

  /* Compute beta = 1 / kT (k = 1). */
  reduce_boltz = 1.0 / temp;

  /* Write header of the trajectory file. */
  fwrite(&n_atoms, sizeof(int), 1, f_trajec);
  fwrite(&n_cycles, sizeof(int), 1, f_trajec);
  fwrite(&n_trajec, sizeof(int), 1, f_trajec);

  /* Compute various instantaneous quantities. */

  /* Write instantaneous quantities to thermodynamics file. */
  i_cycle = 0;
  fprintf(f_thermo,"%d ", i_cycle);
  for (i = 0; i < 3; ++i)
    fprintf(f_thermo, "%g ", h[i][i]);


  /* Write stress tensor. */
  at_press = at_press_vdw_s = at_press_kin = 0.0;
  for (i = 0; i < 3; ++i) {
    for (j = i; j < 3; ++j)
      fprintf(f_thermo, "%g ", at_stress[i][j]);
    at_press += at_stress[i][i];
    at_press_vdw_s += at_stress_vdw_s[i][i];
    at_press_kin += at_stress_kin[i][i];
  }


  mol_press = mol_press_vdw_s = mol_press_kin = 0.0;
  for (i = 0; i < 3; ++i) {
    for (j = i; j < 3; ++j)
      fprintf(f_thermo, "%g ", mol_stress[i][j]);
    mol_press += mol_stress[i][i];
    mol_press_vdw_s += mol_stress_vdw_s[i][i];
    mol_press_kin += mol_stress_kin[i][i];
  }

  rho = n_mols / volume;
  /* Compute and write hydrostatic pressure. */
  at_press = at_press / 3.0;
  mol_press = at_press / 3.0;
  fprintf(f_thermo, "%g ", at_press);
  fprintf(f_thermo, "%g ", mol_press);

  fprintf(f_thermo, "%g ", volume);
  fprintf(f_thermo, "%g ", rho); 


  /* Write potential energy. */
  fprintf(f_thermo, "%g %g\n", pe_vdw_s, pe_stretch, pe_bend);

  /* Define constant */
  radians_to_degrees = 180.0 / PI;


printf(" Entering the MD loop\n");
  /* Molecular Dynamics loop */
  for (i_cycle = 1; i_cycle <= n_cycles; ++i_cycle) {

   md_loop(mol_species, n_mols, atom_rel, atom_mol,
   atom_type, n_atoms, n_atoms_per_mol, exclusions,
   comb_pot, comb_par, r2_on, r2_off, r_off,  h, scaled_atom_coords, gamma,
   three_gamma_over_two, two_over_gamma_cubed,
   &pe_vdw_s, period_switch, &first, &last,
   &phantoms, noffsets, nc, nc_p, &nc_p_total, kc, phantom_skip,
   atom_cells, offsets, atom_coords,
   rel_atom_coords, at_stress_vdw_s,
   mol_stress_vdw_s, f_vdw_s, comp_forces,
   atom_vels, delta, &i_ran, sqrt_kT_over_m, 
   atom_mass, atom_move, h_inv, neigh_switch,temp_switch, mol_vels, mol_mass,
   mol_first_atm, n_free_atom, boltzmann,
   temp, &at_temp, temp_scale, n_free_mol, ke_flag, &pe_stretch, f_stretch, 
   spring,r_equil, vdw_switch,nl_head, nl_tail,
   r2_nl, r_nl, n_bonds_per_mol,
   at_stress_stretch, eval_flag, temp_bonds_1, temp_bonds_2, &ke, &pe, &te,
   mol_stress_kin, at_stress_kin, mol_stress, at_stress,
   mol_stress_vdw, 
   angle_props, &pe_bend, f_bend, at_stress_bend, n_angles_per_mol,
   press_switch, scale_con, press, press_scale, scale, phant_switch, mol_coords,
   scaled_mol_coords, scan_atm_1, scan_atm_2, n_species);


#ifdef GRAPHICS
    if (graph_switch > 0 && i_cycle % n_graph == 0)
      redraw(dpy, win, doubleBuffer, qobj, graph_switch, n_mols, mol_species,
             mol_first_atm, n_atoms_per_mol, n_bonds_per_mol,
             mol_coords, rel_atom_coords, h, temp_bonds_1, temp_bonds_2,
             species_choice, atom_type, comb_col, resph, radius_sph,
             radius_cyl, &keep_going);
#endif


if (i_cycle % n_thermo== 0)
 printf(" temp %g  ke %g pe %g te %g i_cycle %d\n", at_temp, ke/n_atoms, pe/n_atoms, 
       te/n_atoms, i_cycle); 
fflush(NULL);
    /* Calculate instantaneous thermodynamic and structural quantities. */
    /* Calculate forces and stress tensor. */
    /* Check potential energy. */
/* exit(1); */

    /* Compute hydrostatic pressure. */
     /* Write stress tensor. */
  at_press = 0.0;
  for (i = 0; i < 3; ++i) {
    at_press += at_stress[i][i];
    at_press_vdw_s += at_stress_vdw_s[i][i];
    at_press_kin += at_stress_kin[i][i];
  }

  mol_press = 0.0;
  for (i = 0; i < 3; ++i) {
    mol_press += mol_stress[i][i];
    mol_press_vdw_s += mol_stress_vdw_s[i][i];
    mol_press_kin += mol_stress_kin[i][i];
  }

    volume = h[0][0] * h[1][1] * h[2][2];
    rho = n_mols / volume;
    at_press = at_press / 3.0;
    mol_press = mol_press / 3.0;


    /* Write instantaneous quantities to thermodynamics file every 
       n_thermo MC cycles. */
    if (i_cycle % n_thermo == 0) {
      fprintf(f_thermo, "%d ", i_cycle);
      for (i = 0; i < 3; ++i)
	fprintf(f_thermo, "%g ", h[i][i]);
      for (i = 0; i < 3; ++i)
         for (j = i; j < 3; ++j)
           fprintf(f_thermo, "%g ", at_stress[i][j]); 
      for (i = 0; i < 3; ++i)
         for (j = i; j < 3; ++j)
           fprintf(f_thermo, "%g ", mol_stress[i][j]);

      fprintf(f_thermo, "%g ", at_press); 
      fprintf(f_thermo, "%g ", mol_press); 
      fprintf(f_thermo, "%g ", volume); 
      fprintf(f_thermo, "%g ", rho); 

      /* Write potential energy. */
      fprintf(f_thermo, "%g %g %g\n", pe_vdw_s, pe_stretch, pe_bend);
    }

    /* Write instantaneous configuration to trajectory file every 
         n_trajec MC cycles. */
    if (i_cycle % n_trajec == 0){
      write_positions_direct(f_trajec, h, n_atoms,
          atom_coords); 
    /* Save current configuration. */
    write_header_direct(header_file_save, period_switch, n_species,
      n_atoms_per_mol, temp_atm_lab, temp_atm_type, temp_atm_nbr,
      temp_atm_br,  temp_atm_ord, temp_atm_pos, temp_atm_chg,
      temp_atm_sigma, temp_atm_eps,  n_bonds_per_mol, temp_bonds_1,
      temp_bonds_2, temp_bonds_ord,  n_mols_per_species, n_mols,
      mol_species);

    write_config_direct(config_file_save, period_switch, h,
      n_atoms,  dr_max, ratio_dang_dr, dh_max, skin, atom_coords,
      atom_vels, i_cycle);
    }
    /* Calculate block index. */
    i_block = (i_cycle - 1) / n_block;

    /* Add contributions to block accumulators. */
    for (i = 0; i < 3; ++i)
      h_block[i][i_block] += h[i][i];
    for (i = 0; i < 3; ++i)
       for (j = i; j < 3; ++j){
          at_stress_block[i][j][i_block] += at_stress[i][j];
          mol_stress_block[i][j][i_block] += mol_stress[i][j];
       }

    at_press_block[i_block] += at_press;
    mol_press_block[i_block] += mol_press;

    vol_block[i_block] += volume;
    rho_block[i_block] += rho;

    pe_vdw_s_block[i_block] += pe_vdw_s;
    pe_stretch_block[i_block] += pe_stretch;
    pe_bend_block[i_block] += pe_bend;

    /* Compute and print block averages every n_block MC cycles. */
    if (i_cycle % n_block == 0) {

      /* Calculate block averages. */
      norm = 1.0 / n_block;
      for (i = 0; i < 3; ++i)
	h_block[i][i_block] *= norm;
      for (i = 0; i < 3; ++i)
	for (j = i; j < 3; ++j){
	  at_stress_block[i][j][i_block] *= norm;
	  mol_stress_block[i][j][i_block] *= norm;
        }
      at_press_block[i_block] *= norm;
      mol_press_block[i_block] *= norm;

      vol_block[i_block] *= norm;
      rho_block[i_block] *= norm;

      pe_vdw_s_block[i_block] *= norm;
      pe_stretch_block[i_block] *= norm;
      pe_bend_block[i_block] *= norm;

      /* Print block averages to standard output. */
      printf("\nBlock averages for block %d, MC cycles %d - %d\n",
          i_block, i_block * n_block + 1, (i_block + 1) * n_block);
      for (i = 0; i < 3; ++i)
	printf("   h[%d][%d] = %g\n", i, i, h_block[i][i_block]);
      for (i = 0; i < 3; ++i)
         for (j = i; j < 3; ++j)
            printf("   at_stress[%d][%d] = %g\n", i, j, 
                                       at_stress_block[i][j][i_block]);
      for (i = 0; i < 3; ++i)
         for (j = i; j < 3; ++j)
            printf("   mol_stress[%d][%d] = %g\n", i, j, 
                                       mol_stress_block[i][j][i_block]);

      printf("   at_press = %g\n", at_press_block[i_block]);
      printf("   mol_press = %g\n", mol_press_block[i_block]);

      printf("   volume = %g\n", vol_block[i_block]);
      printf("   rho = %g\n", rho_block[i_block]);
      printf("   pe_vdw_s = %g\n", pe_vdw_s_block[i_block]);
      printf("   pe_stretch = %g\n", pe_stretch_block[i_block]);
      printf("   pe_bend = %g\n", pe_bend_block[i_block]);
      fflush(NULL);
    }
  } /* end of MD loop. */

  /* Close output files. */
  fclose(f_thermo);
  fclose(f_trajec);

  /* Save final configuration. */
  write_header_direct(header_file_save, period_switch, n_species,
      n_atoms_per_mol, temp_atm_lab, temp_atm_type, temp_atm_nbr,
      temp_atm_br,  temp_atm_ord, temp_atm_pos, temp_atm_chg,
      temp_atm_sigma, temp_atm_eps,  n_bonds_per_mol, temp_bonds_1,
      temp_bonds_2, temp_bonds_ord,  n_mols_per_species, n_mols,
      mol_species);

  write_config_direct(config_file_save, period_switch, h,
      n_atoms,  dr_max, ratio_dang_dr, dh_max, skin, atom_coords,
      atom_vels, i_cycle);

  /* Calculate run averages and uncertainties. */
  for (i = 0; i < 3; ++i)
    statistics(n_blocks, h_block[i], &h_ave[i], &h_unc[i]);
  for (i = 0; i < 3; ++i)
    for (j = 0; j < 3; ++j)
      statistics(n_blocks, at_stress_block[i][j],
          &at_stress_ave[i][j], &at_stress_unc[i][j]);
  for (i = 0; i < 3; ++i)
    for (j = 0; j < 3; ++j)
      statistics(n_blocks, mol_stress_block[i][j],
          &mol_stress_ave[i][j], &mol_stress_unc[i][j]);

  statistics(n_blocks, at_press_block, &at_press_ave, &at_press_unc);
  statistics(n_blocks, mol_press_block, &mol_press_ave, &mol_press_unc);
  statistics(n_blocks, vol_block, &vol_ave, &vol_unc);
  statistics(n_blocks, rho_block, &rho_ave, &rho_unc);
  statistics(n_blocks, pe_vdw_s_block, &pe_vdw_s_ave, &pe_vdw_s_unc);
  statistics(n_blocks, pe_stretch_block, &pe_stretch_ave, &pe_stretch_unc);
  statistics(n_blocks, pe_bend_block, &pe_bend_ave, &pe_bend_unc);

  /* Print run averages and uncertainties to standard output. */
  printf("\nRun averages\n");
  for (i = 0; i < 3; ++i)
    printf("   h[%d][%d] = %g +/- %g\n", i, i, h_ave[i], h_unc[i]);
  for (i = 0; i < 3; ++i)
     for (j = i; j < 3; ++j)
        printf("  at_stress[%d][%d] = %g +/- %g\n", i, j, at_stress_ave[i][j],
           at_stress_unc[i][j]);

  for (i = 0; i < 3; ++i)
     for (j = i; j < 3; ++j)
        printf("  mol_stress[%d][%d] = %g +/- %g\n", i, j, mol_stress_ave[i][j],
           mol_stress_unc[i][j]);

  printf("   at_press = %g +/- %g\n", at_press_ave, at_press_unc); 
  printf("   mol_press = %g +/- %g\n", mol_press_ave, mol_press_unc); 

  printf("   volume = %g +/- %g\n", vol_ave, vol_unc); 
  printf("   rho = %g +/- %g\n", rho_ave, rho_unc); 
  printf("   pe_vdw_s = %g +/- %g\n", pe_vdw_s_ave, pe_vdw_s_unc);
  printf("   pe_stretch = %g +/- %g\n", pe_stretch_ave, pe_stretch_unc);
  printf("   pe_bend = %g +/- %g\n", pe_bend_ave, pe_bend_unc);

  fflush(NULL);

  exit(0);

}  /* end of main. */

/****************************************************************************/
/* Allocate memory for static arrays */
void allocate_memory_simu(int n_atoms, int n_mols, int n_species,
int n_blocks, 
int period_switch, double ***scaled_atom_coords, int **atom_rel,
int **atom_mol, double **atom_mass, int **atom_type, 
double **sqrt_kT_over_m, double **one_over_2m, double ***mol_coords, 
double ***scaled_mol_coords, double ***rel_atom_coords, 
double ***h_inv, atom_cell **atom_cells, int **offsets, 
int **offsets_total, int noffsets, nl_entry ***nl_head,
nl_entry ***nl_tail, double ***atom_move, int *n_atoms_per_mol, 
int ****exclusions, 
double ***old, double ***s_old, double ***rel_old, double ***mol_old,
double ***ds_opt, 
double ***h_block, double **h_ave, double **h_unc,
double ****mol_stress_block, double ***mol_stress_ave, 
double ***mol_stress_unc, double ****at_stress_block, double ***at_stress_ave,
double ***at_stress_unc,
double **at_press_block, double **mol_press_block, double **vol_block,
double **rho_block, double **pe_vdw_s_block, 
double **pe_stretch_block, double **pe_bend_block, double **n_mol_moves_block, 
double **n_mol_accept_block, double **n_reshape_moves_block, 
double **n_reshape_accept_block,
int **offsets_x, int **offsets_y, int **offsets_z,
double ***f_vdw_s, double ***vdw_s_single, double ***at_stress_vdw_s,
double ***at_stress_vdw_single, double ***mol_stress_vdw_s,
double ***mol_stress_vdw_single, double ***mol_range, double ***atom_vels,
double ***mol_vels, double ***f_stretch, double ***at_stress_stretch, 
double ***mol_stress_stretch, double ***comp_forces,
double ***at_stress, double ***mol_stress, double ***at_stress_kin,
double ***mol_stress_kin, double ***mol_stress_vdw, double ***f_bend,
double ***at_stress_bend)
{
  int i, i_rel, i_species, n_atoms_max;

  /* Allocate memory for arrays of atomic properties. */
  if (period_switch)
    *scaled_atom_coords = allocate_2d_array(n_atoms,
        3, sizeof(double));
  *rel_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for arrays of atomic properties. */
  *atom_rel = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mol = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mass = allocate_1d_array(n_atoms, sizeof(double));
  *atom_type = allocate_1d_array(n_atoms, sizeof(int));
  *sqrt_kT_over_m = allocate_1d_array(n_atoms, sizeof(double));
  *one_over_2m = allocate_1d_array(n_atoms, sizeof(double));

  /* Allocate memory for arrays of molecular properties. */
  *mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));
  *mol_old = allocate_2d_array(n_mols, 3, sizeof(double));
  if (period_switch)
    *scaled_mol_coords = allocate_2d_array(n_mols, 3,
        sizeof(double));

  /* Allocate memory for the box matrices */
  /* For now, orthorombic box */
  *h_inv = allocate_2d_array(3, 3, sizeof(double));

  /* Allocate memory for atomic cell lists. */
  if (period_switch) {
    *atom_cells = allocate_1d_array(8 * n_atoms, sizeof(atom_cell));
    *offsets = allocate_1d_array(noffsets, sizeof(int));
    *offsets_total = allocate_1d_array(noffsets, sizeof(int));
  }
  
  /* Allocate memory for neighbor lists. */
  *nl_head = gcalloc(n_atoms, sizeof(nl_entry*));
  for (i = 0; i < n_atoms; ++i) {
    (*nl_head)[i] = gmalloc(sizeof(nl_entry));
    (*nl_head)[i] -> next = NULL;
    }
  *nl_tail = gcalloc(n_atoms, sizeof(nl_entry*));
  *atom_move = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for exclusion array. */
  *exclusions = allocate_1d_array(n_species, sizeof(int**));
  for (i_species = 0; i_species < n_species; ++i_species) {
    (*exclusions)[i_species] = allocate_1d_array(n_atoms_per_mol[i_species],
        sizeof(int*));
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species];
        ++i_rel) {
      (*exclusions)[i_species][i_rel] = allocate_1d_array(n_atoms_per_mol[i_species],
          sizeof(int));
    }
  }
  n_atoms_max = 0;
  for (i_species = 0; i_species < n_species; ++i_species)
    n_atoms_max = MAX(n_atoms_max, n_atoms_per_mol[i_species]);
  *old = allocate_2d_array(n_atoms_max, 3, sizeof(double));
  *s_old = allocate_2d_array(n_atoms_max, 3, sizeof(double));
  *rel_old = allocate_2d_array(n_atoms_max, 3, sizeof(double));

  /* Allocate memory for optimization array. */
  *ds_opt = allocate_2d_array(n_mols, 3, sizeof(double));

  /* Block accumulators */
  *h_block = allocate_2d_array(3, n_blocks, sizeof(double));
  *mol_stress_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *at_stress_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
  *at_press_block = allocate_1d_array(n_blocks, sizeof(double));
  *mol_press_block = allocate_1d_array(n_blocks, sizeof(double));
  *vol_block = allocate_1d_array(n_blocks, sizeof(double));
  *rho_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_vdw_s_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_stretch_block = allocate_1d_array(n_blocks, sizeof(double));
  *pe_bend_block = allocate_1d_array(n_blocks, sizeof(double));
  *n_mol_moves_block = allocate_1d_array(n_blocks, sizeof(double));
  *n_mol_accept_block = allocate_1d_array(n_blocks, sizeof(double));
  *n_reshape_moves_block = allocate_1d_array(n_blocks, sizeof(double));
  *n_reshape_accept_block = allocate_1d_array(n_blocks, sizeof(double));

  /* Average accumulators. */
  *h_ave = allocate_1d_array(3, sizeof(double));
  *h_unc = allocate_1d_array(3, sizeof(double));
  *mol_stress_ave = allocate_2d_array(3, 3, sizeof(double));
  *mol_stress_unc = allocate_2d_array(3, 3, sizeof(double));

  /* Array of offsets for nophantom case */

  *offsets_x =allocate_1d_array(noffsets, sizeof(int));
  *offsets_y =allocate_1d_array(noffsets, sizeof(int));
  *offsets_z =allocate_1d_array(noffsets, sizeof(int));

  /* Memory for force and stress tensor */

  *f_vdw_s = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *comp_forces = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *f_stretch = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *f_bend = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *vdw_s_single = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *at_stress_vdw_s = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress_kin = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_vdw_s = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_vdw = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_kin = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_stretch = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress_stretch = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress_bend = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *at_stress_vdw_single = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_vdw_single = allocate_2d_array(NDIM, NDIM, sizeof(double));

  /* Memory for geometrical molecular lengths. */
  
  *mol_range = allocate_2d_array(n_species, NDIM, sizeof(double));
  *atom_vels = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *mol_vels = allocate_2d_array(n_atoms, NDIM, sizeof(double));

}

/****************************************************************************/
/* Set up array of relative atom indices. */
void relative_atoms(int n_mols, int *mol_species, int *mol_first_atm,
   int *n_atoms_per_mol, double **temp_atm_mass, int **temp_atm_type_i,
   int *atom_rel, int *atom_mol, double *atom_mass, int *atom_type, 
   double *sqrt_kT_over_m, double *one_over_2m, double boltzmann, 
   double temp)
{
  int i_species, skip, i, i_mol, i_rel;

  /* Set up array of atomic properties. */
  for (i_mol = 0; i_mol < n_mols; ++i_mol) {
    i_species = mol_species[i_mol];
    skip = mol_first_atm[i_mol];
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
      i = skip + i_rel;
      atom_rel[i] = i_rel;
      atom_mol[i] = i_mol;
      atom_mass[i] = temp_atm_mass[i_species][i_rel];
      atom_type[i] = temp_atm_type_i[i_species][i_rel];
      sqrt_kT_over_m[i] = sqrt(boltzmann * temp / atom_mass[i]);
      one_over_2m[i] = 1.0 / (2.0 * atom_mass[i]);
    }
  }

}
