#include "build.h"
#include "ff.h"



void select_pot(int id_0, int id_1, int pot_form, char **token, int n_tokens,
     int vdw_rad_switch, int comb_flag, double ***comb_par) 
{
   double sigma, sigma2, r_min2, epsilon, four_epsilon;
   double ALPHA_COS, BETA_COS, cos_eps;

   /* Set up combination array for non-bonded interactions. */
   switch (pot_form) {

     /*******************************************************************/
     /*******************    0 = LJ potential    ************************/
     /*******************************************************************/
     case 0 :
       if (!comb_flag) {    /* Explicit entry in pot_file. */
         
         /* Check number of parameters. */
         if (n_tokens != 5)
           error_exit("Wrong number of parameters in LJ potential\n");

         /* Convert tokens. */
         sigma = atof(token[3]);
         epsilon = atof(token[4]);  
         }
       else {               /* No explicit entry in pot_file. */

         /* Use combination rules to assign parameters. */
         if (vdw_rad_switch == 0) {
            sigma = sqrt(comb_par[id_0][id_0][0] * comb_par[id_1][id_1][0]);
            }
         else {
            sigma = 0.5 * (comb_par[id_0][id_0][0] + comb_par[id_1][id_1][0]);
            }
         epsilon = sqrt(comb_par[id_0][id_0][1] * comb_par[id_1][id_1][1]);
       } 

       /* Compute additional parameters. */
       sigma2 = SQR(sigma);
       four_epsilon = 4.0 * epsilon;

       /* Assign parameters to comb_par array. */
       comb_par[id_0][id_1][0] = comb_par[id_1][id_0][0] = sigma;
       comb_par[id_0][id_1][1] = comb_par[id_1][id_0][1] = epsilon;
       comb_par[id_0][id_1][2] = comb_par[id_1][id_0][2] = sigma2;
       comb_par[id_0][id_1][3] = comb_par[id_1][id_0][3] = four_epsilon;

       /* Print parameters to the standard output. */
       printf("types = %d, %d : pot_form = %d (LJ)\n", id_0, id_1, pot_form);
       printf("   sigma = %g, epsilon = %g, sigma2 = %g, four_epsilon = %g\n", sigma, epsilon, sigma2, four_epsilon); 
       printf("\n");

       break;

     /*******************************************************************/
     /*******************    1 = WCA potential    ***********************/
     /*******************************************************************/
     case 1 :
       if (!comb_flag) {    /* Explicit entry in pot_file. */
         
         /* Check number of parameters. */
         if (n_tokens != 5)
           error_exit("Wrong number of parameters in WCA potential\n");

         /* Convert tokens. */
         sigma = atof(token[3]);
         epsilon = atof(token[4]);  
         }
       else {               /* No explicit entry in pot_file. */

         /* Use combination rules to assign parameters. */
         if (vdw_rad_switch == 0) {
            sigma = sqrt(comb_par[id_0][id_0][0] * comb_par[id_1][id_1][0]);
            }
         else {
            sigma = 0.5 * (comb_par[id_0][id_0][0] + comb_par[id_1][id_1][0]);
            }
         epsilon = sqrt(comb_par[id_0][id_0][1] * comb_par[id_1][id_1][1]);
       } 

       /* Compute additional parameters. */
       sigma2 = SQR(sigma);
       four_epsilon = 4.0 * epsilon;
       r_min2 = pow(2.0, 1.0 / 3.0) * sigma2;

       /* Assign parameters to comb_par array. */
       comb_par[id_0][id_1][0] = comb_par[id_1][id_0][0] = sigma;
       comb_par[id_0][id_1][1] = comb_par[id_1][id_0][1] = epsilon;
       comb_par[id_0][id_1][2] = comb_par[id_1][id_0][2] = sigma2;
       comb_par[id_0][id_1][3] = comb_par[id_1][id_0][3] = four_epsilon;
       comb_par[id_0][id_1][4] = comb_par[id_1][id_0][4] = r_min2;

       /* Print parameters to the standard output. */
       printf("types = %d, %d : pot_form = %d (WCA)\n", id_0, id_1, pot_form);
       printf("   sigma = %g, epsilon = %g, sigma2 = %g, four_epsilon = %g, r_min2 = %g\n", sigma, epsilon, sigma2, four_epsilon, r_min2); 
       printf("\n");

       break;

     /*******************************************************************/
     /*******************    2 = LJ + Cosine potential    ************************/
     /*******************************************************************/
     case 2 :
       if (!comb_flag) {    /* Explicit entry in pot_file. */
         
         /* Check number of parameters. */
         if (n_tokens != 8)
           error_exit("Wrong number of parameters in LJ potential\n");

         /* Convert tokens. */
         sigma = atof(token[3]);
         epsilon = atof(token[4]);  
         ALPHA_COS = atof(token[5]);  
         BETA_COS = atof(token[6]);  
         cos_eps = atof(token[7]);  

         }
       else {               /* No explicit entry in pot_file. */

         /* Use combination rules to assign parameters. */
         if (vdw_rad_switch == 0) {
            sigma = sqrt(comb_par[id_0][id_0][0] * comb_par[id_1][id_1][0]);
            }
         else {
            sigma = 0.5 * (comb_par[id_0][id_0][0] + comb_par[id_1][id_1][0]);
            }
         epsilon = sqrt(comb_par[id_0][id_0][1] * comb_par[id_1][id_1][1]);
       } 

       /* Compute additional parameters. */
       sigma2 = SQR(sigma);
       four_epsilon = 4.0 * epsilon;
       r_min2 = pow(2.0, 1.0 / 3.0) * sigma2;

       /* Assign parameters to comb_par array. */
       comb_par[id_0][id_1][0] = comb_par[id_1][id_0][0] = sigma;
       comb_par[id_0][id_1][1] = comb_par[id_1][id_0][1] = epsilon;
       comb_par[id_0][id_1][2] = comb_par[id_1][id_0][2] = sigma2;
       comb_par[id_0][id_1][3] = comb_par[id_1][id_0][3] = four_epsilon;
       comb_par[id_0][id_1][4] = comb_par[id_1][id_0][4] = ALPHA_COS;
       comb_par[id_0][id_1][5] = comb_par[id_1][id_0][5] = BETA_COS;
       comb_par[id_0][id_1][6] = comb_par[id_1][id_0][6] = cos_eps;
       comb_par[id_0][id_1][7] = comb_par[id_1][id_0][7] = r_min2;

       /* Print parameters to the standard output. */
       printf("types = %d, %d : pot_form = %d (LJ)\n", id_0, id_1, pot_form);
       printf("   sigma = %g, epsilon = %g, sigma2 = %g, four_epsilon = %g\n", sigma, epsilon, sigma2, four_epsilon); 
       printf("   alpha = %g, beta = %g, cos_eps %g\n", ALPHA_COS, BETA_COS, cos_eps); 
       printf("\n");

       break;
     /*******************************************************************/
     /*****************    default = undefined potential    *************/
     /*******************************************************************/
     default :
       printf("pot_form = %d\n", pot_form);
       error_exit("Potential form undefined in select_pot.\n"); 

       break;
   }
}

/*****************************************************************************/
