/* Periodic boundary condition nonbonded force routines for molecular
   modeling package, with LJ form for vdW interactions. */

#include "build.h"

/* Calculate short-range LJ interactions using a N^2 search, and using a
   switching function to truncate the pair potential and pair force smoothly. */

void lj_s_period_phantom(int *mol_species, int *atom_rel, int *atom_mol, 
   int n_atoms, 
   int *n_atoms_per_mol, int ***exclusions, double ****comb_sigma2, 
   double ****comb_four_eps, double **h, double r2_on, double r2_off, 
   double **scaled_atom_coords, double gamma, double three_gamma_over_two,
   double two_over_gamma_cubed, double *pe_vdw_s, 
   int period_switch, int *first, int *last, phantom_cell *phantoms, 
   int noffsets, int *nc_p, int kc, int *phantom_skip, int *nc,
   atom_cell *atom_cells, int *offsets, 
   double **atom_coords, double **rel_atom_coords, 
   double **at_stress_vdw_s, double **mol_stress_vdw_s, double **f_vdw_s)
{
   int i, j, k, i_species, j_species, i_mol, j_mol, i_rel, j_rel, inter_flag;
   double s_sep[NDIM], sep[NDIM], r2_sep, one_over_r2_sep,
      rho_2, rho_6, rho_12, four_epsilon, u_vdw, 
      sw1, sw2, sw3, sw4, s_i[NDIM], l_range[NDIM], shift[NDIM];
   int in_plane, icxy, icx, icy, icz, jcx, jcy, jcz, jc, i_off;
   int ic, j_real;
   double p_norm, volume, rel_dist[NDIM], f_i_vdw[NDIM], fvdw, f_vdw[NDIM];

   /* Initialisation. */
   *pe_vdw_s = 0.0;

   /* Zero short-range vdW forces. */
   for (i = 0; i < n_atoms; ++i)
      for (k = 0; k < NDIM; ++k)
         f_vdw_s[i][k] = 0.0;

   for (i = 0; i < NDIM; ++i)
      for (k = 0; k < NDIM; ++k)
         mol_stress_vdw_s[i][k] = 0.0;
   
/*   update_cells( period_switch,  n_atoms, h,
                  scaled_atom_coords, atom_coords, atom_cells, first, last,
                  phantoms,  kc, phantom_skip, nc, nc_p);

   update_phantoms( n_atoms, atom_cells, phantom_skip, phantoms, atom_coords);
*/
   /* Loop over atoms. */
   for (i = 0; i < n_atoms ; ++i) {

      /* Get attributes of atom i. */

      for (k = 0; k < NDIM; ++k){
        s_i[k] = atom_coords[i][k];
/*        f_i_vdw[k] = f_vdw_s[i][k];  */
        f_i_vdw[k] = 0.0;  
       }
      
      i_mol = atom_mol[i];
      i_rel = atom_rel[i];
      i_species = mol_species[i_mol];

      /* Get cell index. */
      ic = atom_cells[i].cell;

      for (i_off = 0; i_off < noffsets; ++i_off) {

         /* Compute index of neighboring cell and get index of the
            first atom in that cell. */
         jc = ic + offsets[i_off];
         j = first[jc];

         /* Loop over atoms in neighboring cell. */
         while (j != -1) {

         /* Get attributes of atom j. */
         j_real = atom_cells[j].real;
         j_mol = atom_mol[j_real];
         j_rel = atom_rel[j_real];
     
         /* Determine whether interaction should be computed. */
         inter_flag = i_mol != j_mol;
         if (inter_flag || exclusions[i_species][i_rel][j_rel]) {

               /* Calculate scaled pair separation. */
               for (k = 0; k < NDIM; ++k)
                 sep[k] = atom_coords[j][k] - s_i[k];

               r2_sep = SQR(sep[0]) + SQR(sep[1]) + SQR(sep[2]);

               /* If the pair separation is less than r_off, calculate
                  vdW interaction. */
               if (r2_sep < r2_off) {
                  
	          /* Calculate pair interaction. The vdW pair potential
                     is switched off smoothly between r_on and r_off. */
                  j_species = mol_species[j_mol];
                  one_over_r2_sep = 1.0 / r2_sep;
                  rho_2 = comb_sigma2[i_species][i_rel][j_species][j_rel] 
                          * one_over_r2_sep;
                  rho_6 = CUBE(rho_2);
                  rho_12 = SQR(rho_6);
                  u_vdw = rho_12 - rho_6;   
       /*           u_vdw = rho_12 - 0.001716378;   */
                  fvdw = rho_12 + u_vdw;
                  four_epsilon = 
                            comb_four_eps[i_species][i_rel][j_species][j_rel];
                  u_vdw *= four_epsilon;
                  fvdw *= 6.0 * one_over_r2_sep * four_epsilon;
                  if (r2_sep > r2_on) {
                     sw1 = r2_off - r2_sep;
                     sw2 = two_over_gamma_cubed * sw1;
                     sw3 = sw1 * sw2 * (three_gamma_over_two - sw1);
                     sw4 = 6.0 * sw2 * (gamma - sw1);
                     fvdw = sw4 * u_vdw + sw3 * fvdw;
                     u_vdw *= sw3;
                     }
                  /* Add contributions to force. */
                  for ( k = 0; k < NDIM; ++k){
                    f_vdw[k] = sep[k] * fvdw;
                    f_i_vdw[k] -= f_vdw[k];
             /*     f_vdw_s[j_real][k] +=f_vdw[k]; */
                  }
                  /* Add contributions to potential energy and atomic and
                     molecular pressure tensors. */
                     *pe_vdw_s += u_vdw;

                     mol_stress_vdw_s[0][0] += sep[0] * f_vdw[0];
                     mol_stress_vdw_s[1][1] += sep[1] * f_vdw[1];
                     mol_stress_vdw_s[2][2] += sep[2] * f_vdw[2];
                     mol_stress_vdw_s[0][1] += sep[0] * f_vdw[1];
                     mol_stress_vdw_s[0][2] += sep[0] * f_vdw[2];
                     mol_stress_vdw_s[1][2] += sep[1] * f_vdw[2];
                     /* Add contribution coming from the intramolecular 
                        rigidity constraint */
                    for ( k =0; k<NDIM; ++k)
                      rel_dist[k] = (rel_atom_coords[j_real][k] - 
                                                 rel_atom_coords[i][k]);

                    mol_stress_vdw_s[0][0] -= rel_dist[0] * f_vdw[0];
                    mol_stress_vdw_s[1][1] -= rel_dist[1] * f_vdw[1];
                    mol_stress_vdw_s[2][2] -= rel_dist[2] * f_vdw[2];
                    mol_stress_vdw_s[0][1] -= rel_dist[0] * f_vdw[1];
                    mol_stress_vdw_s[0][2] -= rel_dist[0] * f_vdw[2];
                    mol_stress_vdw_s[1][2] -= rel_dist[1] * f_vdw[2];
                  }
               }
            j = atom_cells[j].next;
            }
	}
      for ( k = 0; k < NDIM; ++k)
       f_vdw_s[i][k] = f_i_vdw[k];
   }
/* The contributions to the potential and to the stress tensor are half
   the previous quantities (we have computed i on j and j on i). */

   *pe_vdw_s /= 2.0;
    
   for (i = 0; i < NDIM; ++i)
     for (j = i; j < NDIM; ++j)
       mol_stress_vdw_s[i][j] /= 2.0;
/* 
 for (i = 0; i < n_atoms; ++i)
    printf("i_p = %d : %g %g %g\n", i, f_vdw_s[i][0], f_vdw_s[i][1], f_vdw_s[i][2]);
*/
}
/****************************************************************************/
/* Calculate short-range LJ interactions between the molecule i_mol and all the
others, using a N^2 search, and using a switching function to truncate the pair
potential and pair force smoothly. */

void lj_s_period_single_phantom(int skip, int mol, int *mol_species, 
   int *atom_rel, 
   int *atom_mol, int n_atoms, int *n_atoms_per_mol, int ***exclusions, 
   double ****comb_sigma2, double ****comb_four_eps, double **h, double r2_on, 
   double r2_off, double **scaled_atom_coords, double gamma, 
   double three_gamma_over_two, double two_over_gamma_cubed, 
   double *pe_vdw_s_single,
   int period_switch, int *first, int *last, phantom_cell *phantoms, 
   int noffsets, int *nc_p, int kc, int *phantom_skip, int *nc,
   atom_cell *atom_cells, int *offsets, 
   double **atom_coords, int *mol_first_atm)
{
   int i, j, k, i_species, j_species, i_mol, j_mol, i_rel, j_rel, inter_flag;
   double s_sep[NDIM], sep[NDIM], r2_sep, one_over_r2_sep,
      rho_2, rho_6, rho_12, four_epsilon, u_vdw, 
      sw1, sw2, sw3, sw4, s_i[NDIM], l_range[NDIM], shift[NDIM];
   int in_plane, icxy, icx, icy, icz, jcx, jcy, jcz, jc, i_off;
   int ic, j_real;

   /* Initialisation. */
   *pe_vdw_s_single = 0.0;

/*
   update_cells_single( mol, period_switch,  n_atoms, h,
                  scaled_atom_coords, atom_coords, atom_cells, first, last,
                  phantoms,  kc, phantom_skip, nc, nc_p,
                  n_atoms_per_mol, mol_species, mol_first_atm);

   update_phantoms_single( mol, n_atoms, atom_cells, phantom_skip, phantoms,
                  atom_coords, mol_first_atm, mol_species, n_atoms_per_mol);

*/
   i_species = mol_species[mol];
   /* Loop over atoms in the molecule i_mol. */
   for (i = skip; i < skip + n_atoms_per_mol[i_species] ; ++i) {

      /* Get attributes of atom i. */
      for (k = 0; k < NDIM; ++k)
        s_i[k] = atom_coords[i][k];
      i_mol = atom_mol[i];
      i_rel = atom_rel[i];

     /* Get cell index. */
      ic = atom_cells[i].cell;

      for (i_off = 0; i_off < noffsets; ++i_off) {

            /* Compute index of neighboring cell and get index of the
               first atom in that cell. */
            jc = ic + offsets[i_off];
            j = first[jc];

       /* Loop over atoms in neighboring cell. */
         while (j != -1) {

         /* Get attributes of atom j. */
         j_real = atom_cells[j].real;
         j_mol = atom_mol[j_real];
         j_rel = atom_rel[j_real];

         /* Determine whether interaction should be computed. */
         inter_flag = i_mol != j_mol;
         if (inter_flag || exclusions[i_species][i_rel][j_rel]) {

               /* Calculate scaled pair separation. */
               for (k = 0; k < NDIM; ++k)
                 sep[k] = atom_coords[j][k] - s_i[k];
                 
               r2_sep = SQR(sep[0]) + SQR(sep[1]) + SQR(sep[2]);

               /* If the pair separation is less than r_off, calculate
                  vdW interaction. */
               if (r2_sep < r2_off) {

                  /* Calculate pair interaction. The vdW pair potential
                     is switched off smoothly between r_on and r_off. */
                  j_species = mol_species[j_mol];
                  one_over_r2_sep = 1.0 / r2_sep;
                  rho_2 = comb_sigma2[i_species][i_rel][j_species][j_rel] 
                          * one_over_r2_sep;
                  rho_6 = CUBE(rho_2);
                  rho_12 = SQR(rho_6);
                  u_vdw = rho_12 - rho_6;  
    /*             u_vdw = rho_12 - 0.001716378;   */
                  four_epsilon = 
                            comb_four_eps[i_species][i_rel][j_species][j_rel];
                  u_vdw *= four_epsilon;
                  if (r2_sep > r2_on) {
                     sw1 = r2_off - r2_sep;
                     sw2 = two_over_gamma_cubed * sw1;
                     sw3 = sw1 * sw2 * (three_gamma_over_two - sw1);
                     sw4 = 6.0 * sw2 * (gamma - sw1);
                     u_vdw *= sw3;
                  }
                  /* Add contributions to potential energy and atomic and
                     molecular pressure tensors. */
                     *pe_vdw_s_single += u_vdw;
                  }
               }
              j = atom_cells[j].next;
            }
          }
	}
}
/****************************************************************************/
