/* Shared utilities for molecular modeling package. */

#include "build.h"

/* Error-handling routine. */
void error_exit(char *error_msg)
{
   puts(error_msg);
   exit(1);
}

/* Graceful fopen routine. */
FILE *gfopen(const char *file_name, const char *type)
{
   FILE *ptr;

   if ((ptr = fopen(file_name, type)) == NULL) {
      fprintf(stderr, "Cannot open %s in gfopen\n", file_name);
      exit(1);
   }

   return ptr;
}

