/* Top-level force routines for molecular modeling package */

#include "build.h"
#include "ff.h"
#include "proto.h"


/* Calculate and sum selected components of force. */
void evaluate_forces(int *mol_species, int *atom_rel, int *atom_mol,
   int *atom_type, int n_atoms, int *n_atoms_per_mol, int ***exclusions,
   int **comb_pot, double ***comb_par, double r2_on, double r2_off,
   double **h, double **scaled_atom_coords, double gamma,
   double three_gamma_over_two, double two_over_gamma_cubed,
   double *pe_vdw_s, int period_switch, int *first, int *last,
   phantom_cell *phantoms, int noffsets, int *nc, int *nc_p, 
   int kc, int *phantom_skip,
   atom_cell *atom_cells, int *offsets, double **atom_coords,
   double **rel_atom_coords, double **at_stress_vdw_s,
   double **mol_stress_vdw_s, double **f_vdw_s, double **comp_forces, 
   double *pe_stretch, double **f_stretch, double spring, double r_equil, 
   int neigh_switch, int vdw_switch,nl_entry **nl_head, nl_entry **nl_tail,
   double r2_nl,
   double **atom_move, int *mol_first_atm, int *n_bonds_per_mol, 
   double **mol_stress_stretch, int eval_flag, int n_mols, 
   int **temp_bonds_1, int **temp_bonds_2)
{
   int i, k;
   double pe_vdw_s_non, pe_stretch_bon;

printf(" I am in sum_force n_atoms %d \n", n_atoms);
   /* Zero force accumulators. */
   for (i = 0; i < n_atoms; ++i) {
       for (k = 0; k < NDIM; ++k)
      comp_forces[i][k] = 0.0;
   }

printf(" I am in sum_force\n");
fflush(NULL);

   /* calculate short- range nonbonded interactions and add
      contributions to force accumulators. */

      /* Calculate nonbonded interactions. */
               if (neigh_switch == 1) {
          wca_period_phantom(mol_species, atom_rel, atom_mol, atom_type, n_atoms,
          n_atoms_per_mol, exclusions, comb_pot, comb_par,
          r2_on, r2_off, h, scaled_atom_coords, gamma, three_gamma_over_two,
          two_over_gamma_cubed, &pe_vdw_s_non, period_switch,
          first, last, phantoms, noffsets, nc_p, kc,
          phantom_skip, nc, atom_cells, offsets, atom_coords,
          rel_atom_coords, at_stress_vdw_s, mol_stress_vdw_s,
          f_vdw_s);
               } 
/*               else {
               if (neigh_switch == 2)
               lj_s_nl_period_phantom( mol_species, atom_rel, atom_mol, n_atoms,
       n_atoms_per_mol, exclusions, comb_sigma2, comb_four_eps, h, r2_on,
       r2_off, scaled_atom_coords, gamma, three_gamma_over_two,
       two_over_gamma_cubed, &pe_vdw_s, period_switch, first, last, phantoms,
       noffsets, nc_p, kc, phantom_skip, nc, atom_cells, offsets, atom_coords,
       nl_head, nl_tail, r2_nl, rel_atom_coords, at_stress_vdw_s,
       mol_stress_vdw_s, f_vdw_s, atom_move);

          zero_move(n_atoms, atom_move);
               }
*/

printf(" I am in sum_force, pe_vdw_s %g pe_stretch %g\n", pe_vdw_s_non, pe_stretch );
printf(" I am in sum_force, f_vdw_s %g \n", f_vdw_s[0][0]);
fflush(NULL);

       *pe_vdw_s = pe_vdw_s_non;

      /* Add short-range  nonbonded forces to force accumulators. */
      for (i = 0; i < n_atoms; ++i) {
         for ( k = 0; k < NDIM; ++k)
         comp_forces[i][k] += f_vdw_s[i][k];
      }

   /* calculate bond stretching interactions and add contributions to force
      accumulators. */

      /* Calculate bond stretching interactions. */
       stretch(period_switch, eval_flag, 
             f_stretch, mol_first_atm, n_bonds_per_mol,mol_stress_stretch,
             &pe_stretch_bon, spring, r_equil, n_atoms, n_mols, mol_species,
             temp_bonds_1, temp_bonds_2, h,
             scaled_atom_coords);

      /* Add bond stretching forces to force accumulators. */
      for (i = 0; i < n_atoms; ++i) {
         for ( k = 0; k < NDIM; ++k)
         comp_forces[i][k] += f_stretch[i][k];
      }
     *pe_stretch = pe_stretch_bon;

printf(" I am in sum_force, pe_vdw_s %g pe_stretch %g\n", *pe_vdw_s, *pe_stretch );
printf(" I am in sum_force, f_stretch %g \n", f_stretch[0][0]);
}

/* Calculate total forces and thermodynamic quantities. */
/*
void sum_forces(int ke_flag, int n_mols, double **mol_vels, double **atom_vels,
                double atom_mass, double mol_mass, int *mol_first_atom, 
                int *n_atoms_per_mol, int n_free_atom, int n_free_mol, 
                double boltzmann, double temperature)
{
   int level, i;

   eval_flag = 1;
   trajec_counter = 0;

   evaluate_forces(mol_species, atom_rel, atom_mol,
   atom_type, n_atoms, n_atoms_per_mol, exclusions,
   comb_pot, comb_par, r2_on, r2_off, h, scaled_atom_coords, gamma,
   three_gamma_over_two, two_over_gamma_cubed,
   &pe_vdw_s, period_switch, first, last,
   phantoms, noffsets, nc_p, kc, phantom_skip,
   nc, atom_cells, offsets, atom_coords,
   rel_atom_coords, at_stress_vdw_s,
   mol_stress_vdw_s, f_vdw_s, comp_forces);        

   for (i = 0; i < n_atoms; ++i) {
      for ( k = 0; k < NDIM; ++k)
      total_forces[i][k] = f_vdw_s[i][k]+ f_stretch[i][k];
   }
   thermodynamics(ke_flag, n_mols, mol_vels, atom_vels, atom_mass, mol_mass,
                  mol_first_atm, n_atoms_per_mol,
                  n_free_atom, n_free_mol, boltzmann, temperature);
}
*/
