/* Spatial correlation function routines. */

#include "shared.h"
#include "process.h"

/* Calculate center of mass pair correlation functions. */
void spatial_correlation(int n_r, int n_r_par, int n_r_perp)
{
   FILE *f_output;
   char corr_file[F_MAX];
   vector_3d pos_i, s_pos_i, pos_j, s_pos_j, sep, s_sep, u_ref, u_i, u_j;
   int i_data, i_mol, j_mol, i_r, i_r_par, i_r_perp,
      skip_i, skip_j, abs_1, abs_2,
      i_set, i_species, j_species, group_cut_flag, n_snapshots;
   double r_max, r2_max, r_par_max, r_perp_max,
      r_incr, one_over_r_incr,
      r_par_incr, one_over_r_par_incr,
      r_perp_incr, one_over_r_perp_incr,
      r2, r, r_1, r_2,
      r_par, x_perp, y_perp, z_perp, r_perp,
      r_perp_1, r_perp_2,
      mag, u_i_dot_u_j, p_1, p_2,
      norm1, norm2,
      **g_r, **g_1, **g_2,
      ***g_r_par_perp, ***g_1_par_perp, ***g_2_par_perp;

   r_max = 1e+06;
   /* Calculate radius of inscribed sphere. */
   r_max = MIN(r_max, vars.a_1_perp);
   r_max = MIN(r_max, vars.a_2_perp);
   r_max = MIN(r_max, vars.a_3_perp);
   r_max *= 0.5;
   r2_max = SQR(r_max);

   /* Calculate sizes of bins. */
   r_incr = r_max / n_r;
   one_over_r_incr = 1.0 / r_incr;
   r_par_incr = 2.0 * r_par_max / n_r_par;
   one_over_r_par_incr = 1.0 / r_par_incr;
   r_perp_incr = r_perp_max / n_r_perp;
   one_over_r_perp_incr = 1.0 / r_perp_incr;

      /* Loop over all pairs of molecules. */
      for (i_mol = 0; i_mol < n_mols - 1; ++i_mol)
         for (j_mol = i_mol + 1; j_mol < n_mols; ++j_mol) {

            /* Get molecular species. */
            i_species = mol_species[i_mol];
            j_species = mol_species[j_mol];

            /* Get atom label offsets. */
            skip_i = mol_first_atm[i_mol];
            skip_j = mol_first_atm[j_mol];
        
        s_dx = scaled_mol_coords[j_mol][0] - scaled_mol_coords[i_mol][0];
        s_dy = scaled_mol_coords[j_mol][1] - scaled_mol_coords[i_mol][1];
        s_dz = scaled_mol_coords[j_mol][2] - scaled_mol_coords[i_mol][2];
        s_dx -= NINT(s_dx);
        s_dy -= NINT(s_dy);
        s_dz -= NINT(s_dz);
        dx = h[0][0] * s_dx + h[0][1] * s_dy + h[0][2] * s_dz;
        dy = h[1][1] * s_dy + h[1][2] * s_dz;
        dz = h[2][2] * s_dz;
        r2 = SQR(dx) + SQR(dy) + SQR(dz);

        /* Test whether squared pair separation is within cutoff. */
        if (r2 < r2_max) {

        /* Calculate separation of molecules i_mol and j_mol. */
        r = sqrt(r2);

        /* Calculate molecular directors for molecules i_mol and j_mol,
        as well as Legendre polynomials of their dot product.
        If params.mol_orient_switch == 0, the molecular director is
        defined as the minimum-moment eigenvector of the molecular
        inertia tensor (if params.n_group_cut == 0) or the inertia
        tensor of a subgroup of atoms (if params.n_group_cut > 0),
        with its polarity defined by the reference vector joining
        atoms params.mol_orient_atom_1 and params.mol_orient_atom_2.
        If params.mol_orient_switch == 1, the molecular director is
        defined as the normalized reference vector joining atoms
        params.mol_orient_atom_1 and params.mol_orient_atom_2. */
        abs_1 = skip_i + params.mol_orient_atom_1[i_species];
        abs_2 = skip_i + params.mol_orient_atom_2[i_species];
        u_ref.x = rel_atom_coords[abs_2].x - rel_atom_coords[abs_1].x;
        u_ref.y = rel_atom_coords[abs_2].y - rel_atom_coords[abs_1].y;
        u_ref.z = rel_atom_coords[abs_2].z - rel_atom_coords[abs_1].z;

        u_i.x = mol_inert_axis[i_mol][2][0];
        u_i.y = mol_inert_axis[i_mol][2][1];
        u_i.z = mol_inert_axis[i_mol][2][2];
        if (dot_product(u_i, u_ref) < 0.0)
           u_i = scale_vector(u_i, -1.0);

        u_j.x = mol_inert[j_mol].axis[2][0];
        u_j.y = mol_inert[j_mol].axis[2][1];
        u_j.z = mol_inert[j_mol].axis[2][2];
        if (dot_product(u_j, u_ref) < 0.0)
           u_j = scale_vector(u_j, -1.0);
               
        u_i_dot_u_j = dot_product(u_i, u_j);
        p_1 = u_i_dot_u_j;
        p_2 = 1.5 * SQR(u_i_dot_u_j) - 0.5;

        /* Add contributions to molecular translational and orientational
           correlation functions. */
        i_r = (int) (r * one_over_r_incr);
        if (i_r < n_r) {
          if (i_species == j_species) {    
            g_r[i_r][i_species] += volume;
            g_1[i_r][i_species] += volume * p_1;
            g_2[i_r][i_species] += volume * p_2;
          }
        }
   }
}

}
