/* Function declarations */

void read_mass_params(char *mass_file, mass_entry **mass, int *n_mass);
void read_lj_params(char *lj_file, lj_entry **lj, int *n_lj);
void read_e6_params(char *e6_file, e6_entry **e6, int *n_e6);
void read_bend_params(char *bend_file, bend_entry **bend, int *n_bend);
void read_config_direct(char *config_file, int period_switch, double ***h, 
    int n_atoms, double ***atom_coords, double ***atom_vels);
void set_up_force_field(int n_species, int n_mols, int *n_atoms_per_mol,
     int n_mass, mass_entry *mass, int *mol_species, int *n_bonds_per_mol,
     double ***temp_atm_mass, char ***temp_atm_type, double **mol_mass, 
     double **mol_mass_true, int **mol_first_atm, int **n_angles_per_mol,
     int **temp_atm_nbr, int ***temp_atm_br, 
     angle_prop ***angle_props, int n_bend, bend_entry *bend);

void combination_array(int vdw_switch, int vdw_rad_switch, int n_species,
     int *n_atoms_per_mol, int n_lj, lj_entry *lj, int n_pot, pot_entry *pot,
     char ***temp_atm_type, double **temp_atm_sigma, double **temp_atm_eps,
     double **temp_atm_chg, double *****comb_sigma, double *****comb_sigma2,
     double *****comb_r_min2, double *****comb_eps, double *****comb_four_eps,
     int *****comb_pot, double *****comb_chg, double *r_on, double *r_off);

void allocate_memory_simu(int n_atoms, int n_mols, int n_species,
int n_blocks,
int period_switch, double ***scaled_atom_coords, int **atom_rel,
int **atom_mol, double **atom_mass, int **atom_type,
double **sqrt_kT_over_m, double **one_over_2m, double ***mol_coords,
double ***scaled_mol_coords, double ***rel_atom_coords,
double ***h_inv, atom_cell **atom_cells, int **offsets,
int **offsets_total, int noffsets, nl_entry ***nl_head,
nl_entry ***nl_tail, double ***atom_move, int *n_atoms_per_mol,
int ****exclusions,
double ***old, double ***s_old, double ***rel_old, double ***mol_old,
double ***ds_opt,
double ***h_block, double **h_ave, double **h_unc,
double ****mol_stress_block, double ***mol_stress_ave,
double ***mol_stress_unc, double ****at_stress_block, double ***at_stress_ave,
double ***at_stress_unc,
double **at_press_block, double **mol_press_block, double **vol_block,
double **rho_block, double **pe_vdw_s_block,
double **pe_stretch_block, double **pe_bend_block, double **n_mol_moves_block,
double **n_mol_accept_block, double **n_reshape_moves_block,
double **n_reshape_accept_block,
int **offsets_x, int **offsets_y, int **offsets_z,
double ***f_vdw_s, double ***vdw_s_single, double ***at_stress_vdw_s,
double ***at_stress_vdw_single, double ***mol_stress_vdw_s,
double ***mol_stress_vdw_single, double ***mol_range, 
double ***mol_vels, double ***f_stretch, double ***at_stress_stretch,
double ***mol_stress_stretch, double ***comp_forces,
double ***at_stress, double ***mol_stress, double ***at_stress_kin,
double ***mol_stress_kin, double ***mol_stress_vdw, double ***f_bend,
double ***at_stress_bend, double ****corr);


void relative_atoms(int n_mols, int *mol_species, int *mol_first_atm,
   int *n_atoms_per_mol, double **temp_atm_mass, int **temp_atm_type_i,
   int *atom_rel, int *atom_mol, double *atom_mass, int *atom_type,
   double *sqrt_kT_over_m, double *one_over_2m, double boltzmann,
   double temperature);

void exclusion_array(int n_species, int *n_atoms_per_mol, int *excl_switch,   
       int **temp_atm_nbr, int ***temp_atm_br, int ****exclusions);

void set_up_scan_list(int n_species, int *n_atoms_per_mol, int **temp_atm_nbr,
   int ***temp_atm_br, int ***scan_atm_1, int ***scan_atm_2);
void adjust_template_molecules(int n_species, int *n_atoms_per_mol,
      int *principal, double **temp_atm_mass, double ***temp_atm_pos);
void scaled_atomic_coords_single(int i_mol, int *n_atoms_per_mol,
       int *mol_first_atm, int *mol_species, double **h_inv, 
       double **atom_coords, double **scaled_atom_coords);
void box_dimensions(double **h, double **h_inv, int period_switch, double r_off,  double mol_max_length);
void box_inverse(double **h, double **h_inv);

void center_of_mass_positions(int period_switch, int n_mols, int n_species, 
  int *n_atoms_per_mol, int *mol_species, double *atom_mass, 
  int *mol_first_atm, double **atom_coords, double **scaled_atom_coords, 
  int **scan_atm_1, int **scan_atm_2, double *mol_mass, double **h, 
  double **h_inv, double **mol_coords, double **scaled_mol_coords, 
  double **rel_atom_coords, double ***corr);

int isotropic_start(int n_mols, long *i_ran, int *mol_first_atm,
      int *n_atoms_per_mol, int *mol_species, int *atom_rel,
      double ***temp_atm_pos, double **h, double **h_inv,
      double **mol_coords, double **scaled_mol_coords,
      double **atom_coords, double **scaled_atom_coords,
      double ****combine, int *n_bonds_per_mol, 
      int **temp_bonds_1, int **temp_bonds_2);
int nematic_start(int n_mols, long *i_ran, int *mol_first_atm,
      int *n_atoms_per_mol, int *mol_species, int *atom_rel,
      double ***temp_atm_pos, double **h, double **h_inv,
      double **mol_coords, double **scaled_mol_coords,
      double **atom_coords, double **scaled_atom_coords,
      double ****combine, int *n_bonds_per_mol, 
      int **temp_bonds_1, int **temp_bonds_2);
int smectic_start(int n_mols, int n_species, long *i_ran, int n_layers,
      int *n_mols_per_species, int *mol_first_atm,
      int *n_atoms_per_mol, int *mol_species, int *atom_rel,
      double ***temp_atm_pos, double **h, double **h_inv,
      double **mol_coords, double **scaled_mol_coords,
      double **atom_coords, double **scaled_atom_coords,
      double ****combine, int *n_bonds_per_mol,
      int **temp_bonds_1, int **temp_bonds_2);
int overlaps(int i_mol, int j_mol, int *mol_first_atm,
      int *n_atoms_per_mol, int *mol_species, int *atom_rel,
      double **h, double **scaled_atom_coords, double ****combine);
void write_header_direct(char *header_file, int period_switch, int n_species,
  int *n_atoms_per_mol, int **temp_atm_lab, char ***temp_atm_type,
  int **temp_atm_nbr, int ***temp_atm_br, double ***temp_atm_ord,
  double ***temp_atm_pos, double **temp_atm_chg, double **temp_atm_sigma,
  double **temp_atm_eps, int *n_bonds_per_mol, int **temp_bonds_1,
  int **temp_bonds_2, double **temp_bonds_ord, int *n_mols_per_species,
  int n_mols, int *mol_species);
void mc_cycle(int n_mols, int n_atoms, int vdw_switch, int period_switch,
      long *i_ran, int *mol_first_atm, int *n_atoms_per_mol, int *mol_species,
      int *atom_rel, int *atom_mol, int *atom_type, double ***temp_atm_pos,
      double **h, double **h_inv, double aspect_xy, double aspect_xz,
      double **mol_coords, double **scaled_mol_coords, double **atom_coords,
      double **scaled_atom_coords, double **rel_atom_coords, int ***exclusions,
      int **comb_pot, double ***comb_par, double gamma,
      double three_gamma_over_two, double two_over_gamma_cubed, double dr_max,
      double *ds_mol_max, double dang_mol_max, double dh_max, int reshape_axis,
      double mol_max_length, double r2_on,
      double r2_off, double r_off, double r_nl, double r2_nl, double **s_old,
      double **old, double **rel_old, double **mol_old, int press_switch,
      double reduce_boltz, double press, int neigh_switch,
      int phant_switch, int **first, int **last,
      phantom_cell **phantoms, int noffsets, int *nc, int *nc_p,
      int *nc_p_total, int kc, int *phantom_skip, atom_cell *atom_cells,
      int *offsets, nl_entry **nl_head, nl_entry **nl_tail, double **atom_move,
      int n_reshape, double *pe_vdw_s, int *n_mol_moves,
      int *n_mol_accept, int *n_reshape_moves, int *n_reshape_accept,
      double **ds_opt,
      double **at_stress_vdw_s, double **mol_stress_vdw_s, double **vdw_s,
      int *offsets_x, int *offsets_y, int *offsets_z);

int mol_move(int period_switch, int vdw_switch, int i_mol, int n_mols,
      int n_atoms, long *i_ran, int *mol_first_atm, int *n_atoms_per_mol,
      int *mol_species, int *atom_rel, int *atom_mol, int *atom_type,
      double ***temp_atm_pos, double **h, double **h_inv, double **mol_coords,
      double **scaled_mol_coords, double **atom_coords,
      double **scaled_atom_coords, double **rel_atom_coords,
      int ***exclusions, int **comb_pot, double ***comb_par, double gamma,
      double three_gamma_over_two,
      double two_over_gamma_cubed, double *ds_mol_max, double dang_mol_max,
      double r2_on, double r_off, double r2_off, double r_nl, double r2_nl,
      double **s_old, double **old, double **rel_old, double reduce_boltz,
      int neigh_switch,
      int phant_switch, int *first, int *last, phantom_cell *phantoms,
      int noffsets, int *nc, int *nc_p, int kc, int *phantom_skip,
      atom_cell *atom_cells, int *offsets, nl_entry **nl_head,
      nl_entry **nl_tail, double **atom_move,
      double *pe_vdw_s, double **ds_opt, int *offsets_x, int *offsets_y,
      int *offsets_z);

int reshape_move(int period_switch, int vdw_switch, int reshape_axis,
      double mol_max_length, int n_mols, int n_atoms,
      long *i_ran, int *mol_first_atm, int *n_atoms_per_mol, int *mol_species,
      int *atom_rel, int *atom_mol, int *atom_type, double **h, double **h_inv,
      double **mol_coords, double **scaled_mol_coords, double **atom_coords,
      double **scaled_atom_coords, double **rel_atom_coords, int ***exclusions,
      int **comb_pot, double ***comb_par, double gamma,
      double three_gamma_over_two, double two_over_gamma_cubed, double dh_max,
      double dr_max, double *ds_mol_max, double r2_on, double r2_off,
      double r_off, double r2_nl, double r_nl, double **mol_old,
      double reduce_boltz,
      int neigh_switch, int phant_switch, int **first, int **last,
      phantom_cell **phantoms, int noffsets, int *nc, int *nc_p,
      int *nc_p_total, int kc, int *phantom_skip, atom_cell *atom_cells,
      int *offsets, nl_entry **nl_head, nl_entry **nl_tail, double **atom_move,
      double *pe_vdw, double **at_stress_vdw_s, double **mol_stress_vdw_s,
      double **vdw_s, int *offsets_x, int *offsets_y, int *offsets_z);

int reshape_move_press(int period_switch, int vdw_switch, int reshape_axis,
      double mol_max_length, int n_mols, int n_atoms, long *i_ran,
      int *mol_first_atm, int *n_atoms_per_mol, int *mol_species,
      int *atom_rel, int *atom_mol, int *atom_type, double **h, double **h_inv,
      double aspect_xy, double aspect_xz, double **mol_coords,
      double **scaled_mol_coords, double **atom_coords,
      double **scaled_atom_coords, double **rel_atom_coords, int ***exclusions,
      int **comb_pot, double ***comb_par, double gamma,
      double three_gamma_over_two, double two_over_gamma_cubed, double dh_max,
      double dr_max, double *ds_mol_max, double r2_on, double r2_off,
      double r_off, double r2_nl, double r_nl, double **mol_old,
      double reduce_boltz, double press, int neigh_switch, int phant_switch,
      int **first, int **last, phantom_cell **phantoms, int noffsets,
      int *nc, int *nc_p, int *nc_p_total, int kc, int *phantom_skip,
      atom_cell *atom_cells, int *offsets, nl_entry **nl_head,
      nl_entry **nl_tail, double **atom_move, double *pe_vdw,
      double **at_stress_vdw_s, double **mol_stress_vdw_s, double **vdw_s,
      int *offsets_x, int *offsets_y, int *offsets_z);


void lj_s_period(int *mol_species, int *atom_rel, int *atom_mol,
   int *atom_type, int n_atoms,
   int *n_atoms_per_mol, int ***exclusions, int **comb_pot,
   double ***comb_par, double **h, double r2_on, double r2_off,
   double **scaled_atom_coords, double **scaled_mol_coords,
   double **rel_atom_coords, double gamma, double three_gamma_over_two,
   double two_over_gamma_cubed, double *pe_vdw_s, double **f_vdw_s,
   double **mol_stress_vdw_s);

void lj_s_period_single(int skip, int mol, int *mol_species, int *atom_rel,
   int *atom_mol, int *atom_type, int n_atoms, int *n_atoms_per_mol,
   int ***exclusions, int **comb_pot, double ***comb_par, double **h,
   double r2_on, double r2_off, double **scaled_atom_coords, double gamma,
   double three_gamma_over_two, double two_over_gamma_cubed,
   double *pe_vdw_s_single);

void optimize_molecule_moves(int n_mols, double **h, double *dr_max,
  double *dr_max_old, double *ds_mol_max, double *dang_mol_max,
  double ratio_dang_dr, double *opt_time, double *efficiency, double **ds_opt);
void optimize_reshape_moves(double **h, double reshape_accept_rate,
   double *dh_max);
double compute_efficiency(int n_mols, double **h, double *opt_time,
   double **ds_opt);
double cpu(void);

void set_up_cells_phantom(double **h, int *nc, int *nc_p, int *nc_p_total,
    atom_cell *atom_cells, int kc, int period_switch, double r_nl,
    double r_off, int neighb_switch, int **first, int **last, int *offsets,
    int n_atoms, double **scaled_atom_coords, double **atom_coords, 
    phantom_cell **phantoms, int *phantom_skip);

void set_up_offsets(int kc, int *nc_p, int *offsets);

void set_up_phantom_arrays(int cell_flag_1, int *nc_p, int nc_p_total,
    phantom_cell **phantoms, int kc, int *nc, double **h);

void phantom_block(int rx, int ry, int rz, int *nc, int *nc_p, int kc,
   double **h, phantom_cell *phantoms);

void initialize_cells(int n_atoms, int period_switch, double **h,
    double **atom_coords, double **scaled_atom_coords, int *first, int *last,
    int *nc, int *nc_p, int nc_p_total, int kc, atom_cell *atom_cells,
    phantom_cell *phantoms, int *phantom_skip);

int cell_index_period(double *scaled_coords, int *nc, int *nc_p, int kc);


void add_entry(int i, int ic, atom_cell *atom_cells, int *first, int *last);

void remove_entry(int i, int ic, atom_cell *atom_cells, int *first, int *last);

void update_phantoms(int n_atoms, atom_cell *atom_cells, int *phantom_skip,
                     phantom_cell *phantoms, double **atom_coords);

void update_cells_single(int i_mol, int period_switch, int n_atoms, double **h,
    double **scaled_atom_coords, double **atom_coords, atom_cell *atom_cells,
    int *first, int *last, phantom_cell *phantoms, int kc, int *phantom_skip,
    int *nc, int *nc_p, int *n_atoms_per_mol, int *mol_species,
    int *mol_first_atm);

void update_phantoms_single(int i_mol, int n_atoms, atom_cell *atom_cells,
    int *phantom_skip, phantom_cell *phantoms, double **atom_coords,
    int *mol_first_atm, int *mol_species, int *n_atoms_per_mol);

/*************************************************************************/
/* for no Phantom case decalre all the subroutine */

void set_up_cells_nophantom(double **h, int *nc, int *nc_p, int *nc_p_total,
                  atom_cell *atom_cells, int kc, int period_switch,
                  double r_nl, double r_off, int neigh_switch,
                  int **first, int **last,
                  int *offsets_x, int *offsets_y, int *offsets_z, int n_atoms,
                  double **scaled_atom_coords, double **atom_coords);

void set_up_offsets_nophantom(int kc, int *nc_p, int *offsets_x, int *offsets_y, int *offsets_z);

void initialize_cells_nophantom(int n_atoms, int period_switch, double **h,
                      double **scaled_atom_coords, double **atom_coords,
                      int *first, int *last, int nc_p_total, int *nc_p,
                      atom_cell *atom_cells, int kc, int *nc);

void update_cells_nophantom(int period_switch, int n_atoms, double **h,
                  double **scaled_atom_coords, double **atom_coords,
                  atom_cell *atom_cells, int *first, int *last,
                  int kc, int *nc, int *nc_p);

void update_cells_single_nophantom(int i_mol, int period_switch, int n_atoms, double **h,
                  double **scaled_atom_coords, double **atom_coords,
                  atom_cell *atom_cells, int *first, int *last,
                  int kc, int *nc,
                  int *nc_p, int *n_atoms_per_mol, int *mol_species,
                  int *mol_first_atm);
int cell_index_period_nophantom(double *scaled_coords, int *nc, int *nc_p, int kc);



void neighbor_lists_period(int *mol_species, int *atom_rel, int *atom_mol,
   int n_atoms, int *n_atoms_per_mol, int ***exclusions, double **h,
   double r2_on, double r2_off, double **scaled_atom_coords, int period_switch,
   int *first, int *last, phantom_cell *phantoms, int noffsets, int *nc_p,
   int kc, int *phantom_skip, int *nc, atom_cell *atom_cells, int *offsets,
   double **atom_coords, double **atom_move, nl_entry **nl_head,
   nl_entry **nl_tail, double r2_nl);

void neighbor_lists_period_single(int mol, int *mol_species, int *atom_rel,
   int *atom_mol, int *mol_first_atm,
   int n_atoms, int *n_atoms_per_mol, int ***exclusions, double **h,
   double r2_on, double r2_off, double **scaled_atom_coords, int period_switch,
   int *first, int *last, phantom_cell *phantoms, int noffsets, int *nc_p,
   int kc, int *phantom_skip, int *nc, atom_cell *atom_cells, int *offsets,
   double **atom_coords, double **atom_move, nl_entry **nl_head,
   nl_entry **nl_tail, double r2_nl);

void zero_move(int n_atoms, double **atom_move);

void velocity_step(int n_atoms, double **atom_vels,
                   double *atom_mass, double delta, double **comp_forces);

void position_step(int n_atoms, double **atom_coords,
                   double **atom_vels,
                   double **atom_move, double **scaled_atom_coords,
                   double **h_inv, double **h, double delta, int neigh_switch);

void center_of_mass_velocities(int n_mols, double **mol_vels,
                 double **atom_vels, double *atom_mass, double *mol_mass,
                 int *mol_first_atm, int *n_atoms_per_mol, int *mol_species);

void kinetic_energy_and_temperature(int n_mols, int n_atoms, int *mol_species,
            double *mol_mass, double **atom_vels, double **mol_vels,
            double boltzmann, int n_free_atom, int n_free_mol, double *atom_mass,
            double *at_temp, double *ke);

void stress_tensors(int ke_flag, double **at_stress_kin, double **mol_stress_kin,
                    double *atom_mass, double **atom_vels, double **mol_vels,
                    int n_atoms, int n_mols, int *mol_species, double **h,
                    double **mol_stress, double **at_stress, double **at_stress_vdw_s,
                    double **mol_stress_vdw, int n_free_atom, int n_free_mol,
                    double boltzmann, double temperature,
                    double **at_stress_stretch, double **mol_stress_vdw_s,
                    double *mol_mass, double **at_stress_bend);

/*
  void evaluate_forces(int *mol_species, int *atom_rel, int *atom_mol,
   int *atom_type, int n_atoms, int *n_atoms_per_mol, int ***exclusions,
   int **comb_pot, double ***comb_par, double r2_on, double r2_off,
   double **h, double **scaled_atom_coords, double gamma,
   double three_gamma_over_two, double two_over_gamma_cubed,
   double *pe_vdw_s, int period_switch, int *first, int *last,
   phantom_cell *phantoms, int noffsets, int *nc, int *nc_p, int kc, int *phantom_skip,
   atom_cell *atom_cells, int *offsets, double **atom_coords,
   double **rel_atom_coords, double **at_stress_vdw_s,
   double **mol_stress_vdw_s, double **f_vdw_s, double **comp_forces,
   double *pe_stretch, double **f_stretch, double spring, double r_equil,
   int neigh_switch, int vdw_switch,nl_entry **nl_head, nl_entry **nl_tail,
   double r2_nl, double **atom_move, int *mol_first_atm, int *n_bonds_per_mol,
   double **mol_stress_stretch, int eval_flag, int n_mols,
   int **temp_bonds_1, int **temp_bonds_2);
*/

void sample_velocities(long *idum, double **atom_vels, int n_atoms,
                       double *sqrt_kT_over_m);

void thermodynamics(int ke_flag, int n_mols, double **mol_vels,
                    double **atom_vels, double *atom_mass, double *mol_mass,
                    int *mol_first_atm, int *n_atoms_per_mol,
                    int n_free_atom, int n_free_mol, double boltzmann,
                    double temperature, double **h,
                    double *pe_vdw_s, double *pe_stretch, int n_atoms,
                    int *mol_species, double *at_temp, double *ke, double *pe,
                    double *te, double **at_stress_vdw_s,
                    double **at_stress_stretch, double **mol_stress_kin,
                    double **at_stress_kin,
                    double **mol_stress, double **at_stress,
                    double **mol_stress_vdw, double **mol_stress_vdw_s,
                    double *pe_bend, double **at_stress_bend,
                    int bend_switch);

void md_loop(int *mol_species, int n_mols, int *atom_rel, int *atom_mol,
   int *atom_type, int n_atoms, int *n_atoms_per_mol, int ***exclusions,
   int **comb_pot, double ***comb_par, double r2_on, double r2_off, double r_off,
   double **h, double **scaled_atom_coords, double gamma,
   double three_gamma_over_two, double two_over_gamma_cubed,
   double *pe_vdw_s, int period_switch, int **first, int **last,
   phantom_cell **phantoms, int noffsets, int *nc, int *nc_p,
   int *nc_p_total, int kc, int *phantom_skip,
   atom_cell *atom_cells, int *offsets, double **atom_coords,
   double **rel_atom_coords, double **at_stress_vdw_s,
   double **mol_stress_vdw_s, double **f_vdw_s, double **comp_forces,
   double **atom_vels, double delta, long *idum,
   double *sqrt_kT_over_m, double *atom_mass, double **atom_move, double **h_inv,
   int neigh_switch, int temp_switch, double **mol_vels, double *mol_mass,
   int *mol_first_atm, int n_free_atom, double boltzmann,
   double temperature, double *at_temp, double temp_scale, int n_free_mol,
   int ke_flag, double *pe_stretch, double **f_stretch, double spring,
   double r_equil, int vdw_switch, int bend_switch, 
   nl_entry **nl_head, nl_entry **nl_tail,
   double r2_nl, double r_nl, int *n_bonds_per_mol,
   double **at_stress_stretch, int eval_flag, int **temp_bonds_1, int **temp_bonds_2,
   double *ke, double *pe, double *te, 
   double **mol_stress_kin, double **at_stress_kin,
   double **mol_stress, double **at_stress,
   double **mol_stress_vdw, 
   angle_prop **angle_props, double *pe_bend, double **f_bend,
   double **at_stress_bend, int *n_angles_per_mol, int press_switch, 
   int scale_con, double press, double press_scale, int **scale, int phant_switch, 
   double **mol_coords, double **scaled_mol_coords,
   int **scan_atm_1, int **scan_atm_2, int n_species, double ***corr);

void manostat(int n_mols, int n_atoms, int *mol_species, int *n_atoms_per_mol,
              double **mol_coords, double **atom_coords, double **scaled_atom_coords,
              double **h, double **h_inv, double **at_stress, int scale_con,
              double r_off, double r2_nl, double r_nl,
              double press, int neigh_switch, int phant_switch,
              int **first, int **last, phantom_cell **phantoms, 
              int *nc, int *nc_p, int *nc_p_total, int kc, int *phantom_skip,
              atom_cell *atom_cells, int *offsets, double press_scale,
              int period_switch, int  **scale, int *mol_first_atm,
              double **mol_stress);

void mol_stress_cal(int n_atoms, double **rel_atom_coords, double **f_vdw_s,
                      double **at_stress_vdw_s, double **mol_stress_vdw_s,
                      double volume);

void one_step(int *mol_species, int *atom_rel, int *atom_mol,
   int *atom_type, int n_atoms, int *n_atoms_per_mol, int ***exclusions,
   int **comb_pot, double ***comb_par, double r2_on, double r2_off,
   double **h, double **scaled_atom_coords, double gamma,
   double three_gamma_over_two, double two_over_gamma_cubed,
   double *pe_vdw_s, int period_switch, int *first, int *last,
   phantom_cell *phantoms, int noffsets, int *nc, int *nc_p,
   int *nc_p_total, int kc, int *phantom_skip,
   atom_cell *atom_cells, int *offsets, double **atom_coords,
   double **rel_atom_coords, double **at_stress_vdw_s,
   double **mol_stress_vdw_s, double **f_vdw_s, double **comp_forces,
   double **atom_vels, double delta, double *atom_mass, double **atom_move,
   double **h_inv, int neigh_switch, double *pe_stretch, double **f_stretch,
   double spring, double r_equil, int vdw_switch, int bend_switch,
   nl_entry **nl_head, nl_entry **nl_tail,
   double r2_nl, int *mol_first_atm, int *n_bonds_per_mol,
   double **at_stress_stretch, int eval_flag,int **temp_bonds_1, int **temp_bonds_2,
   int n_mols, double r_nl, double r_off,
   angle_prop **angle_props, double *pe_bend, double **f_bend,
   double **at_stress_bend, int *n_angles_per_mol, double *mol_mass,
   int **scan_atm_1, int **scan_atm_2, double **mol_coords, double **scaled_mol_coords,
   int n_species, double ***corr);

