#include "build.h"
#include "ff.h"
#include "proto.h"
#include "pair.h"

main(int argc, char *argv[])
{
  int ans, i_mol, skip, i_atom, abs;
  double diff_x, diff_y, diff_z, xx, yy, zz, pe_vdw_s_single,
      pe_vdw_s_p;
  nl_entry *p, *p_term;

  double pe_vdw_s_tot;
  int i_rel, j_rel, j_species;
  int i, j, k, i_atoms, i_species, i_phant, n_species, n_species_chk, 
      n_unit_cells, n_mols, n_atoms;
  int period_switch, vdw_switch, vdw_rad_switch, *excl_switch, init_switch,
      phant_switch, neigh_switch, opt_switch, press_switch, one_four_switch,
      nb_switch, con_switch, sim_switch, temp_switch, start_switch;
  /* Random generator */
  long i_ran, seed, idum;
  /* Array of geometrical molecular lengths. */
  double **mol_range, mol_max_length, xmax;
  /* Declare parameters used to build the initial state and box matrices*/
  int n_layers;
  double rho, aspect_xy, aspect_xz, layer_spacing;
  double **h, **h_inv, r_off, r_on, r2_on, r2_off, r_nl, r2_nl,
         volume;
  int kc;
  /* Declare and initialize force field parameters. */
  int n_mass = 0, n_lj = 0, n_e6 = 0, n_pot = 0, n_type = 0;
  mass_entry *mass = NULL;
  lj_entry *lj = NULL;
  e6_entry *e6 = NULL;
  pot_entry *pot = NULL;
  type_entry *atm_type = NULL;
  /* File names */
  char par_file[F_MAX], *mass_file, *lj_file, *e6_file, *pot_file, 
      **struct_file, *header_file, *config_file, *header_file_save, 
      *config_file_save;
  FILE *f_thermo, *f_trajec;
  /* Declare and initialize molecular structure parameters. */
  int *n_atoms_per_mol = NULL, *n_mols_per_species = NULL,
      *n_bonds_per_mol = NULL, **temp_atm_lab, **temp_atm_nbr,
      ***temp_atm_br, **temp_atm_type_i;
  double ***temp_atm_pos, **temp_atm_mass, **temp_atm_chg,
      **temp_atm_sigma, **temp_atm_eps, ***temp_atm_ord;
  char ***temp_atm_type;
  int **temp_bonds_1 = NULL, **temp_bonds_2 = NULL;
  double **temp_bonds_ord = NULL;
  int *n_mols_per_unit_cell, *mol_species;

  /* Declare some arrays used in set up force field */
  double *mol_mass, *mol_mass_true;
  int *mol_first_atm;

  /* Declare combination and exclusion arrays */
  int ***exclusions, **comb_pot;
  double ***comb_par;
  /* Declare arrays used in build */
  double **scaled_atom_coords, **mol_coords, **scaled_mol_coords,
      **atom_coords, **rel_atom_coords, **atom_vels, *atom_mass, 
      *sqrt_kT_over_m, *one_over_2m, **mol_vels;
  int *atom_rel, *atom_mol, *atom_type, *hot_atom;
  int hot_flag;

  /* Scan list arrays. */
  int **scan_atm_1, **scan_atm_2;

  /* Array of the chosen principal molecular axe. */
  int *principal;
  /* Monte Carlo parameters. */
  int i_cycle, n_cycles, n_trajec, n_block, n_blocks, n_inst;

  /* Declare cell arrays. */
  atom_cell *atom_cells = NULL;
  phantom_cell *phantoms = NULL;
  int phantom_skip[7], nc[NDIM], nc_p[NDIM], nc_p_total, *first = NULL, 
  *last = NULL, *offsets, *offsets_total, noffsets;
  int *offsets_x, *offsets_y, *offsets_z;

  /* Neighbor list. */ 
  nl_entry **nl_head, **nl_tail; 
  double **atom_move;

/* Array for cluster analysis */
  int *inClust, *clustSize, *clustHead, *clustNext, *hist, nClust, nClustt, 
      bigSize, nSingle, ncUse, cBig, m, ncl;
  double rClust, sSum, ssSum,rrClust;

/* Array for Pair Correlation function */
  double **histRdf, *tRdf, rangeRdf, dum1, dum2, r_1, r_2,
         rrRange, deltaR, rBin, r_max, dum1_total, dum1_water,
         dum1_head, dum1_tail, dum1_spacer, dum1_w_h, dum1_w_t, 
         dum1_w_s, dum1_h_t, dum1_h_s, dum1_t_s;
  int sizeHistRdf, limitRdf, i_r, allen, n_water, no_lyotropic, n_head,
      n_tail, n_spacer, n_w_h, n_w_t, n_w_s, n_h_t, n_h_s, n_t_s, n_counter;

  double s_sep[NDIM], sep[NDIM], r2_sep;
    int j1, j2, rdfType, j_mol, n;
    char *type_i, *type_j;

  int pos_1, pos_2, record_size, i0, offset, data_skip, n_snap;
  /* Get command line input. */
  if (argc != 2) {
    printf("Usage: %s params_file\n", argv[0]);
    exit(1);
  }
  strcpy(par_file, argv[1]);

/* Initialize the variables */

   dum1_total= dum1_water = dum1_head = dum1_tail =  dum1_spacer =
            dum1_w_h = dum1_w_t = dum1_w_s = dum1_h_t = dum1_h_s
            = dum1_t_s = 0;


  /* Read in input parameter file. */
  read_pair_params(par_file, &start_switch, &header_file, &config_file, 
      &mass_file, &pot_file, 
      &n_species_chk, &excl_switch, &r_on, &r_off, 
      &neigh_switch, &phant_switch, &kc, &r_nl, &n_cycles, 
      &n_block, &n_trajec, &seed, &limitRdf, &rangeRdf, &sizeHistRdf,
      &allen, &data_skip);

  printf("header_file = %s, config_file = %s\n",header_file,
      config_file);
  printf("mass_file = %s\n",mass_file);
  printf("pot_file = %s\n",pot_file);
  printf("n_species (from params file) = %d\n", n_species_chk);
  for (i_species = 0; i_species < n_species_chk; ++i_species)
     printf("i_specie = %d, excl_switch = %d\n", i_species,
          excl_switch[i_species]);

  printf("r_on = %g, r_off = %g\n",r_on, r_off);
  printf("neigh_switch = %d, phant_switch = %d\n", neigh_switch,
      phant_switch);
  printf("kc = %d, r_nl = %g\n",kc, r_nl);
  printf("n_cycles = %d, \n", n_cycles);
  printf("n_trajec = %d\n", n_trajec);
  printf("seed = %ld\n",seed);
  printf("allen = %d data_skip %d\n",allen, data_skip);

  /* Define additional variables. */
  if (n_cycles % n_block != 0) 
    error_exit("n_cycles must be a multiple of n_block!\n");
  n_blocks = n_cycles / n_block;
  noffsets = CUBE(2 * kc + 1);

  /* Initialize random number generator. */
  i_ran = -seed;
  ran3(&i_ran);

  /* Read information about template molecules and atoms from header file */
  read_header_direct(header_file, &period_switch, &n_species,
      &n_atoms_per_mol,  &temp_atm_lab, &temp_atm_type, &temp_atm_nbr,
      &temp_atm_br, &temp_atm_ord,  &temp_atm_pos, &temp_atm_chg,
      &temp_atm_sigma, &temp_atm_eps,  &n_bonds_per_mol, &temp_bonds_1,
      &temp_bonds_2, &temp_bonds_ord,  &n_mols_per_species, &n_mols,
      &n_atoms, &mol_species);

  /* Check exclusion switch array. */
  if (n_species_chk != n_species) {
     printf("n_species_chk = %d, n_species = %d\n", n_species_chk, n_species);
     error_exit("Problem in the number of species.\n");
  }
 
  /* If the number of exclusion sites is greater than the number of atoms
     present in the template molecule, set the exclusion switch to -1, i.e.
     remove all intramolecular interactions. */ 
  for (i_species = 0; i_species < n_species; ++i_species)
    if (excl_switch[i_species] >= n_atoms_per_mol[i_species])
      excl_switch[i_species] = -1;
 
  /* Read FF masses file. */
  read_mass_params(mass_file, &mass, &n_mass);

  /* Set up force field data for masses. */
  set_up_force_field_pair(n_species, n_mols, n_atoms_per_mol, n_mass,
      mass, mol_species, n_bonds_per_mol, &temp_atm_mass, temp_atm_type,
      &mol_mass, &mol_mass_true, &mol_first_atm);

  /* Convert string tags to integer identifiers. */
  /* Create an integer identifier corresponding to template atom type. */ 
  convert_type(n_species, n_atoms_per_mol, temp_atm_type, &temp_atm_type_i, 
     &atm_type, &n_type);

  /* Set up scan list. */
  set_up_scan_list(n_species, n_atoms_per_mol, temp_atm_nbr, temp_atm_br,  
     &scan_atm_1, &scan_atm_2);

  /* Allocate memory for arrays used in the builder. */
  allocate_memory_pair(n_atoms, n_mols, n_species, 
      period_switch,  &scaled_atom_coords, &atom_rel, &atom_mol,
      &atom_mass, &atom_type, 
      &mol_coords, &scaled_mol_coords, 
      &rel_atom_coords, &h_inv, &atom_cells, &offsets, &offsets_total, 
      noffsets, &nl_head, &nl_tail, &atom_move,
      n_atoms_per_mol, &exclusions, &inClust, &clustSize, &clustHead,
      &clustNext, &hist, &histRdf, &tRdf, sizeHistRdf);


  /* Set up array of relative atom indices */
  relative_atoms_pair(n_mols, mol_species, mol_first_atm, n_atoms_per_mol,
      temp_atm_mass, temp_atm_type_i, atom_rel, atom_mol, atom_mass, atom_type);
      

  /* Set up the nonbonded exclusion array */
  exclusion_array(n_species, n_atoms_per_mol, excl_switch, temp_atm_nbr,  
    temp_atm_br, &exclusions);
 
  /* If we are using periodic boundary conditions, and that we are using
   cell (or neighbor) list, set up atom index offsets for updating phantom 
   atoms. */

  r2_nl = r_nl * r_nl;
  r2_on = r_on * r_on;
  r2_off = r_off * r_off;


  rrRange = SQR (rangeRdf);
  deltaR = rangeRdf / sizeHistRdf;

     n_head = n_tail = n_spacer = n_water = n_counter = 0;

    for (j1 = 0; j1 < n_atoms ; ++j1) {

           i_mol = atom_mol[j1];
           i_rel = atom_rel[j1];
           i_species = mol_species[i_mol];

           type_i = temp_atm_type[i_species][i_rel];
           if (strcmp(type_i,"C_4")==0) n_head++;
           if (strcmp(type_i,"C_2")==0) n_tail++;
           if (strcmp(type_i,"C_5")==0) n_spacer++;
           if (strcmp(type_i,"C_3")==0) n_water++;
           if (strcmp(type_i,"C_1")==0) n_counter++;

   }
printf ( "no_water %d head %d tail %d spacer %d \n", n_water, n_head, n_tail, n_spacer);

     n_w_h = n_water+ n_head;
     n_w_t = n_water+ n_tail;
     n_w_s = n_water + n_spacer;
     n_h_t = n_head + n_tail;
     n_h_s = n_head + n_spacer;
     n_t_s = n_tail + n_spacer;

   r_max = 10e6;

 /* If start_switch == 0, read and display only a configuration
     file (ascii). */

/* Open output file. */
  f_trajec = gfopen(config_file, "r");

  /* Read header from the trajectory file. */
  fread(&n_atoms, sizeof(int), 1, f_trajec);
  fread(&n_cycles, sizeof(int), 1, f_trajec);
  fread(&n_trajec, sizeof(int), 1, f_trajec);

  printf("Header from %s\n", config_file);
  printf("n_atoms = %d\n", n_atoms);
  printf("n_cycles = %d\n", n_cycles);
  printf("n_trajec = %d\n", n_trajec);


  /* Allocate memory for box and atom coordinates. */
  h = allocate_2d_array(3, 3, sizeof(double));
  atom_coords = allocate_2d_array(8*n_atoms, 3, sizeof(double));

  /* Compute number of instantaneous configuration in trajectory file. */
  if (n_cycles % n_trajec != 0) {
      printf("n_cycles must be a multiple of n_trajec\n");
      exit(1);
  }
  n_inst = n_cycles / n_trajec;

   /* Read in number of snapshots and first configuration, and store
      starting position and record size for trajectory file. */
   pos_1 = ftell(f_trajec);
   read_positions_direct(f_trajec, h, n_atoms, atom_coords);
   pos_2 = ftell(f_trajec);
   record_size = pos_2 - pos_1;
   printf("record_size %d hx %g hy %g hz %g\n", 
              record_size, h[0][0], h[1][1], h[2][2]);

 fclose(f_trajec);

/* ReOpen output file. */
  f_trajec = gfopen(config_file, "r");

  /* Read header from the trajectory file. */
  fread(&n_atoms, sizeof(int), 1, f_trajec);
  fread(&n_cycles, sizeof(int), 1, f_trajec);
  fread(&n_trajec, sizeof(int), 1, f_trajec);

  /* Loop  over trajectories. */
  printf("\nEntering main loop\n");
  fflush(NULL);
    for (i_cycle = 1; i_cycle <= n_inst; ++i_cycle) {

      /* Read in instantaneous configuration from trajectory file. */
      read_positions_direct(f_trajec, h, n_atoms, atom_coords);

      /* Calculate quantities that depend on box dimensions and exit
         if system is too small. */
      box_dimensions(h, h_inv, period_switch, 0.0, 0.0);
      /* Calculate radius of inscribed sphere. */
      r_max = MIN(r_max, h[0][0]);
      r_max = MIN(r_max, h[1][1]); 
      r_max = MIN(r_max, h[2][2]);
   }
   fclose(f_trajec);


  rangeRdf = 0.5*r_max;
  rrRange = SQR (rangeRdf);
  deltaR = rangeRdf / sizeHistRdf;
  printf(" rrRange %g deltaR %g \n", rrRange, deltaR);

  /* Reopen Trajec file */
  f_trajec = gfopen(config_file, "r");

  /* Read header from the trajectory file. */
  fread(&n_atoms, sizeof(int), 1, f_trajec);
  fread(&n_cycles, sizeof(int), 1, f_trajec);
  fread(&n_trajec, sizeof(int), 1, f_trajec);
  n_snap = 0;

    for (i_cycle = 1; i_cycle <= n_inst; ++i_cycle) {


      /* One of every data_skip configurations is considered. */
      if ((i_cycle + data_skip) % data_skip == 0) {

         /* Position file pointer. */
         offset = pos_1 + i_cycle * record_size;
         fseek(f_trajec, offset, 0);

      /* Read in instantaneous configuration from trajectory file. */
      read_positions_direct(f_trajec, h, n_atoms, atom_coords);

      /* Calculate quantities that depend on box dimensions and exit
         if system is too small. */
      box_dimensions(h, h_inv, period_switch, 0.0, 0.0);
      volume = h[0][0]*h[1][1]*h[2][2];

      if (period_switch) {
         scaled_atomic_coords(n_atoms, h_inv, atom_coords, scaled_atom_coords);
         periodic_boundary_conditions(n_atoms, h, scaled_atom_coords,
                                      atom_coords);
      }


      for (j1 = 0; j1 < n_atoms - 1; ++j1) {
      for (j2 = j1 + 1; j2 < n_atoms; ++j2) {

           i_mol = atom_mol[j1];
           i_rel = atom_rel[j1];
           i_species = mol_species[i_mol];
           j_mol = atom_mol[j2];
           j_rel = atom_rel[j2];
           j_species = mol_species[j_mol];

           type_i = temp_atm_type[i_species][i_rel];
           type_j = temp_atm_type[j_species][j_rel];

        /* Calculate pair separation. */

               for (k = 0; k < NDIM; ++k){
                 s_sep[k] = scaled_atom_coords[j1][k] - scaled_atom_coords[j2][k];
                 s_sep[k] -= NINT(s_sep[k]);
               }
               sep[0] = h[0][0] * s_sep[0] + h[0][1] * s_sep[1]
                        + h[0][2] * s_sep[2];
               sep[1] = h[1][1] * s_sep[1] + h[1][2] * s_sep[2];
               sep[2] = h[2][2] * s_sep[2];

               r2_sep = SQR(sep[0]) + SQR(sep[1]) + SQR(sep[2]);


        if (r2_sep < rrRange) {

          if (i_species ==0 &&strcmp(type_i,"C_3")==0
               && j_species == 0 && strcmp(type_j,"C_3")==0 && i_mol != j_mol)
                                       rdfType = 1;  /* HH correlation*/

          if (i_species ==0 &&strcmp(type_i,"C_3")==0
               && j_species == 0 && strcmp(type_j,"C_2")==0)
                                       rdfType = 2;  /* HT correlation*/

          if (i_species ==0 &&strcmp(type_i,"C_2")==0
               && j_species == 0 && strcmp(type_j,"C_2")==0)
                                       rdfType = 3;  /* TT correlation*/

          if (i_species ==1 &&strcmp(type_i,"C_1")==0
               && j_species == 1 && strcmp(type_j,"C_1")==0)
                                       rdfType = 4;  /* counter correlation*/

          if (i_species ==0 &&strcmp(type_i,"C_3")==0
               && j_species == 1 && strcmp(type_j,"C_1")==0)
                                       rdfType = 5;  /* counter-H correlation*/

          if (i_species ==0 &&strcmp(type_i,"C_2")==0
               && j_species == 1 && strcmp(type_j,"C_1")==0)
                                       rdfType = 6;  /* counter-tail correlation*/


          n = (int) (sqrt (r2_sep) / deltaR) + 1;
          if (n < sizeHistRdf){
             histRdf[n][rdfType]= histRdf[n][rdfType] + volume;
             tRdf[n] = tRdf[n] + volume ;
     }
    } } }
    n_snap = n_snap + 1;
    printf(" i_cycle = %d, n_snap %d\n", i_cycle, n_snap);
}

  } /* end of the loop. */
printf(" Finished calculating the histogram\n");

  /* Close output file. */
  fclose(f_trajec);

/* Normalize pair correlation functions and write them to output file. */
if ( allen ){
   dum1_total = 3.0 / (TWO_PI
      * n_atoms * (n_atoms - 1) * n_snap);

   dum1_water = 3.0 / (TWO_PI
      * n_water * (n_water - 1) * n_snap);

   dum1_head = 3.0 / (TWO_PI
      * n_head * (n_head - 1) * n_snap);

   dum1_tail = 3.0 / (TWO_PI
      * n_tail * (n_tail - 1) * n_snap);

if (n_spacer > 0) {
   dum1_spacer = 3.0 / (TWO_PI
      * n_spacer * (n_spacer - 1) * n_snap);

   dum1_w_s = 3.0 / (TWO_PI
      * n_water * n_spacer * n_snap);

   dum1_h_s = 3.0 / (TWO_PI
      * n_head * n_spacer * n_snap);

   dum1_t_s = 3.0 / (TWO_PI
      * n_tail * n_spacer * n_snap);
}

   dum1_w_h = 3.0 / (TWO_PI
      * n_water * n_head * n_snap);

   dum1_w_t = 3.0 / (TWO_PI
      * n_water * n_tail * n_snap);


   dum1_h_t = 3.0 / (TWO_PI
      * n_head * n_tail * n_snap);




 }else{
   dum1 = volume/ (TWO_PI
      * n_atoms * (n_atoms ) * pow (deltaR, 3.0)* n_snap);
 }
     for (i_r = 0; i_r < sizeHistRdf; ++i_r) {
      r_1 = i_r * deltaR;
      r_2 = (i_r + 1) * deltaR;
if(allen)
      dum2 = 1.0 / (CUBE(r_2) - CUBE(r_1));
else
      dum2 = 1.0 /SQR(i_r+0.5) ;
      tRdf[i_r] *=dum2;
      for (i = 1; i < 10; ++i) {
           histRdf[i_r][i] *=dum2;
  }}
printf(" I am entering in the PrintRdf\n");

  PrintRdf( sizeHistRdf, rangeRdf, histRdf,
            tRdf, dum1_total, dum1_water, dum1_head, dum1_tail, dum1_spacer,
            dum1_w_h, dum1_w_t, dum1_w_s, dum1_h_t, dum1_h_s, dum1_t_s,
            n_spacer);
}
  exit(0);

}  /* end of main. */

/****************************************************************************/
/* Allocate memory for static arrays */
void allocate_memory_pair(int n_atoms, int n_mols, int n_species,
int period_switch, double ***scaled_atom_coords, int **atom_rel,
int **atom_mol, double **atom_mass, int **atom_type, 
double ***mol_coords, 
double ***scaled_mol_coords, double ***rel_atom_coords, 
double ***h_inv, atom_cell **atom_cells, int **offsets, 
int **offsets_total, int noffsets, nl_entry ***nl_head,
nl_entry ***nl_tail, double ***atom_move, int *n_atoms_per_mol, 
int ****exclusions, int **inClust, int **clustSize, int **clustHead,
int **clustNext, int **hist, double ***histRdf, double **tRdf,
int sizeHistRdf)

{
  int i, i_rel, i_species, n_atoms_max;

  /* Allocate memory for arrays of atomic properties. */
  if (period_switch)
    *scaled_atom_coords = allocate_2d_array(n_atoms,
        3, sizeof(double));
  *rel_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for arrays of atomic properties. */
  *atom_rel = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mol = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mass = allocate_1d_array(n_atoms, sizeof(double));
  *atom_type = allocate_1d_array(n_atoms, sizeof(int));

  /* Allocate memory for arrays of molecular properties. */
  *mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));
  if (period_switch)
    *scaled_mol_coords = allocate_2d_array(n_mols, 3,
        sizeof(double));

  /* Allocate memory for the box matrices */
  /* For now, orthorombic box */
  *h_inv = allocate_2d_array(3, 3, sizeof(double));

  /* Allocate memory for atomic cell lists. */
  if (period_switch) {
    *atom_cells = allocate_1d_array(8 * n_atoms, sizeof(atom_cell));
    *offsets = allocate_1d_array(noffsets, sizeof(int));
    *offsets_total = allocate_1d_array(noffsets, sizeof(int));
  }
  
  /* Allocate memory for neighbor lists. */
  *nl_head = gcalloc(n_atoms, sizeof(nl_entry*));
  for (i = 0; i < n_atoms; ++i) {
    (*nl_head)[i] = gmalloc(sizeof(nl_entry));
    (*nl_head)[i] -> next = NULL;
    }
  *nl_tail = gcalloc(n_atoms, sizeof(nl_entry*));
  *atom_move = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for exclusion array. */
  *exclusions = allocate_1d_array(n_species, sizeof(int**));
  for (i_species = 0; i_species < n_species; ++i_species) {
    (*exclusions)[i_species] = allocate_1d_array(n_atoms_per_mol[i_species],
        sizeof(int*));
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species];
        ++i_rel) {
      (*exclusions)[i_species][i_rel] = allocate_1d_array(n_atoms_per_mol[i_species],
          sizeof(int));
    }
  }
/* Allocate memory for cluster count */
  *inClust = allocate_1d_array(n_atoms, sizeof(int));
  *clustSize = allocate_1d_array(n_atoms, sizeof(int));
  *clustHead = allocate_1d_array(n_atoms, sizeof(int));
  *clustNext = allocate_1d_array(n_atoms, sizeof(int));
  *hist = allocate_1d_array(n_atoms, sizeof(int));
  *histRdf = allocate_2d_array(sizeHistRdf,n_atoms, sizeof(double));
  *tRdf = allocate_1d_array(sizeHistRdf, sizeof(double));


}

/****************************************************************************/
/* Set up array of relative atom indices. */
void relative_atoms_pair(int n_mols, int *mol_species, int *mol_first_atm,
   int *n_atoms_per_mol, double **temp_atm_mass, int **temp_atm_type_i,
   int *atom_rel, int *atom_mol, double *atom_mass, int *atom_type)
{
  int i_species, skip, i, i_mol, i_rel;

  /* Set up array of atomic properties. */
  for (i_mol = 0; i_mol < n_mols; ++i_mol) {
    i_species = mol_species[i_mol];
    skip = mol_first_atm[i_mol];
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
      i = skip + i_rel;
      atom_rel[i] = i_rel;
      atom_mol[i] = i_mol;
      atom_mass[i] = temp_atm_mass[i_species][i_rel];
      atom_type[i] = temp_atm_type_i[i_species][i_rel];
    }
  }

}
