#include "build.h"
#include "ff.h"
#include "proto.h"

void PrintRdf( int sizeHistRdf, double rangeRdf, double **histRdf,
            double *tRdf, double dum1_total, double dum1_water,
            double dum1_head, double dum1_tail, double dum1_spacer,
            double dum1_w_h, double dum1_w_t, double dum1_w_s,
            double dum1_h_t, double dum1_h_s, double dum1_t_s, int n_spacer) 
{
    
    FILE *hhfp1,*ttfp1, *wwfp1, *whfp1, *htfp1, *wtfp1;
    FILE *ssfp1,*stfp1, *shfp1, *swfp1,*towfp1;
 
    double rBin;
    int n;

    hhfp1=fopen("hhcor.dat","w");
    htfp1=fopen("htcor.dat","w");
    ttfp1=fopen("ttcor.dat","w");
    wwfp1=fopen("wwcor.dat","w");
    whfp1=fopen("whcor.dat","w");
    ssfp1=fopen("sscor.dat","w");
    swfp1=fopen("swcor.dat","w");
    towfp1=fopen("totalcor.dat","w");
    wtfp1=fopen("wtcor.dat","w");
    stfp1=fopen("stcor.dat","w");
    shfp1=fopen("shcor.dat","w");

printf(" I am in printing pair corelation\n");

        for (n = 0; n < sizeHistRdf; ++n) {
             rBin = (n + 0.5) * rangeRdf / sizeHistRdf;
             fprintf (hhfp1, "%8.4f %8.4f\n", rBin, histRdf[n][1]*dum1_head);
             fprintf (htfp1, "%8.4f %8.4f\n", rBin, histRdf[n][2]*dum1_h_t);
             fprintf (ttfp1, "%8.4f %8.4f\n", rBin, histRdf[n][3]*dum1_tail);
             fprintf (wwfp1, "%8.4f %8.4f\n", rBin, histRdf[n][4]*dum1_water);
             fprintf (whfp1, "%8.4f %8.4f\n", rBin, histRdf[n][5]*dum1_w_h);
             fprintf (wtfp1, "%8.4f %8.4f\n", rBin, histRdf[n][6]*dum1_w_t);
if (n_spacer > 0) {
             fprintf (ssfp1, "%8.4f %8.4f\n", rBin, histRdf[n][7]*dum1_spacer);
             fprintf (swfp1, "%8.4f %8.4f\n", rBin, histRdf[n][8]*dum1_w_s);
             fprintf (shfp1, "%8.4f %8.4f\n", rBin, histRdf[n][9]*dum1_h_s);
             fprintf (stfp1, "%8.4f %8.4f\n", rBin, histRdf[n][10]*dum1_t_s);
}
             fprintf (towfp1, "%8.4f %8.4f\n", rBin,tRdf[n]*dum1_total);
        }
fclose(hhfp1);
fclose(htfp1);
fclose(ttfp1);
fclose(wwfp1);
fclose(whfp1);
fclose(towfp1);
fclose(wtfp1);
fclose(ssfp1);
fclose(swfp1);
fclose(stfp1);
fclose(shfp1);
}

