#include "build.h"

/* Molecular dynamics loop. */
void md_loop(int *mol_species, int n_mols, int *atom_rel, int *atom_mol,
   int *atom_type, int n_atoms, int *n_atoms_per_mol, int ***exclusions,
   int **comb_pot, double ***comb_par, double r2_on, double r2_off, double r_off,
   double **h, double **scaled_atom_coords, double gamma,
   double three_gamma_over_two, double two_over_gamma_cubed,
   double *pe_vdw_s, int period_switch, int **first, int **last,
   phantom_cell **phantoms, int noffsets, int *nc, int *nc_p, 
   int *nc_p_total, int kc, int *phantom_skip,
   atom_cell *atom_cells, int *offsets, double **atom_coords,
   double **rel_atom_coords, double **at_stress_vdw_s,
   double **mol_stress_vdw_s, double **f_vdw_s, double **comp_forces,
   double **atom_vels, double delta, long *idum,
   double *sqrt_kT_over_m, double *atom_mass, double **atom_move, double **h_inv,
   int neigh_switch, int temp_switch, double **mol_vels, double *mol_mass,
   int *mol_first_atm, int n_free_atom, double boltzmann,
   double temperature, double *at_temp, double temp_scale, int n_free_mol,
   int ke_flag, double *pe_stretch, double **f_stretch, double spring,
   double r_equil, int vdw_switch, int bend_switch, nl_entry **nl_head, 
   nl_entry **nl_tail,
   double r2_nl, double r_nl, int *n_bonds_per_mol,
   double **at_stress_stretch, int eval_flag, int **temp_bonds_1, 
   int **temp_bonds_2, double *ke, double *pe, double *te,
   double **mol_stress_kin, double **at_stress_kin, 
   double **mol_stress, double **at_stress,
   double **mol_stress_vdw, 
   angle_prop **angle_props, double *pe_bend, double **f_bend,
   double **at_stress_bend, int *n_angles_per_mol, int press_switch,
   int scale_con, double press, double press_scale, int  **scale,
   int phant_switch, double **mol_coords, double **scaled_mol_coords,
   int **scan_atm_1, int **scan_atm_2, int n_species, double ***corr)
{

int i;

      /* If n_levels == 1, integrate the equations of motion
         using the velocity Verlet algorithm. */


   one_step(mol_species, atom_rel, atom_mol,
   atom_type, n_atoms, n_atoms_per_mol, exclusions,
   comb_pot, comb_par, r2_on, r2_off, h, scaled_atom_coords, gamma,
   three_gamma_over_two, two_over_gamma_cubed,
   pe_vdw_s, period_switch, *first, *last,
   *phantoms, noffsets, nc, nc_p, nc_p_total, kc, phantom_skip,
   atom_cells, offsets, atom_coords,
   rel_atom_coords, at_stress_vdw_s,
   mol_stress_vdw_s, f_vdw_s, comp_forces,
   atom_vels, delta, atom_mass, atom_move,
   h_inv, neigh_switch, pe_stretch, f_stretch, spring, r_equil, 
   vdw_switch, bend_switch, nl_head, nl_tail,
   r2_nl, mol_first_atm, n_bonds_per_mol,
   at_stress_stretch, eval_flag, temp_bonds_1, temp_bonds_2, n_mols,
   r_nl, r_off, 
   angle_props, pe_bend, f_bend, at_stress_bend, n_angles_per_mol, mol_mass,
   scan_atm_1, scan_atm_2, mol_coords, scaled_mol_coords,
   n_species, corr);

/* printf(" I am in md pe_vdw_s %g pe_stretch %g\n",pe_vdw_s, pe_stretch); */

      /* Calculate thermodynamic quantities and add them to block
         accumulators every params.n_thermo timesteps. */

         thermodynamics(ke_flag, n_mols, mol_vels,
                    atom_vels, atom_mass, mol_mass,
                    mol_first_atm, n_atoms_per_mol,
                    n_free_atom, n_free_mol, boltzmann,
                    temperature, h, pe_vdw_s, pe_stretch, n_atoms,
                    mol_species, at_temp, ke, pe, te,
                    at_stress_vdw_s,
                    at_stress_stretch, mol_stress_kin,
                    at_stress_kin, 
                    mol_stress, at_stress,
                    mol_stress_vdw, mol_stress_vdw_s, pe_bend,
                    at_stress_bend, bend_switch);  


      /* Regulate temperature using the
         Berendsen thermostat. */

         nvt_berendsen(n_atoms, temperature, atom_vels,temp_scale, at_temp,
                       n_mols, mol_species, mol_mass, 
                       mol_vels, boltzmann, n_free_atom, n_free_mol, atom_mass);

/* printf(" I am in md after thermodynamics pe_vdw_s %g pe_stretch %g pe_bend %lf\n",
             *pe_vdw_s, *pe_stretch, *pe_bend); */

      /* If press_switch == 1, regulate pressure using the Berendsen manostat. */
      if (press_switch == 1)
       manostat(n_mols, n_atoms, mol_species, n_atoms_per_mol,
              mol_coords, atom_coords, scaled_atom_coords,
              h, h_inv, at_stress, scale_con,
              r_off, r2_nl, r_nl,
              press, neigh_switch, phant_switch,
              first, last, phantoms, 
              nc, nc_p, nc_p_total, kc, phantom_skip,
              atom_cells, offsets, press_scale, period_switch,
              scale, mol_first_atm, mol_stress);


}
