/* Periodic boundary condition nonbonded force routines for molecular
   modeling package, with WCA form for vdW interactions. */

#include "build.h"
#include "ff.h"
#include "proto.h"

/* Calculate short-range WCA interactions using a cell search with phantom
   cells. */

void wca_period_phantom(int *mol_species, int *atom_rel, int *atom_mol, 
   int *atom_type, int n_atoms, int *n_atoms_per_mol, int ***exclusions, 
   int **comb_pot, double ***comb_par, double r2_on, double r2_off,
   double **h, double **scaled_atom_coords, double gamma, 
   double three_gamma_over_two, double two_over_gamma_cubed, 
   double *pe_vdw_s, int period_switch, int *first, int *last, 
   phantom_cell *phantoms, int noffsets, int *nc_p, int kc, int *phantom_skip, 
   int *nc, atom_cell *atom_cells, int *offsets, double **atom_coords, 
   double **rel_atom_coords, double **at_stress_vdw_s, 
   double **mol_stress_vdw_s, double **f_vdw_s)
{
   int i, j, k, i_species, j_species, i_mol, j_mol, i_rel, j_rel, inter_flag;
   double s_sep[NDIM], sep[NDIM], r2_sep, u_vdw, 
      s_i[NDIM], l_range[NDIM], shift[NDIM];
   int in_plane, icxy, icx, icy, icz, jcx, jcy, jcz, jc, i_off;
   int ic, j_real, pot_form, i_type, j_type, compute_flag;
   double p_norm, volume, rel_dist[NDIM], f_i_vdw[NDIM], fvdw, f_vdw[NDIM];
   int counter;

   volume = h[0][0] * h[1][1] * h[2][2];
   /* Initialisation. */
   *pe_vdw_s = 0.0;

   /* Zero short-range vdW forces. */
   for (i = 0; i < n_atoms; ++i)
      for (k = 0; k < NDIM; ++k)
         f_vdw_s[i][k] = 0.0;

   for (i = 0; i < NDIM; ++i)
      for (k = 0; k < NDIM; ++k){
         at_stress_vdw_s[i][k] = 0.0;
         mol_stress_vdw_s[i][k] = 0.0;
      }
   
   update_cells( period_switch,  n_atoms, h,
                  scaled_atom_coords, atom_coords, atom_cells, first, last,
                  phantoms,  kc, phantom_skip, nc, nc_p);

   update_phantoms( n_atoms, atom_cells, phantom_skip, phantoms, atom_coords);


   /* Loop over atoms. */
   for (i = 0; i < n_atoms ; ++i) {

      /* Get attributes of atom i. */
      for (k = 0; k < NDIM; ++k){
        s_i[k] = atom_coords[i][k];
        f_i_vdw[k] = f_vdw_s[i][k];  
       }
      
      i_mol = atom_mol[i];
      i_rel = atom_rel[i];
      i_type = atom_type[i];
      i_species = mol_species[i_mol];

      /* Get cell index. */
      ic = atom_cells[i].cell;

      for (i_off = 0; i_off < noffsets; ++i_off) {


         /* If i_off == 0, start with the atom that follows atom i in the
            home cell list. Otherwise, start with the first atom in the
            neighboring cell. */
         if (i_off == 0)
            j = atom_cells[i].next;
         else {

         /* Compute index of neighboring cell and get index of the
            first atom in that cell. */
         jc = ic + offsets[i_off];
         j = first[jc];
       }
         /* Loop over atoms in neighboring cell. */
         while (j != -1) {

         /* Get attributes of atom j. */
/*  printf( " I am here in force_wca n_atoms %d, j %d nc_p %d\n", ic, jc, j); */
         j_real = atom_cells[j].real;
/* printf( " I am here in force_wca n_atoms %d, j %d \n", i, j); */
         j_mol = atom_mol[j_real];
         j_rel = atom_rel[j_real];
         j_type = atom_type[j_real];
     
         /* Determine whether interaction should be computed. */
         inter_flag = i_mol != j_mol;
         if (inter_flag || exclusions[i_species][i_rel][j_rel]) {

               /* Calculate scaled pair separation. */
               for (k = 0; k < NDIM; ++k)
                 sep[k] = atom_coords[j][k] - s_i[k];

               r2_sep = SQR(sep[0]) + SQR(sep[1]) + SQR(sep[2]);
               
               /* Calculate specie of the j atom. */
               j_species = mol_species[j_mol];

               /* Get the pair interaction form. */
               pot_form = comb_pot[i_type][j_type];
               compute_flag = 0;
/****************************************************************************/
/********************** Begin of pair interaction menu. *********************/
/****************************************************************************/
               /* Compute pair interaction. */
               compute_pot(i_type, j_type, pot_form, r2_off, r2_on, r2_sep, 
                  comb_par, gamma, three_gamma_over_two, two_over_gamma_cubed,
                  &u_vdw, &fvdw, &compute_flag);

               if (compute_flag) {

               /* Add contributions to potential energy and atomic and
                  molecular pressure tensors. */
               *pe_vdw_s += u_vdw;

               /* Add contributions to force. */
               for ( k = 0; k < NDIM; ++k){
                 f_vdw[k] = sep[k] * fvdw;
                 f_i_vdw[k] -= f_vdw[k];
               }
               for ( k = 0; k < NDIM; ++k)
               f_vdw_s[j_real][k] += f_vdw[k];
               
               /* Compute stress tensor. */
               at_stress_vdw_s[0][0] += sep[0] * f_vdw[0];
               at_stress_vdw_s[1][1] += sep[1] * f_vdw[1];
               at_stress_vdw_s[2][2] += sep[2] * f_vdw[2];
               at_stress_vdw_s[0][1] += sep[0] * f_vdw[1];
               at_stress_vdw_s[0][2] += sep[0] * f_vdw[2];
               at_stress_vdw_s[1][2] += sep[1] * f_vdw[2];

               }

/****************************************************************************/
/************************ End of pair interaction menu. *********************/
/****************************************************************************/
               }
            j = atom_cells[j].next;
            }
	}
      for ( k = 0; k < NDIM; ++k)
       f_vdw_s[i][k] = f_i_vdw[k];
   }

/* The contributions to the potential and to the stress tensor are half
   the previous quantities (we have computed i on j and j on i). */

/*   *pe_vdw_s /= 2.0; */
   p_norm = 1.0/volume;
    
   for (i = 0; i < NDIM; ++i)
     for (j = i; j < NDIM; ++j)
       at_stress_vdw_s[i][j] *= p_norm;
       mol_stress_cal(n_atoms, rel_atom_coords, f_vdw_s, at_stress_vdw_s,
                        mol_stress_vdw_s, volume); 
}
/****************************************************************************/
/* Calculate short-range LJ interactions between the molecule i_mol and all the
others, using a N^2 search, and using a switching function to truncate the pair
potential and pair force smoothly. */

void wca_period_single_phantom(int skip, int mol, int *mol_species, 
   int *atom_rel, int *atom_mol, int *atom_type, int n_atoms, 
   int *n_atoms_per_mol, int ***exclusions, 
   int **comb_pot, double ***comb_par,  double r2_on, double r2_off,
   double **h, double **scaled_atom_coords, 
   double gamma, double three_gamma_over_two, double two_over_gamma_cubed, 
   double *pe_vdw_s_single,
   int period_switch, int *first, int *last, phantom_cell *phantoms, 
   int noffsets, int *nc_p, int kc, int *phantom_skip, int *nc,
   atom_cell *atom_cells, int *offsets, 
   double **atom_coords, int *mol_first_atm)
{
   int i, j, k, i_species, j_species, i_mol, j_mol, i_rel, j_rel, inter_flag,
      i_type, j_type;
   double s_sep[NDIM], sep[NDIM], r2_sep, u_vdw, fvdw, 
      s_i[NDIM], l_range[NDIM], shift[NDIM];
   int in_plane, icxy, icx, icy, icz, jcx, jcy, jcz, jc, i_off;
   int ic, j_real, pot_form, compute_flag;
   int counter;

   /* Initialisation. */
   *pe_vdw_s_single = 0.0;

   i_species = mol_species[mol];
   /* Loop over atoms in the molecule i_mol. */
   for (i = skip; i < skip + n_atoms_per_mol[i_species] ; ++i) {

      /* Get attributes of atom i. */
      for (k = 0; k < NDIM; ++k)
        s_i[k] = atom_coords[i][k];
      i_mol = atom_mol[i];
      i_rel = atom_rel[i];
      i_type = atom_type[i];

     /* Get cell index. */
      ic = atom_cells[i].cell;

      for (i_off = 0; i_off < noffsets; ++i_off) {

            /* Compute index of neighboring cell and get index of the
               first atom in that cell. */
            jc = ic + offsets[i_off];
            j = first[jc];

       counter = 0;
       /* Loop over atoms in neighboring cell. */
         while (j != -1) {

         ++counter;
         if (counter > 5000) 
           error_exit("pb with do-while loop wca_period_single.");

         /* Get attributes of atom j. */
         j_real = atom_cells[j].real;
         j_mol = atom_mol[j_real];
         j_rel = atom_rel[j_real];
         j_type = atom_type[j_real];

         /* Determine whether interaction should be computed. */
         inter_flag = i_mol != j_mol;
         if (inter_flag || exclusions[i_species][i_rel][j_rel]) {

               /* Calculate scaled pair separation. */
               for (k = 0; k < NDIM; ++k)
                 sep[k] = atom_coords[j][k] - s_i[k];
                 
               r2_sep = SQR(sep[0]) + SQR(sep[1]) + SQR(sep[2]);

               /* If the pair separation is less than r_off, calculate
                  vdW interaction. */
               j_species = mol_species[j_mol];

               /* Get the pair interaction form. */
               pot_form = comb_pot[i_type][j_type];
               compute_flag = 0;

/****************************************************************************/
/********************** Begin of pair interaction menu. *********************/
/****************************************************************************/
               /* Compute pair interaction. */
               compute_pot(i_type, j_type, pot_form, r2_off, r2_on, r2_sep, 
                  comb_par, gamma, three_gamma_over_two, two_over_gamma_cubed,
                  &u_vdw, &fvdw, &compute_flag);

               if (compute_flag)
               /* Add contributions to potential energy and atomic and
                  molecular pressure tensors. */
               *pe_vdw_s_single += u_vdw;
/****************************************************************************/
/************************ End of pair interaction menu. *********************/
/****************************************************************************/
	      }
              j = atom_cells[j].next;
            }
          }
	}
}
/****************************************************************************/
/* Calculate short-range vdW contribution to molecular stress tensor. */
void mol_stress_cal(int n_atoms, double **rel_atom_coords, double **f_vdw_s,
                      double **at_stress_vdw_s, double **mol_stress_vdw_s,
                      double volume)
{
   int i, j;
   double p_norm;

   /* Calculate molecular stress tensor. */
   for (i = 0; i < n_atoms; ++i) {
      mol_stress_vdw_s[0][0] -= rel_atom_coords[i][0] * f_vdw_s[i][0];
      mol_stress_vdw_s[1][1] -= rel_atom_coords[i][1] * f_vdw_s[i][1]; 
      mol_stress_vdw_s[2][2] -= rel_atom_coords[i][2] * f_vdw_s[i][2];
      mol_stress_vdw_s[0][1] -= rel_atom_coords[i][0] * f_vdw_s[i][1]; 
      mol_stress_vdw_s[0][2] -= rel_atom_coords[i][0] * f_vdw_s[i][2]; 
      mol_stress_vdw_s[1][2] -= rel_atom_coords[i][1] * f_vdw_s[i][2]; 
      mol_stress_vdw_s[1][0] -= rel_atom_coords[i][1] * f_vdw_s[i][0]; 
      mol_stress_vdw_s[2][0] -= rel_atom_coords[i][2] * f_vdw_s[i][0]; 
      mol_stress_vdw_s[2][1] -= rel_atom_coords[i][2] * f_vdw_s[i][1]; 
   }
   p_norm = 1.0 / volume;
   for (i = 0; i < 3; ++i)
      for (j = 0; j < 3; ++j)
         mol_stress_vdw_s[i][j] *= p_norm;
   for (i = 0; i < 3; ++i)
      for (j = i; j < 3; ++j)
         mol_stress_vdw_s[i][j] += at_stress_vdw_s[i][j];
   for (i = 1; i < 3; ++i)
      for (j = 0; j < i; ++j)
         mol_stress_vdw_s[i][j] += at_stress_vdw_s[j][i];
}

