/* Bond vector routines for molecular modeling package. */

#include "build.h"

/* Calculate bond vectors for use in intramolecular force calculations and
   constraint routines, with periodic boundary conditions. */
void calculate_bond_vectors_period(int n_mols, int *n_bonds_per_mol
                         double **scaled_atom_coords, int *mol_first_atm,
                         int **temp_bonds_1, int **temp_bonds_2, 
                         int *mol_species, int var_flag)
{
   int i_species, i_bond, i_mol, rel_1, rel_2, abs_1, abs_2, skip,
      v_rel_1, v_rel_2, v_abs_1, v_abs_2, v_skip;
   double s_bond[NDIM], bond[NDIM], r2_bond;

   /* Loop over molecules. */
   for (i_mol = 0; i_mol < n_mols; ++i_mol) {

      /* Get label of molecular species. */
      i_species = mol_species[i_mol];

      /* Get atom and bond vector label offsets. */
      skip = mol_first_atm[i_mol];
      v_skip = mol_props[i_mol].first_vector;

      /* Loop over bonds. */
      for (i_bond = 0; i_bond < n_bonds_per_mol[i_species]; ++i_bond) {

         /* Get relative labels of atoms that share bond. */
         rel_1 = temp_bonds_1[i_species][i_bond];
         rel_2 = temp_bonds_2[i_species][i_bond];

         /* Get relative label of bond vectors. */
         v_rel_1 = vector_index[i_species][rel_1][rel_2];
         v_rel_2 = vector_index[i_species][rel_2][rel_1];

         /* Compute absolute labels of atoms that share bond. */
         abs_1 = skip + rel_1;
         abs_2 = skip + rel_2;

         /* Compute absolute labels of bond vectors. */
         v_abs_1 = v_skip + v_rel_1;
         v_abs_2 = v_skip + v_rel_2;

         /* Calculate bond vector and bond length. */
         for (k = 0; k < NDIM; ++k)
         {
            s_bond[k] = scaled_atom_coords[abs_2][k]
                      - scaled_atom_coords[abs_1][k];
            s_bond[k] -= NINT(s_bond[k]);
         }
         bond[0] = h[0][0] * s_bond[0] + h[0][1] * s_bond[1]
                  + h[0][2] * s_bond[2];
         bond[1] = h[1][1] * s_bond[1] + h[1][2] * s_bond[2];
         bond[2] = h[2][2] * s_bond[2];

         r2_bond = SQR(bond[0]) + SQR(bond[1]) + SQR(bond[2]);

         /* Fill bond vector arrays. */
        for (k = 0; k < NDIM; ++k)
         bond_vectors[v_abs_1][k] = bond[k];
         bond_vectors[v_abs_1].r2 = r2_bond;
        for (k = 0; k < NDIM; ++k)
         bond_vectors[v_abs_2][k] = bond[k];
         bond_vectors[v_abs_2].r2 = r2_bond;
      }
   }

   /* Set bond update flag = 0. */
   bond_flag = 0;
}

