/*--------------------------------------------------------------------
 *	save_image.c
 *
 *	Subroutine to save the current GL window in an Iris image file.
 *
 *	Requires routines from -limage and -lgutil. Source for  these
 *	libraries is given in ~4Dgifts/iristools.
 *------------------------------------------------------------------*/
#include "shared.h"

static int myerror = 0;

unsigned char *chkmalloc(int n);

int save_image_ (char *filename)
{
	IMAGE			*oimage;
	long			xsize = -1, ysize = -1;
	long			xorg = -1, yorg = -1;
	int				rgbmode, y;
	unsigned short	*rs, *gs, *bs;
	unsigned long	*scrbuf, *ss;
	char			*s;

	s = filename + strlen (filename) - 1;
	while (isspace (*s))
		s--;
	*(++s) = 0;
	s = filename;
	while (isspace (*s)) s++;

	/*	Get the geometry and rgb mode of the current window. */
	getsize (&xsize, &ysize);
	getorigin (&xorg, &yorg);
/*xsize -= 600;
xorg += 300;*/
	rgbmode = getdisplaymode ();
	rgbmode = (rgbmode == DMRGB || rgbmode == DMRGBDOUBLE);
rgbmode = 1;

	/* Open the image file */
    if(rgbmode)
		oimage = iopen (s, "w", RLE(1), 3, xsize, ysize, 3);
    else
		oimage = iopen (s, "w", RLE(1), 2, xsize, ysize, 1);

	/* Allocate buffers */
    rs = (unsigned short *)chkmalloc (xsize*sizeof(short));
	gs = (unsigned short *)chkmalloc (xsize*sizeof(short));
	bs = (unsigned short *)chkmalloc (xsize*sizeof(short));
	scrbuf = (unsigned long *)chkmalloc (xsize*ysize*sizeof(long));

	/* Read display */
	readdisplay (xorg, yorg, xorg + xsize - 1, yorg + ysize - 1, scrbuf, RD_FREEZE);

	/* write the data to the image file */
    ss = scrbuf;
    for (y = 0; y < ysize; y++) {
        cpacktorgb (ss, rs, gs, bs, xsize);
        if(rgbmode) {
            if (putrow (oimage, rs, y, 0) != xsize)
                myerror = 1;
            if (putrow (oimage, gs, y, 1) != xsize)
                myerror = 1;
            if (putrow (oimage, bs, y, 2) != xsize)
                myerror = 1;
        } else {
            rgbrowtobw (rs, gs, bs, rs, xsize);
            if (putrow (oimage, rs, y, 0) != xsize)
                myerror = 1;
        }
        ss += xsize;
    }

	/* free buffers */
    free (rs);
    free (gs);
    free (bs);
    free (scrbuf);

	/* close the image file */
    if (iclose (oimage) < 0)
        myerror = 1;

	if (myerror == 1) return 1;
	else return 0;
}

unsigned char *chkmalloc(int n)
{
    unsigned char *lptr;

    lptr = (unsigned char *)malloc(n);
    if(!lptr) {
        fprintf(stderr,"save_image: malloc of %d bytes failed\n",n);
        myerror = 1;
    }
    return lptr;
}

