/* Utility routines for simulation programs. */

#include "build.h"

/* Assign one n-dimensional vector to another. */
double *assign_vector(double *v, int n)
{
   int i;
   double *v_temp;

   v_temp = calloc(n, sizeof(double));

   for (i = 0; i < n; ++i)
      v_temp[i] = v[i];
   return v_temp;
}

/* Calculate sum of two n-dimensional vectors. */
double *vector_sum(double *v1, double *v2, int n)
{
   int i;
   double *sum;

   sum = calloc(n, sizeof(double));

   for (i = 0; i < n; ++i)
      sum[i] = v1[i] + v2[i];
   return sum;
}

/* Calculate difference of two n-dimensional vectors. */
double *vector_difference(double *v1, double *v2, int n)
{
   int i;
   double *diff;

   diff = calloc(n, sizeof(double));

   for (i = 0; i < n; ++i)
      diff[i] = v1[i] - v2[i];
   return diff;
}

/* Calculate dot product of two n-dimensional vectors. */
double dot_product(double *v1, double *v2, int n)
{
   int i;
   double product = 0.0;

   for (i = 0; i < n; ++i)
      product += v1[i] * v2[i];
   return product;
}

/* Calculate magnitude of a n-dimensional vector. */
double magnitude(double *v, int n)
{
   return sqrt(dot_product(v, v, n));
}

/* Multiply n-dimensional vector by a scale factor. */
double *scale_vector(double *v, int n, double scale_factor)
{
   int i;
   double *v_s;

   v_s = calloc(n, sizeof(double));

   for (i = 0; i < n; ++i)
      v_s[i] = scale_factor * v[i];
   return v_s;
}

