/* Poly-spherocylinders simulation program. */

#define MAIN
#include "build.h"
#include "ff.h"
#include "proto.h"
#undef MAIN

#define RMS_MAX 2.0
/* List of All variables 
   Array for spherocylinder in a molecules sphero_mol 
   Array for number of spherocylinders per molecules n_sphero_per_mol 
   Arrays of template molecule - labels of atoms sharing a bond
                                                               (temp_bonds_1,
                                                                temp_bonds_2) */
int main(int argc, char *argv[])
{
   FILE *f_thermo, *f_trajec, *f_dist, *f_free;
   char *defaults_file, *param_file;
   char par_file[F_MAX], *mass_file, *lj_file, *e6_file, *pot_file,
      **struct_file, *header_file, *config_file, *header_file_save,
      *config_file_save;

   int i, j, i_mol, n_mol, n_layers, start_switch, graph_switch, n_graph,
      n_cos_theta, n_rms_displ, opt_switch, n_opt, n_reshape, reshape_axis,
      bias_switch, cell_switch, n_cycles, n_block, n_thermo, n_trajec,
      i_cycle, i_bin, displ_flag, end_vec_switch, n_mol_moves, n_mol_accept, 
      n_cell_moves, n_reshape_moves, n_reshape_accept, n_reshape_moves_opt, 
      n_reshape_accept_opt, i_block, n_blocks, *cos_theta_mod_hist, 
      *rms_displ_hist, *n_mol_moves_block, *n_mol_accept_block, 
      *n_cell_moves_block, *n_cell_accept_block, *n_reshape_moves_block, 
      *n_reshape_accept_block, n_mol_moves_tot, n_mol_accept_tot, 
      n_reshape_moves_tot, n_reshape_accept_tot;
   long i_ran;
   double open_angle, epsilon;
   int nrot, i_atom, dum, nc_x, nc_y, nc_z;

   double *length, length1, length2, rho_star, rho, rho_cp, aspect_xy, aspect_xz, 
          layer_spacing, **disp,
      norm, s_spacing, s0_ref, s0,
      skin_old, opt_time, efficiency, ratio_du_dr, ratio_du_dr_old, dr_max_old, 
      displ_max, pi, degrees_to_radians, radians_to_degrees,
      mol_accept, reshape_accept, dummy, reshape_accept_opt,
      *cos_theta, *phi, cos_theta_mod, phi_mod,
      theta_equil, cos_theta_equil, pressure_star, v0, pressure, volume,
      rms_displ_equil,
      cos_theta_incr, rms_displ_incr,
      **h_block, *layer_spacing_block, *volume_block, *rho_star_block,
      ***q_end_block, **cos_theta_block, **phi_block, ***lambda_block,
      *rms_displ_block, *e_bias_block, volume_ave, volume_unc,
      rho_star_ave, rho_star_unc,
      *h_ave, *h_unc, layer_spacing_ave, layer_spacing_unc,
      **q_end_ave, **q_end_unc, *cos_theta_ave, *cos_theta_unc, *phi_ave, *phi_unc,
      **lambda_ave, **lambda_unc,
      rms_displ_ave, rms_displ_unc,
      e_bias_ave, e_bias_unc,
      weight, weight_sum, *weight_dist, free_energy,
      dr_max, ds_max[3], du_max, dside_max, dphi, 
      rms_displ, deviation, e_bias, skin, k_theta, k_displ,
      **q_end, **q_polar, **lambda, ***v, **h, 
      **dr_tot, **dr_opt, **mol_inert_mt, ***mol_inert_axis, 
      ***mol_order_inst, **order_temp, *lambda_temp, **v_temp, 
      ****mol_order_block, ***mol_order_ave, ***mol_order_unc;
   nl_entry **nl_head, **nl_tail, *p;
   short val, keep_going;

/* Addition for the bananas */
    double **atom_coords, **scaled_atom_coords, **scaled_mol_coords, 
      **mol_coords, **h_inv;
    double **atom_coords_trial, **mol_coords_trial, 
      **scaled_atom_coords_trial, **rel_atom_coords, 
      **s_sphero, **u_sphero, **s_sphero_trial, 
      **end_sphero, **polar_sphero, **scaled_mol_unfolded;
    int polar_switch, 
      *mol_first_atm, k, 
      atom_count, principal, sphero_count, 
      *mol_first_sphero, *sphero_mol, n_sphero, **temp_bonds_1, **temp_bonds_2;
    double norm1, norm2;
    double angle, cos_angle, theta, ctheta, stheta, alpha, beta, dx, dy, dz, 
       a1[3], b1[3], c1[3], n_mol_xy;

/* Parameter from graphics */

    double radius_sph, radius_cyl;
    int resph, antialias_switch, species_choice, *comb_col;
    char *color_file;

/* New variables for mixture */
    int n_species, *mol_species, n_mols, n_atoms,
        i_species, period_switch;
    int *n_atoms_per_mol = NULL, *n_mols_per_species = NULL,
      *n_bonds_per_mol = NULL, **temp_atm_lab, **temp_atm_nbr,
      ***temp_atm_br, **temp_atm_type_i;
  double ***temp_atm_pos, **temp_atm_mass, **temp_atm_chg,
      **temp_atm_sigma, **temp_atm_eps, ***temp_atm_ord, *atom_mass;
  char ***temp_atm_type;
  double **temp_bonds_ord = NULL;
  int *atom_rel, *atom_mol, *atom_type;
  int **scan_atm_1, **scan_atm_2;

/* Declare and initialize force field parameters. */
  int n_mass = 0, n_lj = 0, n_e6 = 0, n_pot = 0, n_type = 0;
  mass_entry *mass = NULL;
  lj_entry *lj = NULL;
  e6_entry *e6 = NULL;
  pot_entry *pot = NULL;
  type_entry *atm_type = NULL;

  double *mol_mass, *mol_mass_true, ***corr;

  int i_sphero;

/* OpenGL/X variables declaration. */
    Display *dpy;
    Window win;
    GLboolean doubleBuffer = GL_TRUE;
    GLUquadricObj *qobj;

   /* Get command-line input, which consists of the names of files
      containing default parameters and input parameters. */
   if (argc != 3) {
      fprintf(stderr, "Usage: %s defaults_file param_file\n", argv[0]);
      exit(1);
   }
   defaults_file = gmalloc((strlen(argv[1])+1) * sizeof(char));
   strcpy(defaults_file, argv[1]);
   param_file = gmalloc((strlen(argv[2])+1) * sizeof(char));
   strcpy(param_file, argv[2]);

   printf("\nLa Banane : simulation program, v1.0\n");
   fflush(NULL);

   /* Read default parameters from defaults file. */
   parse_params(defaults_file, &header_file, &config_file, 
                &mass_file, &color_file,
                &header_file_save, &config_file_save,
                &pressure_star, &n_layers, &layer_spacing,
                &skin, &dr_max, &ratio_du_dr, &dside_max,
                &reshape_axis, &n_reshape, &bias_switch, &cell_switch,
                &k_theta, &theta_equil, &dphi,
                &k_displ, &rms_displ_equil,
                &displ_flag, &displ_max,
                &n_cycles, &n_block, &n_thermo, &n_trajec,
                &opt_switch, &n_opt,
                &n_cos_theta, &n_rms_displ,
                &graph_switch, &n_graph, &i_ran,
                &open_angle, &end_vec_switch, &radius_sph, &radius_cyl,
                &resph, &antialias_switch, &species_choice);

   /* Read input parameters from parameter file. */
   parse_params(param_file, &header_file, &config_file, 
                &mass_file, &color_file,
                &header_file_save, &config_file_save,
                &pressure_star, &n_layers, &layer_spacing,
                &skin, &dr_max, &ratio_du_dr, &dside_max,
                &reshape_axis, &n_reshape, &bias_switch, &cell_switch,
                &k_theta, &theta_equil, &dphi, &k_displ, &rms_displ_equil,
                &displ_flag, &displ_max, &n_cycles, &n_block, &n_thermo, 
                &n_trajec, &opt_switch, &n_opt, &n_cos_theta, &n_rms_displ,
                &graph_switch, &n_graph, &i_ran, &open_angle, &end_vec_switch,
                &radius_sph, &radius_cyl, &resph, &antialias_switch, &species_choice);

   /* Check for errors in input parameters. */
   if (n_cycles % n_block != 0) {
      fprintf(stderr, "n_cycles must be a multiple of n_block\n");
      exit(1);
   }
   if (n_cycles % n_trajec != 0) {
      fprintf(stderr, "n_cycles must be a multiple of n_trajec\n");
      exit(1);
   }

   /* Initialize random number generator. */
   i_ran = - i_ran;
   ran3(&i_ran);

   /* Generate initial configuration. If start_switch == 0, the initial
      configuration is read from config_file. */
   /* First read the header file */
    read_header_direct(header_file, &period_switch, &n_species,
      &n_atoms_per_mol,  &temp_atm_lab, &temp_atm_type, &temp_atm_nbr,
      &temp_atm_br, &temp_atm_ord,  &temp_atm_pos, &temp_atm_chg,
      &n_bonds_per_mol, &temp_bonds_1,
      &temp_bonds_2, &temp_bonds_ord,  &n_mols_per_species, &n_mols,
      &n_atoms, &mol_species);


      read_config_direct(config_file, &h, n_atoms, &length1, &length2,
                  &dr_max, &ratio_du_dr, &dside_max, &skin, &atom_coords);

printf(" length1 %g length2 %g\n", length1, length2);
/* Compute number of sphero Cylinder */
   n_sphero = 0;

   for (i_species = 0; i_species < n_species; ++i_species){
   n_sphero += n_bonds_per_mol[i_species]* n_mols_per_species[i_species];

   }
   printf(" n_sphero %d\n", n_sphero);

     /* Initialize all the arrays */

      h_inv = allocate_2d_array(3, 3, sizeof(double));
      mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));
      scaled_mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));
      scaled_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));
      rel_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));

      /* Allocate memory for arrays of atomic properties. */

      atom_rel = allocate_1d_array(n_atoms, sizeof(int));
      atom_mol = allocate_1d_array(n_atoms, sizeof(int));
      atom_mass = allocate_1d_array(n_atoms, sizeof(double));
      atom_type = allocate_1d_array(n_atoms, sizeof(int));
      mol_first_atm = allocate_1d_array(n_mols, sizeof(int));
      mol_first_sphero = allocate_1d_array(n_mols, sizeof(int));
      s_sphero = allocate_2d_array(n_sphero, 3, sizeof(double));
      u_sphero = allocate_2d_array(n_sphero, 3, sizeof(double));
      sphero_mol = allocate_1d_array(n_sphero, sizeof(int));
      length = allocate_1d_array(n_sphero, sizeof(double));
   /* Allocate memory for temporary array. */
      corr = allocate_1d_array(n_species, sizeof(double**));
         for (i_species = 0; i_species < n_species; ++i_species)
             corr[i_species] = allocate_2d_array(n_atoms_per_mol[i_species], NDIM,
                              sizeof(double));

      volume = h[0][0] * h[1][1] * h[2][2];
      v0 = PI * (3* length1 / 4.0 + 1.0 / 6.0);
      rho = n_mols / volume;
      rho_star = rho * v0;
      
printf(" n_mols %d , rho %g v0 %g, rho_star %g\n", n_mols, rho, v0, rho_star);
      /* Read FF masses file. */
  read_mass_params(mass_file, &mass, &n_mass);

  /* Set up force field data for masses. */
  set_up_force_field(n_species, n_mols, n_atoms_per_mol, n_mass,
      mass, mol_species, n_bonds_per_mol, &temp_atm_mass, temp_atm_type,
      &mol_mass, &mol_mass_true, &mol_first_atm);

  /* Convert string tags to integer identifiers. */
  /* Create an integer identifier corresponding to template atom type. */
  convert_type(n_species, n_atoms_per_mol, temp_atm_type, &temp_atm_type_i,
     &atm_type, &n_type);

   /* Set up scan list. */
  set_up_scan_list(n_species, n_atoms_per_mol, temp_atm_nbr, temp_atm_br,
     &scan_atm_1, &scan_atm_2);
   
   /* Set up array of relative atom indices */
  relative_atoms(n_mols, mol_species, mol_first_atm, n_atoms_per_mol,
      temp_atm_mass, temp_atm_type_i, atom_rel, atom_mol, atom_mass, atom_type);

  /* Calculate box aspect ratio. */
  aspect_xy = h[1][1] / h[0][0];
  aspect_xz = h[2][2] / h[0][0];

  /* Calculate quantities that depend on box dimensions and exit
     if system is too small. */
  box_dimensions(h, h_inv);

  
      /* Calculate scaled atomic coordinates. */
      scaled_atomic_coords(n_atoms, h_inv, atom_coords,
        scaled_atom_coords);

      /* Define absolute label of the first atom and first spherocylinder
         in a molecule. */
      atom_count = 0;
      sphero_count = 0;
      for (i_mol = 0; i_mol < n_mols; ++i_mol) {
       i_species = mol_species[i_mol];
       mol_first_sphero[i_mol] = sphero_count;
       for (i = 0; i < n_bonds_per_mol[i_species]; ++i){
          sphero_mol[sphero_count + i] = i_mol;
          if (i_species == 0){
            length[sphero_count + i] = length1;
          }else length[sphero_count + i] = length2;
        }
       sphero_count += n_bonds_per_mol[i_species];
       }

   /* Compute molecular center of mass and relative "atom" coordinates. */
    center_of_mass_positions(period_switch, n_mols, n_species,
      n_atoms_per_mol,  mol_species, atom_mass, mol_first_atm,
      atom_coords, scaled_atom_coords,  scan_atm_1, scan_atm_2,
      mol_mass, h, h_inv, mol_coords, scaled_mol_coords,  rel_atom_coords,
      n_bonds_per_mol, corr);


   /* Compute center of mass and unit vector for each spherocylinder. */
   center_of_sphero(n_mols, mol_first_atm, h, length, scaled_atom_coords,
                    mol_first_sphero, s_sphero, u_sphero, mol_species, 
                    n_bonds_per_mol);


/* Plot initial configuration. */
   /* Hit Escape to exit the loop.*/
#ifdef GRAPHICS
   if (graph_switch > 0) {
      /* Read and set up color id for each atom type. */
  read_set_up_color(color_file, atm_type, n_type, &comb_col);

  /* Initialize graphics. */
  initialize(&dpy, &win, doubleBuffer, &qobj, graph_switch, antialias_switch,
             h);

      printf("\nEsc to exit from initial condition and start the main MC loop.\n");
      XBell(dpy, 100);
      keep_going = 0;
      do {
         redraw(dpy, win, doubleBuffer, qobj, graph_switch, n_mols,
                 mol_species, mol_first_atm, n_atoms_per_mol, n_bonds_per_mol,
                 mol_coords, rel_atom_coords, h, temp_bonds_1, temp_bonds_2,
                 species_choice, atom_type, comb_col,
                 resph, radius_sph, radius_cyl, &keep_going);


       } while(!keep_going);
   /* Store initial view angles. Can be reset inside the MC loop
      by pressing Esc. */
   xAngle_init = xAngle;
   yAngle_init = yAngle;
   zAngle_init = zAngle;
   }
#endif

   /* Convert pressure from reduced units into internal units. */
   pressure = pressure_star / v0;

   /* Compute various quantities, make conversions, etc. */
   du_max = ratio_du_dr * dr_max;
   for (i = 0; i < NDIM; ++i)
      ds_max[i] = dr_max / h[i][i];
   n_blocks = n_cycles / n_block;
   radians_to_degrees = 180.0 / PI;

   /* Allocate memory for various arrays used in mc_moves. */
   q_end = allocate_2d_array(3, 3, sizeof(double));
   mol_inert_mt = allocate_2d_array(n_mols, 3, sizeof(double));
   mol_inert_axis = allocate_3d_array(n_mols, 3, 3, sizeof(double));
   mol_order_inst = allocate_3d_array(n_species, 3, 3, sizeof(double));
   lambda = allocate_2d_array(n_species, 3, sizeof(double));
   v = allocate_3d_array(n_species, 3, 3, sizeof(double));
   phi = allocate_1d_array(n_species, sizeof(double));
   cos_theta = allocate_1d_array(n_species, sizeof(double));
   dr_tot = allocate_2d_array(n_atoms, 3, sizeof(double));
   dr_opt = allocate_2d_array(n_atoms, 3, sizeof(double));
   disp = allocate_2d_array(n_mols, 3, sizeof(double));
   nl_head = gcalloc(n_sphero, sizeof(nl_entry*));
   for (i_mol = 0; i_mol < n_sphero; ++i_mol) {
      nl_head[i_mol] = gmalloc(sizeof(nl_entry));
      nl_head[i_mol] -> next = NULL;
   }
   nl_tail = gcalloc(n_sphero, sizeof(nl_entry*));
   mol_coords_trial = allocate_2d_array(n_mols, 3, sizeof(double));
   atom_coords_trial = allocate_2d_array(n_atoms, 3, sizeof(double));
   scaled_atom_coords_trial = allocate_2d_array(n_atoms, 3, sizeof(double));
   s_sphero_trial = allocate_2d_array(n_sphero, 3, sizeof(double));
   end_sphero = allocate_2d_array(n_mols, 3, sizeof(double));
   polar_sphero = allocate_2d_array(n_mols, 3, sizeof(double));
   scaled_mol_unfolded = allocate_2d_array(n_mols, 3, sizeof(double));



   /* Allocate memory for scratch arrays. */
   order_temp = dmatrix(1, 3, 1, 3);
   lambda_temp = dvector(1, 3);
   v_temp = dmatrix(1, 3, 1, 3);

   /* Allocate memory for block averages. */
   h_block = allocate_2d_array(3, n_blocks, sizeof(double));
   volume_block = allocate_1d_array(n_blocks, sizeof(double));
   rho_star_block = allocate_1d_array(n_blocks, sizeof(double));
   layer_spacing_block = allocate_1d_array(n_blocks, sizeof(double));
   q_end_block = allocate_3d_array(3, 3, n_blocks, sizeof(double));
   mol_order_block =  allocate_4d_array(n_species, 3, 3, n_blocks, sizeof(double));
   cos_theta_block = allocate_2d_array(n_species, n_blocks, sizeof(double));
   phi_block = allocate_2d_array(n_species, n_blocks, sizeof(double));
   lambda_block = allocate_3d_array(n_species, 3, n_blocks, sizeof(double));
   rms_displ_block = allocate_1d_array(n_blocks, sizeof(double));
   e_bias_block = allocate_1d_array(n_blocks, sizeof(double));
   n_mol_moves_block = allocate_1d_array(n_blocks, sizeof(int));
   n_mol_accept_block = allocate_1d_array(n_blocks, sizeof(int));
   n_reshape_moves_block = allocate_1d_array(n_blocks, sizeof(int));
   n_reshape_accept_block = allocate_1d_array(n_blocks, sizeof(int));

   /* Allocate memory for averages and uncertainties. */
   h_ave = allocate_1d_array(3, sizeof(double));
   h_unc = allocate_1d_array(3, sizeof(double));
   q_end_ave = allocate_2d_array(3, 3, sizeof(double));
   q_end_unc = allocate_2d_array(3, 3, sizeof(double));
   mol_order_ave =  allocate_3d_array(n_species, 3, 3, sizeof(double));
   mol_order_unc =  allocate_3d_array(n_species, 3, 3, sizeof(double));
   lambda_ave = allocate_2d_array(n_species, 3, sizeof(double));
   lambda_unc = allocate_2d_array(n_species, 3, sizeof(double));
   cos_theta_ave = allocate_1d_array(n_species, sizeof(double));
   cos_theta_unc = allocate_1d_array(n_species, sizeof(double));
   phi_ave = allocate_1d_array(n_species, sizeof(double));
   phi_unc = allocate_1d_array(n_species, sizeof(double));

   /* Initialize neighbor lists. */

   update_neighbor_lists(n_mols, length, skin, h, s_sphero, u_sphero,
                         nl_head, nl_tail, n_sphero, sphero_mol,
                         dr_tot, scaled_mol_coords, scaled_mol_unfolded, n_atoms);

#ifdef DEBUG
   for (i = 0; i < n_sphero; ++i) {
      printf("        i_mol = %d\n\n", sphero_mol[i]);
      p = nl_head[i];
      while (p != NULL) {
        printf("%d ", sphero_mol[p -> label]);
        p = p -> next;
      }
      printf("NULL\n");
      printf("--------------------------\n");
   }
#endif

    /* Initialize variables used for optimization. */
   dr_max_old = dr_max;
   ratio_du_dr_old = ratio_du_dr;
   skin_old = skin;
   opt_time = cpu();
   efficiency = 0.0;
   n_reshape_moves_opt = n_reshape_accept_opt = 0;

   /* Zero accumulators. */
   n_mol_accept = n_reshape_accept = 0;

   /* Open output files. */
   f_thermo = gfopen("sim.thermo", "w");
   f_trajec = gfopen("sim.trajec", "w");

   /* Write header to trajectory file. */
   fwrite(&n_atoms, sizeof(int), 1, f_trajec);
/*   fwrite(&length1, sizeof(double), 1, f_trajec);
   fwrite(&length1, sizeof(double), 1, f_trajec);
*/
   fwrite(&n_cycles, sizeof(int), 1, f_trajec);
   fwrite(&n_trajec, sizeof(int), 1, f_trajec);

   /* Compute various instantaneous quantities. */
    /* Compute various instantaneous quantities. */
  /* Compute inertia tensors for each molecule. */
  inertia_tensors(n_mols, mol_species, mol_first_atm, n_atoms_per_mol,
      atom_mass, mol_mass, rel_atom_coords, mol_inert_mt, mol_inert_axis);

  /* Compute instantaneous orientational order parameters. */
  nematic_order(n_mols, n_species, mol_species, n_mols_per_species,
      mol_inert_axis, mol_order_inst, lambda, v);

  /* Use the largest eigenvalue to compute the average molecular orientation. */
  for (i_species = 0; i_species < n_species; ++i_species) {
    if (v[i_species][2][0] < 0.0)
      for (i = 0; i < 3; ++i)
        v[i_species][i][0] *= -1.0;
    cos_theta[i_species] = v[i_species][2][0];
    phi[i_species] = atan2(v[i_species][1][0], v[i_species][0][0]);
  }


   /* Write instantaneous quantities to thermodynamics file. */
   i_cycle = 0;
   fprintf(f_thermo,"%d ", i_cycle);
   for (i = 0; i < 3; ++i)
     fprintf(f_thermo, "%g ", h[i][i]);
  
   fprintf(f_thermo, "%g ", volume);
   fprintf(f_thermo, "%g ", rho_star);
   fprintf(f_thermo, "%g ", layer_spacing);

   /* Print order parameters and directors. */
  for (i_species = 0; i_species < n_species; ++i_species) {
   for (i = 0; i < 3; ++i)
      for (j = 0; j < 3; ++j)
        fprintf(f_thermo, "%g ", mol_order_inst[i_species][i][j]);
    fprintf(f_thermo, "%g ", cos_theta[i_species]);
    fprintf(f_thermo, "%g ", phi[i_species]);
    for (i = 0; i < 3; ++i)
      fprintf(f_thermo, "%g ", lambda[i_species][i]);
   }
    fprintf(f_thermo, "\n");

   /* Loop over MC cycles. */
   printf("\nEntering main MC loop\n");
   fflush(NULL);
   for (i_cycle = 1; i_cycle <= n_cycles; ++i_cycle) {

      /* Carry out MC cycle. */
      mc_cycle(n_mols, n_reshape, length1, length2, skin, h, h_inv, dr_max, 
         ds_max, du_max, reshape_axis, dside_max, &i_ran, 
         nl_head, nl_tail, dr_tot, dr_opt,
         mol_coords, scaled_mol_coords, scaled_mol_unfolded,
         atom_coords, scaled_atom_coords, rel_atom_coords,
         mol_coords_trial, atom_coords_trial, scaled_atom_coords_trial,
         s_sphero_trial, mol_first_atm, 
         n_atoms_per_mol, s_sphero, u_sphero, 
         mol_first_sphero, n_bonds_per_mol, sphero_mol,
         cell_switch, pressure, &volume, 
         &n_mol_moves, &n_mol_accept, &n_reshape_moves, &n_reshape_accept, 
         mol_species, n_atoms, n_sphero, length, disp);


#ifdef GRAPHICS
      if (graph_switch > 0 && i_cycle % n_graph == 0)
      redraw(dpy, win, doubleBuffer, qobj, graph_switch, n_mols, mol_species,
             mol_first_atm, n_atoms_per_mol, n_bonds_per_mol,
             mol_coords, rel_atom_coords, h, temp_bonds_1, temp_bonds_2,
             species_choice, atom_type, comb_col, resph, radius_sph,
             radius_cyl, &keep_going);

#endif

   /* Calculate instantaneous thermodynamic and structural quantities. */
   layer_spacing = h[2][2] / n_layers;
   rho = n_mols / volume;
   rho_star = rho * v0 ;

    /* Compute inertia tensors for each molecule. */
  inertia_tensors(n_mols, mol_species, mol_first_atm, n_atoms_per_mol,
      atom_mass, mol_mass, rel_atom_coords, mol_inert_mt, mol_inert_axis);

  /* Compute instantaneous orientational order parameters. */
  nematic_order(n_mols, n_species, mol_species, n_mols_per_species,
      mol_inert_axis, mol_order_inst, lambda, v);

   /* Use the largest eigenvalue to compute the average molecular
       orientation. */
    for (i_species = 0; i_species < n_species; ++i_species) {
      if (v[i_species][2][0] < 0.0)
        for (i = 0; i < 3; ++i)
          v[i_species][i][0] *= -1.0;
      cos_theta[i_species] = v[i_species][2][0];
      phi[i_species] = atan2(v[i_species][1][0],
          v[i_species][0][0]);
    }

     /* Write instantaneous quantities to thermodynamics file every 
        n_thermo MC cycles. */
     if (i_cycle % n_thermo == 0) {
         fprintf(f_thermo, "%d ", i_cycle);
         for (i = 0; i < 3; ++i)
            fprintf(f_thermo, "%g ", h[i][i]);
         fprintf(f_thermo, "%g ", volume);
         fprintf(f_thermo, "%g ", rho_star);
         fprintf(f_thermo, "%g ", layer_spacing);

         /* Print order parameters and directors. */
       for (i_species = 0; i_species < n_species; ++i_species) {
         for (i = 0; i < 3; ++i)
           for (j = 0; j < 3; ++j)
             fprintf(f_thermo, "%g ", mol_order_inst[i_species][i][j]);
         fprintf(f_thermo, "%g ", cos_theta[i_species]);
         fprintf(f_thermo, "%g ", phi[i_species]);
         for (i = 0; i < 3; ++i)
           fprintf(f_thermo, "%g ", lambda[i_species][i]);
         fprintf(f_thermo, "\n");
     }
  }

     /* Write instantaneous configuration to trajectory file every 
        n_trajec MC cycles. */
     if (i_cycle % n_trajec == 0) {
         write_positions_direct(f_trajec, h, n_atoms,
          atom_coords);
   /* Save final configuration. */
   write_header_direct(header_file_save, period_switch, n_species,
      n_atoms_per_mol, temp_atm_lab, temp_atm_type, temp_atm_nbr,
      temp_atm_br,  temp_atm_ord, temp_atm_pos, temp_atm_chg,
      n_bonds_per_mol, temp_bonds_1,
      temp_bonds_2, temp_bonds_ord,  n_mols_per_species, n_mols,
      mol_species);

   write_config_direct(config_file_save, h, n_atoms, length1, length2,
                dr_max, ratio_du_dr, dside_max, skin, atom_coords);
     }

     /* Calculate block index. */
      i_block = (i_cycle - 1) / n_block;

      /* Add contributions to block accumulators. */
      for (i = 0; i < 3; ++i)
         h_block[i][i_block] += h[i][i];
      volume_block[i_block] += volume;
      rho_star_block[i_block] += rho_star;
      layer_spacing_block[i_block] += layer_spacing;

      for (i_species = 0; i_species < n_species; ++i_species) {
      for (i = 0; i < 3; ++i)
        for (j = 0; j < 3; ++j)
          mol_order_block[i_species][i][j][i_block]
              +=  mol_order_inst[i_species][i][j];
      }
      n_mol_moves_block[i_block] += n_mol_moves;
      n_mol_accept_block[i_block] += n_mol_accept;
      n_reshape_moves_block[i_block] += n_reshape_moves;
      n_reshape_accept_block[i_block] += n_reshape_accept;

      /* Compute and print block averages every n_block MC cycles. */
      if (i_cycle % n_block == 0) {

         /* Calculate block averages. */
         norm = 1.0 / n_block;
         for (i = 0; i < 3; ++i)
            h_block[i][i_block] *= norm;
         volume_block[i_block] *= norm;
         rho_star_block[i_block] *= norm;
         layer_spacing_block[i_block] *= norm;

       for (i_species = 0; i_species < n_species; ++i_species) {
         for (i = 0; i < 3; ++i)
           for (j = 0; j < 3; ++j) {
              mol_order_block[i_species][i][j][i_block] *= norm;
              order_temp[i+1][j+1] =  mol_order_block[i_species][i][j][i_block];
           }
         jacobi(order_temp, 3, lambda_temp, v_temp, &nrot);
         eigsrt(lambda_temp, v_temp, 3);
         /* Copy scratch arrays into real arrays. */
         for (i = 0; i < 3; ++i) {
           lambda[i_species][i] = lambda_temp[i+1];
           for (j = 0; j < 3; ++j)
             v[i_species][i][j] = v_temp[i+1][j+1];
         }
         if (v[i_species][2][0] < 0.0)
          for (i = 0; i < 3; ++i)
            v[i_species][i][0] *= -1.0;
         cos_theta_block[i_species][i_block] = v[i_species][2][0];
         phi_block[i_species][i_block] = atan2(v[i_species][1][0], v[i_species][0][0]);
         for (i = 0; i < 3; ++i)
           lambda_block[i_species][i][i_block] = lambda[i_species][i];
        }

         mol_accept = (double) n_mol_accept_block[i_block] 
                      / n_mol_moves_block[i_block];
         if (n_reshape != 0)
            reshape_accept = (double) n_reshape_accept_block[i_block] 
                             / n_reshape_moves_block[i_block];

         /* Print block averages to standard output. */
         printf("\nBlock averages for block %d, MC cycles %d - %d\n", i_block,
            i_block * n_block + 1, (i_block + 1) * n_block);
         for (i = 0; i < 3; ++i)
            printf("   h[%d][%d] = %g\n", i,i, h_block[i][i_block]);
         printf("   volume = %g\n", volume_block[i_block]);
         printf("   rho_star = %g\n", rho_star_block[i_block]);
         printf("   layer_spacing = %g\n", layer_spacing_block[i_block]);

         for (i_species = 0; i_species < n_species;
          ++i_species) {
        printf("         i_species = %d\n", i_species);
        printf("   q = %g %g %g\n",  mol_order_block[i_species][0][0][i_block],
            mol_order_block[i_species][0][1][i_block],
            mol_order_block[i_species][0][2][i_block]);
        printf("       %g %g %g\n", mol_order_block[i_species][1][0][i_block],
            mol_order_block[i_species][1][1][i_block],
            mol_order_block[i_species][1][2][i_block]);
        printf("       %g %g %g\n", mol_order_block[i_species][2][0][i_block],
            mol_order_block[i_species][2][1][i_block],
            mol_order_block[i_species][2][2][i_block]);
        printf("   cos_theta = %g\n", cos_theta_block[i_species][i_block]);
        printf("   theta = %g degrees\n",
            acos(cos_theta_block[i_species][i_block]) *
            radians_to_degrees);
        printf("   phi = %g degrees\n",
            phi_block[i_species][i_block] * radians_to_degrees);
        for (i = 0; i < 3; ++i)
          printf("   lambda[%d] = %g\n", i,
                     lambda_block[i_species][i][i_block]);
      }

        printf("   mol_accept = %g\n", mol_accept);
       if(n_reshape !=0)
        printf("   reshape_accept = %g\n", reshape_accept);
        fflush(NULL);
      }

      /* Add contributions to optimization accumulators. */
      n_reshape_moves_opt += n_reshape_moves;
      n_reshape_accept_opt += n_reshape_accept;

      /* Optimize MC procedure every n_opt cycles. */
      if (i_cycle % n_opt == 0) {

         /* If opt_switch == 1, adjust maximum size of molecule moves to
            maximize efficiency; if opt_switch == 2, adjust ratio of
            maximum reorientation to maximum displacement to maximize
            efficiency; if opt_switch == 3, adjust neighbor list skin to
            maximize efficiency. */
         if (opt_switch == 1)
            optimize_molecule_moves(n_atoms, h, &dr_max, &dr_max_old,
                                    ds_max, &du_max, ratio_du_dr,
                                    &opt_time, &efficiency, dr_opt);
         else if (opt_switch == 2)
            optimize_ratio(n_atoms, h, dr_max, &du_max,
                           &ratio_du_dr, &ratio_du_dr_old,
                           &opt_time, &efficiency, dr_opt);
         else if (opt_switch == 3)
            optimize_skin(n_mols, h, &skin, &skin_old, 
                   &opt_time, &efficiency, dr_opt, s_sphero, u_sphero,
                   nl_head, nl_tail, dr_tot, scaled_mol_coords, 
                   scaled_mol_unfolded, n_bonds_per_mol, sphero_mol, n_atoms,
                   n_sphero, length);

         /* Calculate average acceptance rate for reshaping moves over 
            previous n_opt cycles (if some box moves are attempted). */
         if (n_reshape != 0) {
            reshape_accept_opt = (double) n_reshape_accept_opt / 
                                                       n_reshape_moves_opt;
            n_reshape_moves_opt = n_reshape_accept_opt = 0;

            /* Adjust maximum size of cell reshaping moves to achieve 
               specified acceptance rate. */
            optimize_reshape_moves(h, reshape_accept_opt, &dside_max);
         }
      }
  
  }
  /* Close output files. */
   fclose(f_thermo);
   fclose(f_trajec);

   /* Save final configuration. */
   write_header_direct(header_file_save, period_switch, n_species,
      n_atoms_per_mol, temp_atm_lab, temp_atm_type, temp_atm_nbr,
      temp_atm_br,  temp_atm_ord, temp_atm_pos, temp_atm_chg,
      n_bonds_per_mol, temp_bonds_1,
      temp_bonds_2, temp_bonds_ord,  n_mols_per_species, n_mols,
      mol_species);

   write_config_direct(config_file_save, h, n_atoms, length1, length2,
                dr_max, ratio_du_dr, dside_max, skin, atom_coords);

   /* Calculate run averages and uncertainties. */
   for (i = 0; i < 3; ++i)
      statistics(n_blocks, h_block[i], &h_ave[i], &h_unc[i]);
   statistics(n_blocks, volume_block, &volume_ave, &volume_unc);
   statistics(n_blocks, rho_star_block, &rho_star_ave, &rho_star_unc);
   statistics(n_blocks, layer_spacing_block, &layer_spacing_ave, 
              &layer_spacing_unc);

   for (i_species = 0; i_species < n_species; ++i_species) {
    for (i = 0; i < 3; ++i)
      for (j = 0; j < 3; ++j)
        statistics(n_blocks, mol_order_block[i_species][i][j],
            &mol_order_ave[i_species][i][j], &mol_order_unc[i_species][i][j]);
    for (i = 0; i < 3; ++i)
      for (j = 0; j < 3; ++j)
        order_temp[i+1][j+1] = mol_order_ave[i_species][i][j];
    jacobi(order_temp, 3, lambda_temp, v_temp, &nrot);
    eigsrt(lambda_temp, v_temp, 3);
    /* Copy scratch arrays into real arrays. */
    for (i = 0; i < 3; ++i) {
      lambda_ave[i_species][i] = lambda_temp[i+1];
      for (j = 0; j < 3; ++j)
        v[i_species][i][j] = v_temp[i+1][j+1];
    }
    if (v[i_species][2][0] < 0.0)
      for (i = 0; i < 3; ++i)
        v[i_species][i][0] *= -1.0;
    cos_theta_ave[i_species] = v[i_species][2][0];
    statistics(n_blocks, cos_theta_block[i_species],
        &dummy,  &cos_theta_unc[i_species]);
    phi_ave[i_species] = atan2(v[i_species][1][0], v[i_species][0][0]);
    statistics(n_blocks, phi_block[i_species], &dummy,
        &phi_unc[i_species]);
    for (i = 0; i < 3; ++i)
      statistics(n_blocks, lambda_block[i_species][i],
          &dummy,  &lambda_unc[i_species][i]);
  }

   n_mol_moves_tot = n_mol_accept_tot = n_reshape_moves_tot 
     = n_reshape_accept_tot = 0;
   for (i_block = 0; i_block < n_blocks; ++i_block) {
      n_mol_moves_tot += n_mol_moves_block[i_block];
      n_mol_accept_tot += n_mol_accept_block[i_block];
      n_reshape_moves_tot += n_reshape_moves_block[i_block];
      n_reshape_accept_tot += n_reshape_accept_block[i_block];
   }
   mol_accept = (double) n_mol_accept_tot / n_mol_moves_tot;
   if (n_reshape != 0)
      reshape_accept = (double) n_reshape_accept_tot / n_reshape_moves_tot;

   /* Print run averages and uncertainties to standard output. */
   printf("\nRun averages\n");
   for (i = 0; i < 3; ++i)
      printf("   h[%d][%d] = %g +/- %g\n", i,i, h_ave[i], h_unc[i]);
   printf("   volume = %g +/- %g\n", volume_ave, volume_unc);
   printf("   rho_star = %g +/- %g\n", rho_star_ave, rho_star_unc);
   printf("   layer_spacing = %g +/- %g\n", layer_spacing_ave, layer_spacing_unc);

   for (i_species = 0; i_species < n_species; ++i_species) {
    printf("   q = %g %g %g\n", mol_order_ave[i_species][0][0],

        mol_order_ave[i_species][0][1], mol_order_ave[i_species][0][2]);
    printf("       %g %g %g\n", mol_order_ave[i_species][1][0],
        mol_order_ave[i_species][1][1], mol_order_ave[i_species][1][2]);
    printf("       %g %g %g\n", mol_order_ave[i_species][2][0],

        mol_order_ave[i_species][2][1], mol_order_ave[i_species][2][2]);
    printf("   cos_theta = %g +/- %g\n", cos_theta_ave[i_species],

        cos_theta_unc[i_species]);
    printf("   theta = %g degrees\n", acos(cos_theta_ave[i_species])
        * radians_to_degrees);
    printf("   phi = %g +/- %g degrees\n", phi_ave[i_species]
        * radians_to_degrees, phi_unc[i_species] * radians_to_degrees);
    for (i = 0; i < 3; ++i)
      printf("   lambda[%d] = %g +/- %g\n", i,
          lambda_ave[i_species][i],  lambda_unc[i_species][i]);
  }
   printf("   mol_accept = %g\n", mol_accept);
   printf("   reshape_accept = %g\n", reshape_accept);
   fflush(NULL);

   exit(0);
}
/****************************************************************************/
/* Set up array of relative atom indices. */
void relative_atoms(int n_mols, int *mol_species, int *mol_first_atm,
   int *n_atoms_per_mol, double **temp_atm_mass, int **temp_atm_type_i,
   int *atom_rel, int *atom_mol, double *atom_mass, int *atom_type)
{
  int i_species, skip, i, i_mol, i_rel;

  /* Set up array of atomic properties. */
  for (i_mol = 0; i_mol < n_mols; ++i_mol) {
    i_species = mol_species[i_mol];
    skip = mol_first_atm[i_mol];
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
      i = skip + i_rel;
      atom_rel[i] = i_rel;
      atom_mol[i] = i_mol;
      atom_mass[i] = temp_atm_mass[i_species][i_rel];
      atom_type[i] = temp_atm_type_i[i_species][i_rel];
    }
  }

}
#undef RMS_MAX
