#define GRAPHICS   

/* Include header files for system libraries. */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/time.h>
#include <sys/resource.h>

#ifdef GRAPHICS
/* Include the OpenGL and XWindows libraries. */
#include <GL/glx.h>           /* the GL extension for X. */ 
#include <GL/gl.h>
#include <GL/glu.h>
#include <X11/keysym.h>
#endif

#include "color.h"
#include "nr.h"
#include "nrutil.h"
#include "allocate.h"


/* Macro definitions. */
#define SQR(x)             ((x) * (x))
#define CUBE(x)            ((x) * (x) * (x))
#define ABS(x)             ((x) < 0 ? -(x) : (x))
#define MAX(x,y)           ((x) > (y) ? (x) : (y))
#define MIN(x,y)           ((x) < (y) ? (x) : (y))
#define SIGN(a,b)          ((b) > 0.0 ? fabs(a) : -fabs(a))
#define NINT(x)            ((x) < 0.0 ? (int) ((x) - 0.5) : (int) ((x) + 0.5))
#define ROTATE(a,i,j,k,l)  g=a[i][j];h=a[k][l];a[i][j]=g-s*(h+g*tau);\
                           a[k][l]=h+s*(g-h*tau);
#define NDIM                    3
#define TYPE_MAX                9
#define MAX_LINE                200
#define F_MAX                   200
#define TWO_PI              6.28318530718
#define PI                  3.1415927

static double dmaxarg1,dmaxarg2;
#define DMAX(a,b) (dmaxarg1=(a),dmaxarg2=(b),(dmaxarg1) > (dmaxarg2) ?\
   (dmaxarg1) : (dmaxarg2))

static int iminarg1,iminarg2;
#define IMIN(a,b) (iminarg1=(a),iminarg2=(b),(iminarg1) < (iminarg2) ?\
        (iminarg1) : (iminarg2))

/* Structure definitions. */
struct neighb_list {
   int label;                 /* Label of neighboring molecule. */
   struct neighb_list *next;  /* Pointer to next entry in neighbor list. */
};

typedef struct neighb_list nl_entry;

/* Definition of global variables. Variables used by OpenGL. I just was
   lazy.*/
#ifdef MAIN
GLfloat         xAngle = 90.0, yAngle = 0.0, zAngle = .0,
                xTrans = 0.95, yTrans = 0.0, zTrans = -24,
                xAngle_init, yAngle_init, zAngle_init;
#else
extern GLfloat         xAngle, yAngle, zAngle, xTrans, yTrans, zTrans,
                       xAngle_init, yAngle_init, zAngle_init;
#endif


