#include "shared.h"

/*****************************************************************************/
/* Calculate scaled atomic coordinates for a single molecule. */
/*
input :
       Label of the molecule inserted (i_mol)
       Array of number of atoms per template molecule (n_atoms_per_mol)
       Array of first atomic site in each molecule (mol_first_atm)
       Array of the label of molecules (mol_species)
       Array of the inverse box matrix (side_inv)
       Array of atomic coordinates (atom_coords)
output :
       Array of scaled atomic coordinates (s)
*/

void scaled_atomic_coords_single_old(int i_mol, int n_atoms_per_mol,
       int *mol_first_atm, double *side_inv,
       double **atom_coords, double **scaled_atom_coords)
{
   int i_species, skip, i;

   skip = mol_first_atm[i_mol];
   for (i = skip; i < skip + n_atoms_per_mol; ++i) {
      scaled_atom_coords[i][0] = side_inv[0] * atom_coords[i][0];
      scaled_atom_coords[i][1] = side_inv[1] * atom_coords[i][1];
      scaled_atom_coords[i][2] = side_inv[2] * atom_coords[i][2];
   }
}

/********************************************************************************/
/* Apply periodic boundary conditions to a single molecule. */
void periodic_boundary_conditions_single_old(int i_mol, int n_atoms_per_mol,
       int *mol_first_atm, double *side,
       double **atom_coords, double **scaled_atom_coords)

{
   int skip, i;

   skip = mol_first_atm[i_mol];
   for (i = skip; i < skip + n_atoms_per_mol; ++i) {
      scaled_atom_coords[i][0] -= NINT(scaled_atom_coords[i][0]);
      scaled_atom_coords[i][1] -= NINT(scaled_atom_coords[i][1]);
      scaled_atom_coords[i][2] -= NINT(scaled_atom_coords[i][2]);
      atom_coords[i][0] = side[0] * scaled_atom_coords[i][0];
      atom_coords[i][1] = side[1] * scaled_atom_coords[i][1];
      atom_coords[i][2] = side[2] * scaled_atom_coords[i][2];
   }
}

/*****************************************************************************/
/* Calculate scaled atomic coordinates for a single molecule. */
/*
input :
       Label of the molecule inserted (i_mol)
       Array of number of atoms per template molecule (n_atoms_per_mol)
       Array of first atomic site in each molecule (mol_first_atm)
       Array of the label of molecules (mol_species)
       Array of the inverse box matrix (side_inv)
       Array of atomic coordinates (atom_coords)
output :
       Array of scaled atomic coordinates (s)
*/

void scaled_atomic_coords_single(double *side_inv, double **atom_coords, 
                                 double **scaled_atom_coords)
{
   int i;

   for (i = 0; i < 3; ++i) {
      scaled_atom_coords[i][0] = side_inv[0] * atom_coords[i][0];
      scaled_atom_coords[i][1] = side_inv[1] * atom_coords[i][1];
      scaled_atom_coords[i][2] = side_inv[2] * atom_coords[i][2];
   }
}

/********************************************************************************/
/* Apply periodic boundary conditions to a single molecule. */
void periodic_boundary_conditions_single(double *side,
       double **atom_coords, double **scaled_atom_coords)

{
   int skip, i;

   for (i = 0; i < 3; ++i) {
      scaled_atom_coords[i][0] -= NINT(scaled_atom_coords[i][0]);
      scaled_atom_coords[i][1] -= NINT(scaled_atom_coords[i][1]);
      scaled_atom_coords[i][2] -= NINT(scaled_atom_coords[i][2]);
      atom_coords[i][0] = side[0] * scaled_atom_coords[i][0];
      atom_coords[i][1] = side[1] * scaled_atom_coords[i][1];
      atom_coords[i][2] = side[2] * scaled_atom_coords[i][2];
   }
}

/*****************************************************************************/
/* Calculate scaled atomic coordinates. */
/* Calculate scaled atomic coordinates. */
/*
input :
       Total number of atoms (n_atoms)
       Array of the inverse box matrix (h_inv)
       Array of atomic coordinates (atom_coords)
output :
       Array of scaled atomic coordinates (scaled_atom_coords)
*/

void scaled_atomic_coords(int n_mol, double *side_inv, double **atom_coords,
   double **scaled_atom_coords)
{
   int i;

   for (i = 0; i < 3*n_mol; ++i) {
      scaled_atom_coords[i][0] = side_inv[0] * atom_coords[i][0];
      scaled_atom_coords[i][1] = side_inv[1] * atom_coords[i][1];
      scaled_atom_coords[i][2] = side_inv[2] * atom_coords[i][2];
   }
}
/********************************************************************************/
/* Apply periodic boundary conditions to a single molecule. */
void periodic_boundary_conditions(int n_mol, double *side,
       double **atom_coords, double **scaled_atom_coords)

{
   int  i;

   for (i = 0; i < 3*n_mol; ++i) {
      scaled_atom_coords[i][0] -= NINT(scaled_atom_coords[i][0]);
      scaled_atom_coords[i][1] -= NINT(scaled_atom_coords[i][1]);
      scaled_atom_coords[i][2] -= NINT(scaled_atom_coords[i][2]);
      atom_coords[i][0] = side[0] * scaled_atom_coords[i][0];
      atom_coords[i][1] = side[1] * scaled_atom_coords[i][1];
      atom_coords[i][2] = side[2] * scaled_atom_coords[i][2];
   }
}
