/* Routine for parsing input parameters from a data file. */

#include "build.h"


/* parse_params reads input parameters from a data file.

input: name of input parameter file (param_file)
       pointer to system initialization switch (start_switch)
       pointer to system initialization polar switch (polar_switch)
       pointer to name of configuration file (config_file)
       pointer to number of molecules (n_mol)
       pointer to length of molecules (length)
       pointer to reduced density (rho_star)
       pointer to aspect ratio of system in x-y plane (aspect_xy)
       pointer to aspect ratio of system in x-z plane (aspect_xz)
       pointer to number of smectic layers (n_layers)
       pointer to smectic layer spacing (layer_spacing)
       pointer to neighbor list skin (skin)
       pointer to maximum attempted displacement of molecule (dr_max)
       pointer to ratio of molecular reorientations to molecular 
         displacements (ratio_du_dr)
       pointer to maximum attempted relative change in linear dimension 
         of unit cell (dside_max)
       pointer to unique axis for reshaping move (reshape_axis)
       pointer to number of reshaping moves per MC cycle (n_reshape)
       pointer to switch indicating what type of biasing potential 
         is applied (bias_switch)
       pointer to strength of tilt biasing potential (k_theta)
       pointer to position of minimum of tilt biasing potential (theta_equil)
       pointer to interlayer phase increment for modulated director field (dphi)
       pointer to strength of rms displacement biasing potential (k_displ)
       pointer to position of minimum of rms displacement biasing 
         potential (rms_displ_equil)
       pointer to out-of-layer displacement flag (displ_flag)
       pointer to maximum out-of-layer displacement (displ_max)
       pointer to number of MC cycles (n_cycles)
       pointer to number of MC cycles per block (n_block)
       pointer to thermodynamics output interval (n_thermo)
       pointer to trajectory output interval (n_trajec)
       pointer to MC procedure optimization flag (opt_switch)
       pointer to MC procedure optimization interval (n_opt)
       pointer to number of bins in director tilt distribution 
         function (n_cos_theta)
       pointer to number of bins in rms displacement distribution 
         function (n_rms_displ)
       pointer to graphics flag (graph_switch)
       pointer to graphics display interval (n_graph)
       pointer to seed for random number generator (i_ran)

output: the values of any parameters that are found in the parameter file
           are modified upon output. */

void parse_params(char *param_file, char **header_file, char **config_file,
                  char **mass_file, char **color_file, 
                  char **header_file_save, char **config_file_save, 
                  double *pressure_star, 
                  int *n_layers, double *layer_spacing, double *skin,
                  double *dr_max, double *ratio_du_dr, double *dside_max,
                  int *reshape_axis, int *n_reshape, int *bias_switch, 
                  int *cell_switch,
                  double *k_theta, double *theta_equil, double *dphi,
                  double *k_displ, double *rms_displ_equil,
                  int *displ_flag, double *displ_max,
                  int *n_cycles, int *n_block, int *n_thermo, int *n_trajec,
                  int *opt_switch, int *n_opt,
                  int *n_cos_theta, int *n_rms_displ,
                  int *graph_switch, int *n_graph,
                  long *i_ran, double *open_angle, int *end_vec_switch,
                  double *radius_sph, double *radius_cyl, int *resph,
                  int *antialias_switch, int *species_choice)
{
   FILE *f_param;
   char line[MAX_LINE], *param_name, *param_value, **token = NULL;
   int n_tokens;

   printf("\nReading input parameters from %s\n", param_file);

   /* Open parameter file. */
   f_param = gfopen(param_file, "r");

   /* Read through file. */
   while (fgets(line, MAX_LINE, f_param) != NULL) {
      if (strncmp(line, "#", 1) != 0) {
         n_tokens = parse_tokens(line, &token);
         if (n_tokens == 3 && strcmp(token[1], "=") == 0) {
            param_name = token[0];
            param_value = token[2];
            if (strcmp(param_name, "header_file") == 0) {
               *header_file = gmalloc(strlen(param_value) * sizeof(char));
               strcpy(*header_file, param_value);
               printf("   header_file = %s\n", *header_file);
            }
            else if (strcmp(param_name, "config_file") == 0) {
               *config_file = gmalloc(strlen(param_value) * sizeof(char));
               strcpy(*config_file, param_value);
               printf("   config_file = %s\n", *config_file);
            }
            else if (strcmp(param_name, "mass_file") == 0) {
               *mass_file = gmalloc(strlen(param_value) * sizeof(char));
               strcpy(*mass_file, param_value);
               printf("   mass_file = %s\n", *mass_file);
            }
            else if (strcmp(param_name, "color_file") == 0) {
               *color_file = gmalloc(strlen(param_value) * sizeof(char));
               strcpy(*color_file, param_value);
               printf("   color_file = %s\n", *color_file);
            }
            else if (strcmp(param_name, "header_file_save") == 0) {
               *header_file_save = gmalloc(strlen(param_value) * sizeof(char));
               strcpy(*header_file_save, param_value);
               printf("   header_file_save = %s\n", *header_file_save);
            }
            else if (strcmp(param_name, "config_file_save") == 0) {
               *config_file_save = gmalloc(strlen(param_value) * sizeof(char));
               strcpy(*config_file_save, param_value);
               printf("   config_file_save = %s\n", *config_file_save);
            }
            else if (strcmp(param_name, "pressure_star") == 0) {
               *pressure_star = atof(param_value);
               printf("   pressure_star = %g\n", *pressure_star);
            }
            else if (strcmp(param_name, "n_layers") == 0) {
               *n_layers = atoi(param_value);
               printf("   n_layers = %d\n", *n_layers);
            }
            else if (strcmp(param_name, "layer_spacing") == 0) {
               *layer_spacing = atof(param_value);
               printf("   layer_spacing = %g\n", *layer_spacing);
            }
            else if (strcmp(param_name, "skin") == 0) {
               *skin = atof(param_value);
               printf("   skin = %g\n", *skin);
            }
            else if (strcmp(param_name, "dr_max") == 0) {
               *dr_max = atof(param_value);
               printf("   dr_max = %g\n", *dr_max);
            }
            else if (strcmp(param_name, "ratio_du_dr") == 0) {
               *ratio_du_dr = atof(param_value);
               printf("   ratio_du_dr = %g\n", *ratio_du_dr);
            }
            else if (strcmp(param_name, "dside_max") == 0) {
               *dside_max = atof(param_value);
               printf("   dside_max = %g\n", *dside_max);
            }
            else if (strcmp(param_name, "reshape_axis") == 0) {
               *reshape_axis = atoi(param_value);
               printf("   reshape_axis = %d\n", *reshape_axis);
            }
            else if (strcmp(param_name, "n_reshape") == 0) {
               *n_reshape = atoi(param_value);
               printf("   n_reshape = %d\n", *n_reshape);
            }
            else if (strcmp(param_name, "bias_switch") == 0) {
               *bias_switch = atoi(param_value);
               printf("   bias_switch = %d\n", *bias_switch);
            }
            else if (strcmp(param_name, "cell_switch") == 0) {
               *cell_switch = atoi(param_value);
               printf("   cell_switch = %d\n", *cell_switch);
            }
            else if (strcmp(param_name, "k_theta") == 0) {
               *k_theta = atof(param_value);
               printf("   k_theta = %g\n", *k_theta);
            }
            else if (strcmp(param_name, "theta_equil") == 0) {
               *theta_equil = atof(param_value);
               printf("   theta_equil = %g degrees\n", *theta_equil);
            }
            else if (strcmp(param_name, "dphi") == 0) {
               *dphi = atof(param_value);
               printf("   dphi = %g degrees\n", *dphi);
            }
            else if (strcmp(param_name, "k_displ") == 0) {
               *k_displ = atof(param_value);
               printf("   k_displ = %g\n", *k_displ);
            }
            else if (strcmp(param_name, "rms_displ_equil") == 0) {
               *rms_displ_equil = atof(param_value);
               printf("   rms_displ_equil = %g degrees\n", *rms_displ_equil);
            }
            else if (strcmp(param_name, "displ_flag") == 0) {
               *displ_flag = atoi(param_value);
               printf("   displ_flag = %d\n", *displ_flag);
            }
            else if (strcmp(param_name, "displ_max") == 0) {
               *displ_max = atof(param_value);
               printf("   displ_max = %g\n", *displ_max);
            }
            else if (strcmp(param_name, "n_cycles") == 0) {
               *n_cycles = atoi(param_value);
               printf("   n_cycles = %d\n", *n_cycles);
            }
            else if (strcmp(param_name, "n_block") == 0) {
               *n_block = atoi(param_value);
               printf("   n_block = %d\n", *n_block);
            }
            else if (strcmp(param_name, "n_thermo") == 0) {
               *n_thermo = atoi(param_value);
               printf("   n_thermo = %d\n", *n_thermo);
            }
            else if (strcmp(param_name, "n_trajec") == 0) {
               *n_trajec = atoi(param_value);
               printf("   n_trajec = %d\n", *n_trajec);
            }
            else if (strcmp(param_name, "opt_switch") == 0) {
               *opt_switch = atoi(param_value);
               printf("   opt_switch = %d\n", *opt_switch);
            }
            else if (strcmp(param_name, "n_opt") == 0) {
               *n_opt = atoi(param_value);
               printf("   n_opt = %d\n", *n_opt);
            }
            else if (strcmp(param_name, "n_cos_theta") == 0) {
               *n_cos_theta = atoi(param_value);
               printf("   n_cos_theta = %d\n", *n_cos_theta);
            }
            else if (strcmp(param_name, "n_rms_displ") == 0) {
               *n_rms_displ = atoi(param_value);
               printf("   n_rms_displ = %d\n", *n_rms_displ);
            }
            else if (strcmp(param_name, "graph_switch") == 0) {
               *graph_switch = atoi(param_value);
               printf("   graph_switch = %d\n", *graph_switch);
            }
            else if (strcmp(param_name, "n_graph") == 0) {
               *n_graph = atoi(param_value);
               printf("   n_graph = %d\n", *n_graph);
            }
            else if (strcmp(param_name, "i_ran") == 0) {
               *i_ran = atoi(param_value);
               printf("   i_ran = %ld\n", *i_ran);
            }
            else if (strcmp(param_name, "open_angle") == 0) {
               *open_angle = atof(param_value);
               printf("   open_angle = %g degrees\n", *open_angle);
            }
            else if (strcmp(param_name, "end_vec_switch") == 0) {
               *end_vec_switch = atoi(param_value);
               printf("   end_vec_switch = %d\n", *end_vec_switch);
            }
            else if (strcmp(param_name, "radius_sph") == 0) {
               *radius_sph = atof(param_value);
               printf("   radius_sph = %g\n", *radius_sph);
            }
            else if (strcmp(param_name, "radius_cyl") == 0) {
               *radius_cyl = atof(param_value);
               printf("   radius_cyl = %g\n", *radius_cyl);
            }
            else if (strcmp(param_name, "resph") == 0) {
               *resph = atoi(param_value);
               printf("   resph = %d\n", *resph);
            }
            else if (strcmp(param_name, "antialias_switch") == 0) {
               *antialias_switch = atoi(param_value);
               printf("   antialias_switch = %d\n", *antialias_switch);
            }
            else if (strcmp(param_name, "species_choice") == 0) {
               *species_choice = atoi(param_value);
               printf("   species_choice = %d\n", *species_choice);
            }
            else {
               fprintf(stderr, "Invalid parameter, %s, found in %s\n", param_name, param_file);
               exit(1);
            }
         }
         else {
            fprintf(stderr, "Invalid record, %s, found in %s\n", line, param_file);
            exit(1);
         }
/*         free_2d_array(token, n_tokens);*/
      }
   }

   /* Close parameter file. */
   fclose(f_param);

   fflush(NULL);

   return;
}

