#define MAIN
#include "build.h"
#undef MAIN
#include "ff.h"
#include "proto.h"

main(int argc, char *argv[])
{
int skip, abs;
int i, j, i_atoms, i_species, n_species, n_unit_cells, n_mols, n_atoms;
int period_switch, vdw_rad_switch, init_switch, trial_switch;
int found;
/* Random generator */
long i_ran, seed;
/* Declare parameters used to build the initial state and box matrices*/
int n_layers;
double rho, aspect_xy, aspect_xz, volume, layer_spacing;
double **h, **h_inv;
/* Declare and initialize (NULL pointers for Linux!) force field parameters. */
int n_mass = 0, n_lj = 0, n_e6 = 0, n_type = 0;
mass_entry *mass = NULL;
lj_entry *lj = NULL;
e6_entry *e6 = NULL;
pot_entry *pot = NULL;
type_entry *atm_type = NULL;
/* File names */
char par_file[F_MAX], *mass_file, *lj_file, *e6_file, *pot_file, **struct_file, 
   *header_file, *config_file;
/* Declare and initialize molecular structure parameters. */
int *n_atoms_per_mol = NULL, *n_mols_per_species = NULL, 
  *n_bonds_per_mol = NULL, **temp_atm_lab, **temp_atm_nbr, ***temp_atm_br,
  **temp_atm_type_i;
double ***temp_atm_pos, **temp_atm_mass, **temp_atm_chg, **temp_atm_sigma, 
   **temp_atm_eps, ***temp_atm_ord;
char ***temp_atm_type;
int **temp_bonds_1 = NULL, **temp_bonds_2 = NULL;
double **temp_bonds_ord = NULL;
int *n_mols_per_unit_cell, *mol_species;
/* Declare some arrays used in set up force field */
double *mol_mass, *mol_mass_true;
int *mol_first_atm;
/* Declare combination and exclusion arrays */
double overlap_criterion, **combine;
int **comb_pot;
double ***comb_par;
/* Declare arrays used in build */
double **scaled_atom_coords, **mol_coords, **scaled_mol_coords, **atom_coords,
 **atom_vels, **rel_atom_coords;
int *atom_rel, *atom_type = NULL;
/* Array of the chosen principal molecular axe. */
int *principal;
/* Pore parameters. */
int pore_switch, graph_pore_switch;
double x0, y0, z0, r0;

  /* Graphic parameters */
  double radius_sph, radius_cyl;
  int graph_switch, resph, antialias_switch, species_choice, keep_going,
    *comb_col, x_cut_switch;
  char *color_file;

  /* OpenGL/X variables declaration. */
  Display *dpy;
  Window win;
  GLboolean doubleBuffer = GL_TRUE;
  GLUquadricObj *qobj;

/* Get command line input. */
if (argc != 2) {
        printf("Usage: %s params_file\n", argv[0]);
        exit(1);
    }
strcpy(par_file, argv[1]);

/* Read in input parameter file. */
read_new_build_params(par_file, &mass_file, &pot_file, 
   &period_switch, &n_species, &n_mols_per_unit_cell, &struct_file, 
   &trial_switch, &vdw_rad_switch, &overlap_criterion, &init_switch, 
   &n_layers, &layer_spacing, &rho, &n_unit_cells, &aspect_xy, &aspect_xz, 
   &principal, &pore_switch, &r0, &z0, &graph_pore_switch, &seed, 
   &header_file, 
   &config_file, &graph_switch, &color_file, &species_choice, &radius_sph, 
   &radius_cyl, &resph, &antialias_switch, &x_cut_switch);

printf("mass_file = %s\n",mass_file);
printf("pot_file = %s\n",pot_file);
printf("period_switch = %d\n",period_switch);
printf("n_species = %d\n",n_species);
for (i_species = 0; i_species < n_species; ++i_species)
  printf("n_mol_per_unitcell = %d, struct_file = %s\n",
     n_mols_per_unit_cell[i_species], struct_file[i_species]);
printf("trial_switch = %d\n",trial_switch);
printf("vdw_rad_switch = %d, overlap = %g\n",vdw_rad_switch,overlap_criterion);
printf("init_switch = %d, n_layers = %d, layer_spac = %g\n",init_switch,n_layers,layer_spacing);
printf("rho = %g\n",rho);
printf("n_unit_cells = %d\n",n_unit_cells);
printf("aspect_xy = %g, aspect_xz = %g\n",aspect_xy, aspect_xz);
for (i_species = 0; i_species < n_species; ++i_species)
  printf("principal = %d\n",principal[i_species]);
printf("pore_switch = %d, r0 = %g, z0 = %g\n",pore_switch, r0, z0);
printf("graph_pore_switch = %d\n", graph_pore_switch);
printf("seed = %ld\n",seed);
printf("header_file = %s, config_file = %s\n",header_file,config_file);
printf("graph_switch = %d\n", graph_switch);
printf("color_file = %s\n", color_file);
printf("species_choice = %d\n", species_choice);
printf("radius_sph = %g, radius_cyl = %g\n", radius_sph, radius_cyl);
printf("resph = %d, antialias_switch = %d\n", resph, antialias_switch);
printf("x_cut_switch = %d\n", x_cut_switch);

/* Check input. */
   if ((init_switch < 0) || (init_switch > 7))
      error_exit("init_switch must be between 0 and 6");

   if (((init_switch == 4) || (init_switch == 5) || (init_switch == 6)
       || (init_switch == 7)) && (!pore_switch))
       error_exit("Init options 4, 5, 6, 7 are valid only if pore_switch = 1");

   if ((init_switch == 6) || (init_switch == 7)){
     found = 0;
     for (i_species = 0; i_species < n_species; ++i_species)
       if (n_mols_per_unit_cell[i_species] == 1)
           found += 1;
     if ((found == 0)||(found == 2))
        error_exit("One specie should have only one molecule \n (single chain in a pore)"); 
   }

   if (((init_switch == 6) || (init_switch == 7)) && (trial_switch == 1))
      error_exit("With init_switch == 6, 7, the single chain should be inserted first (use trial_switch == 0)");

/* Initialize random number generator. */
   i_ran = - seed;
   ran3(&i_ran);

/* Set up infomations about template atoms and bonds. */
start_new_build(struct_file, &i_ran, trial_switch, n_species, n_unit_cells, 
  n_mols_per_unit_cell, &n_atoms_per_mol, &n_mols_per_species, 
  &n_bonds_per_mol, &temp_atm_lab, &temp_atm_type, &temp_atm_pos, 
  &temp_atm_chg, &temp_atm_nbr, &temp_atm_br, &temp_atm_ord, &temp_bonds_1, 
  &temp_bonds_2, &temp_bonds_ord, &n_mols, &n_atoms, &mol_species);

  /* Read FF masses file. */
  read_mass_params(mass_file, &mass, &n_mass);

  /* Set up force field data for masses. */
  set_up_force_field(n_species, n_mols, n_atoms_per_mol, n_mass,
      mass, mol_species, n_bonds_per_mol, &temp_atm_mass, temp_atm_type,
      &mol_mass, &mol_mass_true, &mol_first_atm);

  /* Convert string tags to integer identifiers. */
  /* Create an integer identifier corresponding to template atom type. */
  convert_type(n_species, n_atoms_per_mol, temp_atm_type, &temp_atm_type_i,
     &atm_type, &n_type);

  /* if we consider a pore, add one more integer identifier for the
     walls. This entry cannot be process before because it's not an
     atom type (i.e not read from the structure file). */
  if (pore_switch)
    add_type(&atm_type, &n_type);

  /* Read and Set up force field data for potential interactions. */
  read_set_up_pot(pot_file, vdw_rad_switch, atm_type, n_type, &comb_pot, 
    &comb_par);

/* Precompute overlap criterion for template atomic sites. */
combination_array(overlap_criterion, n_type, comb_pot, comb_par, &combine);
for (i = 0; i < n_type; ++i)
  for (j = 0; j < n_type; ++j)
  printf("type %d %d, com = %g\n", i, j, combine[i][j]);

/* Allocate memory for arrays used in the builder. */
allocate_memory_build(n_atoms, n_mols, period_switch, &atom_coords, 
   &scaled_atom_coords, &rel_atom_coords, &atom_vels, &atom_rel, &atom_type, 
   &mol_coords, &scaled_mol_coords, &h, &h_inv);

/* Set array of relative atom indices */
relative_atoms(n_mols, mol_species, mol_first_atm, n_atoms_per_mol, temp_atm_type_i, atom_rel, atom_type);

/* Compute cartesian dimensions of the pore. */
if (pore_switch)
   x0 = y0 = r0 / sqrt(2.0);

/* Choose initial state to be built and compute box dimensions*/
if (init_switch == 1 || init_switch == 2 || init_switch == 7)
	{
        h[0][0] = pow(n_mols / (aspect_xy * aspect_xz * rho), 1.0 / 3.0);
        h[1][1] = aspect_xy * h[0][0];
        h[2][2] = aspect_xz * h[0][0];

        if (pore_switch){
          h[0][0] = pow((n_mols / 2.0 - PI * SQR(r0) * z0 * rho)
                         / (aspect_xy * aspect_xz * rho), 1.0 / 3.0);  
          h[1][1] = aspect_xy * h[0][0];
          h[2][2] = 2.0 * aspect_xz * h[0][0] + 2.0 * z0;
/*          volume = 2.0 * h[0][0] * h[1][1] * (h[2][2]/2.0 - z0) + 2 * PI * SQR(r0) * z0;
printf("rho = %g\n", n_mols / volume);
exit(1);
*/
          }
	}
else if (init_switch == 3)
        {
        h[2][2] = n_layers * layer_spacing;
        h[0][0] = sqrt(n_mols / (aspect_xy * rho * h[2][2]));
        h[1][1] = aspect_xy * h[0][0];
	}
/* It's also for isotropic (or nematic) but with a pore. */
else if (((init_switch == 4) || (init_switch == 5) 
           || (init_switch == 6)) && (pore_switch))
        {
        h[0][0] = 6.0 * r0 * aspect_xy; /* when aspect_xy == 1, transverse
                                           length of the box is 3 D (D being
                                           the pore diameter. */
        h[1][1] = h[0][0];
        h[2][2] = (n_mols / 2.0 - PI * SQR(r0) * z0 * rho)
                  / (SQR(h[0][0]) * rho);
	}
printf("hxx = %g, hyy = %g, hzz = %g\n", h[0][0], h[1][1], h[2][2]);
h[0][1] = h[0][2] = h[1][2] = 0.0;  /* Orthorombic box */

/* Adjust pore dimensions. */
if (pore_switch){
  if (2 * x0 > h[0][0])
    x0 = h[0][0] / 2.0;
  if (2 * y0 > h[1][1])
    y0 = h[1][1] / 2.0;
  if (2 * z0 > h[2][2])
    z0 = h[2][2] / 2.0;
}

/* Calculate quantities which depend of box dimensions */
box_inverse(h, h_inv);

/* Adjust template molecule coordinates */
adjust_template_molecules(n_species, n_atoms_per_mol, principal, 
   temp_atm_mass, temp_atm_pos);

#ifdef GRAPHICS
  /* Initialize graphics. */
  initialize(&dpy, &win, doubleBuffer, &qobj, graph_switch, antialias_switch,
             h);

  /* Read and set up color id for each atom type. */
  read_set_up_color(color_file, atm_type, n_type, &comb_col);
#endif

/* Generate initial condition. */
if ((init_switch == 1) || (init_switch == 4))
       isotropic_start(dpy, win, doubleBuffer, qobj, &graph_switch, 
          &graph_pore_switch, n_mols, n_species, 
          &i_ran, mol_first_atm, n_atoms_per_mol, 
          mol_species, atom_rel, n_type, atom_type, temp_atm_pos, h, h_inv, 
          mol_coords,
          scaled_mol_coords, atom_coords, scaled_atom_coords, rel_atom_coords,
          combine, pore_switch, z0, r0,
          n_bonds_per_mol, temp_bonds_1, temp_bonds_2, &species_choice,
          comb_col, resph, radius_sph, &radius_cyl, x_cut_switch);
   else if ((init_switch == 2) || (init_switch == 5))
        nematic_start(dpy, win, doubleBuffer, qobj, &graph_switch, 
          &graph_pore_switch, n_mols, n_species, 
          &i_ran, mol_first_atm, n_atoms_per_mol, 
          mol_species, atom_rel, n_type, atom_type, temp_atm_pos, h, h_inv, 
          mol_coords,
          scaled_mol_coords, atom_coords, scaled_atom_coords, rel_atom_coords,
          combine, pore_switch, z0, r0,
          n_bonds_per_mol, temp_bonds_1, temp_bonds_2, &species_choice,
          comb_col, resph, radius_sph, &radius_cyl, x_cut_switch);
   else if (init_switch == 3)
        smectic_start(dpy, win, doubleBuffer, qobj, &graph_switch, 
          &graph_pore_switch, n_mols, 
          n_species, &i_ran, n_layers, n_mols_per_species,
          mol_first_atm, n_atoms_per_mol, mol_species, atom_rel, n_type, 
          atom_type,
          temp_atm_pos, h, h_inv, mol_coords, scaled_mol_coords, 
          atom_coords, scaled_atom_coords, rel_atom_coords, combine, 
          pore_switch, z0, r0, n_bonds_per_mol, 
          temp_bonds_1, temp_bonds_2, &species_choice, comb_col, resph, 
          radius_sph, &radius_cyl, x_cut_switch);
   else if ((init_switch == 6) || (init_switch == 7))
        single_start(dpy, win, doubleBuffer, qobj, &graph_switch, 
          &graph_pore_switch, n_mols, n_species, 
          &i_ran, mol_first_atm, n_atoms_per_mol, 
          mol_species, n_mols_per_species, atom_rel, n_type, 
          atom_type, temp_atm_pos, h, h_inv, mol_coords,
          scaled_mol_coords, atom_coords, scaled_atom_coords, rel_atom_coords,
          combine, pore_switch, z0, r0,
          n_bonds_per_mol, temp_bonds_1, temp_bonds_2, &species_choice,
          comb_col, resph, radius_sph, &radius_cyl, x_cut_switch);


/* Write information about template molecules and atoms to header file */
write_header_direct(header_file, period_switch, n_species, n_atoms_per_mol, 
  temp_atm_lab, temp_atm_type, temp_atm_nbr, temp_atm_br, temp_atm_ord, 
  temp_atm_pos, temp_atm_chg, n_bonds_per_mol, temp_bonds_1, temp_bonds_2, 
  temp_bonds_ord, n_mols_per_species, n_mols, mol_species);

/* Write box dimension and atomic coordinates and velocities to 
   configuration file */
write_config_direct(config_file, period_switch, h, n_atoms, atom_coords,
  atom_vels);

  /* Initialize graphics. */
#ifdef GRAPHICS
 if (graph_switch > 0) {

  /* Plot initial configuration. Hit Escape to exit the loop.*/
  printf("\nEsc to start the MC simulation.\n");
  XBell(dpy, 100);
  keep_going = 0;
  do {
      redraw(dpy, win, doubleBuffer, qobj, &graph_switch, n_mols, mol_species,
             mol_first_atm, n_atoms_per_mol, n_bonds_per_mol,
             mol_coords, rel_atom_coords, h, temp_bonds_1, temp_bonds_2,
             n_species, &species_choice, atom_type, comb_col, resph, radius_sph,
             &radius_cyl, &keep_going, x_cut_switch, pore_switch);
      if (pore_switch)
        redraw_pore(dpy, win, doubleBuffer, &graph_pore_switch, resph, z0, r0, 
                    h, x_cut_switch, comb_col, n_type);


     } while(!keep_going);
 }
#endif

}  /* end of main */


/* Allocate memory for static arrays */
void allocate_memory_build(int n_atoms, int n_mols, int period_switch, 
     double ***atom_coords, double ***scaled_atom_coords, 
     double ***rel_atom_coords,
     double ***atom_vels, int **atom_rel, int **atom_type,
     double ***mol_coords, double ***scaled_mol_coords, double ***h,
     double ***h_inv)
{
   int i;

   /* Allocate memory for arrays of atomic properties. */
   *atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));  
   *rel_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));
   *atom_vels = allocate_2d_array(n_atoms, 3, sizeof(double));  

   if (period_switch)
      *scaled_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));

   /* Allocate memory for arrays of atomic properties. */
   *atom_rel = allocate_1d_array(n_atoms, sizeof(int));
   *atom_type = allocate_1d_array(n_atoms, sizeof(int));

   /* Allocate memory for arrays of molecular properties. */
   *mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));
   if (period_switch)
      *scaled_mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));

   /* Allocate memory for the box matrices */
   /* For now, orthorombic box */
   *h = allocate_2d_array(3, 3, sizeof(double));
   *h_inv = allocate_2d_array(3, 3, sizeof(double));
}

void relative_atoms(int n_mols, int *mol_species, int *mol_first_atm, int *n_atoms_per_mol, int **temp_atm_type_i, int *atom_rel, int *atom_type)
{
   int i_species, skip, i, i_mol, i_rel;

   /* Set up array of atomic properties. */
   for (i_mol = 0; i_mol < n_mols; ++i_mol) {
      i_species = mol_species[i_mol];
      skip = mol_first_atm[i_mol];
      for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
         i = skip + i_rel;
         atom_rel[i] = i_rel;
         atom_type[i] = temp_atm_type_i[i_species][i_rel];
      }
   }
}
