/* Visualization for molecular modeling package */
/* v1.0 */

#include "build.h"
/*#include "color.h" */

#ifndef CALLBACK
#define CALLBACK
#endif

void CALLBACK errorCallback(GLenum errorCode);

/*****************************************************************************/
void redraw_pore(Display *dpy, Window win, GLboolean doubleBuffer,
    int *graph_pore_switch, int resph, double z0, double r0, double **h,
    int x_cut_switch, int *comb_col, int n_type)
{
    double v0, v1, v2, w0, w1, w2, bond[3], s_bond[3], x, y, z, x0, y0;
    int i, skip, i_species, i_mol, i_bond, rel_1, rel_2, abs_1, abs_2, k;
    int i_atom, abs, w, i_type, id_col, i_type_1, i_type_2, id_col_1, id_col_2;
    double R, RXY, xincr, yincr;
    float theta, phi;
    XEvent          event;
    GLboolean       needRedraw = GL_TRUE, recalcModelView = GL_TRUE; 
    KeySym ks;
    char buff[31];
    GLUquadricObj *qobj;

   /* Now draw the pore if graph_pore_switch == 1 or 2. */

   if (*graph_pore_switch == 1){ /* Draw wire frame. */

   /* Turn off the light. */
   glDisable(GL_LIGHTING); 

   /* Choose color of the pore (last type i.e (n_type - 1)
      is the type of the "atom" pore. */
   glColor3fv(defaultColor[comb_col[n_type - 1]]);

   qobj = gluNewQuadric();
   gluQuadricCallback(qobj, GLU_ERROR,
                      (GLvoid (CALLBACK*) ()) errorCallback);
   gluQuadricDrawStyle(qobj, GLU_LINE);
   gluQuadricNormals(qobj, GLU_NONE);

   /* Line thickness. */
   w = 1;
   glLineWidth((GLfloat)w);

   glPushMatrix(); 
   glTranslatef((GLfloat)(0.0), (GLfloat)(0.0), (GLfloat)(-z0));

   /* call utility routine to draw cylinders. */
   gluCylinder(qobj, (GLdouble)r0, (GLdouble)r0,
               (GLdouble)(2 * z0), (GLint)(2 * resph), 10);

   /* restore the matrix */
   glPopMatrix(); 

   /* Draw the outer pore surfaces. */ 
   xincr = h[0][0] / (2 * resph);
   yincr = h[1][1] / (2 * resph);
   x0 = y0 = r0 / sqrt(2.0);

  for (k = 0; k < 2; ++k) {

   z = (2 * k - 1) * z0;

   for (i = 0; i < 2 * resph; ++i){
     
      x = - h[0][0] * 0.5 + i * xincr;
      if (fabs(x) - x0 > 0.0){
          glBegin(GL_LINE_LOOP);
          v0 = x;
          v1 = 0.5 * (- h[1][1] - h[1][2]);
          v2 = z;
          glVertex3f(v0, v1, v2);
          v0 = x;
          v1 = - 0.5 * (- h[1][1] - h[1][2]);
          v2 = z;
          glVertex3f(v0, v1, v2);
          glEnd();
      }
      else{
          glBegin(GL_LINE_LOOP);
          v0 = x;
          v1 = 0.5 * (- h[1][1] - h[1][2]);
          v2 = z;
          glVertex3f(v0, v1, v2);
          v0 = x;
          v1 = - sqrt(SQR(r0) - SQR(x));
          v2 = z;
          glVertex3f(v0, v1, v2);
          glEnd();

          glBegin(GL_LINE_LOOP);
          v0 = x;
          v1 = - 0.5 * (- h[1][1] - h[1][2]);
          v2 = z;
          glVertex3f(v0, v1, v2);
          v0 = x;
          v1 = sqrt(SQR(r0) - SQR(x));
          v2 = z;
          glVertex3f(v0, v1, v2);
          glEnd();
      }
      
      y = - h[1][1] * 0.5 + i * yincr;
      if (fabs(y) - y0 > 0.0){
          glBegin(GL_LINE_LOOP);
          v0 = 0.5 * (- h[0][0]); 
          v1 = y;
          v2 = z;
          glVertex3f(v0, v1, v2);
          v0 = - 0.5 * (- h[0][0]);
          v1 = y;
          v2 = z;
          glVertex3f(v0, v1, v2);
          glEnd();
      }
      else{
          glBegin(GL_LINE_LOOP);
          v0 = 0.5 * (- h[0][0]); 
          v1 = y;
          v2 = z;
          glVertex3f(v0, v1, v2);
          v0 = - sqrt(SQR(r0) - SQR(y));
          v1 = y;
          v2 = z;
          glVertex3f(v0, v1, v2);
          glEnd();

          glBegin(GL_LINE_LOOP);
          v0 = - 0.5 * (- h[0][0]);
          v1 = y;
          v2 = z;
          glVertex3f(v0, v1, v2);
          v0 = sqrt(SQR(r0) - SQR(y));
          v1 = y;
          v2 = z;
          glVertex3f(v0, v1, v2);
          glEnd();
      }
      
   }

  glBegin(GL_LINE_LOOP);
  v0 = 0.5 * (- h[0][0]); 
  v1 = 0.5 * (- h[1][1]);
  v2 = z;
  glVertex3f(v0, v1, v2);
  v0 = 0.5 * (- h[0][0]); 
  v1 = - 0.5 * (- h[1][1]);
  v2 = z;
  glVertex3f(v0, v1, v2);
  v0 = - 0.5 * (- h[0][0]); 
  v1 = - 0.5 * (- h[1][1]);
  v2 = z;
  glVertex3f(v0, v1, v2);
  v0 = - 0.5 * (- h[0][0]); 
  v1 = 0.5 * (- h[1][1]);
  v2 = z;
  glVertex3f(v0, v1, v2);
  glEnd();
}
   /* Turn on lightning. */
   glEnable(GL_LIGHTING); 
}
else if (*graph_pore_switch == 2){

   /* Choose color of the pore (last type i.e (n_type - 1)
      is the type of the "atom" pore. */
   glColor3fv(defaultColor[comb_col[n_type - 1]]);

   qobj = gluNewQuadric();
   gluQuadricCallback(qobj, GLU_ERROR,
                      (GLvoid (CALLBACK*) ()) errorCallback);
   gluQuadricDrawStyle(qobj, GLU_FILL);
   gluQuadricNormals(qobj, GLU_SMOOTH);

   glPushMatrix(); 
   glTranslatef((GLfloat)(0.0), (GLfloat)(0.0), (GLfloat)(-z0));

   /* call utility routine to draw cylinders. */
   gluCylinder(qobj, (GLdouble)r0, (GLdouble)r0,
               (GLdouble)(2 * z0), (GLint)(2 * resph), 10);

   /* restore the matrix */
   glPopMatrix(); 

  glBegin(GL_POLYGON);
  v0 = 0.5 * (- h[0][0]); 
  v1 = 0.5 * (- h[1][1]);
  v2 = z;
  glVertex3f(v0, v1, v2);
  v0 = 0.5 * (- h[0][0]); 
  v1 = - 0.5 * (- h[1][1]);
  v2 = z;
  glVertex3f(v0, v1, v2);
  v0 = - 0.5 * (- h[0][0]); 
  v1 = - 0.5 * (- h[1][1]);
  v2 = z;
  glVertex3f(v0, v1, v2);
  v0 = - 0.5 * (- h[0][0]); 
  v1 = 0.5 * (- h[1][1]);
  v2 = z;
  glVertex3f(v0, v1, v2);
  glEnd();
}

   if(doubleBuffer) glXSwapBuffers(dpy, win);  
                                                
       else glFlush();  /* explicit flush for single buffered case */
}

/*****************************************************************************/
