/* Interaction of the particles with the walls 
   (modelled as a given potential - see pot.ff for the label Wall) */
  
#include "build.h"


int pore(int i_mol, int *mol_first_atm, int *n_atoms_per_mol, int *mol_species,
      int n_type, int *atom_type, double **combine,
      double **h, double **mol_coords, double **scaled_atom_coords,
      double **rel_atom_coords, double z0, double r0)
{
   int i, k, skip_i, i_species, i_type, pore_type;
   double x, y, z, x_com, y_com, r, r_sep, r_sep2, rho_sep2, z_sep, z_sep2; 

   /* Get pore type (pore type is the last entry). */
   pore_type = n_type - 1;

   /* Get label of molecular species and label of first atom in molecule. */
   i_species = mol_species[i_mol];
   skip_i = mol_first_atm[i_mol];

   /* Get molecular coordinates. */
   x_com = mol_coords[i_mol][0];
   y_com = mol_coords[i_mol][1];
 
   /* Loop over atoms in molecule i_mol. */
   for (i = skip_i; i < skip_i + n_atoms_per_mol[i_species]; ++i) {
   
      /* Get attributes of atom i. */
      x = x_com + rel_atom_coords[i][0];
      y = y_com + rel_atom_coords[i][1];
      z = h[2][2] * scaled_atom_coords[i][2];
   
      /* Get atom type. */   
      i_type = atom_type[i];

      /* Compute minimum separation between atom i and the wall. */
      z_sep = fabs(z) - z0;
      if (z_sep <= 0.0) /* Interior of the pore. */
         z_sep2 = 0.0;
      else
         z_sep2 = SQR(z_sep);

      /* Calculate radial pair separation. */
      r = sqrt(SQR(x) + SQR(y));
      r_sep = r0 - r;
      if (r_sep <= 0.0)  /* Exterior of the pore. */
         r_sep2 = 0.0;
      else              /* Interior of the pore. */
         r_sep2 = SQR(r_sep);
       
      rho_sep2 = r_sep2 + z_sep2;
     
      /* If the atom is outside the pore (rho_sep2 == 0) or if it is inside
         the pore but too close from the wall to satisfy the overlap 
         criterion, return 1 (overlap detected). */ 
      if (rho_sep2 < combine[i_type][pore_type])
         return(1);         
   }
   /* If no overlap between the molecule and the pore walls was detected,
      return 0 */
      return(0);
}
