
#include "build.h"

/* Calculate averages, and uncertainties from an array of block averages. */
void statistics(int nb, double *x, double *xave, double *xunc)
{
   int i;
   double norm1, norm2;

   *xave = *xunc = 0.0;
   for (i = 0; i < nb; ++i) {
      *xave += x[i];
      *xunc += SQR(x[i]);
   }
   norm1 = 1.0 / nb;
   *xave *= norm1;
   *xunc *= norm1;
   if(nb == 1)
      *xunc = 0.0;
   else {
      norm2 = 1.0 / (nb - 1);
      *xunc = sqrt(norm2 * ABS(*xunc - SQR(*xave)));
   }
}
