/* Banane analysis program. */

#define MAIN
#include "shared.h"
#undef MAIN

int main(int argc, char *argv[])
{
   FILE *f_thermo, *f_trajec, *f_dist, *f_free, *f_output;
   char *defaults_file, *param_file, *config_file;
   int i, j, i_mol, n_mol, n_layers, start_switch, graph_switch, n_graph,
      n_cos_theta, n_rms_displ, opt_switch, n_opt, n_reshape, reshape_axis,
      bias_switch, cell_switch, n_cycles, n_block, n_thermo, n_trajec, n_inst,
      i_cycle, i_bin, displ_flag, end_vec_switch, n_mol_moves, n_mol_accept, 
      n_cell_moves, n_reshape_moves, n_reshape_accept, n_reshape_moves_opt, 
      n_reshape_accept_opt, i_block, n_blocks, *cos_theta_mod_hist, 
      *rms_displ_hist, *n_mol_moves_block, *n_mol_accept_block, 
      *n_cell_moves_block, *n_cell_accept_block, *n_reshape_moves_block, 
      *n_reshape_accept_block, n_mol_moves_tot, n_mol_accept_tot, 
      n_reshape_moves_tot, n_reshape_accept_tot;
   long i_ran;
   double open_angle;
   int nrot, i_atom;

   double length, rho_star, rho, rho_cp, aspect_xy, aspect_xz, layer_spacing, 
      norm, s_spacing, s0_ref, s0,
      skin_old, opt_time, efficiency, ratio_du_dr, ratio_du_dr_old, dr_max_old, 
      displ_max, pi, degrees_to_radians, radians_to_degrees,
      mol_accept, reshape_accept, dummy, reshape_accept_opt,
      cos_theta, norm_cos, phi, cos_theta_mod, phi_mod,
      theta_equil, cos_theta_equil, pressure_star, v0, pressure, 
      rms_displ_equil,
      cos_theta_incr, rms_displ_incr,
      **side_block, *layer_spacing_block, *rho_star_block,
      ***q_end_block, *cos_theta_block, *phi_block, **lambda_block,
      *rms_displ_block, *e_bias_block, 
      rho_star_ave, rho_star_unc,
      *side_ave, *side_unc, layer_spacing_ave, layer_spacing_unc,
      **q_end_ave, **q_end_unc, cos_theta_ave, cos_theta_unc, phi_ave, phi_unc,
      *lambda_ave, *lambda_unc,
      rms_displ_ave, rms_displ_unc,
      e_bias_ave, e_bias_unc,
      weight, weight_sum, *weight_dist, free_energy,
      dr_max, ds_max[3], du_max, dside_max, dphi, 
      rms_displ, deviation, e_bias, skin, k_theta, k_displ,
      **q_end, **q_polar, *lambda, **v, side[3], 
      **dr_tot, **dr_opt, **mol_inert_mt, ***mol_inert_axis, 
      **mol_order_inst, **order_temp, *lambda_temp, **v_temp, 
      ***mol_order_block, **mol_order_ave, **mol_order_unc;
   nl_entry **nl_head, **nl_tail, *p;
   short val, keep_going;

/* Addition for the bananas */
    double **atom_coords, **scaled_atom_coords, **scaled_mol_coords, 
      **mol_coords, side_inv[3];
    double **atom_coords_trial, **mol_coords_trial, 
      **scaled_atom_coords_trial, **rel_atom_coords, **temp_atm_pos, 
      **s_sphero, **u_sphero, **s_sphero_trial, 
      **end_sphero, **polar_sphero, **scaled_mol_unfolded;
    int n_atoms_per_mol = 3, n_sphero_per_mol = 2, *mol_first_atm, k, 
      atom_count, principal, sphero_count, scan_atm_1[2], scan_atm_2[2], 
      *mol_first_sphero, *sphero_mol, n_sphero, *temp_bonds_1, *temp_bonds_2;
    double norm1, norm2;
    double angle, cos_angle;
    double radius_sph, radius_cyl;
    int resph, antialias_switch;

/* Analysis variables. */
    char s_layer[60], name[60];
    double s_mol_inert[3], s_mol_inert2[3], mol_inert[3], mol_inert2[3], theta;
    int skip, n_mol_in_layer_0, i_layer;
    int *layer_index_0, *layer_index, *layer_cnt, layer_lab_max, layer_cnt_max,
        n_bins, n_r, n_r_par, n_r_perp, i_r, i_r_par, i_r_perp, n_x, n_y,
        i_x, i_y;
    double factor, *diffusion_block, s_delta, diffusion_ave, diffusion_unc,
        *mol_polar_inst, polar_norm, **mol_polar_block, *mol_antipolar_inst,
        antipolar_norm, **mol_antipolar_block, *mol_polar_ave, *mol_polar_unc,
        *mol_antipolar_ave, *mol_antipolar_unc, polar_norm_ave, polar_norm_unc,
        antipolar_norm_ave, antipolar_norm_unc, *polar_norm_block, 
        *antipolar_norm_block, shift, shift_0, *volume_block, volume_ave, 
        volume_unc, *density_block, density_ave, density_unc, density, volume,
        avg_normal, d_bin, sbin, one_over_sbin, z_bin, *dens_prof, r_max, 
        r2_max,
        *g_r, *g_1, *g_2, **g_r_par_perp, **g_1_par_perp, **g_2_par_perp,
        r_incr, one_over_r_incr, r_par_incr, one_over_r_par_incr, r_perp_incr,
        one_over_r_perp_incr, r, r_1, r_2, r_perp_1, r_perp_2, norm_1, norm_2,
        spat_thresh, r_par_max, r_perp_max, x_max, y_max, one_over_x_incr,
        one_over_y_incr, x_incr, y_incr, *g_r_lay, *g_1_lay, *g_2_lay, 
        *g_r_6_bo_lay,
        ***g_xy, ***g_1_xy, ***g_2_xy, ***g_xy_6_bo, **g_xy_tot, **g_1_xy_tot,
        **g_2_xy_tot, **g_xy_6_bo_tot, in_lay_thresh, dum1, dum2, l1, l2;
    double xx_sep[6], yy_sep[6], ax, ay, bx,by, o6_x_re, o6_x_im, o6_x_norm2, epsilon;
    int pos_1, layer_switch;

    /* Voronoi variables. */
    int *n_neighb, **i_neighb, *i_min;
    double *r2_min, **x_sep, **y_sep, **r2_sep, **x_int, **y_int; 
    double *o2_re, *o2_im, *o4_re, *o4_im, *o6_re, *o6_im;
    double o2_norm2, o4_norm2, o6_norm2, *o2_norm2_block, *o4_norm2_block,
       *o6_norm2_block, o2_norm2_ave, o2_norm2_unc, o4_norm2_ave, o4_norm2_unc,
       o6_norm2_ave, o6_norm2_unc, *o2_lay, *o4_lay, *o6_lay;
    int *mol_lay;

   /* Get command-line input, which consists of the names of files
      containing default parameters and input parameters. */
   if (argc != 2) {
      fprintf(stderr, "Usage: %s param_file\n", argv[0]);
      exit(1);
   }
   param_file = gmalloc((strlen(argv[1])+1) * sizeof(char));
   strcpy(param_file, argv[1]);

   printf("\nLa Banane : analyse program, v1.0\n");
   fflush(NULL);

   /* Read parameters from file. */
   parse_params(param_file, &n_block, &config_file,
                &n_layers, &n_bins, &n_r, &n_r_par, &n_r_perp,
                &spat_thresh, &n_x, &n_y, &in_lay_thresh, &layer_switch);

   /* Check for errors in input parameters. */
/*   if (start_switch < 0 || start_switch > 1) {
      fprintf(stderr, "start_switch must be between 0 and 1\n");
      exit(1);
   }

   if (graph_switch <= 0 || graph_switch > 5) {
      fprintf(stderr, "graph_switch must be between 1 and 5\n");
      exit(1);
   }
*/


   /* Open trajectory files. */
   f_trajec = gfopen(config_file, "r");  

   /* Read header from trajectory file. */
   fread(&n_mol, sizeof(int), 1, f_trajec);
   fread(&length, sizeof(double), 1, f_trajec);
   fread(&n_cycles, sizeof(int), 1, f_trajec);
   fread(&n_trajec, sizeof(int), 1, f_trajec);

   pos_1 = ftell(f_trajec);

   printf("Header from %s\n", config_file);
   printf("n_mol = %d\n", n_mol);
   printf("length = %g\n", length);
   printf("n_cycles = %d\n", n_cycles);
   printf("n_trajec = %d\n", n_trajec);

   /* Compute number of instantaneous configuration in trajectory file. */
   if (n_cycles % n_trajec != 0) {
      printf("n_cycles must be a multiple of n_trajec\n");
      exit(1);
   }
   n_inst = n_cycles / n_trajec;

   degrees_to_radians = PI / 180.0;
   radians_to_degrees = 1.0 / degrees_to_radians;
   n_blocks = n_inst / n_block;
   if (n_inst % n_block != 0){
     printf("number of trajectories must be a multiple of n_block\n");
     exit(1);
   }

   /* Allocate memory for atomic and molecular arrays. */
   temp_bonds_1 = allocate_1d_array(n_sphero_per_mol, sizeof(int));
   temp_bonds_2 = allocate_1d_array(n_sphero_per_mol, sizeof(int));
   mol_coords = allocate_2d_array(n_mol, 3, sizeof(double));
   scaled_mol_coords = allocate_2d_array(n_mol, 3, sizeof(double));
   atom_coords = allocate_2d_array(3 * n_mol, 3, sizeof(double));
   scaled_atom_coords = allocate_2d_array(3 * n_mol, 3, sizeof(double));
   rel_atom_coords = allocate_2d_array(3 * n_mol, 3, sizeof(double));
   mol_first_atm = allocate_1d_array(n_mol, sizeof(int));
   mol_inert_mt = allocate_2d_array(n_mol, 3, sizeof(double));
   mol_inert_axis = allocate_3d_array(n_mol, 3, 3, sizeof(double));
   mol_order_inst = allocate_2d_array(3, 3, sizeof(double));
   mol_polar_inst = allocate_1d_array(3, sizeof(double));
   mol_antipolar_inst = allocate_1d_array(3, sizeof(double));
   lambda = allocate_1d_array(3, sizeof(double));
   v = allocate_2d_array(3, 3, sizeof(double));
   layer_index = allocate_1d_array(n_mol, sizeof(int));
   layer_index_0 = allocate_1d_array(n_mol, sizeof(int));
   layer_cnt = allocate_1d_array(n_layers, sizeof(int));

   /* Allocate memory for scratch arrays. */
   order_temp = dmatrix(1, 3, 1, 3);
   lambda_temp = dvector(1, 3);
   v_temp = dmatrix(1, 3, 1, 3);

   /* Allocate memory for block averages. */
   mol_order_block =  allocate_3d_array(3, 3, n_blocks, sizeof(double));
   mol_polar_block =  allocate_2d_array(3, n_blocks, sizeof(double));
   mol_antipolar_block =  allocate_2d_array(3, n_blocks, sizeof(double));
   polar_norm_block =  allocate_1d_array(n_blocks, sizeof(double));
   antipolar_norm_block =  allocate_1d_array(n_blocks, sizeof(double));
   diffusion_block =  allocate_1d_array(n_blocks, sizeof(double));
   volume_block =  allocate_1d_array(n_blocks, sizeof(double));
   density_block =  allocate_1d_array(n_blocks, sizeof(double));
   cos_theta_block = allocate_1d_array(n_blocks, sizeof(double));
   phi_block = allocate_1d_array(n_blocks, sizeof(double));
   lambda_block = allocate_2d_array(3, n_blocks, sizeof(double));
   o2_norm2_block = allocate_1d_array(n_blocks, sizeof(double));
   o4_norm2_block = allocate_1d_array(n_blocks, sizeof(double));
   o6_norm2_block = allocate_1d_array(n_blocks, sizeof(double));

   /* Allocate memory for averages and uncertainties. */
   mol_order_ave = allocate_2d_array(3, 3, sizeof(double));
   mol_order_unc = allocate_2d_array(3, 3, sizeof(double));
   mol_polar_ave =  allocate_1d_array(3, sizeof(double));
   mol_polar_unc =  allocate_1d_array(3, sizeof(double));
   mol_antipolar_ave =  allocate_1d_array(3, sizeof(double));
   mol_antipolar_unc =  allocate_1d_array(3, sizeof(double));
   lambda_ave = allocate_1d_array(3, sizeof(double));
   lambda_unc = allocate_1d_array(3, sizeof(double));

   /* Allocate memory for analysis quantities. */
   dens_prof = allocate_1d_array(n_bins, sizeof(double));
   g_r = allocate_1d_array(n_r, sizeof(double));
   g_1 = allocate_1d_array(n_r, sizeof(double));
   g_2 = allocate_1d_array(n_r, sizeof(double));
   g_r_par_perp = allocate_2d_array(n_r_par, n_r_perp, sizeof(double));
   g_1_par_perp = allocate_2d_array(n_r_par, n_r_perp, sizeof(double));
   g_2_par_perp = allocate_2d_array(n_r_par, n_r_perp, sizeof(double));
   g_r_lay = allocate_1d_array(n_r, sizeof(double));
   g_1_lay = allocate_1d_array(n_r, sizeof(double));
   g_2_lay = allocate_1d_array(n_r, sizeof(double));
   g_r_6_bo_lay = allocate_1d_array(n_r, sizeof(double));
   g_xy = allocate_3d_array(n_x, n_y, n_layers, sizeof(double));
   g_1_xy = allocate_3d_array(n_x, n_y, n_layers, sizeof(double));
   g_2_xy = allocate_3d_array(n_x, n_y, n_layers, sizeof(double));
   g_xy_6_bo = allocate_3d_array(n_x, n_y, n_layers, sizeof(double));
   g_xy_tot = allocate_2d_array(n_x, n_y, sizeof(double));
   g_1_xy_tot = allocate_2d_array(n_x, n_y, sizeof(double));
   g_2_xy_tot = allocate_2d_array(n_x, n_y, sizeof(double));
   g_xy_6_bo_tot = allocate_2d_array(n_x, n_y, sizeof(double));

   /* Allocate memory for arrays used in Voronoi analysis. */
   n_neighb = allocate_1d_array(n_mol, sizeof(int));
   i_min = allocate_1d_array(n_mol, sizeof(int));
   r2_min = allocate_1d_array(n_mol, sizeof(double));
   x_sep = allocate_2d_array(n_mol, NGHB_MAX, sizeof(double));
   y_sep = allocate_2d_array(n_mol, NGHB_MAX, sizeof(double));
   r2_sep = allocate_2d_array(n_mol, NGHB_MAX, sizeof(double));
   i_neighb = allocate_2d_array(n_mol, NGHB_MAX, sizeof(int));
   x_int = allocate_2d_array(NGHB_MAX, NGHB_MAX, sizeof(double));
   y_int = allocate_2d_array(NGHB_MAX, NGHB_MAX, sizeof(double));
   o2_re = allocate_1d_array(n_mol, sizeof(double));
   o2_im = allocate_1d_array(n_mol, sizeof(double));
   o4_re = allocate_1d_array(n_mol, sizeof(double));
   o4_im = allocate_1d_array(n_mol, sizeof(double));
   o6_re = allocate_1d_array(n_mol, sizeof(double));
   o6_im = allocate_1d_array(n_mol, sizeof(double));
   o2_lay = allocate_1d_array(n_layers, sizeof(double));
   o4_lay = allocate_1d_array(n_layers, sizeof(double));
   o6_lay = allocate_1d_array(n_layers, sizeof(double));
   mol_lay = allocate_1d_array(n_layers, sizeof(double));
   
   /* Define absolute label of the first atom in a molecule. */
   atom_count = 0;
   for (i_mol = 0; i_mol < n_mol; ++i_mol) {
       mol_first_atm[i_mol] = atom_count;
       atom_count += n_atoms_per_mol;
   }

   /* Connectivity of the bananas molecules. The bow atom is labeled 0 and
      the 2 end atoms are 1 and 2. */
   scan_atm_1[0] = 1;
   scan_atm_2[0] = 0;
   scan_atm_1[1] = 0;
   scan_atm_2[1] = 2;

   /* Loop over trajectories. */
   printf("\nEntering main loop\n");
   fflush(NULL);

   /* Initialize variables used to compute layer position. */
   s_spacing = 1.0 / n_layers;
   s0_ref = 0.5 * s_spacing - 0.5;
   n_mol_in_layer_0 = 0;
   avg_normal = 0.0;
   for (i_mol = 0; i_mol < n_mol; ++i_mol)
     layer_index[i_mol] = 0;

   /* Loop over data sets to determine minimum radius of inscribed cylinder. */
   r_max = 1e06;
   x_max = 1.0e6;
   y_max = 1.0e6;
   for (i_cycle = 0; i_cycle < n_inst; ++i_cycle) {

      /* Read instantaneous configuration from trajectory file. */
      fread(side, sizeof(double), 3, f_trajec);
      for (i = 0; i < 3 * n_mol; ++i)
        fread(atom_coords[i], sizeof(double), 3, f_trajec);

      /* Calculate radius of inscribed sphere. */
      r_max = MIN(r_max, side[0]);
      r_max = MIN(r_max, side[1]);
      r_max = MIN(r_max, side[2]);
      x_max = MIN(x_max, side[0]);
      y_max = MIN(y_max, side[1]);

   }

   /* Close trajectory file. */
   fclose(f_trajec);

   r_max *= 0.5;
   r2_max = SQR(r_max);
   x_max *= 0.5;
   y_max *= 0.5;

   /* Choose r_par_max and r_perp_max so as to maximize sample volume. */
   r_par_max = r_max;
   r_perp_max = r_max;

   /* Calculate sizes of bins. */
   r_incr = r_max / n_r;
   one_over_r_incr = 1.0 / r_incr;
   r_par_incr = 2.0 * r_par_max / n_r_par;
   one_over_r_par_incr = 1.0 / r_par_incr;
   r_perp_incr = r_perp_max / n_r_perp;
   one_over_r_perp_incr = 1.0 / r_perp_incr;
   x_incr = 2.0 * x_max / n_x;
   one_over_x_incr = 1.0 / x_incr;
   y_incr = 2.0 * y_max / n_y;
   one_over_y_incr = 1.0 / y_incr;

   /* Calculate scaled size of bins. */
   sbin = 1.0 / n_bins;
   one_over_sbin = 1.0 / sbin;

   /* Open trajectory files. */
   f_trajec = gfopen(config_file, "r");  

   /* Position trajectory file pointer at beginning of first data set. */
   fseek(f_trajec, pos_1, 0);

   for (i_cycle = 1; i_cycle <= n_inst; ++i_cycle) {


      /* Read instantaneous configuration from trajectory file. */
      fread(side, sizeof(double), 3, f_trajec);
      for (i = 0; i < 3 * n_mol; ++i) 
        fread(atom_coords[i], sizeof(double), 3, f_trajec);

      /* Inverse cell vector. */
      for (k = 0; k < 3; ++k)
          side_inv[k] = 1.0 / side[k];

      /* Calculate scaled atomic coordinates. */
      scaled_atomic_coords(n_mol, side_inv, atom_coords, scaled_atom_coords);

      /* Compute molecular center of mass and relative "atom" coordinates. */
      center_of_mass_positions(n_mol, n_atoms_per_mol, scan_atm_1, scan_atm_2,
                            mol_first_atm, atom_coords, scaled_atom_coords,
                            side, side_inv, mol_coords, scaled_mol_coords,
                            rel_atom_coords);

    if (layer_switch){

      /* Initialize counter for layer assignment. */
      for (i_layer = 0; i_layer < n_layers; ++i_layer)
         layer_cnt[i_layer] = 0;

      /* Find position of the ref layer (layer 0). */
      if (i_cycle == 1) {
         shift_0 = s0_ref;
         layer_position(n_layers, n_mol, side, scaled_mol_coords, &shift_0, 
                        &rms_displ);     
         }
      else {
         /* Find position of the ref layer (layer 0). */
         shift = s0_ref;
         layer_position(n_layers, n_mol, side, scaled_mol_coords, &shift, 
                        &rms_displ);     
         }
    }

     /* Compute end-to-end vector (nematic director) and polar director,
        layers position and assign molecules to layers. */
     for (i_mol = 0; i_mol < n_mol; ++i_mol) {

        skip = mol_first_atm[i_mol];

        /* Compute end-to-end vector. */ 
        mol_inert_axis[i_mol][2][0] = rel_atom_coords[skip + 2][0] -
                         rel_atom_coords[skip + 1][0];
        mol_inert_axis[i_mol][2][1] = rel_atom_coords[skip + 2][1] -
                         rel_atom_coords[skip + 1][1];
        mol_inert_axis[i_mol][2][2] = rel_atom_coords[skip + 2][2] -
                         rel_atom_coords[skip + 1][2];

        /* Normalize end-to-end vector. */
        norm = 0.0;
        for (k = 0; k < 3; ++k)
          norm += mol_inert_axis[i_mol][2][k] * mol_inert_axis[i_mol][2][k];
        norm = sqrt(norm);

        mol_inert_axis[i_mol][2][0] /= norm;
        mol_inert_axis[i_mol][2][1] /= norm;
        mol_inert_axis[i_mol][2][2] /= norm;

        /* Compute polar director, perpendicular to the molecular end-to-end
           vector and pointing toward the apex point of the bananas. */

        for (k = 0; k < 3; ++k)
          mol_inert_axis[i_mol][1][k] = 2.0 * rel_atom_coords[skip][k] 
                        - rel_atom_coords[skip + 1][k] 
                        - rel_atom_coords[skip + 2][k]; 

      /* Normalize polar vector. */
      norm = 0.0;
      for (k = 0; k < 3; ++k)
        norm += mol_inert_axis[i_mol][1][k] * mol_inert_axis[i_mol][1][k];
      norm = sqrt(norm);

      mol_inert_axis[i_mol][1][0] /= norm;
      mol_inert_axis[i_mol][1][1] /= norm;
      mol_inert_axis[i_mol][1][2] /= norm;

     if (layer_switch){

      /* Compute norm of o6 for the tilted crystal (tilt toward nearest
         neighbors). */
      if (i_cycle == 1 && i_mol == 0){
        cos_theta = norm_cos = 0.0; 
        for (k = 0; k < 3; ++k){
          l1 = rel_atom_coords[1][k] - rel_atom_coords[0][k]; 
          l2 = rel_atom_coords[2][k] - rel_atom_coords[0][k]; 
          cos_theta += l1 * l2;
          norm_cos += SQR(l1);
        }
        cos_theta /= norm_cos;
        theta = acos(cos_theta) / 2.0;
        printf("theta = %g\n", theta * radians_to_degrees); 

        theta = PI / 2.0 - theta;
        cos_theta = cos(theta);

        /* List coordinates of nearest neighbors. */
        ax = 1.0 / cos_theta;
        ay = 0.0;
        bx = ax / 2.0;
        by = sqrt(3.0) / 2.0;
        epsilon = 0.05;
        ax += epsilon;
        norm = sqrt(bx * bx + by * by);
        bx = bx / norm * (norm + epsilon);
        by = by / norm * (norm + epsilon);

        xx_sep[0] = ax;
        yy_sep[0] = ay;
        xx_sep[1] = bx;
        yy_sep[1] = by; 
        xx_sep[2] = - ax + bx;
        yy_sep[2] = - ay + by;
        xx_sep[3] = - ax;
        yy_sep[3] = - ay;
        xx_sep[4] = - bx;
        yy_sep[4] = - by; 
        xx_sep[5] = ax - bx;
        yy_sep[5] = ay - by;

        o6_x_re = o6_x_im = 0.0;
        for (j = 0; j < 6; ++j) {
         angle = atan2(xx_sep[j], yy_sep[j]);
         dum1 = 6.0 * angle;
         o6_x_re += cos(dum1);
         o6_x_im += sin(dum1);
        }
        o6_x_re /= 6;
        o6_x_im /= 6;
        o6_x_norm2 = SQR(o6_x_re) + SQR(o6_x_im);

printf("o6_norm2 = %g\n", o6_x_norm2);
      }

      /* Initialize layer position (assume layer normal along z)
         and shift layers if necessary. */
      if (i_cycle == 1){
         /* Assign molecule to layer. */
         layer_index_0[i_mol] = 
                      layer_assignment(n_layers, scaled_mol_coords[i_mol]);
 
         layer_index[i_mol] = layer_index_0[i_mol]; 

         /* Compute the number of molecules in layer 0 (ref layer)). */
         if (layer_index_0[i_mol] == 0)
            ++n_mol_in_layer_0;
         factor = 1.0;
         }
      else {
         /* Assign molecule to layer. */
         layer_index[i_mol] = 
                    layer_assignment(n_layers, scaled_mol_coords[i_mol]);

         /* Find the new layer assignment of the molecules initially
            in layer 0 (ref layer). */
         if (layer_index_0[i_mol] == 0) 
            ++layer_cnt[layer_index[i_mol]]; 
         }
     }    
      }
/*
if (i_cycle > 1){
  for (i_layer = 0; i_layer < n_layers; ++i_layer)
     printf("i_layer = %d : cnt = %d\n", i_layer, layer_cnt[i_layer]);
  exit(1);
}
*/
      if ((i_cycle > 1) && (layer_switch)) {
      /* Find where the molecules initially in layer 0 are going
         predominantly. */         
      layer_lab_max = 0; 
      layer_cnt_max = layer_cnt[0];
      for (i_layer = 1; i_layer < n_layers; ++i_layer)
          if (layer_cnt[i_layer] > layer_cnt_max){
               layer_lab_max = i_layer;
               layer_cnt_max = layer_cnt[i_layer];
          }
       
      factor = layer_cnt_max / (double) n_mol_in_layer_0;
      /* Exit if the initial reference layer cannot be defined 
         anymore (i.e if there have been more than 50% of molecules
         which have diffused. */ 
      if (factor < 0.5) {
          printf("n_mol_in_layer / n_mol_in_layer_0 = %g\n", factor);
          exit(1);
      }

 /*         printf("n_mol_in_layer / n_mol_in_layer_0 = %g, layer_lab = %d\n", factor, layer_lab_max);
*/
      /* Compute layer shift. */
         s_delta =  shift - shift_0 + s_spacing * layer_lab_max;

      /* Shift molecule positions. */
      for (i_mol = 0; i_mol < n_mol; ++i_mol){
         for (k = 0; k < 3; ++k) {
         scaled_mol_coords[i_mol][k] -= s_delta;
         scaled_mol_coords[i_mol][k] -= NINT(scaled_mol_coords[i_mol][k]);
         mol_coords[i_mol][k] = scaled_mol_coords[i_mol][k] * side[k];
         }
         layer_index[i_mol] = 
                          layer_assignment(n_layers, scaled_mol_coords[i_mol]);
      }
/*         shift = s0_ref;
         layer_position(n_layers, n_mol, side, scaled_mol_coords, &shift, 
                        &rms_displ);     
printf("      shift after computation = %lf\n", shift); 
fflush(NULL);
*/
      }

      /* Compute instantaneous volume and density. */
      volume = side[0] * side[1] * side[2];
      density = n_mol / volume;

      /* Compute instantaneous orientational order parameters. */
      nematic_order(n_mol, mol_inert_axis, mol_order_inst, lambda, v);

      /* Use the largest eigenvalue to compute the average molecular
         orientation. */
      if (v[2][0] < 0.0)
        for (i = 0; i < 3; ++i)
          v[i][0] *= -1.0;
      cos_theta = v[2][0];
      phi = atan2(v[1][0], v[0][0]);

      /* Compute instantaneous polar order parameters. */
      polar_order(n_mol, mol_inert_axis, layer_index, mol_polar_inst, 
                  &polar_norm, mol_antipolar_inst, &antipolar_norm);


     /* Bond orientational order parameters. */
     if (layer_switch)
     voronoi(n_mol, n_neighb, i_neighb, i_min, r2_min, x_sep, y_sep, r2_sep,
       x_int, y_int, side, scaled_mol_coords, layer_index, n_layers,
       o2_re, o2_im, o4_re, o4_im, o6_re, o6_im, o2_lay, o4_lay, o6_lay,
       mol_lay, &o2_norm2, &o4_norm2, &o6_norm2);

      /* Compute instantaneous density profile. */
      profiles(n_bins, n_mol, scaled_mol_coords, side, one_over_sbin,
               dens_prof, &avg_normal);

      /* Compute "bulk" correlations functions. */
      spatial_correlation(n_r, n_r_par, n_r_perp,
         one_over_r_incr, one_over_r_par_incr,
         one_over_r_perp_incr, r2_max, r_par_max, n_mol,
         scaled_mol_coords, mol_inert_axis, volume, side,
         g_r, g_1, g_2, g_r_par_perp, g_1_par_perp, g_2_par_perp);

      /* Compute in-layer correlations functions. */
      if (layer_switch)
      in_layer_correlation(n_r, n_x, n_y, one_over_r_incr, one_over_x_incr, 
         one_over_y_incr, r2_max, x_max, y_max, n_mol, scaled_mol_coords, 
         mol_inert_axis, layer_index, side, o6_re, o6_im, 
         g_r_lay, g_1_lay, g_2_lay,
         g_r_6_bo_lay, g_xy, g_1_xy, g_2_xy, g_xy_6_bo);

      /* Calculate block index. */
      i_block = (i_cycle - 1) / n_block;

      /* Add contributions to block accumulators. */
      for (i = 0; i < 3; ++i){
        mol_polar_block[i][i_block] += mol_polar_inst[i];
        mol_antipolar_block[i][i_block] += mol_antipolar_inst[i];
        for (j = 0; j < 3; ++j)
          mol_order_block[i][j][i_block] +=  mol_order_inst[i][j];
      }

      volume_block[i_block] += volume;
      density_block[i_block] += density;

      if (layer_switch){
        diffusion_block[i_block] += factor;

        o2_norm2_block[i_block] += o2_norm2;
        o4_norm2_block[i_block] += o4_norm2;
        o6_norm2_block[i_block] += o6_norm2;
      }

      if (i_cycle % n_block == 0) {

         /* Calculate block averages. */
         norm = 1.0 / n_block;

         for (i = 0; i < 3; ++i){
           mol_polar_block[i][i_block] *= norm;
           mol_antipolar_block[i][i_block] *= norm;
           for (j = 0; j < 3; ++j) {
              mol_order_block[i][j][i_block] *= norm;
              order_temp[i+1][j+1] =  mol_order_block[i][j][i_block];
           }
         }

         if (layer_switch) {
           diffusion_block[i_block] *= norm;
    
           o2_norm2_block[i_block] *= norm;
           o4_norm2_block[i_block] *= norm;
           o6_norm2_block[i_block] *= norm;
         }

         volume_block[i_block] *= norm;
         density_block[i_block] *= norm;

         jacobi(order_temp, 3, lambda_temp, v_temp, &nrot);
         eigsrt(lambda_temp, v_temp, 3);
         /* Copy scratch arrays into real arrays. */
         for (i = 0; i < 3; ++i) {
           lambda[i] = lambda_temp[i+1];
           for (j = 0; j < 3; ++j)
             v[i][j] = v_temp[i+1][j+1];
         }
         if (v[2][0] < 0.0)
          for (i = 0; i < 3; ++i)
            v[i][0] *= -1.0;
         cos_theta_block[i_block] = v[2][0];
         phi_block[i_block] = atan2(v[1][0], v[0][0]);
         for (i = 0; i < 3; ++i)
           lambda_block[i][i_block] = lambda[i];

         polar_norm_block[i_block] = 0.0;
         antipolar_norm_block[i_block] = 0.0;
         for (i = 0; i < 3; ++i){
           polar_norm_block[i_block] += SQR(mol_polar_block[i][i_block]);
           antipolar_norm_block[i_block] += 
                                    SQR(mol_antipolar_block[i][i_block]);
         }

         /* Print block averages to standard output. */
         printf("\nBlock averages for block %d, MC cycles %d - %d\n", i_block,
            i_block * n_block + 1, (i_block + 1) * n_block);

         printf("   q = %g %g %g\n", mol_order_block[0][0][i_block],
                                     mol_order_block[0][1][i_block],
                                     mol_order_block[0][2][i_block]);
         printf("       %g %g %g\n", mol_order_block[1][0][i_block],
                                     mol_order_block[1][1][i_block],
                                     mol_order_block[1][2][i_block]);
         printf("       %g %g %g\n", mol_order_block[2][0][i_block],
                                     mol_order_block[2][1][i_block],
                                     mol_order_block[2][2][i_block]);
        printf("   cos_theta = %g\n", cos_theta_block[i_block]);
        printf("   theta = %g degrees\n", acos(cos_theta_block[i_block]) * radians_to_degrees);
        printf("   phi = %g degrees\n",
            phi_block[i_block] * radians_to_degrees);
        for (i = 0; i < 3; ++i)
          printf("   lambda[%d] = %g\n", i, lambda_block[i][i_block]);
        printf("\n");

        printf("    P = %g %g %g\n", mol_polar_block[0][i_block], 
                                     mol_polar_block[1][i_block],
                                     mol_polar_block[2][i_block]); 
        printf("    Polar norm = %g\n", polar_norm_block[i_block]);
         
        printf("    anti P = %g %g %g\n", mol_antipolar_block[0][i_block], 
                                     mol_antipolar_block[1][i_block],
                                     mol_antipolar_block[2][i_block]); 
        printf("    Antipolar norm = %g\n", antipolar_norm_block[i_block]);

        if (layer_switch) {
          printf("    |O2|^2  = %g\n", o2_norm2_block[i_block] / o6_x_norm2);
          printf("    |O4|^2  = %g\n", o4_norm2_block[i_block] / o6_x_norm2);
          printf("    |O6|^2  = %g\n", o6_norm2_block[i_block] / o6_x_norm2);

          printf("    diffusion = %g\n", diffusion_block[i_block]);
        }

        printf("    volume = %g\n", volume_block[i_block]);
        printf("    density = %g\n", density_block[i_block]);
        fflush(NULL);

     }

   }
   /* Close trajectory file. */
   fclose(f_trajec);

   for (i = 0; i < 3; ++i)
     for (j = 0; j < 3; ++j)
        statistics(n_blocks, mol_order_block[i][j], &mol_order_ave[i][j],
                   &mol_order_unc[i][j]);
   for (i = 0; i < 3; ++i)
     for (j = 0; j < 3; ++j)
        order_temp[i+1][j+1] = mol_order_ave[i][j];
   jacobi(order_temp, 3, lambda_temp, v_temp, &nrot);
   eigsrt(lambda_temp, v_temp, 3);
   /* Copy scratch arrays into real arrays. */
   for (i = 0; i < 3; ++i) {
     lambda_ave[i] = lambda_temp[i+1];
     for (j = 0; j < 3; ++j)
        v[i][j] = v_temp[i+1][j+1];
   }
   if (v[2][0] < 0.0)
      for (i = 0; i < 3; ++i)
        v[i][0] *= -1.0;
   cos_theta_ave = v[2][0];
   statistics(n_blocks, cos_theta_block, &dummy,  &cos_theta_unc);
   phi_ave = atan2(v[1][0], v[0][0]);
   statistics(n_blocks, phi_block, &dummy, &phi_unc);
   for (i = 0; i < 3; ++i)
      statistics(n_blocks, lambda_block[i], &dummy, &lambda_unc[i]);

   for (i = 0; i < 3; ++i)
      statistics(n_blocks, mol_polar_block[i], &mol_polar_ave[i],
                   &mol_polar_unc[i]);

   polar_norm_ave = 0.0;
     for (i = 0; i < 3; ++i)
        polar_norm_ave += SQR(mol_polar_ave[i]);
   statistics(n_blocks, polar_norm_block, &dummy, &polar_norm_unc);

   for (i = 0; i < 3; ++i)
      statistics(n_blocks, mol_antipolar_block[i], &mol_antipolar_ave[i],
                   &mol_antipolar_unc[i]);

   antipolar_norm_ave = 0.0;
     for (i = 0; i < 3; ++i)
        antipolar_norm_ave += SQR(mol_antipolar_ave[i]);
   statistics(n_blocks, antipolar_norm_block, &dummy, &antipolar_norm_unc);

   if (layer_switch){
     statistics(n_blocks, o2_norm2_block, &o2_norm2_ave, &o2_norm2_unc);
     statistics(n_blocks, o4_norm2_block, &o4_norm2_ave, &o4_norm2_unc);
     statistics(n_blocks, o6_norm2_block, &o6_norm2_ave, &o6_norm2_unc);

     statistics(n_blocks, diffusion_block, &diffusion_ave, &diffusion_unc);
   }

   statistics(n_blocks, volume_block, &volume_ave, &volume_unc);
   statistics(n_blocks, density_block, &density_ave, &density_unc);

   /* Print run averages and uncertainties to standard output. */
   printf("\nRun averages\n");
   printf("   q = %g %g %g\n", mol_order_ave[0][0], mol_order_ave[0][1],
                               mol_order_ave[0][2]);
   printf("       %g %g %g\n", mol_order_ave[1][0], mol_order_ave[1][1],
                               mol_order_ave[1][2]);
   printf("       %g %g %g\n", mol_order_ave[2][0], mol_order_ave[2][1],
                               mol_order_ave[2][2]);
   printf("   cos_theta = %g +/- %g\n", cos_theta_ave, cos_theta_unc);
   printf("   theta = %g degrees\n", acos(cos_theta_ave) * radians_to_degrees);
   printf("   phi = %g +/- %g degrees\n", phi_ave * radians_to_degrees,
                                      phi_unc * radians_to_degrees);
   for (i = 0; i < 3; ++i)
      printf("   lambda[%d] = %g +/- %g\n", i, lambda_ave[i], lambda_unc[i]);
   
   printf("\n");

   printf("    P = %g +/- %g,  %g +/-%g, %g +/- %g\n", 
               mol_polar_ave[0], mol_polar_unc[0],  mol_polar_ave[1], mol_polar_unc[1],
                                     mol_polar_ave[2], mol_polar_unc[2]); 
   printf("    Polar norm = %g +/- %g\n\n", polar_norm_ave, polar_norm_unc);
         
   printf("    anti P = %g +/- %g,  %g +/-%g, %g +/- %g\n", 
               mol_antipolar_ave[0], mol_antipolar_unc[0],  mol_antipolar_ave[1], 
               mol_antipolar_unc[1], mol_antipolar_ave[2], mol_antipolar_unc[2]); 

   printf("    Antipolar norm = %g +/- %g\n\n", antipolar_norm_ave, antipolar_norm_unc);

   if (layer_switch){
      printf("    |O2|^2  = %g +/- %g\n", o2_norm2_ave / o6_x_norm2, o2_norm2_unc);
      printf("    |O4|^2  = %g +/- %g\n", o4_norm2_ave / o6_x_norm2, o4_norm2_unc);
      printf("    |O6|^2  = %g +/- %g\n", o6_norm2_ave / o6_x_norm2, o6_norm2_unc);

      printf("    diffusion = %g +/- %g\n", diffusion_ave, diffusion_unc);
   }

   printf("    volume = %g +/- %g\n", volume_ave, volume_unc);
   printf("    density = %g +/- %g\n", density_ave, density_unc);
   fflush(NULL);

   /* Normalize density profile. */
   norm = n_bins / (volume_ave * n_inst);
   for (i_bin = 0; i_bin < n_bins; ++i_bin)
      dens_prof[i_bin] *= norm;

   /* Write density profile to output file. */
   f_output = fopen("a.dens_prof", "w");

   d_bin = avg_normal / (n_bins * n_inst);
   for (i_bin = 0; i_bin < n_bins; ++i_bin) {
      z_bin = i_bin * d_bin;
      fprintf(f_output,"%g %g\n", z_bin, dens_prof[i_bin]);
   }
   fclose(f_output);


   /* Normalize pair correlation functions. */
   norm1 = 3.0 / (TWO_PI * n_mol * (n_mol - 1) * n_inst);
   for (i_r = 0; i_r < n_r; ++i_r) {
     r_1 = i_r * r_incr;
     r_2 = (i_r + 1) * r_incr;
     norm2 = norm1 / (CUBE(r_2) - CUBE(r_1));
     if (g_r[i_r] > 0.0) {
       g_1[i_r] /= g_r[i_r];
       g_2[i_r] /= g_r[i_r];
     }
     g_r[i_r] *= norm2;
     if (g_r[i_r] < spat_thresh) {
       g_1[i_r] = 0.0;
       g_2[i_r] = 0.0;
     }
   }

   /* Write pair correlation functions to output files. */
   f_output = fopen("a.g_r", "w");
   for (i_r = 0; i_r < n_r; ++i_r) {
      r = (i_r + 0.5) * r_incr;
      fprintf(f_output, "%g %g %g %g\n", r, g_r[i_r], g_1[i_r], 
              g_2[i_r]);
   }
   fclose(f_output);

   /* Normalize two-dimensional correlation functions. */
   norm1 = 1.0 / (PI * r_par_incr * n_mol * (n_mol - 1) * n_inst);
   for (i_r_perp = 0; i_r_perp < n_r_perp; ++i_r_perp) 
      for (i_r_par = 0; i_r_par < n_r_par; ++i_r_par) {
         r_perp_1 = i_r_perp * r_perp_incr;
         r_perp_2 = (i_r_perp + 1) * r_perp_incr;
         norm2 = norm1 / (SQR(r_perp_2) - SQR(r_perp_1));
         if (g_r_par_perp[i_r_par][i_r_perp] > 0.0) {
            g_1_par_perp[i_r_par][i_r_perp] /= g_r_par_perp[i_r_par][i_r_perp];
            g_2_par_perp[i_r_par][i_r_perp] /= g_r_par_perp[i_r_par][i_r_perp];
         }
       g_r_par_perp[i_r_par][i_r_perp] *= norm2;
       if (g_r_par_perp[i_r_par][i_r_perp] < spat_thresh) {
          g_1_par_perp[i_r_par][i_r_perp] = 0.0;
          g_2_par_perp[i_r_par][i_r_perp] = 0.0;
       }
   }

   /* Write two-dimensional correlation functions to output files. */
   f_output = fopen("a.g_r_par_perp", "w");
   fprintf(f_output, "%d %d %g %g %g %g\n", n_r_par, n_r_perp,
         - r_par_max, 0.0, r_par_incr, r_perp_incr);
   for (i_r_perp = 0; i_r_perp < n_r_perp; ++i_r_perp) {
      for (i_r_par = 0; i_r_par < n_r_par; ++i_r_par)
         fprintf(f_output, "%g ", g_r_par_perp[i_r_par][i_r_perp]);
      fprintf(f_output, "\n");
   }
   fclose(f_output);

   f_output = fopen("a.g_1_par_perp", "w");
   fprintf(f_output, "%d %d %g %g %g %g\n", n_r_par, n_r_perp,
         - r_par_max, 0.0, r_par_incr, r_perp_incr);
   for (i_r_perp = 0; i_r_perp < n_r_perp; ++i_r_perp) {
      for (i_r_par = 0; i_r_par < n_r_par; ++i_r_par)
         fprintf(f_output, "%g ", g_1_par_perp[i_r_par][i_r_perp]);
      fprintf(f_output, "\n");
   }
   fclose(f_output);

   f_output = fopen("a.g_2_par_perp", "w");
   fprintf(f_output, "%d %d %g %g %g %g\n", n_r_par, n_r_perp,
         - r_par_max, 0.0, r_par_incr, r_perp_incr);
   for (i_r_perp = 0; i_r_perp < n_r_perp; ++i_r_perp) {
      for (i_r_par = 0; i_r_par < n_r_par; ++i_r_par)
         fprintf(f_output, "%g ", g_2_par_perp[i_r_par][i_r_perp]);
      fprintf(f_output, "\n");
   }
   fclose(f_output);

 if (layer_switch){

   /* Normalize in-layer correlation functions and write them to output file. */
   dum1 = n_layers / (PI * r_incr * SQR(n_mol) * n_inst);
   f_output = fopen("a.g_r_in_layer", "w");
   for (i_r = 0; i_r < n_r; ++i_r) {
      r = (i_r + 0.5) * r_incr;
      dum2 = dum1 / r;
      if (g_r_lay[i_r] > 0.0) {
         g_1_lay[i_r] /= g_r_lay[i_r];
         g_2_lay[i_r] /= g_r_lay[i_r];
         g_r_6_bo_lay[i_r] /= g_r_lay[i_r];
      }
      g_r_lay[i_r] *= dum2;
      if (g_r_lay[i_r] < in_lay_thresh) {
         g_1_lay[i_r] = 0.0;
         g_2_lay[i_r] = 0.0;
         g_r_6_bo_lay[i_r] = 0.0;
      }
      fprintf(f_output, "%g %g %g %g %g\n", r,
         g_r_lay[i_r], g_1_lay[i_r], g_2_lay[i_r], g_r_6_bo_lay[i_r]);
   }
   fclose(f_output);


   dum1 = SQR(n_layers) / (x_incr * y_incr * SQR(n_mol) * n_inst);
   for (i_layer = 0; i_layer < n_layers; ++i_layer) {
      for (i_y = 0; i_y < n_y; ++i_y)
         for (i_x = 0; i_x < n_x; ++i_x) {
            g_xy[i_x][i_y][i_layer] *= dum1;
            g_1_xy[i_x][i_y][i_layer] *= dum1;
            g_2_xy[i_x][i_y][i_layer] *= dum1;
            g_xy_6_bo[i_x][i_y][i_layer] *= dum1;

            g_xy_tot[i_x][i_y] += g_xy[i_x][i_y][i_layer];
            g_1_xy_tot[i_x][i_y] += g_1_xy[i_x][i_y][i_layer];
            g_2_xy_tot[i_x][i_y] += g_2_xy[i_x][i_y][i_layer];
            g_xy_6_bo_tot[i_x][i_y] += g_xy_6_bo[i_x][i_y][i_layer];
         }
   }
   for (i_y = 0; i_y < n_y; ++i_y)
      for (i_x = 0; i_x < n_x; ++i_x) {
         g_xy_tot[i_x][i_y] /= n_layers;
         g_1_xy_tot[i_x][i_y] /= n_layers;
         g_2_xy_tot[i_x][i_y] /= n_layers;
         g_xy_6_bo_tot[i_x][i_y] /= n_layers;
      }


   for (i_layer = 0; i_layer < n_layers; ++i_layer) {
      sprintf(s_layer, "%d", i_layer);
      strcpy(name, "a.g_xy_in_layer_");
      strcat(name, s_layer);
      f_output = fopen(name, "w");
      fprintf(f_output, "%d %d %g %g %g %g\n",
         n_x, n_y,
         -x_max, -y_max,
         x_incr, y_incr);
      for (i_y = 0; i_y < n_y; ++i_y) {
         for (i_x = 0; i_x < n_x; ++i_x)
            fprintf(f_output, "%g ", g_xy[i_x][i_y][i_layer]);
         fprintf(f_output, "\n");
      }
      fclose(f_output);

      strcpy(name, "a.g_1_xy_in_layer_");
      strcat(name, s_layer);
      f_output = fopen(name, "w");
      fprintf(f_output, "%d %d %g %g %g %g\n",
         n_x, n_y,
         -x_max, -y_max,
         x_incr, y_incr);
      for (i_y = 0; i_y < n_y; ++i_y) {
         for (i_x = 0; i_x < n_x; ++i_x)
            fprintf(f_output, "%g ", g_1_xy[i_x][i_y][i_layer]);
         fprintf(f_output, "\n");
      }
      fclose(f_output);

      strcpy(name, "a.g_2_xy_in_layer_");
      strcat(name, s_layer);
      f_output = fopen(name, "w");
      fprintf(f_output, "%d %d %g %g %g %g\n",
         n_x, n_y,
         -x_max, -y_max,
         x_incr, y_incr);
      for (i_y = 0; i_y < n_y; ++i_y) {
         for (i_x = 0; i_x < n_x; ++i_x)
            fprintf(f_output, "%g ", g_2_xy[i_x][i_y][i_layer]);
         fprintf(f_output, "\n");
      }
      fclose(f_output);

      strcpy(name, "a.g_6_bo_xy_in_layer_");
      strcat(name, s_layer);
      f_output = fopen(name, "w");
      fprintf(f_output, "%d %d %g %g %g %g\n",
         n_x, n_y,
         -x_max, -y_max,
         x_incr, y_incr);
      for (i_y = 0; i_y < n_y; ++i_y) {
         for (i_x = 0; i_x < n_x; ++i_x)
            fprintf(f_output, "%g ", g_xy_6_bo[i_x][i_y][i_layer]);
         fprintf(f_output, "\n");
      }
      fclose(f_output);
   }

   f_output = fopen("a.g_xy_in_layer_tot", "w");
   fprintf(f_output, "%d %d %g %g %g %g\n",
      n_x, n_y,
      -x_max, -y_max,
      x_incr, y_incr);
   for (i_y = 0; i_y < n_y; ++i_y) {
      for (i_x = 0; i_x < n_x; ++i_x)
         fprintf(f_output, "%g ", g_xy_tot[i_x][i_y]);
      fprintf(f_output, "\n");
   }
   fclose(f_output);

   f_output = fopen("a.g_1_xy_in_layer_tot", "w");
   fprintf(f_output, "%d %d %g %g %g %g\n",
      n_x, n_y,
      -x_max, -y_max,
      x_incr, y_incr);
   for (i_y = 0; i_y < n_y; ++i_y) {
      for (i_x = 0; i_x < n_x; ++i_x)
         fprintf(f_output, "%g ", g_1_xy_tot[i_x][i_y]);
      fprintf(f_output, "\n");
   }
   fclose(f_output);

   f_output = fopen("a.g_2_xy_in_layer_tot", "w");
   fprintf(f_output, "%d %d %g %g %g %g\n",
      n_x, n_y,
      -x_max, -y_max,
      x_incr, y_incr);
   for (i_y = 0; i_y < n_y; ++i_y) {
      for (i_x = 0; i_x < n_x; ++i_x)
         fprintf(f_output, "%g ", g_2_xy_tot[i_x][i_y]);
      fprintf(f_output, "\n");
   }
   fclose(f_output);

   f_output = fopen("a.g_6_bo_xy_in_layer_tot", "w");
   fprintf(f_output, "%d %d %g %g %g %g\n",
      n_x, n_y,
      -x_max, -y_max,
      x_incr, y_incr);
   for (i_y = 0; i_y < n_y; ++i_y) {
      for (i_x = 0; i_x < n_x; ++i_x)
         fprintf(f_output, "%g ", g_xy_6_bo_tot[i_x][i_y]);
      fprintf(f_output, "\n");
   }
   fclose(f_output);
 }

   exit(0);
}
