/* Declarations for Numerical Recipes routines. */

void eigsrt(double d[], double **v, int n);
void fit(double x[], double y[], int ndata, double sig[], int mwt,
	double *a, double *b, double *siga, double *sigb, double *chi2, double *q);
double gammln(double xx);
double gammq(double a, double x);
double gammp(double a, double x);
double gasdev(long *idum);
void gcf(double *gammcf, double a, double x, double *gln);
void gser(double *gamser, double a, double x, double *gln);
void indexx(unsigned long n, double arr[], unsigned long indx[]);
void jacobi(double **a, int n, double d[], double **v, int *nrot);
double ran3(long *idum);
void frprmn(double p[], int n, double ftol, int *iter, double *fret,
	double (*dfunc)(double [], double []));
void dlinmin(double p[], double xi[], int n, double *fret,
        double (*dfunc)(double [], double []));
double dbrent(double ax, double bx, double cx, double (*f)(double),
        double (*df)(double), double tol, double *xmin);
double f1dim(double x);
double df1dim(double x);
void mnbrak(double *ax, double *bx, double *cx,
   double *fa, double *fb, double *fc, double (*func)(double));
double erffc(double x);
double erff1(double x);
void svdfit(double x[], double y[], double sig[], int ndata, double a[], int ma,
   double **u, double **v, double w[], double *chisq,
   void (*funcs)(double, double [], int));
void svbksb(double **u, double w[], double **v, int m, int n,
   double b[], double x[]);
void svdcmp(double **a, int m, int n, double w[], double **v);
void svdvar(double **v, int ma, double w[], double **cvm);
double pythag(double a, double b);
void fpoly(double x, double p[], int np);
double bico(int n, int k);
double factln(int n);
void zbrak(double (*fx)(double), double x1, double x2, int n, double xb1[],
	double xb2[], int *nb);
double rtsafe(void (*funcd)(double, double *, double *), double x1, double x2,
	double xacc);
double rtbis(double (*func)(double), double x1, double x2, double xacc);
