#include "build.h"
#include "ff.h"
#include "proto.h"
#include "energy.h"

main(int argc, char *argv[])
{
  int ans, i_mol, skip, i_atom, abs;
  double diff_x, diff_y, diff_z, xx, yy, zz, pe_vdw_s_single,
      pe_vdw_s_p;
  nl_entry *p, *p_term;

  double pe_vdw_s_tot;
  int i_rel, j_rel, j_species;
  int i, j, k, i_atoms, i_species, i_phant, n_species, n_species_chk, 
      n_unit_cells, n_mols, n_atoms, n_mols1;
  int period_switch, vdw_switch, vdw_rad_switch, *excl_switch, init_switch,
      phant_switch, neigh_switch, opt_switch, press_switch, one_four_switch,
      nb_switch, con_switch, sim_switch, temp_switch, start_switch;
  /* Random generator */
  long i_ran, seed, idum;
  /* Array of geometrical molecular lengths. */
  double **mol_range, mol_max_length, xmax;
  /* Declare parameters used to build the initial state and box matrices*/
  int n_layers;
  double rho, aspect_xy, aspect_xz, layer_spacing;
  double **h, **h_inv, r_off, r_on, r2_on, r2_off, r_nl, r2_nl;
  int kc;
  /* Declare and initialize force field parameters. */
  int n_mass = 0, n_lj = 0, n_e6 = 0, n_pot = 0, n_type = 0;
  mass_entry *mass = NULL;
  lj_entry *lj = NULL;
  e6_entry *e6 = NULL;
  pot_entry *pot = NULL;
  type_entry *atm_type = NULL;
  /* File names */
  char par_file[F_MAX], *mass_file, *lj_file, *e6_file, *pot_file, 
      **struct_file, *header_file, *config_file, *header_file_save, 
      *config_file_save;
  FILE *f_thermo, *f_trajec, *f_dist;
  /* Declare and initialize molecular structure parameters. */
  int *n_atoms_per_mol = NULL, *n_mols_per_species = NULL,
      *n_bonds_per_mol = NULL, **temp_atm_lab, **temp_atm_nbr,
      ***temp_atm_br, **temp_atm_type_i;
  double ***temp_atm_pos, **temp_atm_mass, **temp_atm_chg,
      **temp_atm_sigma, **temp_atm_eps, ***temp_atm_ord;
  char ***temp_atm_type;
  int **temp_bonds_1 = NULL, **temp_bonds_2 = NULL;
  double **temp_bonds_ord = NULL;
  int *n_mols_per_unit_cell, *mol_species;

  /* Declare some arrays used in set up force field */
  double *mol_mass, *mol_mass_true;
  int *mol_first_atm;

  /* Declare combination and exclusion arrays */
  int ***exclusions, **comb_pot;
  double ***comb_par;
  /* Declare arrays used in build */
  double **scaled_atom_coords, **mol_coords, **scaled_mol_coords,
      **atom_coords, **rel_atom_coords, **atom_vels, *atom_mass, 
      *sqrt_kT_over_m, *one_over_2m, **mol_vels;
  int *atom_rel, *atom_mol, *atom_type, *hot_atom;
  int hot_flag;

  /* Scan list arrays. */
  int **scan_atm_1, **scan_atm_2;

  /* Array of the chosen principal molecular axe. */
  int *principal;
  /* Monte Carlo parameters. */
  int i_cycle, n_cycles, n_trajec, n_block, n_blocks, n_inst;

  /* Declare cell arrays. */
  atom_cell *atom_cells = NULL;
  phantom_cell *phantoms = NULL;
  int phantom_skip[7], nc[NDIM], nc_p[NDIM], nc_p_total, *first = NULL, 
  *last = NULL, *offsets, *offsets_total, noffsets;
  int *offsets_x, *offsets_y, *offsets_z;

  /* Neighbor list. */ 
  nl_entry **nl_head, **nl_tail; 
  double **atom_move;

/* Array for cluster analysis */
  int l_amp, N_amp, clust_size, i_bin, n_bins, n_dist, pos_1;
  double volume, pressure, pe, deltape, pe_max, dist, deltaR, r_max, sep[NDIM],
         r2_sep, *pe_hist, norm, volume_init, pe_vdw_init, deltavol, 
         pe_delta, *pe_delta_hist;

  /* Variable used in the computation of the potential. */
  double gamma, three_gamma_over_two, two_over_gamma_cubed,
      pe_vdw_s, pe_vdw_s_check, pe_stretch;

  /* Variable for force and stress tensor calculation */
  double **vdw_s , **vdw_s_single ,  **at_stress_vdw_s ,
  **at_stress_vdw_single ,  **mol_stress_vdw_s ,
  **mol_stress_vdw_single;

  /* Get command line input. */
  if (argc != 2) {
    printf("Usage: %s params_file\n", argv[0]);
    exit(1);
  }
  strcpy(par_file, argv[1]);

  /* Read in input parameter file. */
  read_energy_params(par_file, &start_switch, &header_file, &config_file, 
      &mass_file, &pot_file, &vdw_rad_switch, 
      &n_species_chk, &excl_switch, &r_on, &r_off, 
      &neigh_switch, &phant_switch, &kc, &r_nl, &n_cycles, 
      &n_block, &n_trajec, &seed, &pe_max, &n_dist);

  printf("header_file = %s, config_file = %s\n",header_file,
      config_file);
  printf("mass_file = %s\n",mass_file);
  printf("pot_file = %s\n",pot_file);
  printf("vdw_rad_switch = %d\n", vdw_rad_switch);
  printf("n_species (from params file) = %d\n", n_species_chk);
  for (i_species = 0; i_species < n_species_chk; ++i_species)
     printf("i_specie = %d, excl_switch = %d\n", i_species,
          excl_switch[i_species]);

  printf("r_on = %g, r_off = %g\n",r_on, r_off);
  printf("neigh_switch = %d, phant_switch = %d\n", neigh_switch,
      phant_switch);
  printf("kc = %d, r_nl = %g\n",kc, r_nl);
  printf("n_cycles = %d, \n", n_cycles);
  printf("n_trajec = %d\n", n_trajec);
  printf("seed = %ld\n",seed);
  printf("pe_max = %g, n_dist = %d\n",pe_max, n_dist);

  /* Define additional variables. */
  if (n_cycles % n_block != 0) 
    error_exit("n_cycles must be a multiple of n_block!\n");
  n_blocks = n_cycles / n_block;
  noffsets = CUBE(2 * kc + 1);

  /* Initialize random number generator. */
  i_ran = -seed;
  ran3(&i_ran);

  /* Read information about template molecules and atoms from header file */
  read_header_direct(header_file, &period_switch, &n_species,
      &n_atoms_per_mol,  &temp_atm_lab, &temp_atm_type, &temp_atm_nbr,
      &temp_atm_br, &temp_atm_ord,  &temp_atm_pos, &temp_atm_chg,
      &temp_atm_sigma, &temp_atm_eps,  &n_bonds_per_mol, &temp_bonds_1,
      &temp_bonds_2, &temp_bonds_ord,  &n_mols_per_species, &n_mols,
      &n_atoms, &mol_species);

  /* Check exclusion switch array. */
  if (n_species_chk != n_species) {
     printf("n_species_chk = %d, n_species = %d\n", n_species_chk, n_species);
     error_exit("Problem in the number of species.\n");
  }
 
  /* If the number of exclusion sites is greater than the number of atoms
     present in the template molecule, set the exclusion switch to -1, i.e.
     remove all intramolecular interactions. */ 
  for (i_species = 0; i_species < n_species; ++i_species)
    if (excl_switch[i_species] >= n_atoms_per_mol[i_species])
      excl_switch[i_species] = -1;
 
  /* Read FF masses file. */
  read_mass_params(mass_file, &mass, &n_mass);

  /* Set up force field data for masses. */
  set_up_force_field_pair(n_species, n_mols, n_atoms_per_mol, n_mass,
      mass, mol_species, n_bonds_per_mol, &temp_atm_mass, temp_atm_type,
      &mol_mass, &mol_mass_true, &mol_first_atm);

  /* Convert string tags to integer identifiers. */
  /* Create an integer identifier corresponding to template atom type. */ 
  convert_type(n_species, n_atoms_per_mol, temp_atm_type, &temp_atm_type_i, 
     &atm_type, &n_type);

/* printf(" I am before set_up_pot n_type %d\n", n_type); */

  /* Read and Set up force field data for potential interactions. */
  read_set_up_pot(pot_file, vdw_switch, vdw_rad_switch, atm_type, n_type,
     &comb_pot, &comb_par);

printf(" I am after set_up_pot\n");
  /* Adjust cutoffs (r_off and r_on) according to the potential interaction
  form present. */
  adjust_cutoff(n_type, comb_pot, comb_par, &r_on, &r_off);

  /* Set up scan list. */
  set_up_scan_list(n_species, n_atoms_per_mol, temp_atm_nbr, temp_atm_br,  
     &scan_atm_1, &scan_atm_2);


  /* Allocate memory for arrays used in the builder. */
  allocate_memory_energy(n_atoms, n_mols, n_species, 
      period_switch,  &scaled_atom_coords, &atom_rel, &atom_mol,
      &atom_mass, &atom_type, 
      &mol_coords, &scaled_mol_coords, 
      &rel_atom_coords, &h_inv, &atom_cells, &offsets, &offsets_total, 
      noffsets, &nl_head, &nl_tail, &atom_move,
      n_atoms_per_mol, &exclusions, &vdw_s, &at_stress_vdw_s,
      &mol_stress_vdw_s, n_dist, &pe_hist, &pe_delta_hist);


  /* Set up array of relative atom indices */
  relative_atoms_energy(n_mols, mol_species, mol_first_atm, n_atoms_per_mol,
      temp_atm_mass, temp_atm_type_i, atom_rel, atom_mol, atom_mass, atom_type);
      

  /* Set up the nonbonded exclusion array */
  exclusion_array(n_species, n_atoms_per_mol, excl_switch, temp_atm_nbr,  
    temp_atm_br, &exclusions);
 
  /* If we are using periodic boundary conditions, and that we are using
   cell (or neighbor) list, set up atom index offsets for updating phantom 
   atoms. */

  r2_nl = r_nl * r_nl;
  r2_on = r_on * r_on;
  r2_off = r_off * r_off;

  l_amp = n_atoms_per_mol[0];
  N_amp = n_mols_per_species[0];
  printf(" Length of the surfactant: %d and No. of surfactants %d\n", l_amp, N_amp);

     /* No of chromonic in the mixture */
  if (n_species >2)
  n_mols1 = n_mols_per_species[0] + n_mols_per_species[1];
  else n_mols1 = n_mols_per_species[0];

  r_max = 13.1026;
  r_max = 0.5*r_max;
  deltape = pe_max/n_dist;
  deltaR = r_max/n_dist;

/* Open output file. */
  if ((f_trajec = fopen(config_file, "r")) == NULL)
    error_exit("Cannot open config_file\n");

  /* Read header from the trajectory file. */
  fread(&n_atoms, sizeof(int), 1, f_trajec);
  fread(&n_cycles, sizeof(int), 1, f_trajec);
  fread(&n_trajec, sizeof(int), 1, f_trajec);

  pos_1 = ftell(f_trajec);

  printf("Header from %s\n", config_file);
  printf("n_atoms = %d\n", n_atoms);
  printf("n_cycles = %d\n", n_cycles);
  printf("n_trajec = %d\n", n_trajec);


  /* Compute number of instantaneous configuration in trajectory file. */
  if (n_cycles % n_trajec != 0) {
      printf("n_cycles must be a multiple of n_trajec\n");
      exit(1);
  }
  n_inst = n_cycles / n_trajec;

  /* Allocate memory for box and atom coordinates. */
  h = allocate_2d_array(3, 3, sizeof(double));
  atom_coords = allocate_2d_array(8*n_atoms, 3, sizeof(double));
  
  /* Read first data set */

  fseek(f_trajec, pos_1, 0);

      /* Read in instantaneous configuration from trajectory file. */
      read_positions_direct(f_trajec, h, n_atoms, atom_coords);

      /* Calculate quantities that depend on box dimensions and exit
         if system is too small. */
      box_dimensions(h, h_inv, period_switch, 0.0, 0.0);

      volume = h[0][0] * h[1][1] * h[2][2];

      if (period_switch) {
         scaled_atomic_coords(n_atoms, h_inv, atom_coords, scaled_atom_coords);
         periodic_boundary_conditions(n_atoms, h, scaled_atom_coords,
                                      atom_coords);
      }
       /* Compute molecular center of mass and relative "atom" coordinates. */
      center_of_mass_positions(period_switch, n_mols, n_species,
      n_atoms_per_mol,  mol_species, atom_mass, mol_first_atm,
      atom_coords, scaled_atom_coords,  scan_atm_1, scan_atm_2,
      mol_mass, h, h_inv, mol_coords, scaled_mol_coords,  rel_atom_coords);

  /* Initialize number of phantom cells. */
    nc_p[0] = nc_p[1] = nc_p[2] = 0;
    nc_p_total = 0;


  if ((period_switch) && (neigh_switch != 0))
  {
    for (i_phant = 0; i_phant < 7; ++i_phant)
      phantom_skip[i_phant] = (i_phant + 1) *
          n_atoms;
  }

      set_up_cells_phantom(h, nc, nc_p, &nc_p_total,
          atom_cells,  kc,  period_switch, r_nl, r_off,
          neigh_switch, &first, &last, offsets,  n_atoms,
          scaled_atom_coords, atom_coords, &phantoms,
          phantom_skip);

       update_phantoms(n_atoms, atom_cells, phantom_skip,
          phantoms, atom_coords);

     /* Compute the potential energy for each trajectory */
  gamma = 0.0;
  three_gamma_over_two = 0.0;
  two_over_gamma_cubed = 0.0;
  if (r2_on < r2_off) {
    gamma = r2_off - r2_on;
    three_gamma_over_two = 1.5 * gamma;
    two_over_gamma_cubed = 2.0 / CUBE(gamma);
    }
        wca_period_phantom(mol_species, atom_rel, atom_mol, atom_type, n_atoms,
          n_atoms_per_mol, exclusions, comb_pot, comb_par,
          r2_on, r2_off, h, scaled_atom_coords, gamma, three_gamma_over_two,
          two_over_gamma_cubed, &pe_vdw_s, period_switch,
          first, last, phantoms, noffsets, nc_p, kc,
          phantom_skip, nc, atom_cells, offsets, atom_coords,
          rel_atom_coords, at_stress_vdw_s, mol_stress_vdw_s,
          vdw_s);


    volume_init = volume;
    pe_vdw_init = pe_vdw_s;
    printf(" Initial vol %g and pot. energy %g\n", volume_init, pe_vdw_init);

  /* Loop  over trajectories. */
  printf("\nEntering main loop\n");
  fflush(NULL);

    pressure = 1.0;

    for (i_cycle = 1; i_cycle <= n_inst; ++i_cycle) {

      /* Read in instantaneous configuration from trajectory file. */
      read_positions_direct(f_trajec, h, n_atoms, atom_coords);

      /* Calculate quantities that depend on box dimensions and exit
         if system is too small. */
      box_dimensions(h, h_inv, period_switch, 0.0, 0.0);

      volume = h[0][0] * h[1][1] * h[2][2];

      if (period_switch) {
         scaled_atomic_coords(n_atoms, h_inv, atom_coords, scaled_atom_coords);
         periodic_boundary_conditions(n_atoms, h, scaled_atom_coords,
                                      atom_coords);
      }
       /* Compute molecular center of mass and relative "atom" coordinates. */
      center_of_mass_positions(period_switch, n_mols, n_species,
      n_atoms_per_mol,  mol_species, atom_mass, mol_first_atm,
      atom_coords, scaled_atom_coords,  scan_atm_1, scan_atm_2,
      mol_mass, h, h_inv, mol_coords, scaled_mol_coords,  rel_atom_coords);

    /* calculate the pair separation of chromonic molecules */

      for( k = 0; k < NDIM; ++k)
         sep[k] = mol_coords[n_mols1-2][k] - mol_coords[n_mols1-1][k];
         r2_sep = SQR(sep[0]) + SQR(sep[1]) + SQR(sep[2]);
         i_bin = (int) (sqrt (r2_sep) / deltaR) + 1;



  /* Initialize number of phantom cells. */
    nc_p[0] = nc_p[1] = nc_p[2] = 0;
    nc_p_total = 0;


  if ((period_switch) && (neigh_switch != 0))
  {
    for (i_phant = 0; i_phant < 7; ++i_phant)
      phantom_skip[i_phant] = (i_phant + 1) *
          n_atoms;
  }

      set_up_cells_phantom(h, nc, nc_p, &nc_p_total,
          atom_cells,  kc,  period_switch, r_nl, r_off,
          neigh_switch, &first, &last, offsets,  n_atoms,
          scaled_atom_coords, atom_coords, &phantoms,
          phantom_skip);

       update_phantoms(n_atoms, atom_cells, phantom_skip,
          phantoms, atom_coords); 

     /* Compute the potential energy for each trajectory */
  gamma = 0.0;
  three_gamma_over_two = 0.0;
  two_over_gamma_cubed = 0.0;
  if (r2_on < r2_off) {
    gamma = r2_off - r2_on;
    three_gamma_over_two = 1.5 * gamma;
    two_over_gamma_cubed = 2.0 / CUBE(gamma);
    }

        wca_period_phantom(mol_species, atom_rel, atom_mol, atom_type, n_atoms,
          n_atoms_per_mol, exclusions, comb_pot, comb_par,
          r2_on, r2_off, h, scaled_atom_coords, gamma, three_gamma_over_two,
          two_over_gamma_cubed, &pe_vdw_s, period_switch,
          first, last, phantoms, noffsets, nc_p, kc,
          phantom_skip, nc, atom_cells, offsets, atom_coords,
          rel_atom_coords, at_stress_vdw_s, mol_stress_vdw_s,
          vdw_s);

        deltape = pe_vdw_s - pe_vdw_init;
        deltavol = volume - volume_init;

        pe = pe_vdw_s + pressure * volume;
        pe_delta = deltape + pressure * deltavol;

printf("%d %g %g\n", i_cycle*n_trajec, pe_vdw_s, pe);
        pe_hist[i_bin] += pe;
        pe_delta_hist[i_bin] += pe_delta;


  } /* end of the loop. */
  norm = 1.0/n_inst;
  f_dist = gfopen("pe_hist.dat", "w");
    fprintf(f_dist, "%g %d %g\n", norm, n_dist, deltaR);

     for (i = 0; i < n_dist; ++i) {
      dist = deltaR * (i + 0.5);
      fprintf(f_dist, " %d %g %g\n", i, dist, pe_hist[i]);
   }
   fclose(f_dist);


  f_dist = gfopen("pe_delta_hist.dat", "w");
    fprintf(f_dist, "%g %d %g\n", norm, n_dist, deltaR);

     for (i = 0; i < n_dist; ++i) {
      dist = deltaR * (i + 0.5);
      fprintf(f_dist, " %d %g %g\n", i, dist, pe_delta_hist[i]);
   }
   fclose(f_dist);


  /* Close output file. */
  fclose(f_trajec);
}  /* end of main. */

/****************************************************************************/
/* Allocate memory for static arrays */
void allocate_memory_energy(int n_atoms, int n_mols, int n_species,
int period_switch, double ***scaled_atom_coords, int **atom_rel,
int **atom_mol, double **atom_mass, int **atom_type, 
double ***mol_coords, 
double ***scaled_mol_coords, double ***rel_atom_coords, 
double ***h_inv, atom_cell **atom_cells, int **offsets, 
int **offsets_total, int noffsets, nl_entry ***nl_head,
nl_entry ***nl_tail, double ***atom_move, int *n_atoms_per_mol, 
int ****exclusions, double ***vdw_s, double ***at_stress_vdw_s, 
double ***mol_stress_vdw_s, int n_dist, double **pe_hist, 
double **pe_delta_hist)

{
  int i, i_rel, i_species, n_atoms_max;

  /* Allocate memory for arrays of atomic properties. */
  if (period_switch)
    *scaled_atom_coords = allocate_2d_array(n_atoms,
        3, sizeof(double));
  *rel_atom_coords = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for arrays of atomic properties. */
  *atom_rel = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mol = allocate_1d_array(n_atoms, sizeof(int));
  *atom_mass = allocate_1d_array(n_atoms, sizeof(double));
  *atom_type = allocate_1d_array(n_atoms, sizeof(int));

  /* Allocate memory for arrays of molecular properties. */
  *mol_coords = allocate_2d_array(n_mols, 3, sizeof(double));
  if (period_switch)
    *scaled_mol_coords = allocate_2d_array(n_mols, 3,
        sizeof(double));

  /* Allocate memory for the box matrices */
  /* For now, orthorombic box */
  *h_inv = allocate_2d_array(3, 3, sizeof(double));

  /* Allocate memory for atomic cell lists. */
  if (period_switch) {
    *atom_cells = allocate_1d_array(8 * n_atoms, sizeof(atom_cell));
    *offsets = allocate_1d_array(noffsets, sizeof(int));
    *offsets_total = allocate_1d_array(noffsets, sizeof(int));
  }
  
  /* Allocate memory for neighbor lists. */
  *nl_head = gcalloc(n_atoms, sizeof(nl_entry*));
  for (i = 0; i < n_atoms; ++i) {
    (*nl_head)[i] = gmalloc(sizeof(nl_entry));
    (*nl_head)[i] -> next = NULL;
    }
  *nl_tail = gcalloc(n_atoms, sizeof(nl_entry*));
  *atom_move = allocate_2d_array(n_atoms, 3, sizeof(double));

  /* Allocate memory for exclusion array. */
  *exclusions = allocate_1d_array(n_species, sizeof(int**));
  for (i_species = 0; i_species < n_species; ++i_species) {
    (*exclusions)[i_species] = allocate_1d_array(n_atoms_per_mol[i_species],
        sizeof(int*));
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species];
        ++i_rel) {
      (*exclusions)[i_species][i_rel] = allocate_1d_array(n_atoms_per_mol[i_species],
          sizeof(int));
    }
  }

  /* Memory for force and stress tensor */

  *vdw_s = allocate_2d_array(n_atoms, NDIM, sizeof(double));
  *at_stress_vdw_s = allocate_2d_array(NDIM, NDIM, sizeof(double));
  *mol_stress_vdw_s = allocate_2d_array(NDIM, NDIM, sizeof(double));

/* Allocate memory for distribution functions. */
   *pe_hist = allocate_1d_array(n_dist, sizeof(double));
   *pe_delta_hist = allocate_1d_array(n_dist, sizeof(double));

}

/****************************************************************************/
/* Set up array of relative atom indices. */
void relative_atoms_energy(int n_mols, int *mol_species, int *mol_first_atm,
   int *n_atoms_per_mol, double **temp_atm_mass, int **temp_atm_type_i,
   int *atom_rel, int *atom_mol, double *atom_mass, int *atom_type)
{
  int i_species, skip, i, i_mol, i_rel;

  /* Set up array of atomic properties. */
  for (i_mol = 0; i_mol < n_mols; ++i_mol) {
    i_species = mol_species[i_mol];
    skip = mol_first_atm[i_mol];
    for (i_rel = 0; i_rel < n_atoms_per_mol[i_species]; ++i_rel) {
      i = skip + i_rel;
      atom_rel[i] = i_rel;
      atom_mol[i] = i_mol;
      atom_mass[i] = temp_atm_mass[i_species][i_rel];
      atom_type[i] = temp_atm_type_i[i_species][i_rel];
    }
  }

}
