	pro contour_2d,finput,xlabel,ylabel

; Plots 2d data.

; Read header from data file.

        openr,1,finput
        readf,1,nx,ny,x0,y0,dx,dy
        rx=nx*dx
        ry=ny*dy

; Set up global attributes of plots.

        !p.multi=[0,1,1,0,0]
        !p.noclip=1
        !p.title='!5'
	!p.charsize=1.5
        !x.style=1
        !y.style=1
        !z.style=1
        !x.range=[x0,x0+rx]
        !y.range=[y0,y0+ry]

; Read in 2d data.

        data_2d=fltarr(nx,ny)
        readf,1,data_2d
        close,1

; Find min and max data values.

        data_min=min(data_2d)
        data_max=max(data_2d)
        data_range=data_max-data_min
;       data_range=data_range/4.0
        print,'data_min = ',data_min
        print,'data_max = ',data_max
        print,'data_range = ',data_range

; Make plot.

	set_plot,'ps'
;	set_plot,'x'

	if (rx gt ry) then begin
           xs = 6.5
           xo = 1.0
           ys = xs * ry / rx
           yo = (11.0 - ys ) / 2
        endif else begin
           ys = 6.5
           yo = 2.25
           xs = ys * rx / ry
           xo = (8.5 - xs) / 2
        endelse
        device,/inches,xsize=xs,ysize=ys,filename='contour.eps', $
           xoffset=xo,yoffset=yo,/encapsulated

; Make contour plot.

	x=x0+dx*(findgen(nx)+0.5)
	y=y0+dy*(findgen(ny)+0.5)
        interval=data_range/8;
        levels=data_min+(findgen(8)+0.5)*interval
        colors=[223,191,159,127,95,63,31,0]
        print,'levels = ',levels
	contour,data_2d,x,y, $
           level=levels, $
           c_colors=colors, $
           xtitle=xlabel,ytitle=ylabel, /fill

	device, /close

	return

	end
