
/* #define GRAPHICS  */ 

/* Include header files for system libraries. */
#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/resource.h>

#ifdef GRAPHICS
#include <device.h>
#include <gl.h>
#include <gl/sphere.h> 
#endif

#include "nr.h"
#include "nrutil.h"
#include "allocate.h"

#define NDIM                    3
#define TYPE_MAX                6
#define MAX_LINE                200
#define F_MAX			256
#define COUL_COUPLING 		332.0637
#define MAX_TRIALS 		10000000
#define PI                      3.14159265359
#define TWO_PI 			6.28318530718
#define MAX_PAR			20

/* Macro definitions. */
#define SQR(x)             ((x) * (x))
#define CUBE(x)            ((x) * (x) * (x))
#define ABS(x)             ((x) < 0 ? -(x) : (x))
#define MAX(x,y)           ((x) > (y) ? (x) : (y))
#define MIN(x,y)           ((x) < (y) ? (x) : (y))
#define SIGN(a,b)          ((b) >= 0.0 ? fabs(a) : -fabs(a))
#define NINT(x)            ((x) < 0.0 ? (int) ((x) - 0.5) : (int) ((x) + 0.5))
#define FLOOR(x)           ((x) < 0.0 ? ((int) (x)) - 1 : ((int) (x)))

/* These are structures which will be replaced by simple arrays in the
   future! */
/* The atom_cell structure contains the atomic cell index, labels of the
   previous and next entries in the cell list, and the index of the
   corresponding real atom (for phantoms). */
typedef struct {
   int cell,              /* Cell index of atom. */
       prev,              /* Label of previous atom in cell. */
       next,              /* Label of next atom in cell. */
       real;              /* Label of corresponding real atom (for phantoms). */
} atom_cell;

typedef struct {
   int n,        /* Number of phantom cells to create for a given real cell. */
       ic[7];    /* Indices of phantom cells to create. There can be up to */
                 /* seven phantom cells for a given real cell. */
   double d_x,   /* x, y, and z offsets for atoms in a given phantom cell. */
          d_y,
          d_z;
} phantom_cell;

/* nl_entry contains structure of neighbor list */
struct neighb_list {
   int atom;                  /* Label of neighboring atom. */
   struct neighb_list *next;  /* Pointer to next entry in neighbor list. */
};
typedef struct neighb_list nl_entry;

